/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.idstore;

import com.sap.idm.vds.MVDHashMap;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDSearchResultEntry;
import com.sap.idm.vds.MVDSearchResults;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.config.MVDDataSource;
import com.sap.idm.vds.config.MVDDataSourceList;
import com.sap.idm.vds.util.JDBCUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class Schema {
    public static MVDSearchResults getSchema(MVDHashMap param, String startingpoint, String dsScope, String mDatabase, boolean mCacheConnections) {
        MVDLogger.Debug("Get schema ... attributes");
        MVDSearchResults searchResult = new MVDSearchResults();
        String dsuniquename = (String)param.getDSMandatoryParameter("UNIQUENAME");
        MVDLogger.Log("Obtained authenticating datasource " + dsuniquename, 2);
        MVDDataSource ds = MVDDataSourceList.getDSByUniqueName(dsuniquename);
        if (ds == null) {
            searchResult.setError(2, "Can not find SYSTEM data sources");
            return searchResult;
        }
        HashMap hhh = ds.EffectiveResponseAttrMapping();
        boolean conversionenabled = ds.EnableConvServer();
        boolean acceptAll = !ds.ForbidNonAvailFields();
        HashMap availableHash = ds.EffectiveAvailableFieldsForAttributes();
        MVDSearchResultEntry oneEntry = new MVDSearchResultEntry();
        oneEntry.setDn(startingpoint);
        String mskeyvalueattribute = "";
        String mx_entrytypeattribute = "";
        String displaynameattribute = "";
        String attributeQuery = "select attr_id, attrName, info, multivalue from MXIV_SCHEMA where is_id = $SCOPE$";
        attributeQuery = MVDUtil.replace(attributeQuery, "$SCOPE$", dsScope);
        MVDSearchResults resAttr = JDBCUtil.search(mDatabase, attributeQuery, null, mCacheConnections);
        HashMap<String, String> attrID_Names = new HashMap<String, String>();
        Vector<String> attributes = new Vector<String>();
        for (int ix = 0; ix < resAttr.size(); ++ix) {
            MVDSearchResultEntry e = (MVDSearchResultEntry)resAttr.elementAt(ix);
            String attrname = e.getFirstAttrValue("attrName");
            if (!acceptAll && !availableHash.containsKey(attrname.toLowerCase())) continue;
            String attrToReturn = "";
            if (conversionenabled) {
                attrToReturn = (String)hhh.get(attrname.toLowerCase());
                if (attrToReturn == null) {
                    attrToReturn = attrname.toLowerCase();
                }
            } else {
                attrToReturn = attrname.toLowerCase();
            }
            if (attrname.equalsIgnoreCase("mskeyvalue")) {
                mskeyvalueattribute = attrToReturn;
            } else if (attrname.equalsIgnoreCase("mx_entrytype")) {
                mx_entrytypeattribute = attrToReturn;
            } else if (attrname.equalsIgnoreCase("displayname")) {
                displaynameattribute = attrToReturn;
            }
            String desc = e.getFirstAttrValue("info");
            String syntax = "String";
            String attrentry = "(" + attrToReturn + "-oid" + " NAME '" + attrToReturn + "' DESC '" + desc + "' SYNTAX " + syntax + ")";
            attributes.add(attrentry);
            String attr_id = e.getFirstAttrValue("attr_id");
            attrID_Names.put(attr_id, attrToReturn);
        }
        oneEntry.setAttrValue("attributeTypes", true, attributes);
        String entryTypeQuery = "select ocName,ocid,ocDescription from MXIV_ENTRYTYPES where ocisid = $SCOPE$";
        entryTypeQuery = MVDUtil.replace(entryTypeQuery, "$SCOPE$", dsScope);
        MVDSearchResults res = JDBCUtil.search(mDatabase, entryTypeQuery, null, mCacheConnections);
        HashMap<String, String> vAllOcIds = new HashMap<String, String>();
        HashMap<String, String> vAllOcIdsX = new HashMap<String, String>();
        for (int ix = 0; ix < res.size(); ++ix) {
            MVDSearchResultEntry e = (MVDSearchResultEntry)res.elementAt(ix);
            String ocid = e.getFirstAttrValue("ocid");
            String ocname = e.getFirstAttrValue("ocname");
            String ocdesc = e.getFirstAttrValue("ocdescription");
            if (ocdesc == null) {
                ocdesc = "Not available";
            }
            String fixedForOC = " NAME '" + ocname + "' DESC '" + ocdesc + "'";
            if (ocid == null) continue;
            vAllOcIds.put(ocid, fixedForOC);
            vAllOcIdsX.put(ocid, ocname);
        }
        String ocsQuery = "select ocattribute, ocobjectclass, ocmandatory from  MXIV_OBJECTCLASSATTRIBUTES";
        MVDSearchResults resOC = JDBCUtil.search(mDatabase, ocsQuery, null, mCacheConnections);
        Vector<String> ocs = new Vector<String>();
        String mustTop = "( " + mskeyvalueattribute + " $ " + mx_entrytypeattribute + " $ " + displaynameattribute + " )";
        String ocentry = "( 3.1.2.3.0 NAME 'mx_top' DESC 'Standard IdM objectclass' ABSTRACT MUST " + mustTop + " )";
        ocs.add(ocentry);
        Iterator it = vAllOcIds.keySet().iterator();
        while (it.hasNext()) {
            String currentOCID = (String)it.next();
            String currentOCFix = (String)vAllOcIds.get(currentOCID);
            String currentOCNAME = (String)vAllOcIdsX.get(currentOCID);
            String totalMust = "";
            String totalMay = "";
            String oid = "OID";
            String syntax = "SYNTAX";
            String sup = "mx_top";
            for (int ix = 0; ix < resOC.size(); ++ix) {
                String attrname;
                MVDSearchResultEntry e = (MVDSearchResultEntry)resOC.elementAt(ix);
                String objectc = e.getFirstAttrValue("ocobjectclass");
                String attributeid = e.getFirstAttrValue("ocattribute");
                if (!objectc.equals(currentOCID) || (attrname = (String)attrID_Names.get(attributeid)) == null || attrname.equalsIgnoreCase("objectclass") || attrname.equalsIgnoreCase("mx_entrytype") || attrname.equalsIgnoreCase("mskeyvalue")) continue;
                String mand = e.getFirstAttrValue("ocmandatory");
                if (mand.equals("1")) {
                    if (totalMust.length() > 0) {
                        totalMust = totalMust + " $ ";
                    }
                    totalMust = totalMust + attrname;
                    continue;
                }
                if (totalMay.length() > 0) {
                    totalMay = totalMay + " $ ";
                }
                totalMay = totalMay + attrname;
            }
            if (totalMust.indexOf("$") >= 0) {
                totalMust = "( " + totalMust + " )";
            }
            if (totalMay.indexOf("$") >= 0) {
                totalMay = "( " + totalMay + " )";
            }
            if (totalMust.length() > 0) {
                totalMust = " MUST " + totalMust;
            }
            if (totalMay.length() > 0) {
                totalMay = " MAY " + totalMay;
            }
            ocentry = "(" + currentOCNAME + "-oc-oid" + currentOCFix + " SUP " + sup + " STRUCTURAL " + totalMust + totalMay + " )";
            ocs.add(ocentry);
        }
        oneEntry.setAttrValue("objectclasses", true, ocs);
        String ldapstx = "";
        Vector<String> vStx = new Vector<String>();
        ldapstx = "(1.3.6.1.4.1.1466.115.121.1.15 DESC 'Directory String')";
        vStx.add(ldapstx);
        oneEntry.setAttrValue("ldapSyntaxes", true, vStx);
        searchResult.add(oneEntry);
        searchResult.setOK();
        return searchResult;
    }
}

