/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.filter;

import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.filter.MVDFilter;
import com.sap.idm.vds.filter.MVDFilterComplex;
import com.sap.idm.vds.filter.MVDFilterSimple;
import com.sap.idm.vds.filter.MVDFilterSubstring;
import com.sap.idm.vds.ldapv3.Filter;
import com.sap.idm.vds.ldapv3.FilterSetOf;
import com.sap.idm.vds.ldapv3.FilterSetOf1;
import com.sap.idm.vds.ldapv3.SubstringFilter;
import com.sap.idm.vds.ldapv3.SubstringFilterSeqOf;
import com.sap.idm.vds.ldapv3.SubstringFilterSeqOfChoice;
import java.util.Vector;

public class MVDFilterUtil {
    private static Vector processRecursive(FilterSetOf fs) {
        Vector<MVDFilter> filters = new Vector<MVDFilter>();
        int ls = fs.size();
        for (int x = 0; x < ls; ++x) {
            MVDFilter mvdFHelp = MVDFilterUtil.convertFilter((Filter)fs.elementAt(x));
            filters.add(mvdFHelp);
        }
        return filters;
    }

    private static Vector processRecursive(FilterSetOf1 fs) {
        Vector<MVDFilter> filters = new Vector<MVDFilter>();
        int ls = fs.size();
        for (int x = 0; x < ls; ++x) {
            MVDFilter mvdFHelp = MVDFilterUtil.convertFilter((Filter)fs.elementAt(x));
            filters.add(mvdFHelp);
        }
        return filters;
    }

    private static Vector processSubstrings(SubstringFilterSeqOf fs) {
        Vector<MVDFilterSubstring> v = new Vector<MVDFilterSubstring>();
        int ls = fs.size();
        for (int x = 0; x < ls; ++x) {
            MVDFilterSubstring mvdFHelp = MVDFilterUtil.getFilterSubstring((SubstringFilterSeqOfChoice)fs.elementAt(x));
            v.add(mvdFHelp);
        }
        return v;
    }

    private static MVDFilterSubstring getFilterSubstring(SubstringFilterSeqOfChoice fs) {
        try {
            if (fs.choiceId == 0) {
                return new MVDFilterSubstring(5, MVDUtil.FromUTF8(fs.initial));
            }
            if (fs.choiceId == 2) {
                return new MVDFilterSubstring(6, MVDUtil.FromUTF8(fs.final1));
            }
            if (fs.choiceId == 1) {
                return new MVDFilterSubstring(7, MVDUtil.FromUTF8(fs.any));
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static MVDFilterSimple constructSimpleFilter(String aName, int aOp, SubstringFilter sfs) {
        return new MVDFilterSimple(aName, aOp, MVDFilterUtil.processSubstrings(sfs.substrings));
    }

    public static MVDFilter convertFilter(Filter f) {
        String nm = "";
        String val = "";
        try {
            switch (f.choiceId) {
                case 0: {
                    return new MVDFilterComplex(11, MVDFilterUtil.processRecursive(f.and));
                }
                case 1: {
                    return new MVDFilterComplex(12, MVDFilterUtil.processRecursive(f.or));
                }
                case 2: {
                    Vector<MVDFilter> filters = new Vector<MVDFilter>();
                    MVDFilter ftemp = MVDFilterUtil.convertFilter(f.not);
                    filters.add(ftemp);
                    return new MVDFilterComplex(13, filters);
                }
                case 3: {
                    String pe = MVDUtil.FromUTF8(f.equalityMatch.attributeDesc);
                    nm = pe.equalsIgnoreCase("IGNOREDATTR") ? "MVD_IGNORED" : (pe.equalsIgnoreCase("INVALIDATTR") ? "MVD_CLEANED" : pe);
                    val = MVDUtil.FromUTF8(f.equalityMatch.assertionValue);
                    return new MVDFilterSimple(nm, 0, val);
                }
                case 4: {
                    String ps = MVDUtil.FromUTF8(f.substrings.type);
                    nm = ps.equalsIgnoreCase("IGNOREDATTR") ? "MVD_IGNORED" : (ps.equalsIgnoreCase("INVALIDATTR") ? "MVD_CLEANED" : ps);
                    return new MVDFilterSimple(MVDFilterUtil.constructSimpleFilter(nm, 4, f.substrings));
                }
                case 5: {
                    String pg = MVDUtil.FromUTF8(f.greaterOrEqual.attributeDesc);
                    nm = pg.equalsIgnoreCase("IGNOREDATTR") ? "MVD_IGNORED" : (pg.equalsIgnoreCase("INVALIDATTR") ? "MVD_CLEANED" : pg);
                    val = MVDUtil.FromUTF8(f.greaterOrEqual.assertionValue);
                    return new MVDFilterSimple(nm, 2, val);
                }
                case 6: {
                    String pl = MVDUtil.FromUTF8(f.lessOrEqual.attributeDesc);
                    nm = pl.equalsIgnoreCase("IGNOREDATTR") ? "MVD_IGNORED" : (pl.equalsIgnoreCase("INVALIDATTR") ? "MVD_CLEANED" : pl);
                    val = MVDUtil.FromUTF8(f.lessOrEqual.assertionValue);
                    return new MVDFilterSimple(nm, 1, val);
                }
                case 7: {
                    String p = MVDUtil.FromUTF8(f.present);
                    nm = p.equalsIgnoreCase("IGNOREDATTR") ? "MVD_IGNORED" : (p.equalsIgnoreCase("INVALIDATTR") ? "MVD_CLEANED" : p.toLowerCase());
                    return new MVDFilterSimple(nm, 3);
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

