/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.filter;

import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.filter.MVDFilter;
import com.sap.idm.vds.filter.MVDFilterSubstring;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class MVDFilterSimple
extends MVDFilter {
    private String mAttrname;
    private String mAttrvalue;
    private int mOptype;
    private Vector mSubstrings = new Vector();

    public String getAttrName() {
        return this.mAttrname;
    }

    public String getAttrValue() {
        return this.mAttrvalue;
    }

    public int getOpType() {
        return this.mOptype;
    }

    public Vector getSubstrings() {
        return this.mSubstrings;
    }

    public void setAttrName(String s) {
        this.mAttrname = s;
    }

    public void setAttrValue(String o) {
        this.mAttrvalue = o;
    }

    public void setOptype(int i) {
        this.mOptype = i;
    }

    public void setSubstrings(Vector v) {
        this.mSubstrings = v;
    }

    public int getFilterOpType() {
        return 1234;
    }

    MVDFilterSimple(String aName, int aOp, String aVal) {
        super(1234);
        this.mAttrname = aName;
        this.mOptype = aOp;
        this.mAttrvalue = aVal;
    }

    MVDFilterSimple(String aName, int aOp, Vector aSubstrings) {
        super(1234);
        this.mAttrname = aName;
        this.mOptype = aOp;
        this.mSubstrings = aSubstrings;
    }

    MVDFilterSimple(String aName, int aOp) {
        super(1234);
        this.mAttrname = aName;
        this.mOptype = aOp;
        this.mAttrvalue = null;
    }

    MVDFilterSimple(MVDFilterSimple fs) {
        super(1234);
        if (fs != null) {
            this.mAttrname = fs.getAttrName();
            this.mOptype = fs.getOpType();
            this.mAttrvalue = fs.getAttrValue();
            this.mSubstrings = fs.getSubstrings();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        MVDFilterSimple cln = (MVDFilterSimple)super.clone();
        cln.mAttrname = this.mAttrname;
        cln.mOptype = this.mOptype;
        cln.mSubstrings = this.mSubstrings;
        return cln;
    }

    public void clean(String s) {
        if (s.equalsIgnoreCase(this.mAttrname)) {
            this.mAttrname = "MVD_CLEANED";
        }
    }

    public void clean(Vector v) {
        for (int i = 0; i < v.size(); ++i) {
            String s = (String)v.elementAt(i);
            if (!s.equalsIgnoreCase(this.mAttrname)) continue;
            this.mAttrname = "MVD_CLEANED";
            return;
        }
    }

    public String toUrl() {
        String opstr = "";
        String value = "";
        if (this.mAttrname.equals("MVD_CLEANED")) {
            return "FILTER_FALSE";
        }
        if (this.mAttrname.equals("MVD_IGNORED")) {
            return "FILTER_TRUE";
        }
        value = this.mAttrvalue == null ? "*" : this.mAttrvalue;
        if (this.mOptype == 0 || this.mOptype == 1000) {
            opstr = "=";
        } else if (this.mOptype == 2) {
            opstr = ">=";
        } else if (this.mOptype == 3) {
            opstr = "=";
        } else if (this.mOptype == 1) {
            opstr = "<=";
        } else if (this.mOptype == 4) {
            opstr = "=";
            value = "";
            for (int x = 0; x < this.mSubstrings.size(); ++x) {
                value = value + ((MVDFilterSubstring)this.mSubstrings.elementAt(x)).toUrl();
            }
            value = MVDUtil.replace(value, "**", "*");
        }
        return "(" + this.mAttrname + opstr + value + ")";
    }

    public String toMIC() {
        return this.toMIC(null);
    }

    public boolean evaluate(HashMap aAttributes) {
        Vector values = (Vector)aAttributes.get(this.mAttrname.toLowerCase());
        if (values == null) {
            return false;
        }
        switch (this.mOptype) {
            case 0: {
                for (int i = 0; i < values.size(); ++i) {
                    String x = (String)values.elementAt(i);
                    if (!x.equals(this.mAttrvalue)) continue;
                    return true;
                }
                return false;
            }
            case 3: {
                return true;
            }
            case 2: {
                try {
                    int intval = Integer.parseInt(this.mAttrvalue);
                    for (int i = 0; i < values.size(); ++i) {
                        String val = (String)values.elementAt(i);
                        try {
                            int comp = Integer.parseInt(val);
                            if (comp <= intval) continue;
                            return true;
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    return false;
                }
                catch (NumberFormatException e) {
                    for (int i = 0; i < values.size(); ++i) {
                        String val = (String)values.elementAt(i);
                        if (val.compareTo(this.mAttrvalue) <= 0) continue;
                        return true;
                    }
                    return false;
                }
            }
            case 1: {
                try {
                    int intval = Integer.parseInt(this.mAttrvalue);
                    for (int i = 0; i < values.size(); ++i) {
                        String val = (String)values.elementAt(i);
                        try {
                            int comp = Integer.parseInt(val);
                            if (comp >= intval) continue;
                            return true;
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    return false;
                }
                catch (NumberFormatException e) {
                    for (int i = 0; i < values.size(); ++i) {
                        String val = (String)values.elementAt(i);
                        if (val.compareTo(this.mAttrvalue) >= 0) continue;
                        return true;
                    }
                    return false;
                }
            }
            case 4: {
                for (int i = 0; i < values.size(); ++i) {
                    boolean thisValueMatches = true;
                    int strindex = 0;
                    String value = (String)values.elementAt(i);
                    block26: for (int index = 0; index < this.mSubstrings.size() && strindex >= 0; ++index) {
                        MVDFilterSubstring substr = (MVDFilterSubstring)this.mSubstrings.elementAt(i);
                        int subtype = substr.getSubType();
                        String strval = substr.getAttrValue();
                        switch (subtype) {
                            case 5: {
                                if (!value.toLowerCase().startsWith(strval.toLowerCase())) {
                                    thisValueMatches = false;
                                    continue block26;
                                }
                                strindex += strval.length();
                                continue block26;
                            }
                            case 6: {
                                if (!value.toLowerCase().endsWith(strval.toLowerCase())) {
                                    thisValueMatches = false;
                                    continue block26;
                                }
                                strindex = value.length();
                                continue block26;
                            }
                            case 7: {
                                int idx = value.toLowerCase().indexOf(strval.toLowerCase(), strindex);
                                if (idx < 0) {
                                    thisValueMatches = false;
                                    continue block26;
                                }
                                strindex = idx + strval.length();
                            }
                        }
                    }
                    if (!thisValueMatches) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public String toMIC(ArrayList aParams) {
        String opstr = "";
        String value = "";
        String escape = "";
        if (this.mAttrname.equals("MVD_CLEANED")) {
            return "FILTER_FALSE";
        }
        if (this.mAttrname.equals("MVD_IGNORED")) {
            return "FILTER_TRUE";
        }
        value = this.mAttrvalue == null ? "%" : this.mAttrvalue;
        if (this.mOptype == 0) {
            opstr = " = ";
            if (this.mAttrvalue.indexOf("%") != -1) {
                opstr = " LIKE ";
                if (this.mAttrvalue.indexOf("_") != -1) {
                    this.mAttrvalue = MVDUtil.replace(this.mAttrvalue, "_", "!_");
                    escape = " ESCAPE '!'";
                }
            }
        } else if (this.mOptype == 1000) {
            opstr = " LIKE ";
        } else if (this.mOptype == 2) {
            opstr = ">=";
        } else if (this.mOptype == 3) {
            opstr = " LIKE ";
        } else if (this.mOptype == 1) {
            opstr = "<=";
        } else if (this.mOptype == 4) {
            opstr = " LIKE ";
            value = "";
            for (int x = 0; x < this.mSubstrings.size(); ++x) {
                value = value + ((MVDFilterSubstring)this.mSubstrings.elementAt(x)).toMIC();
            }
            if ((value = MVDUtil.replace(value, "%%", "%")).indexOf("_") != -1) {
                value = MVDUtil.replace(value, "_", "!_");
                escape = " ESCAPE '!'";
            }
        }
        if (aParams == null) {
            return "(mskey in (SELECT mskey FROM mxi_values WHERE attr_id IN (SELECT attr_id FROM mxi_attributes WHERE attrname='" + this.mAttrname.toUpperCase() + "') AND searchvalue" + opstr + "'" + value.toUpperCase() + "' " + escape + "))";
        }
        aParams.add(this.mAttrname.toUpperCase());
        aParams.add(value.toUpperCase());
        return "(mskey in (SELECT mskey FROM mxi_values WHERE attr_id IN (SELECT attr_id FROM mxi_attributes WHERE attrname=?) AND searchvalue" + opstr + " ? " + escape + "))";
    }
}

