/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.filter;

import com.sap.idm.vds.filter.MVDFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class MVDFilterComplex
extends MVDFilter
implements Cloneable {
    private Vector mFilters = new Vector();
    private int mFilterOpType;

    MVDFilterComplex(int aOpType, Vector aFilterElements) {
        super(5678);
        this.mFilterOpType = aOpType;
        this.mFilters = aFilterElements;
    }

    public Object clone() throws CloneNotSupportedException {
        MVDFilterComplex cln = (MVDFilterComplex)super.clone();
        cln.mFilterOpType = this.mFilterOpType;
        cln.mFilters = new Vector();
        for (int i = 0; i < this.mFilters.size(); ++i) {
            MVDFilter element = (MVDFilter)this.mFilters.elementAt(i);
            MVDFilter d = (MVDFilter)element.clone();
            cln.mFilters.add(d);
        }
        return cln;
    }

    public int getFilterOpType() {
        return this.mFilterOpType;
    }

    public Vector getFilters() {
        return this.mFilters;
    }

    public void setFilterOpType(int aOpType) {
        this.mFilterOpType = aOpType;
    }

    public void setFilterVector(Vector f) {
        this.mFilters = f;
    }

    public String toUrl() {
        MVDFilter mOne = (MVDFilter)this.mFilters.elementAt(0);
        if (mOne != null) {
            if (this.mFilterOpType == 13) {
                String tmp = mOne.toUrl();
                if (tmp.equals("FILTER_FALSE") || tmp.equals("FILTER_CLEANED")) {
                    return "FILTER_TRUE";
                }
                if (tmp.equals("FILTER_TRUE") || tmp.equals("FILTER_IGNORE")) {
                    return "FILTER_FALSE";
                }
                return "(!" + tmp + ")";
            }
            if (this.mFilters.size() > 1) {
                if (this.mFilterOpType == 11) {
                    String total = "";
                    int cntAdded = 0;
                    for (int x = 0; x < this.mFilters.size(); ++x) {
                        String tmp = ((MVDFilter)this.mFilters.elementAt(x)).toUrl();
                        if (tmp.equals("FILTER_FALSE")) {
                            return "FILTER_FALSE";
                        }
                        if (tmp.equals("FILTER_TRUE")) continue;
                        total = total + tmp;
                        ++cntAdded;
                    }
                    if (cntAdded == 0) {
                        return "FILTER_TRUE";
                    }
                    if (cntAdded == 1) {
                        return total;
                    }
                    return "(&" + total + ")";
                }
                if (this.mFilterOpType == 12) {
                    String total = "";
                    int cntAdded = 0;
                    for (int x = 0; x < this.mFilters.size(); ++x) {
                        String tmp = ((MVDFilter)this.mFilters.elementAt(x)).toUrl();
                        if (tmp.equals("FILTER_FALSE") || tmp.equals("FILTER_TRUE")) continue;
                        total = total + tmp;
                        ++cntAdded;
                    }
                    if (cntAdded == 0) {
                        return "FILTER_TRUE";
                    }
                    if (cntAdded == 1) {
                        return total;
                    }
                    return "(|" + total + ")";
                }
            }
        }
        return "";
    }

    public String toMIC(int databasetype, boolean appendEscape) {
        MVDFilter mOne = (MVDFilter)this.mFilters.elementAt(0);
        if (mOne != null) {
            if (this.mFilterOpType == 13) {
                String tmp = mOne.toMIC();
                if (tmp.equals("FILTER_FALSE") || tmp.equals("FILTER_CLEANED")) {
                    return "FILTER_TRUE";
                }
                if (tmp.equals("FILTER_TRUE") || tmp.equals("FILTER_IGNORE")) {
                    return "FILTER_FALSE";
                }
                return "( NOT " + tmp + ")";
            }
            if (this.mFilters.size() > 1) {
                if (this.mFilterOpType == 11) {
                    String total = "";
                    int cntAdded = 0;
                    for (int x = 0; x < this.mFilters.size(); ++x) {
                        String tmp = ((MVDFilter)this.mFilters.elementAt(x)).toMIC();
                        if (tmp.equals("FILTER_FALSE")) {
                            return "FILTER_FALSE";
                        }
                        if (tmp.equals("FILTER_TRUE")) continue;
                        if (total.length() > 0) {
                            total = total + " AND ";
                        }
                        total = total + tmp;
                        ++cntAdded;
                    }
                    if (cntAdded == 0) {
                        return "FILTER_TRUE";
                    }
                    if (cntAdded == 1) {
                        return total;
                    }
                    return "(" + total + ")";
                }
                if (this.mFilterOpType == 12) {
                    String total = "";
                    int cntAdded = 0;
                    for (int x = 0; x < this.mFilters.size(); ++x) {
                        String tmp = ((MVDFilter)this.mFilters.elementAt(x)).toMIC();
                        if (tmp.equals("FILTER_FALSE")) continue;
                        if (total.length() > 0) {
                            total = total + " OR ";
                        }
                        total = total + tmp;
                        ++cntAdded;
                    }
                    if (cntAdded == 0) {
                        return "FILTER_TRUE";
                    }
                    if (cntAdded == 1) {
                        return total;
                    }
                    return "(" + total + ")";
                }
            }
        }
        return "";
    }

    public String toMIC() {
        return this.toMIC(null);
    }

    public void clean(String s) {
        for (int x = 0; x < this.mFilters.size(); ++x) {
            ((MVDFilter)this.mFilters.elementAt(x)).clean(s);
        }
    }

    public void clean(Vector v) {
        for (int i = 0; i < v.size(); ++i) {
            String s = (String)v.elementAt(i);
            for (int x = 0; x < this.mFilters.size(); ++x) {
                ((MVDFilter)this.mFilters.elementAt(x)).clean(s);
            }
        }
    }

    public boolean evaluate(HashMap aAttributes) {
        switch (this.mFilterOpType) {
            case 11: {
                MVDFilter f;
                boolean result = true;
                for (int i = 0; i < this.mFilters.size() && (result &= (f = (MVDFilter)this.mFilters.elementAt(i)).evaluate(aAttributes)); ++i) {
                }
                return result;
            }
            case 12: {
                MVDFilter f;
                boolean res = false;
                for (int i = 0; i < this.mFilters.size() && !(res |= (f = (MVDFilter)this.mFilters.elementAt(i)).evaluate(aAttributes)); ++i) {
                }
                return res;
            }
            case 13: {
                MVDFilter f = (MVDFilter)this.mFilters.firstElement();
                return !f.evaluate(aAttributes);
            }
        }
        return false;
    }

    public String toMIC(ArrayList aParams) {
        MVDFilter mOne = (MVDFilter)this.mFilters.elementAt(0);
        if (mOne != null) {
            if (this.mFilterOpType == 13) {
                String tmp = mOne.toMIC(aParams);
                if (tmp.equals("FILTER_FALSE") || tmp.equals("FILTER_CLEANED")) {
                    return "FILTER_TRUE";
                }
                if (tmp.equals("FILTER_TRUE") || tmp.equals("FILTER_IGNORE")) {
                    return "FILTER_FALSE";
                }
                return "( NOT " + tmp + ")";
            }
            if (this.mFilters.size() > 1) {
                if (this.mFilterOpType == 11) {
                    String total = "";
                    int cntAdded = 0;
                    for (int x = 0; x < this.mFilters.size(); ++x) {
                        String tmp = ((MVDFilter)this.mFilters.elementAt(x)).toMIC(aParams);
                        if (tmp.equals("FILTER_FALSE")) {
                            return "FILTER_FALSE";
                        }
                        if (tmp.equals("FILTER_TRUE")) continue;
                        if (total.length() > 0) {
                            total = total + " AND ";
                        }
                        total = total + tmp;
                        ++cntAdded;
                    }
                    if (cntAdded == 0) {
                        return "FILTER_TRUE";
                    }
                    if (cntAdded == 1) {
                        return total;
                    }
                    return "(" + total + ")";
                }
                if (this.mFilterOpType == 12) {
                    String total = "";
                    int cntAdded = 0;
                    for (int x = 0; x < this.mFilters.size(); ++x) {
                        String tmp = ((MVDFilter)this.mFilters.elementAt(x)).toMIC(aParams);
                        if (tmp.equals("FILTER_FALSE") || tmp.equals("FILTER_TRUE")) continue;
                        if (total.length() > 0) {
                            total = total + " OR ";
                        }
                        total = total + tmp;
                        ++cntAdded;
                    }
                    if (cntAdded == 0) {
                        return "FILTER_TRUE";
                    }
                    if (cntAdded == 1) {
                        return total;
                    }
                    return "(" + total + ")";
                }
            }
        }
        return "";
    }
}

