/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.event;

import com.sap.idm.vds.MVDModAttrValues;
import com.sap.idm.vds.event.EventTriggerConfig;
import com.sap.idm.vds.filter.MVDFilter;
import com.sap.idm.vds.filter.MVDFilterUtilities;
import com.sap.idm.vds.message.MxAdd;
import com.sap.idm.vds.message.MxDelete;
import com.sap.idm.vds.message.MxModify;
import com.sap.idm.vds.message.MxRequest;
import java.util.HashMap;
import java.util.Vector;

public class FilterEventTrigger
extends EventTriggerConfig {
    MVDFilter mFilter;

    public FilterEventTrigger(String aFilter, String aUsergroups, String aOperations, String aResultCodes) {
        super(aUsergroups, aOperations, aResultCodes);
        this.mFilter = MVDFilterUtilities.constructFilter(aFilter);
    }

    public boolean evaluate(MxRequest aOperation) {
        HashMap attributes = new HashMap();
        if (aOperation instanceof MxAdd) {
            MxAdd add = (MxAdd)aOperation;
            attributes.putAll(add.getAttrSetAndValues().getAttrAndValues());
            Vector<String> dnvector = new Vector<String>();
            dnvector.add(add.getDn());
            attributes.put("dn", dnvector);
        } else if (aOperation instanceof MxModify) {
            MxModify mod = (MxModify)aOperation;
            Vector modvals = mod.getAttrAndModValues();
            for (int i = 0; i < modvals.size(); ++i) {
                MVDModAttrValues val = (MVDModAttrValues)modvals.get(i);
                attributes.put(val.getAttrName(), new Vector(val));
            }
            Vector<String> dnvector = new Vector<String>();
            dnvector.add(mod.getDn());
            attributes.put("dn", dnvector);
        } else if (aOperation instanceof MxDelete) {
            MxDelete del = (MxDelete)aOperation;
            Vector<String> dnvector = new Vector<String>();
            dnvector.add(del.getDn());
            attributes.put("dn", dnvector);
        } else {
            return false;
        }
        return this.mFilter.evaluate(attributes);
    }

    public void setFilter(String aFilter) {
        this.mFilter = MVDFilterUtilities.constructFilter(aFilter);
    }
}

