/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.Engine;
import com.sap.idm.vds.Globals;
import com.sap.idm.vds.MVDGlobals;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDServer;
import com.sap.idm.vds.MVDSnmpSettings;
import com.sap.idm.vds.config.Config;
import com.sap.idm.vds.config.EventTriggerList;
import com.sap.idm.vds.config.FailoverGroupList;
import com.sap.idm.vds.config.LoadBalancingGroupList;
import com.sap.idm.vds.config.LogConfig;
import com.sap.idm.vds.config.MVDAcl;
import com.sap.idm.vds.config.MVDAttributeSourceList;
import com.sap.idm.vds.config.MVDCacheList;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.config.MVDDataSourceList;
import com.sap.idm.vds.config.MVDDataSourceSequentialGroupList;
import com.sap.idm.vds.config.MVDDynamicAddGroupList;
import com.sap.idm.vds.config.MVDForestList;
import com.sap.idm.vds.config.MVDJoinGroupList;
import com.sap.idm.vds.config.MVDKeyStore;
import com.sap.idm.vds.config.MVDKeyStoreList;
import com.sap.idm.vds.config.MVDLDAPDeployment;
import com.sap.idm.vds.config.MVDLDAPDeploymentList;
import com.sap.idm.vds.config.MVDPriorityObject;
import com.sap.idm.vds.config.MVDProvisioningList;
import com.sap.idm.vds.config.MVDProxy;
import com.sap.idm.vds.config.MVDProxyLoggerDebitList;
import com.sap.idm.vds.config.MVDRulesList;
import com.sap.idm.vds.config.MVDSourceList;
import com.sap.idm.vds.config.MVDStatisticsList;
import com.sap.idm.vds.config.MVDTopMultiServerGroupList;
import com.sap.idm.vds.config.MVDUserGroupList;
import com.sap.idm.vds.config.MVDUserList;
import com.sap.idm.vds.config.MVDWSDeploymentList;
import com.sap.idm.vds.ie.op.common.AbstractReader;
import com.sap.idm.vds.ie.op.common.util.MVDMic_Util;
import com.sap.idm.vds.protocols.ldap.MxLdapListener;
import com.sap.idm.vds.queue.MVDPriorityQueue;
import com.sap.idm.vds.sldreg.VDSSLDRegStandalone;
import com.sap.idm.vds.util.ConfigUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReloadConfig
extends Thread {
    private static int mMagicNumber = -1;
    private Config config;
    private String mVersion;
    private long mExpires;
    private boolean mRunning;
    private File mRndFile;
    private int tenSecondsCounter = 0;

    public ReloadConfig(Config cfg) throws MVDConfigException {
        super("Reload");
        this.config = cfg;
        this.mRunning = true;
    }

    public void writeMagicNumberToFile() {
        try {
            boolean writeFile = false;
            if (mMagicNumber == -1) {
                mMagicNumber = (int)(Math.random() * 2.147483647E9 % 2.147483647E9);
                writeFile = true;
            }
            if (writeFile || !this.mRndFile.exists() || !this.mRndFile.canWrite()) {
                BufferedWriter writer;
                String base = this.config.getUniqueConfigBase();
                String fileName = base + ".rnd";
                this.mRndFile = new File(fileName);
                String strTmp = this.mRndFile.getName();
                String configBase = strTmp.substring(0, strTmp.length() - 4);
                MVDProxy.SetRandomFile(fileName);
                String configsource = "file";
                switch (MVDServer.getConfigSourceType()) {
                    case 0: {
                        configsource = "file";
                        break;
                    }
                    case 1: {
                        configsource = "db";
                        break;
                    }
                    case 2: {
                        configsource = "mic";
                        break;
                    }
                    case 3: {
                        configsource = "http";
                    }
                }
                String securityoption = null;
                if (MVDLDAPDeploymentList.getMainLDAPDeployment().getSecureServer()) {
                    securityoption = "ssl";
                    String keystoreid = MVDLDAPDeploymentList.getMainLDAPDeployment().getKeystoreID();
                    MVDKeyStore akeystore = MVDKeyStoreList.getKeyStoreByID(Integer.parseInt(keystoreid));
                    String trustfile = akeystore.getCertStorePath();
                    String password = MVDLDAPDeploymentList.getMainLDAPDeployment().getClientAuthentication() ? akeystore.getCertStorePassword() : "-NOT_NEEDED-";
                    String temp = trustfile + "$$" + password;
                    securityoption = securityoption + ":" + MVDMic_Util.encode((String)temp);
                }
                if (!this.mRndFile.exists() || this.mRndFile.canWrite()) {
                    String servername;
                    MVDLDAPDeployment maindep = MVDLDAPDeploymentList.getMainLDAPDeployment();
                    writer = new BufferedWriter(new FileWriter(this.mRndFile));
                    String string = servername = maindep.getNetworkInterface() == null || maindep.getNetworkInterface().equalsIgnoreCase("") || maindep.getNetworkInterface().equalsIgnoreCase("all") ? "localhost" : maindep.getNetworkInterface();
                    if (securityoption == null) {
                        writer.write(mMagicNumber + "," + servername + ":" + maindep.getPortNumber() + "," + configsource);
                    } else {
                        writer.write(mMagicNumber + "," + servername + ":" + maindep.getPortNumber() + "," + configsource + "," + securityoption);
                    }
                } else {
                    throw new Exception("Cannot write to the rnd file");
                }
                writer.flush();
                writer.close();
                Thread t = new Thread(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public void run() {
                        try {
                            File f = new File(MVDProxy.RandomFile());
                            if (f.exists() && f.canWrite() && f.delete()) return;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                Runtime.getRuntime().addShutdownHook(t);
                MVDProxy.SetSecretDNToStopMVD(mMagicNumber, configBase);
            } else {
                this.mRndFile.setLastModified(System.currentTimeMillis());
            }
        }
        catch (Exception e) {
            MVDLogger.Log("Cannot write to the rnd file", 2);
        }
    }

    public synchronized void run() {
        while (this.mRunning) {
            String base;
            try {
                Document doc;
                try {
                    this.writeMagicNumberToFile();
                    this.wait(10000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (!this.mRunning) break;
                String jdbcurle = (String)MVDServer.hashCommandArguments.get("JDBCURL");
                String httpurl = (String)MVDServer.hashCommandArguments.get("HTTPURL");
                if (jdbcurle != null || httpurl != null) {
                    AbstractReader exsternreader = MVDServer.getExternReader();
                    exsternreader.load(false);
                }
                if (this.tenSecondsCounter == 0 && MVDServer.getMVDProtocol() == 0) {
                    MVDLogger.Log("SLD registration (standalone mode) ... ", 2);
                    Vector<String> vPorts = new Vector<String>();
                    Iterator iter = MVDLDAPDeploymentList.getLDAPDeployments().keySet().iterator();
                    while (iter.hasNext()) {
                        String lsName = (String)iter.next();
                        MVDLDAPDeployment ldp = (MVDLDAPDeployment)MVDLDAPDeploymentList.getLDAPDeployments().get(lsName);
                        if (!ldp.isEnabled()) continue;
                        vPorts.add("" + ldp.getPortNumber());
                    }
                    if (MVDProxy.getSLDRegEnabled() && MVDProxy.getSLDUrl() != null) {
                        MVDLogger.Log("SLD registration (standalone mode) - configuring", 2);
                        VDSSLDRegStandalone.doConfigure(MVDProxy.getSLDUrl(), MVDProxy.getSLDUsername(), MVDProxy.getSLDPassword(), vPorts);
                    }
                    VDSSLDRegStandalone.doPublish();
                }
                if (++this.tenSecondsCounter == 1440) {
                    this.tenSecondsCounter = 0;
                }
                if ((doc = this.config.getNewDoc()) == null) continue;
                Engine.increaseGlobalReloadCounter();
                Globals.initReload();
                NodeList nl = doc.getElementsByTagName("MVDConfig");
                Node node = nl.item(0);
                nl = MVDGlobals.getOperationMode() == 0 ? ((Element)node).getElementsByTagName("Logging") : doc.getElementsByTagName("Logging");
                node = nl.item(0);
                LogConfig.readLogConfig(node, null);
                MVDLogger.Log("Reloading configuration", 4);
                nl = doc.getElementsByTagName("MVDConfig");
                node = nl.item(0);
                NamedNodeMap attrMap = node.getAttributes();
                Node oneAttrNode = attrMap.getNamedItem("Version");
                if (oneAttrNode != null) {
                    this.mVersion = oneAttrNode.getNodeValue();
                }
                String operationaAttributes = MVDGlobals.getGlobalParameter("GLOBAL_OPERATIONAL_ATTRIBUTES", "");
                Globals.setOperationalAttributes(operationaAttributes);
                String extendedCacheAttributes = MVDGlobals.getGlobalParameter("GLOBAL_EXTENDED_CACHE_ATTRIBUTES", "");
                if (extendedCacheAttributes.length() != 0) {
                    Globals.setOperationalAttributes(extendedCacheAttributes);
                }
                nl = doc.getElementsByTagName("KeyStores");
                node = nl.item(0);
                MVDKeyStoreList.reloadConfig(node);
                MVDLogger.Log("Reading globals configuration", 2);
                node = doc.getElementsByTagName("Proxy").item(0);
                MVDProxyLoggerDebitList.readMVDGlobals(node);
                MVDLogger.Log("Reading LDAP Deployments configuration", 2);
                nl = doc.getElementsByTagName("LDAPDeployments");
                node = nl.item(0);
                MVDLDAPDeploymentList.loadConfig(node);
                MVDLDAPDeploymentList.applyChanges();
                if (MVDServer.getMVDProtocol() == 0) {
                    Vector<String> existingLoggerKeys = new Vector<String>();
                    Vector<String> addLoggerKeys = new Vector<String>();
                    Vector<String> removeLoggerKeys = new Vector<String>();
                    HashMap<String, MxLdapListener> newToBeStartedMap = new HashMap<String, MxLdapListener>();
                    Iterator iter = MVDLDAPDeploymentList.getLDAPDeployments().keySet().iterator();
                    while (iter.hasNext()) {
                        String lsName = (String)iter.next();
                        MVDLDAPDeployment ldp = (MVDLDAPDeployment)MVDLDAPDeploymentList.getLDAPDeployments().get(lsName);
                        MxLdapListener aLdapListener = (MxLdapListener)MVDServer.getActiveLdapListenerNames().get(ldp.getName());
                        existingLoggerKeys.add("LDAP Sessions:" + ldp.getName() + "_" + ldp.getPortNumber());
                        if (ldp.isEnabled()) {
                            if (aLdapListener != null) {
                                if (aLdapListener.isAlive() || MVDLDAPDeploymentList.isMainDeployment(ldp)) continue;
                                MVDServer.getActiveLdapListenerNames().remove(ldp.getName());
                            }
                            MxLdapListener newLdapListener = new MxLdapListener(ldp);
                            String aLoggerKey = "LDAP Sessions:" + ldp.getName() + "_" + ldp.getPortNumber();
                            addLoggerKeys.add(aLoggerKey);
                            newToBeStartedMap.put(ldp.getName(), newLdapListener);
                            continue;
                        }
                        if (aLdapListener == null) continue;
                        if (aLdapListener.isAlive()) {
                            aLdapListener.shutdown();
                            MVDServer.getActiveLdapListenerNames().remove(ldp.getName());
                            String aLoggerKey = "LDAP Sessions:" + ldp.getName() + "_" + ldp.getPortNumber();
                            removeLoggerKeys.add(aLoggerKey);
                            continue;
                        }
                        MVDServer.getActiveLdapListenerNames().remove(ldp.getName());
                    }
                    existingLoggerKeys.add(MVDGlobals.getMainGroupName());
                    LogConfig.addLoggers(existingLoggerKeys);
                    if (removeLoggerKeys.size() > 0) {
                        LogConfig.removeLoggers(removeLoggerKeys);
                    }
                    Iterator ix = newToBeStartedMap.keySet().iterator();
                    while (ix.hasNext()) {
                        String key = (String)ix.next();
                        MxLdapListener aLdapListener = (MxLdapListener)newToBeStartedMap.get(key);
                        aLdapListener.start();
                        MVDServer.getActiveLdapListenerNames().put(key, aLdapListener);
                    }
                } else {
                    nl = doc.getElementsByTagName("WSDeployments");
                    if (nl.getLength() == 1) {
                        node = nl.item(0);
                        MVDWSDeploymentList.reloadConfig(node);
                    }
                }
                MVDLogger.Log("Reading cache configuration", 2);
                nl = doc.getElementsByTagName("Cache");
                node = nl.item(0);
                MVDCacheList.reloadConfig(node);
                MVDLogger.Log("Reading request queue configuration", 2);
                nl = doc.getElementsByTagName("RequestQueue");
                node = nl.item(0);
                if (node != null) {
                    MVDPriorityObject.FillQueueDef(node);
                }
                MVDLogger.Log("Reading rules configuration", 2);
                nl = doc.getElementsByTagName("Rules");
                node = nl.item(0);
                MVDRulesList.reloadConfig(node);
                MVDLogger.Log("Reading attribute source configuration", 2);
                MVDAttributeSourceList.initReload();
                nl = doc.getElementsByTagName("AttributeSources");
                for (int i = 0; i < nl.getLength(); ++i) {
                    node = nl.item(i);
                    MVDAttributeSourceList.reloadConfig(node);
                }
                MVDLogger.Log("Reading multi server groups configuration", 2);
                nl = doc.getElementsByTagName("MultiServerGroups");
                if (nl.getLength() > 0) {
                    node = nl.item(0);
                    MVDTopMultiServerGroupList.reloadConfig(node);
                }
                MVDLogger.Log("Reading data source configuration", 2);
                nl = doc.getElementsByTagName("DataSources");
                node = nl.item(0);
                MVDDataSourceList.reloadConfig(node);
                if (this.mVersion.equalsIgnoreCase("1.5") || this.mVersion.equalsIgnoreCase("8.2") || this.mVersion.equalsIgnoreCase("8.3") || this.mVersion.equalsIgnoreCase("8.4")) {
                    MVDLogger.Log("Reading unlinked data source group configuration", 2);
                    nl = doc.getElementsByTagName("UnlinkedDataSourceGroups");
                    node = nl.item(0);
                    if (node != null) {
                        MVDDataSourceSequentialGroupList.reloadConfig(node);
                    }
                    MVDLogger.Log("Reading provisioning update data source group configuration", 2);
                    nl = doc.getElementsByTagName("ProvisioningGroups");
                    if (nl != null && nl.getLength() > 0) {
                        node = nl.item(0);
                        MVDProvisioningList.reloadConfig(node);
                    }
                    MVDAttributeSourceList.applyChanges();
                    MVDLogger.Log("Reading join data source group configuration", 2);
                    nl = doc.getElementsByTagName("JoinGroups");
                    if (nl != null && nl.getLength() > 0) {
                        node = nl.item(0);
                        MVDJoinGroupList.reloadConfig(node);
                    }
                    MVDLogger.Log("Reading Dynamic add data source group configuration", 2);
                    nl = doc.getElementsByTagName("DynamicAddGroups");
                    if (nl != null && nl.getLength() > 0) {
                        node = nl.item(0);
                        MVDDynamicAddGroupList.reloadConfig(node);
                    }
                    MVDLogger.Log("Reading load balancing data source group configuration", 2);
                    nl = doc.getElementsByTagName("LoadBalancingGroups");
                    if (nl != null && nl.getLength() > 0) {
                        node = nl.item(0);
                        LoadBalancingGroupList.reloadConfig(node);
                    }
                    MVDLogger.Log("Reading failover data source group configuration", 2);
                    nl = doc.getElementsByTagName("FailoverGroups");
                    if (nl != null && nl.getLength() > 0) {
                        node = nl.item(0);
                        FailoverGroupList.reloadConfig(node);
                    }
                } else {
                    MVDLogger.Log("Could not reload configuration: The version of this configuration is too old. Please open in the GUI first", 7);
                }
                MVDLogger.Log("Reading forest configuration", 2);
                nl = doc.getElementsByTagName("Forest");
                node = nl.item(0);
                MVDForestList.reloadConfig(node);
                MVDAcl.initReload();
                MVDLogger.Log("Reading user group configuration", 2);
                nl = doc.getElementsByTagName("UserGroups");
                node = nl.item(0);
                MVDUserGroupList.reloadConfig(node);
                MVDUserGroupList.applyChanges();
                MVDLogger.Log("Reading users configuration", 2);
                nl = doc.getElementsByTagName("Users");
                node = nl.item(0);
                MVDUserList.reloadConfig(node);
                MVDUserList.applyChanges();
                nl = doc.getElementsByTagName("ProvisioningGroups");
                if (nl != null && nl.getLength() > 0) {
                    node = nl.item(0);
                    MVDProvisioningList.reloadConfig(node);
                }
                MVDRulesList.applyChanges();
                MVDForestList.applyChanges();
                MVDDataSourceList.applyChanges();
                MVDDataSourceSequentialGroupList.applyChanges();
                MVDProvisioningList.applyChanges();
                MVDJoinGroupList.applyChanges();
                MVDDynamicAddGroupList.applyChanges();
                LoadBalancingGroupList.applyChanges();
                FailoverGroupList.applyChanges();
                MVDLogger.Log("Reading event trigger configuration", 2);
                nl = doc.getElementsByTagName("EventTriggers");
                if (nl != null && nl.getLength() > 0) {
                    node = nl.item(0);
                    EventTriggerList.reloadEventTriggers(node);
                }
                EventTriggerList.applyChanges();
                nl = doc.getElementsByTagName("ACLs");
                node = nl.item(0);
                MVDAcl.reloadConfig(node);
                MVDDataSourceList.createInternalTree();
                MVDDataSourceSequentialGroupList.createInternalTree();
                MVDProvisioningList.createInternalTree();
                MVDJoinGroupList.createInternalTree();
                MVDDynamicAddGroupList.createInternalTree();
                LoadBalancingGroupList.createInternalTree();
                FailoverGroupList.createInternalTree();
                MVDSourceList.connectSourcesToInternalTree();
                node = doc.getElementsByTagName("Proxy").item(0);
                MVDProxyLoggerDebitList.checkConfig(node);
                this.config.saveLastCorrectConfig();
                MVDProxyLoggerDebitList.reloadConfig(node);
                if (MVDSnmpSettings.EnableSnmpTraps()) {
                    MVDLogger.initSNMP(MVDSnmpSettings.SnmpServer(), MVDSnmpSettings.SnmpPort());
                }
                MVDUserList.reloadInternalUser();
                MVDAcl.applyChanges();
                MVDCacheList.applyReload();
                MVDStatisticsList.applyReload();
                Globals.applyReload();
                MVDPriorityQueue aQueue = new MVDPriorityQueue();
                if (!aQueue.getEnabled()) {
                    aQueue = null;
                }
                Globals.setPriorityQueue(aQueue);
                MVDWSDeploymentList.applyChanges();
                MVDProxy.reInitializeTransformationClass();
                MVDLogger.Log("Reloading of configuration succeeded", 3);
                String base2 = this.config.getUniqueConfigBase();
                ConfigUtil.writeKKRFile(base2 + ".kkr", null);
            }
            catch (MVDConfigException ce) {
                base = this.config.getUniqueConfigBase();
                ConfigUtil.writeKKRFile(base + ".kkr", ce);
                MVDLogger.Log("Could not reload configuration: " + ce.getMessage(), 7);
            }
            catch (Exception e) {
                base = this.config.getUniqueConfigBase();
                ConfigUtil.writeKKRFile(base + ".kkr", e);
                MVDLogger.Log("Reload config exception " + e.getMessage(), 7);
            }
            catch (Error e) {
                base = this.config.getUniqueConfigBase();
                ConfigUtil.writeKKRFile(base + ".kkr", e);
                MVDLogger.Log("Reload config error " + e.getMessage(), 7);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            this.mRunning = false;
            ReloadConfig reloadConfig = this;
            synchronized (reloadConfig) {
                this.notify();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

