/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.config.MVDWSDeployment;
import java.util.Hashtable;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MVDWSDeploymentList {
    private static Hashtable allWsDeployments = new Hashtable();
    private static Hashtable newWsDeployments;

    public static Hashtable getWsDeployments() {
        return allWsDeployments;
    }

    public static MVDWSDeployment getWSDeploymentByName(String aName) {
        return (MVDWSDeployment)allWsDeployments.get(aName);
    }

    public static void reloadConfig(Node wsdeplTopNode) throws MVDConfigException {
        MVDWSDeploymentList.readAllWsDeployments(wsdeplTopNode);
    }

    public static void applyChanges() {
        allWsDeployments = newWsDeployments;
    }

    public static void loadConfig(Node wsdeplTopNode) throws MVDConfigException {
        MVDWSDeploymentList.readAllWsDeployments(wsdeplTopNode);
        MVDWSDeploymentList.applyChanges();
    }

    private static void readAllWsDeployments(Node wsdeplTopNode) throws MVDConfigException {
        newWsDeployments = new Hashtable();
        NodeList nodeList = wsdeplTopNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            MVDWSDeployment wsdepl = new MVDWSDeployment();
            if (!MVDWSDeploymentList.fillWSDeployment(wsdepl, nodeList.item(i))) continue;
            if (wsdepl.getApplicationName() == null) {
                throw new MVDConfigException("WSDeployment config: " + wsdepl.getName() + " - Aplication name is 'null'");
            }
            if (newWsDeployments.put(wsdepl.getApplicationName(), wsdepl) == null) continue;
            throw new MVDConfigException("WSDeployment config: Identical hash " + wsdepl.getName());
        }
    }

    private static boolean fillWSDeployment(MVDWSDeployment wsdepl, Node WSDeploymentRecordNode) throws MVDConfigException {
        if (!WSDeploymentRecordNode.hasChildNodes()) {
            return false;
        }
        try {
            NodeList nodeList = WSDeploymentRecordNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String strVal;
                Node node = nodeList.item(i);
                if (!node.hasChildNodes()) continue;
                String nodeStr = node.getNodeName();
                if (nodeStr.equalsIgnoreCase("Name")) {
                    strVal = node.getFirstChild().getNodeValue();
                    wsdepl.setName(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Enabled")) {
                    boolean boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    wsdepl.setEnabled(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("TransClass")) {
                    strVal = node.getFirstChild().getNodeValue();
                    wsdepl.setTransformationClass(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Server")) {
                    strVal = node.getFirstChild().getNodeValue();
                    wsdepl.setDeploymentServer(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ApplicationName")) {
                    strVal = node.getFirstChild().getNodeValue();
                    wsdepl.setApplicationName(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Description")) {
                    strVal = node.getFirstChild().getNodeValue();
                    wsdepl.setDescription(strVal);
                    continue;
                }
                throw new MVDConfigException("Configuration error: Wrong node type in WS Deployment config: " + nodeStr);
            }
        }
        catch (NumberFormatException nfe) {
            throw new MVDConfigException("WS Deployment Configuration error: Expected int but got String: " + nfe.getMessage());
        }
        catch (DOMException de) {
            throw new MVDConfigException("WS Deployment Configuration error: Cannot get node value: " + de.getMessage());
        }
        return true;
    }
}

