/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.config.MVDForestList;
import com.sap.idm.vds.config.MVDProxy;
import com.sap.idm.vds.config.MVDUser;
import com.sap.idm.vds.config.MVDUserGroup;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MVDUserList {
    private static Hashtable allUsers = new Hashtable();
    private static Hashtable newUsers;

    public static void applyChanges() {
        allUsers = newUsers;
    }

    public static void reloadConfig(Node node) throws MVDConfigException {
        MVDUserList.readUsers(node);
    }

    public static void loadConfig(Node node) throws MVDConfigException {
        MVDUserList.readUsers(node);
        MVDUserList.applyChanges();
    }

    private static void readUsers(Node userTopNode) throws MVDConfigException {
        newUsers = new Hashtable();
        NodeList nodeList = userTopNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            MVDUser ur = new MVDUser();
            if (!MVDUserList.FillUser(ur, nodeList.item(i))) continue;
            newUsers.put(new Integer(ur.ID()), ur);
        }
        if (MVDProxy.isTestModeEnabled() && MVDProxy.getTestModeUser() != null && MVDProxy.getTestModePassword() != null) {
            MVDUser internalUser = new MVDUser();
            internalUser.SetID(-999992);
            internalUser.SetLoginName(MVDProxy.getTestModeUser().toLowerCase());
            internalUser.SetPassword(MVDProxy.getTestModePassword());
            internalUser.SetFromIP("");
            internalUser.SetUserGroupDisplayName(Integer.MAX_VALUE - MVDForestList.INTERNAL_TREE_ID + "");
            internalUser.SetSubnetMask("");
            newUsers.put(new Integer(internalUser.ID()), internalUser);
        }
    }

    public static void reloadInternalUser() {
        if (MVDProxy.isTestModeEnabled() && MVDProxy.getTestModeUser() != null && MVDProxy.getTestModePassword() != null) {
            MVDUser internalUser = new MVDUser();
            internalUser.SetID(-999992);
            internalUser.SetLoginName(MVDProxy.getTestModeUser().toLowerCase());
            internalUser.SetPassword(MVDProxy.getTestModePassword());
            internalUser.SetFromIP("");
            internalUser.SetUserGroupDisplayName(Integer.MAX_VALUE - MVDForestList.INTERNAL_TREE_ID + "");
            internalUser.SetSubnetMask("");
            allUsers.put(new Integer(internalUser.ID()), internalUser);
        } else {
            allUsers.remove(new Integer(-999992));
        }
    }

    private static boolean FillUser(MVDUser ur, Node userRecordNode) throws MVDConfigException {
        if (!userRecordNode.hasChildNodes()) {
            return false;
        }
        try {
            NodeList nodeList = userRecordNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                boolean boolVal;
                String strVal;
                Node node = nodeList.item(i);
                if (!node.hasChildNodes()) continue;
                String nodeStr = node.getNodeName();
                if (nodeStr.equalsIgnoreCase("ID")) {
                    int intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    ur.SetID(intVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Name") || nodeStr.equalsIgnoreCase("LoginName")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ur.SetLoginName(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Password")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ur.SetPassword(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ClientIP") || nodeStr.equalsIgnoreCase("FromIP")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ur.SetFromIP(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("UserGroupID") || nodeStr.equalsIgnoreCase("UserGroupDisplayName")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ur.SetUserGroupDisplayName(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("SubnetMask")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ur.SetSubnetMask(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("CaseSignificant")) {
                    boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    ur.SetCaseSignificant(boolVal);
                    continue;
                }
                if (!nodeStr.equalsIgnoreCase("RegExp")) continue;
                boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                ur.SetRegExp(boolVal);
            }
        }
        catch (NumberFormatException nfe) {
            throw new MVDConfigException("User Configuration error: Expected int but got String: " + nfe.getMessage());
        }
        catch (DOMException de) {
            throw new MVDConfigException("User Configuration error: Cannot get node value: " + de.getMessage());
        }
        return true;
    }

    private static String IpAnd(String Ip1, String ip2) {
        Vector userMask = MVDUtil.splitString(Ip1, ".");
        Vector clientMask = MVDUtil.splitString(ip2, ".");
        String temp = "";
        for (int x = 0; x <= 3; ++x) {
            int a = Integer.parseInt((String)userMask.get(x));
            int b = Integer.parseInt((String)clientMask.get(x));
            if (temp.length() > 0) {
                temp = temp + ".";
            }
            temp = temp + (a & b);
        }
        return temp;
    }

    private static String GetDoubleHash(String s) {
        byte[] pwHash = MVDUtil.getMD5Bytes(MVDUtil.ToUTF8(s));
        String pwHashString = MVDUtil.byteToHex(pwHash);
        pwHashString = pwHashString.toLowerCase();
        byte[] pwpwHash = MVDUtil.getMD5Bytes(MVDUtil.ToUTF8(pwHashString));
        String finalHashString = MVDUtil.byteToHex(pwpwHash);
        finalHashString = finalHashString.toLowerCase();
        return finalHashString;
    }

    private static boolean checkSubNetMask(String ipUser, String subUser, String sIP) {
        String s3;
        String s2 = MVDUserList.IpAnd(ipUser, subUser);
        return s2.equals(s3 = MVDUserList.IpAnd(subUser, sIP));
    }

    private static MVDUserGroup UserPwdIp(String sName, String sPwd, String sIP) {
        Enumeration e = allUsers.elements();
        while (e.hasMoreElements()) {
            MVDUser us = (MVDUser)e.nextElement();
            if (us.FromIP().size() == 0 || us.isRegExp()) continue;
            boolean bCredentialsOK = false;
            if (us.isCaseSignificant()) {
                if (us.LoginName().equals(sName) && us.Password().equals(sPwd)) {
                    bCredentialsOK = true;
                }
            } else if (us.LoginName().equalsIgnoreCase(sName) && us.Password().equalsIgnoreCase(sPwd)) {
                bCredentialsOK = true;
            }
            if (!bCredentialsOK) continue;
            Vector ips = us.FromIP();
            Vector masks = us.SubnetMask();
            for (int i = 0; i < ips.size(); ++i) {
                boolean bOk = MVDUserList.checkSubNetMask((String)ips.elementAt(i), (String)masks.elementAt(i), sIP);
                if (!bOk || !us.UserGroup().IsAllowed() && !us.UserGroup().isInternal()) continue;
                return us.UserGroup();
            }
        }
        return null;
    }

    private static MVDUserGroup UserPwd(String sName, String sPwd, String sIP) {
        Enumeration e = allUsers.elements();
        while (e.hasMoreElements()) {
            MVDUser us = (MVDUser)e.nextElement();
            if (us.FromIP().size() > 0 || us.isRegExp()) continue;
            boolean bCredentialsOK = false;
            if (us.isCaseSignificant()) {
                if (us.LoginName().equals(sName) && us.Password().equals(sPwd)) {
                    bCredentialsOK = true;
                }
            } else if (us.LoginName().equalsIgnoreCase(sName) && us.Password().equalsIgnoreCase(sPwd)) {
                bCredentialsOK = true;
            }
            if (!bCredentialsOK || !us.UserGroup().IsAllowed() && !us.UserGroup().isInternal()) continue;
            return us.UserGroup();
        }
        return null;
    }

    private static MVDUserGroup RegExpIp(String sName, String sPwd, String sIP) {
        Enumeration e = allUsers.elements();
        while (e.hasMoreElements()) {
            MVDUser us = (MVDUser)e.nextElement();
            if (us.FromIP().size() == 0 || !us.isRegExp()) continue;
            Pattern p = Pattern.compile(us.LoginName());
            Matcher m = p.matcher(sName);
            boolean bCredentialsOK = false;
            if (m.matches()) {
                MVDLogger.Debug("Pattern match:" + us.LoginName() + "\u00a7\u00a7" + sName, 0);
                bCredentialsOK = true;
            }
            if (!bCredentialsOK) continue;
            Vector ips = us.FromIP();
            Vector masks = us.SubnetMask();
            for (int i = 0; i < ips.size(); ++i) {
                boolean bOk = MVDUserList.checkSubNetMask((String)ips.elementAt(i), (String)masks.elementAt(i), sIP);
                if (!bOk || !us.UserGroup().IsAllowed() && !us.UserGroup().isInternal()) continue;
                return us.UserGroup();
            }
        }
        return null;
    }

    private static MVDUserGroup RegExp(String sName, String sPwd, String sIP) {
        Enumeration e = allUsers.elements();
        while (e.hasMoreElements()) {
            MVDUser us = (MVDUser)e.nextElement();
            if (us.FromIP().size() > 0 || !us.isRegExp()) continue;
            Pattern p = Pattern.compile(us.LoginName());
            Matcher m = p.matcher(sName);
            boolean bCredentialsOK = false;
            if (m.matches()) {
                MVDLogger.Debug("Pattern match:" + us.LoginName() + "\u00a7\u00a7" + sName, 0);
                bCredentialsOK = true;
            }
            if (!bCredentialsOK || !us.UserGroup().IsAllowed() && !us.UserGroup().isInternal()) continue;
            return us.UserGroup();
        }
        return null;
    }

    private static MVDUserGroup AllBackwardMatchIp(String sName, String sPwd, String sIP) {
        Enumeration e = allUsers.elements();
        while (e.hasMoreElements()) {
            MVDUser us = (MVDUser)e.nextElement();
            if (us.FromIP().size() == 0 || us.isRegExp() || !us.LoginName().equals("*")) continue;
            Vector ips = us.FromIP();
            Vector masks = us.SubnetMask();
            for (int i = 0; i < ips.size(); ++i) {
                boolean bOk = MVDUserList.checkSubNetMask((String)ips.elementAt(i), (String)masks.elementAt(i), sIP);
                if (!bOk || !us.UserGroup().IsAllowed() && !us.UserGroup().isInternal()) continue;
                return us.UserGroup();
            }
        }
        return null;
    }

    private static MVDUserGroup AllBackwardMatch(String sName, String sPwd, String sIP) {
        Enumeration e = allUsers.elements();
        while (e.hasMoreElements()) {
            MVDUser us = (MVDUser)e.nextElement();
            if (us.FromIP().size() > 0 || us.isRegExp() || !us.LoginName().equals("*") || !us.UserGroup().IsAllowed() && !us.UserGroup().isInternal()) continue;
            return us.UserGroup();
        }
        return null;
    }

    public static MVDUserGroup DetermineUserGroup(String sName, String sPwd, String sIP) {
        if (sPwd.length() > 0) {
            sPwd = MVDUserList.GetDoubleHash(sPwd);
        }
        if (sName.length() == 0) {
            sName = "[Anonymous]";
        }
        MVDUserGroup retGroup = null;
        retGroup = MVDUserList.UserPwdIp(sName, sPwd, sIP);
        if (retGroup != null) {
            return retGroup;
        }
        retGroup = MVDUserList.UserPwd(sName, sPwd, sIP);
        if (retGroup != null) {
            return retGroup;
        }
        retGroup = MVDUserList.RegExpIp(sName, sPwd, sIP);
        if (retGroup != null) {
            return retGroup;
        }
        retGroup = MVDUserList.RegExp(sName, sPwd, sIP);
        if (retGroup != null) {
            return retGroup;
        }
        retGroup = MVDUserList.AllBackwardMatchIp(sName, sPwd, sIP);
        if (retGroup != null) {
            return retGroup;
        }
        retGroup = MVDUserList.AllBackwardMatch(sName, sPwd, sIP);
        if (retGroup != null) {
            return retGroup;
        }
        return null;
    }

    public static void main(String[] args) {
        Pattern p = Pattern.compile("*");
        Matcher m = p.matcher("maam");
        boolean b = m.matches();
        boolean x = true;
    }
}

