/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.config.MVDAcl;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.config.MVDUserGroup;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MVDUserGroupList {
    private static Hashtable allUG = new Hashtable();
    private static Hashtable allUGName;
    private static Hashtable allTreeUGMap;
    private static Hashtable newUG;
    private static Hashtable newUGName;
    private static Hashtable newTreeUGMap;
    private static Hashtable tmpInternalUG;

    public static MVDUserGroup getUGByID(int ugID) {
        return (MVDUserGroup)allUG.get(new Integer(ugID));
    }

    public static MVDUserGroup getUGByName(String ugName) {
        return (MVDUserGroup)allUGName.get(ugName.toLowerCase());
    }

    public static int getUGIdByTreeId(Integer treeId) {
        return (Integer)allTreeUGMap.get(treeId);
    }

    public static void applyChanges() {
        allUG = newUG;
        allUGName = newUGName;
        allTreeUGMap = newTreeUGMap;
    }

    public static void reloadConfig(Node ugTopNode) throws MVDConfigException {
        MVDUserGroupList.readUserGroups(ugTopNode);
        Iterator iter = tmpInternalUG.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            MVDUserGroup ug = (MVDUserGroup)entry.getValue();
            if (newUG.put(new Integer(ug.ID()), ug) != null) {
                throw new MVDConfigException("UserGroup config: identical hash " + ug.ID());
            }
            if (newUGName.put(ug.Name().toLowerCase(), ug) != null) {
                throw new MVDConfigException("UserGroup config: identical names " + ug.Name());
            }
            newTreeUGMap.put(new Integer(ug.TreeID()), new Integer(ug.ID()));
            MVDAcl.addUG(ug);
        }
        tmpInternalUG = new Hashtable();
    }

    public static void loadConfig(Node ugTopNode) throws MVDConfigException {
        MVDUserGroupList.readUserGroups(ugTopNode);
        if (tmpInternalUG != null) {
            Iterator iter = tmpInternalUG.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                MVDUserGroup ug = (MVDUserGroup)entry.getValue();
                if (newUG.put(new Integer(ug.ID()), ug) != null) {
                    throw new MVDConfigException("UserGroup config: identical hash " + ug.ID());
                }
                if (newUGName.put(ug.Name().toLowerCase(), ug) != null) {
                    throw new MVDConfigException("UserGroup config: identical names " + ug.Name());
                }
                newTreeUGMap.put(new Integer(ug.TreeID()), new Integer(ug.ID()));
                MVDAcl.addUG(ug);
            }
        }
        tmpInternalUG = new Hashtable();
        MVDUserGroupList.applyChanges();
    }

    private static void readUserGroups(Node ugTopNode) throws MVDConfigException {
        newUG = new Hashtable();
        newUGName = new Hashtable();
        newTreeUGMap = new Hashtable();
        NodeList nodeList = ugTopNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            MVDUserGroup ug = new MVDUserGroup();
            if (!MVDUserGroupList.fillUserGroup(ug, nodeList.item(i))) continue;
            if (newUG.put(new Integer(ug.ID()), ug) != null) {
                throw new MVDConfigException("UserGroup config: identical hash " + ug.ID());
            }
            if (newUGName.put(ug.Name().toLowerCase(), ug) != null) {
                throw new MVDConfigException("UserGroup config: identical names " + ug.Name());
            }
            newTreeUGMap.put(new Integer(ug.TreeID()), new Integer(ug.ID()));
            MVDAcl.addUG(ug);
        }
    }

    private static boolean fillUserGroup(MVDUserGroup userGroup, Node ugRecordNode) throws MVDConfigException {
        if (!ugRecordNode.hasChildNodes()) {
            return false;
        }
        try {
            NodeList nodeList = ugRecordNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String nodeStr;
                Node node = nodeList.item(i);
                if (!node.hasChildNodes() || (nodeStr = node.getNodeName()).equalsIgnoreCase("ShortName")) continue;
                if (nodeStr.equalsIgnoreCase("ID")) {
                    userGroup.setID(Integer.parseInt(node.getFirstChild().getNodeValue()));
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ForestID") || nodeStr.equalsIgnoreCase("VTree")) {
                    userGroup.setTreeID(Integer.parseInt(node.getFirstChild().getNodeValue()));
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Name") || nodeStr.equalsIgnoreCase("DisplayName")) {
                    userGroup.setName(node.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Enabled") || nodeStr.equalsIgnoreCase("Allowed")) {
                    userGroup.setIsAllowed(node.getFirstChild().getNodeValue().equalsIgnoreCase("true"));
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("LegalStartingPoints")) continue;
                if (nodeStr.equalsIgnoreCase("optPrefDS")) {
                    userGroup.setOptPrefDS(Integer.parseInt(node.getFirstChild().getNodeValue()));
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("optSizeLimit")) {
                    userGroup.setOptSizeLimit(Integer.parseInt(node.getFirstChild().getNodeValue()));
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("optLegalDN") || nodeStr.equalsIgnoreCase("FixMapp")) continue;
                if (nodeStr.equalsIgnoreCase("EnableConvToClient") || nodeStr.equalsIgnoreCase("EnableConvServer")) {
                    userGroup.setEnableConvServer(node.getFirstChild().getNodeValue().equalsIgnoreCase("true"));
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("EnableConvFromClient") || nodeStr.equalsIgnoreCase("EnableConvClient")) {
                    userGroup.setEnableConvClient(node.getFirstChild().getNodeValue().equalsIgnoreCase("true"));
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("AttrConvFromClient") || nodeStr.equalsIgnoreCase("AttrConvIn")) {
                    userGroup.setAttrConvIn(node.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("AttrConvToClient") || nodeStr.equalsIgnoreCase("AttrConvOut")) {
                    userGroup.setAttrConvOut(node.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("DoEditAttributeSet")) {
                    userGroup.setEditAttrIsRequired(node.getFirstChild().getNodeValue().equalsIgnoreCase("true"));
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("EditAttributeSetMethod")) {
                    userGroup.setEditAttrMethod(node.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ExecuteBindMethod")) {
                    boolean b = Boolean.valueOf(node.getFirstChild().getNodeValue());
                    userGroup.setExecuteBindMethod(b);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Description")) continue;
                throw new MVDConfigException("Configuration error: Wrong node type in User Group config: " + nodeStr);
            }
        }
        catch (NumberFormatException nfe) {
            throw new MVDConfigException("User Group Configuration error: Expected int but got String: " + nfe.getMessage());
        }
        catch (DOMException de) {
            throw new MVDConfigException("User Group Configuration error: Cannot get node value: " + de.getMessage());
        }
        return true;
    }

    public static void createUserGroup(int aTreeId, String aName) throws MVDConfigException {
        if (tmpInternalUG == null) {
            tmpInternalUG = new Hashtable();
        }
        MVDUserGroup ug = new MVDUserGroup();
        ug.setAttrConvIn("");
        ug.setAttrConvOut("");
        ug.setEditAttrIsRequired(false);
        ug.setEditAttrMethod("");
        ug.setEnableConvClient(false);
        ug.setEnableConvServer(false);
        ug.setID(Integer.MAX_VALUE - aTreeId);
        ug.setName(aName);
        ug.setOptPrefDS(1);
        ug.setOptSizeLimit(0);
        ug.setTreeID(aTreeId);
        ug.setInternal(true);
        tmpInternalUG.put(new Integer(ug.ID()), ug);
    }
}

