/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.MVDHashMap;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.config.MVDDataSource;
import com.sap.idm.vds.config.MVDTopMultiServerGroup;
import com.sap.idm.vds.config.MVDTopMultiServerGroupAbstract;
import java.util.Vector;

public class MVDTopLoadBalancing
extends MVDTopMultiServerGroupAbstract {
    private int mLoadBalancingIdx = -1;
    private boolean mLoadBalancingErrorDetected = false;
    private long mLoadBalancingErrorTime;
    private Vector mInvalidLoadBalancingIndexes = new Vector();

    public void setLoadBalancingErrorDetected() {
        this.mInvalidLoadBalancingIndexes.add(new Integer(this.mLoadBalancingIdx));
        this.mLoadBalancingErrorDetected = true;
        this.mLoadBalancingErrorTime = System.currentTimeMillis();
    }

    public MVDTopLoadBalancing(MVDTopMultiServerGroup aParent) {
        this.mParent = aParent;
    }

    public void setIndex() {
        ++this.mLoadBalancingIdx;
        if (this.mLoadBalancingIdx > this.mParent.getMultiServerGroups().size() - 1) {
            this.mLoadBalancingIdx = 0;
        }
        if (!this.mLoadBalancingErrorDetected) {
            MVDLogger.Log("No previous LB error detected. returning " + this.mLoadBalancingIdx, 1);
            return;
        }
        if (System.currentTimeMillis() - this.mLoadBalancingErrorTime > this.mParent.getRetryTime()) {
            MVDLogger.Log("Retry time expired - clear the prohibition list", 1);
            this.mInvalidLoadBalancingIndexes.clear();
            this.mLoadBalancingErrorTime = 0L;
            this.mLoadBalancingErrorDetected = false;
        } else {
            MVDLogger.Log("Retry time didn't expired yet ", 1);
        }
        for (int noOfAttempts = 1; this.mInvalidLoadBalancingIndexes.contains(new Integer(this.mLoadBalancingIdx)) && noOfAttempts <= this.mParent.getMultiServerGroups().size(); ++noOfAttempts) {
            ++this.mLoadBalancingIdx;
            if (this.mLoadBalancingIdx <= this.mParent.getMultiServerGroups().size() - 1) continue;
            this.mLoadBalancingIdx = 0;
        }
        MVDLogger.Log("Returned load balanced index:" + this.mLoadBalancingIdx, 1);
    }

    public MVDHashMap getMultiServerParams(String dstype, MVDHashMap param) {
        this.setIndex();
        if (this.mLoadBalancingIdx == -1 || this.mLoadBalancingIdx >= this.mParent.getMultiServerGroups().size()) {
            return param;
        }
        Vector selectedDS = (Vector)this.mParent.getMultiServerGroups().elementAt(this.mLoadBalancingIdx);
        this.fillParams(param, dstype, selectedDS);
        return param;
    }

    public long setNextDS(MVDDataSource ds, boolean bDataSourceIsUnavailable) {
        if (bDataSourceIsUnavailable) {
            if (MVDLogger.IsLogging(3)) {
                MVDLogger.Log("One of the datasources " + ds.NiceName() + " is unavailable, retrying after the stipulated amount of time.", 3);
            }
            this.mLoadBalancingErrorDetected = true;
        } else {
            MVDLogger.Log("Last selected load balancing data source was OK ... ", 1);
        }
        return 0L;
    }
}

