/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.Globals;
import com.sap.idm.vds.MVDStatistics;
import com.sap.idm.vds.MVDStatisticsInterface;
import com.sap.idm.vds.config.MVDConfigException;
import java.util.Hashtable;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MVDStatisticsList {
    private static Hashtable allStatistics = null;
    private static Hashtable newStatistics = new Hashtable();

    public static void applyChanges() {
        allStatistics = newStatistics;
        newStatistics = new Hashtable();
    }

    public static void reloadConfig(Node node) throws MVDConfigException {
        MVDStatisticsList.readStatistics(node);
    }

    public static void applyReload() {
        MVDStatisticsList.applyChanges();
        MVDStatistics.getInstance().configReloadFinished();
        MVDStatisticsInterface.reload();
    }

    public static void loadConfig(Node node) throws MVDConfigException {
        MVDStatisticsList.readStatistics(node);
        MVDStatisticsList.applyChanges();
    }

    private static void readStatistics(Node statTopNode) throws MVDConfigException {
        MVDStatisticsList.FillStatistics(MVDStatistics.getInstance(), statTopNode);
    }

    private static boolean FillStatistics(MVDStatistics stat, Node statNode) throws MVDConfigException {
        String strVal;
        if (!statNode.hasChildNodes()) {
            return false;
        }
        try {
            NodeList nodeList = statNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                boolean boolVal;
                Node node = nodeList.item(i);
                if (!node.hasChildNodes()) continue;
                String nodeStr = node.getNodeName();
                if (nodeStr.equalsIgnoreCase("IsEnabled")) {
                    boolVal = Boolean.valueOf(node.getFirstChild().getNodeValue());
                    stat.setEnabled(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("FileName")) continue;
                if (nodeStr.equalsIgnoreCase("Frequency")) {
                    int intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    stat.setWriteFrequency(intVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("DoBasicCacheStat")) {
                    boolVal = Boolean.valueOf(node.getFirstChild().getNodeValue());
                    stat.setPrintCacheStatistics(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("DoQueueStat")) {
                    boolVal = Boolean.valueOf(node.getFirstChild().getNodeValue());
                    stat.setPrintQueueStatistics(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("DoLDAPOpCntStat")) {
                    boolVal = Boolean.valueOf(node.getFirstChild().getNodeValue());
                    stat.setDoStatLDAPOpCnt(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("DoPerDNStat")) {
                    boolVal = Boolean.valueOf(node.getFirstChild().getNodeValue());
                    stat.setPerDNStat(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("StatDNs")) {
                    stat.setStatDNs(node.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("LogUsingClass")) {
                    boolVal = Boolean.valueOf(node.getFirstChild().getNodeValue());
                    stat.setDoLogUsingClass(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("SuppressNoChange")) {
                    boolVal = Boolean.valueOf(node.getFirstChild().getNodeValue());
                    stat.setPrintEqualStats(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("DoProprietaryStat")) {
                    boolVal = Boolean.valueOf(node.getFirstChild().getNodeValue());
                    stat.setDoCollect(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("DoPrintCacheConfig")) {
                    boolVal = Boolean.valueOf(node.getFirstChild().getNodeValue());
                    stat.setDoPrintCacheConfig(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("StatisticClassCollect")) {
                    strVal = node.getFirstChild().getNodeValue();
                    stat.setClassFilename(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("LogDestination") || nodeStr.equalsIgnoreCase("LogLocation")) continue;
                if (nodeStr.equalsIgnoreCase("Delimiter")) {
                    strVal = node.getFirstChild().getNodeValue();
                    Globals.setStatisticsDelimiter(strVal);
                    continue;
                }
                throw new MVDConfigException("Configuration error: Wrong node type in Statistics config: " + nodeStr);
            }
        }
        catch (NumberFormatException nfe) {
            throw new MVDConfigException("Statistics Configuration error: Expected int but got String: " + nfe.getMessage());
        }
        catch (DOMException de) {
            throw new MVDConfigException("Statistics Configuration error: Cannot get node value: " + de.getMessage());
        }
        if (stat.isEnabled() && (strVal = stat.getClassFilename()) != null) {
            Globals.AddExternalClass(strVal);
        }
        return true;
    }
}

