/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.config.FailoverGroup;
import com.sap.idm.vds.config.FailoverGroupList;
import com.sap.idm.vds.config.LoadBalancingGroup;
import com.sap.idm.vds.config.LoadBalancingGroupList;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.config.MVDDataSource;
import com.sap.idm.vds.config.MVDDataSourceList;
import com.sap.idm.vds.config.MVDDataSourceSequentialGroup;
import com.sap.idm.vds.config.MVDDataSourceSequentialGroupList;
import com.sap.idm.vds.config.MVDDynamicAddGroup;
import com.sap.idm.vds.config.MVDDynamicAddGroupList;
import com.sap.idm.vds.config.MVDForestList;
import com.sap.idm.vds.config.MVDJoinGroup;
import com.sap.idm.vds.config.MVDJoinGroupList;
import com.sap.idm.vds.config.MVDProvisioningGroup;
import com.sap.idm.vds.config.MVDProvisioningList;
import com.sap.idm.vds.config.MVDSource;
import java.util.Hashtable;
import java.util.Iterator;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MVDSourceList {
    private static Hashtable allSources = new Hashtable();

    public static MVDSource getSourceBySrcID(int id) {
        return (MVDSource)allSources.get(new Integer(id));
    }

    public static void reloadConfig(Node dsTopNode) throws MVDConfigException {
        allSources.clear();
        MVDSourceList.readSource(dsTopNode);
    }

    public static void loadConfig(Node dsTopNode) throws MVDConfigException {
        MVDSourceList.readSource(dsTopNode);
    }

    public static void readSource(Node dsTopNode) throws MVDConfigException {
        NodeList nodeList = dsTopNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            MVDSource ds = new MVDSource();
            if (!MVDSourceList.FillSource(ds, nodeList.item(i))) continue;
            allSources.put(new Integer(ds.getSrcID()), ds);
        }
    }

    public static boolean FillSource(MVDSource src, Node dsSourceNode) throws MVDConfigException {
        String nodeStr = "";
        try {
            NodeList nodeList = dsSourceNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                boolean boolVal;
                String strVal;
                int intVal;
                Node node = nodeList.item(i);
                if (!node.hasChildNodes()) continue;
                nodeStr = node.getNodeName();
                if (nodeStr.equalsIgnoreCase("MappingID")) {
                    intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    src.setMappingID(intVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("SrcID")) {
                    strVal = node.getFirstChild().getNodeValue();
                    src.setSrcID(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("DisplayName")) {
                    strVal = node.getFirstChild().getNodeValue();
                    src.setDisplayName(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("MappingType")) {
                    intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    src.setMappingType(intVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Tree")) {
                    intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    src.setTree(intVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("NestedDN")) {
                    strVal = node.getFirstChild().getNodeValue();
                    src.setNestedDN(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("IsMaster")) {
                    boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    src.setIsMaster(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("UserData")) {
                    strVal = node.getFirstChild().getNodeValue();
                    src.setUserData(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("IsCritical")) {
                    boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    src.setIsCritical(boolVal);
                    continue;
                }
                throw new MVDConfigException("Configuration error: Wrong node type in VDS source config: " + nodeStr);
            }
        }
        catch (NumberFormatException nfe) {
            throw new MVDConfigException("Configuration error: invalid format: " + nfe.getMessage());
        }
        catch (DOMException de) {
            throw new MVDConfigException("Configuration error: Cannot get node value: " + de.getMessage());
        }
        if (src.getSrcID() != null && src.getSrcID().length() > 0) {
            allSources.put(new Integer(src.getSrcID()), src);
        }
        return true;
    }

    public static void connectSourcesToInternalTree() throws Exception {
        Iterator iter = allSources.values().iterator();
        while (iter.hasNext()) {
            MVDSource src = (MVDSource)iter.next();
            int dsid = src.getMappingID();
            if (dsid == -1) continue;
            switch (src.getMappingType()) {
                case 0: {
                    src.setTree(MVDForestList.INTERNAL_TREE_ID);
                    MVDDataSource ds = MVDDataSourceList.getDSByID(dsid);
                    if (ds == null) {
                        throw new Exception("Data source (id = " + dsid + " does not exist or is disabled");
                    }
                    String dsname = ds.NiceName().replace(' ', '_');
                    dsname = dsname.substring(0, Math.min(20, dsname.length()));
                    src.setNestedDN("ou=ds_" + dsid + ",o=internal");
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    src.setTree(MVDForestList.INTERNAL_TREE_ID);
                    MVDDataSourceSequentialGroup dsg = MVDDataSourceSequentialGroupList.getDSByID(dsid);
                    if (dsg == null) {
                        throw new Exception("Multi search group (id = " + dsid + " does not exist or is disabled");
                    }
                    String dsname = dsg.NiceName().replace(' ', '_');
                    dsname = dsname.substring(0, Math.min(20, dsname.length()));
                    src.setNestedDN("ou=unlinked_" + dsid + ",o=internal");
                    break;
                }
                case 3: {
                    src.setTree(MVDForestList.INTERNAL_TREE_ID);
                    MVDProvisioningGroup dsp = MVDProvisioningList.getProvisioningGroupByID(dsid);
                    if (dsp == null) {
                        throw new Exception("Join source group (id = " + dsid + " does not exist or is disabled");
                    }
                    String dsname = dsp.getName().replace(' ', '_');
                    dsname = dsname.substring(0, Math.min(20, dsname.length()));
                    src.setNestedDN("ou=provisioning_" + dsid + ",o=internal");
                    break;
                }
                case 4: {
                    src.setTree(MVDForestList.INTERNAL_TREE_ID);
                    MVDJoinGroup dsj = MVDJoinGroupList.getJoinGroupByID(dsid);
                    if (dsj == null) {
                        throw new Exception("Join source group (id = " + dsid + " does not exist or is disabled");
                    }
                    String dsname = dsj.getName().replace(' ', '_');
                    dsname = dsname.substring(0, Math.min(20, dsname.length()));
                    src.setNestedDN("ou=join_" + dsid + ",o=internal");
                    break;
                }
                case 5: {
                    src.setTree(MVDForestList.INTERNAL_TREE_ID);
                    MVDDynamicAddGroup dsd = MVDDynamicAddGroupList.getDynamicAddGroupByID(dsid);
                    if (dsd == null) {
                        throw new Exception("Dynamic add group (id = " + dsid + " does not exist or is disabled");
                    }
                    String dsname = dsd.getName().replace(' ', '_');
                    dsname = dsname.substring(0, Math.min(20, dsname.length()));
                    src.setNestedDN("ou=dynamicadd_" + dsid + ",o=internal");
                    break;
                }
                case 6: {
                    src.setTree(MVDForestList.INTERNAL_TREE_ID);
                    LoadBalancingGroup dslb = LoadBalancingGroupList.getLBGroupByID(dsid);
                    if (dslb == null) {
                        throw new Exception("Load balancing group (id = " + dsid + " does not exist or is disabled");
                    }
                    String dsname = dslb.getName().replace(' ', '_');
                    dsname = dsname.substring(0, Math.min(20, dsname.length()));
                    src.setNestedDN("ou=loadbalancing_" + dsid + ",o=internal");
                    break;
                }
                case 7: {
                    src.setTree(MVDForestList.INTERNAL_TREE_ID);
                    String dsname = FailoverGroupList.getFailoverGroupByID(dsid).getName().replace(' ', '_');
                    FailoverGroup dsf = FailoverGroupList.getFailoverGroupByID(dsid);
                    if (dsf == null) {
                        throw new Exception("Dynamic add group (id = " + dsid + " does not exist or is disabled");
                    }
                    dsname = dsf.getName().replace(' ', '_');
                    dsname = dsname.substring(0, Math.min(20, dsname.length()));
                    src.setNestedDN("ou=failover_" + dsid + ",o=internal");
                    break;
                }
            }
        }
    }
}

