/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.Globals;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.MVDUtilities;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.config.MVDWSDeployment;
import com.sap.idm.vds.config.MVDWSDeploymentList;
import com.sap.idm.vds.ie.op.common.util.MVDMic_Util;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class MVDProxy {
    private static boolean mProtectUI;
    private static String mUIPassword;
    private static String mAllAttributes;
    private static int mPortNumber;
    private static String mServiceName;
    private static boolean mExplAuth;
    private static boolean mTransparentAuth;
    private static String mAuthServer;
    private static int mAuthPort;
    private static boolean mEnforceDNRelation;
    private static int mCharSet;
    private static int mClientVersion;
    private static int mEngines;
    private static int mKeepEngine;
    private static int mSessionTimeout;
    private static String mRootDSEClass;
    private static String mSystemManagementClass;
    private static String mAuthenticationClass;
    private static String mRootClass;
    private static String mAttrClass;
    private static String mTransformationClass;
    private static String mPreProcessClass;
    private static String mPostProcessClass;
    private static Vector mPreTransOps;
    private static Vector mPostTransOps;
    private static boolean mValidTransformationClassName;
    private static boolean mValidPreProcessClassName;
    private static boolean mValidPostProcessClassName;
    private static boolean mAllowProtocolTransform;
    private static String mActiveDeployment;
    private static String mProhibitedOperations;
    private static boolean mAllowPartialUpdate;
    private static HashMap mBinAttributes;
    private static String mJNDIbinary;
    private static boolean mSrvProtection;
    private static String mPwdProtection;
    private static int mClientPackageSize;
    private static Vector mJDBCDrivers;
    private static HashMap mMVDGlobals;
    private static String mNetworkInterface;
    private static String mSecretDNtoStopMVD;
    private static String mRandomFile;
    private static int mMagicNumber;
    private static boolean mTestModeEnabled;
    private static String mTestModeUser;
    private static String mTestModePassword;
    private static HashMap mBindMethodParameters;
    private static boolean sStripAdditionalInfo;
    private static Vector mProhibitedSearchURLs;
    private static boolean mSLDRegEnabled;
    private static String mSLDUrl;
    private static String mSLDUsername;
    private static String mSLDPassword;

    public static boolean ProtectUI() {
        return mProtectUI;
    }

    public static void SetProtectUI(boolean b) {
        mProtectUI = b;
    }

    public static String UIPassword() {
        return mUIPassword;
    }

    public static void SetUIPassword(String s) {
        mUIPassword = s;
    }

    public static String AllAttributes() {
        return mAllAttributes;
    }

    public static int PortNumber() {
        return mPortNumber;
    }

    public static String NetworkInterface() {
        return mNetworkInterface;
    }

    public static String ServiceName() {
        return mServiceName;
    }

    public static String JNDIBinaryAttr() {
        return mJNDIbinary;
    }

    public static HashMap MVDGlobals() {
        return mMVDGlobals;
    }

    public static boolean ExplAuth() {
        return mExplAuth;
    }

    public static boolean TransparentAuth() {
        return mTransparentAuth;
    }

    public static String AuthServer() {
        return mAuthServer;
    }

    public static int AuthPort() {
        return mAuthPort;
    }

    public static boolean EnforceDNRelation() {
        return mEnforceDNRelation;
    }

    public static int CharSet() {
        return mCharSet;
    }

    public static int ClientVersion() {
        return mClientVersion;
    }

    public static int Engines() {
        return mEngines;
    }

    public static int KeepEngine() {
        return mKeepEngine;
    }

    public static int SessionTimeout() {
        return mSessionTimeout;
    }

    public static String RootDSEClass() {
        return mRootDSEClass;
    }

    public static String SystemManagementClass() {
        return mSystemManagementClass;
    }

    public static String AuthenticationClass() {
        return mAuthenticationClass;
    }

    public static String RootClass() {
        return mRootClass;
    }

    public static String AttrClass() {
        return mAttrClass;
    }

    public static String TransformationClass() {
        return mTransformationClass;
    }

    public static String PreProcessClass() {
        return mPreProcessClass;
    }

    public static String PostProcessClass() {
        return mPostProcessClass;
    }

    public static Vector PreTransOps() {
        return mPreTransOps;
    }

    public static Vector PostTransOps() {
        return mPostTransOps;
    }

    public static boolean isPostTransOp(String s) {
        return mPostTransOps.contains(s.toUpperCase());
    }

    public static boolean isPreTransOp(String s) {
        return mPreTransOps.contains(s.toUpperCase());
    }

    public static boolean ValidTransformationClassName() {
        return mValidTransformationClassName;
    }

    public static boolean ValidPreProcessClassName() {
        return mValidPreProcessClassName;
    }

    public static boolean ValidPostProcessClassName() {
        return mValidPostProcessClassName;
    }

    public static boolean AllowProtocolTransform() {
        return mAllowProtocolTransform;
    }

    public static String ProhibitedOperations() {
        return mProhibitedOperations;
    }

    public static boolean allowPartialUpdate() {
        return mAllowPartialUpdate;
    }

    public static int getMagicNumber() {
        return mMagicNumber;
    }

    public static Vector JDBCDrivers() {
        return mJDBCDrivers;
    }

    public static boolean IsBinaryAttribute(String attr) {
        if (mBinAttributes.containsKey(attr.toLowerCase())) {
            return true;
        }
        return attr.toLowerCase().indexOf(";binary") > -1;
    }

    public static String SecretDNToStopMVD() {
        return mSecretDNtoStopMVD;
    }

    public static String RandomFile() {
        return mRandomFile;
    }

    public static boolean isTestModeEnabled() {
        return mTestModeEnabled;
    }

    public static String getTestModeUser() {
        return mTestModeUser;
    }

    public static String getTestModePassword() {
        return mTestModePassword;
    }

    public static HashMap getBindMethodParameters() {
        return mBindMethodParameters;
    }

    public static boolean isStripAdditionalInfo() {
        return sStripAdditionalInfo;
    }

    public static String getActiveDeployment() {
        return mActiveDeployment;
    }

    public static void SetPortNumber(int i) {
        mPortNumber = i;
    }

    public static void SetNetworkInterface(String s) {
        mNetworkInterface = s;
    }

    public static void SetServiceName(String s) {
        mServiceName = s;
    }

    public static void SetExplAuth(boolean b) {
        mExplAuth = b;
    }

    public static void SetTransparentAuth(boolean b) {
        mTransparentAuth = b;
    }

    public static void SetAuthServer(String s) {
        mAuthServer = s;
    }

    public static void SetAuthPort(String s) {
        mAuthPort = new Integer(s);
    }

    public static void SetEnforceDNRelation(boolean b) {
        mEnforceDNRelation = b;
    }

    public static void SetCharSet(int i) {
        mCharSet = i;
    }

    public static void SetClientVersion(int i) {
        mClientVersion = i;
    }

    public static void SetEngines(int i) {
        mEngines = i;
    }

    public static void SetKeepEngine(int i) {
        mKeepEngine = i;
    }

    public static void SetSessionTimeout(int i) {
        mSessionTimeout = i;
    }

    public static void SetRootDSEClass(String s) {
        mRootDSEClass = s;
    }

    public static void SetSystemManagementClass(String s) {
        mSystemManagementClass = s;
    }

    public static void SetAuthenticationClass(String s) {
        mAuthenticationClass = s;
    }

    public static void SetRootClass(String s) {
        mRootClass = s;
    }

    public static void setSLDRegEnabled(boolean b) {
        mSLDRegEnabled = b;
    }

    public static void setSLDUrl(String s) {
        mSLDUrl = s;
    }

    public static void setSLDUsername(String s) {
        mSLDUsername = s;
    }

    public static void setSLDPassword(String s) {
        mSLDPassword = MVDMic_Util.dcString((String)s);
    }

    public static boolean getSLDRegEnabled() {
        return mSLDRegEnabled;
    }

    public static String getSLDUrl() {
        return mSLDUrl;
    }

    public static String getSLDUsername() {
        return mSLDUsername;
    }

    public static String getSLDPassword() {
        return mSLDPassword;
    }

    public static void SetAttrClass(String s) {
        mAttrClass = s;
    }

    public static void SetTransformationClass(String s) {
        mTransformationClass = s;
        mAllowProtocolTransform = mValidTransformationClassName = mTransformationClass != null && !mTransformationClass.equalsIgnoreCase("none");
    }

    public static void reInitializeTransformationClass() {
        MVDWSDeployment wsd;
        if (mActiveDeployment != null && (wsd = MVDWSDeploymentList.getWSDeploymentByName(mActiveDeployment)) != null) {
            MVDProxy.SetTransformationClass(wsd.getTransformationClass());
        }
    }

    public static void setPreProcessClass(String aStr) {
        mPreProcessClass = aStr;
        mValidPreProcessClassName = mPreProcessClass != null && !mPreProcessClass.equalsIgnoreCase("none");
    }

    public static void setPostProcessClass(String aStr) {
        mPostProcessClass = aStr;
        mValidPostProcessClassName = mPostProcessClass != null && !mPostProcessClass.equalsIgnoreCase("none");
    }

    public static void SetPreTransOps(String s) {
        mPreTransOps = MVDUtil.splitString(s, ",");
    }

    public static void SetPostTransOps(String s) {
        mPostTransOps = MVDUtil.splitString(s, ",");
    }

    public static void SetProhibitedOperations(String s) {
        mProhibitedOperations = s;
    }

    public static void SetAllowPartialModify(boolean b) {
        mAllowPartialUpdate = b;
    }

    public static void SetAllAttributes(String s) {
        HashMap<String, Object> tempBinAttr = new HashMap<String, Object>();
        Vector tempVector = MVDUtil.splitString(s, ',');
        int ls = tempVector.size();
        for (int i = 0; i < ls; ++i) {
            String tempStr = (String)tempVector.elementAt(i);
            if (!tempStr.startsWith("Binary : ")) continue;
            if (!(tempStr = tempStr.substring(9).toLowerCase()).endsWith(";binary") && !Globals.JNDIOriginalBinaryAttr().contains(tempStr)) {
                if (mJNDIbinary.length() > 0) {
                    mJNDIbinary = mJNDIbinary + " ";
                }
                mJNDIbinary = mJNDIbinary + tempStr;
            }
            tempBinAttr.put(tempStr, null);
        }
        mBinAttributes = tempBinAttr;
        mAllAttributes = s;
    }

    public static void SetJDBCDrivers(String s) throws MVDConfigException {
        Vector tempJDBC = new Vector();
        Vector tmp = MVDUtil.splitString(s, "[&&]");
        for (int x = 0; x < tmp.size(); ++x) {
            Vector a = MVDUtil.splitString((String)tmp.elementAt(x), "[$]");
            if (a.size() > 1) {
                String val = (String)a.elementAt(1);
                if (!val.equalsIgnoreCase("true")) continue;
                tempJDBC.add(a.elementAt(0));
                continue;
            }
            throw new MVDConfigException("Proxy Configuration error: Invalid JDBCDrivers " + a.elementAt(0));
        }
        mJDBCDrivers = tempJDBC;
    }

    public static void SetMVDGlobals(String s) throws MVDConfigException {
        HashMap<String, String> tempGlobals = new HashMap<String, String>();
        MVDLogger.getEmptyLogStrings().removeAllElements();
        MVDLogger.setAvoidEmptyLog("false");
        MVDLogger.setMaskFilter("0");
        Vector tmp = MVDUtil.splitString(s, "[&&]");
        int ls = tmp.size();
        for (int x = 0; x < ls; ++x) {
            Vector a = MVDUtil.splitString((String)tmp.elementAt(x), "[$]");
            if (a.size() > 1) {
                String name = (String)a.elementAt(0);
                String val = (String)a.elementAt(1);
                if (name.startsWith("-D") || name.startsWith("-d")) {
                    name = name.substring(2, name.length());
                    System.setProperty(name, val);
                    continue;
                }
                val = MVDUtilities.masterDcString(val);
                if (name.startsWith("NO_LOG")) {
                    MVDLogger.getEmptyLogStrings().add(val);
                    continue;
                }
                if (name.equalsIgnoreCase("AVOID_EMPTY_LOG")) {
                    MVDLogger.setAvoidEmptyLog(val);
                    continue;
                }
                if (name.equalsIgnoreCase("MASK_FILTER")) {
                    MVDLogger.setMaskFilter(val);
                    continue;
                }
                tempGlobals.put("GLOBAL_" + name, val);
                continue;
            }
            throw new MVDConfigException("Proxy Configuration error: Invalid MVDGlobals " + a.elementAt(0));
        }
        mMVDGlobals = tempGlobals;
    }

    public static void SetSecretDNToStopMVD(int magicNumber, String configname) {
        mSecretDNtoStopMVD = "o=" + magicNumber + ",c=" + configname;
        mMagicNumber = magicNumber;
    }

    public static void SetRandomFile(String filename) {
        mRandomFile = filename;
    }

    public static void setTestModeEnabled(boolean aEnabled) {
        mTestModeEnabled = aEnabled;
    }

    public static void setTestModeUser(String aUsername) {
        mTestModeUser = aUsername;
    }

    public static void setTestModePassword(String aPassword) {
        mTestModePassword = aPassword;
    }

    public static void setBindMethodParameters(HashMap aParams) {
        mBindMethodParameters = aParams;
    }

    public static void setBindMethodParameters(String aBindMethodParameters) {
        Vector v = MVDUtil.splitString(aBindMethodParameters, "[$$]");
        Iterator iter = v.iterator();
        while (iter.hasNext()) {
            String line = (String)iter.next();
            Vector x = MVDUtil.splitString(line, "[&&]");
            String parname = (String)x.elementAt(0);
            String parval = (String)x.elementAt(1);
            mBindMethodParameters.put("AUTH_" + parname.toUpperCase(), parval);
        }
    }

    public static void setStripAdditionalInfo(boolean aValue) {
        sStripAdditionalInfo = aValue;
    }

    public static void checkRootDSEClass() throws MVDConfigException {
        String strVal = MVDProxy.RootDSEClass();
        if (strVal == null || strVal != null && strVal.equalsIgnoreCase("Default") || strVal.equalsIgnoreCase("com.sap.idm.vds.bc.MxBackwardsRootDSE") && !MVDProxy.ExplAuth() && !MVDProxy.TransparentAuth()) {
            strVal = "MxRootDSEClass";
            MVDLogger.Log("Using default root DSE class.", 2);
        }
        MVDProxy.SetRootDSEClass(strVal);
        Globals.AddExternalClass(strVal);
    }

    public static Vector getProhibitedSearchURLs() {
        return mProhibitedSearchURLs;
    }

    public static void setProhibitedSearchURLs(Vector aProhibitedSearchURLs) {
        mProhibitedSearchURLs = aProhibitedSearchURLs;
    }

    public static void setActiveDeployment(String aActiveDeployment) {
        mActiveDeployment = aActiveDeployment;
    }

    static {
        mPreTransOps = new Vector();
        mPostTransOps = new Vector();
        mProhibitedOperations = "";
        mBinAttributes = new HashMap();
        mJNDIbinary = "";
        mJDBCDrivers = new Vector();
        mMVDGlobals = new HashMap();
        mNetworkInterface = null;
        mSecretDNtoStopMVD = null;
        mRandomFile = null;
        mTestModeEnabled = false;
        mProhibitedSearchURLs = null;
        mSLDRegEnabled = false;
        mSLDUrl = null;
        mSLDUsername = null;
        mSLDPassword = null;
    }
}

