/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDModAttrValues;
import com.sap.idm.vds.MVDOrderedHashMap;
import com.sap.idm.vds.MVDUtilities;
import com.sap.idm.vds.config.MVDProvisionExecElem;
import com.sap.idm.vds.config.MVDProvisioningUpdateElem;
import com.sap.idm.vds.config.MVDSource;
import com.sap.idm.vds.message.MxAdd;
import com.sap.idm.vds.message.MxAttrSet;
import com.sap.idm.vds.message.MxDelete;
import com.sap.idm.vds.message.MxModify;
import com.sap.idm.vds.message.MxRequest;
import com.sap.idm.vds.operations.MVDAddOperation;
import com.sap.idm.vds.operations.MVDCommonAMDOperation;
import com.sap.idm.vds.operations.MVDModifyOperation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class MVDProvisioningUtil {
    public static MxRequest constructDeleteRequest(MVDCommonAMDOperation origop, MVDProvisioningUpdateElem cpuxElem, String virtualPath) throws Exception {
        MxDelete memberDelete = new MxDelete();
        MVDSource elemSource = cpuxElem.Source();
        String fixedDn = MVDUtilities.fixStartingPoint(origop.getDNOfTheOriginalRequest(), elemSource.getNestedDN(), virtualPath);
        String originalOp = origop.getAMDType();
        if (originalOp.equalsIgnoreCase("ADD") || originalOp.equalsIgnoreCase("MODIFY") || originalOp.equalsIgnoreCase("DELETE")) {
            memberDelete.setDn(fixedDn);
            return memberDelete;
        }
        MVDLogger.Log("Provisioning: Could not create a delete request - invalid operation type:" + originalOp, 3);
        throw new Exception("Invalid operation type");
    }

    public static MxRequest constructModifyRequest(MVDCommonAMDOperation origop, MVDProvisioningUpdateElem cpuxElem, String virtualPath) throws Exception {
        MxModify memberModify = new MxModify();
        MVDSource elemSource = cpuxElem.Source();
        String fixedDn = MVDUtilities.fixStartingPoint(origop.getDNOfTheOriginalRequest(), elemSource.getNestedDN(), virtualPath);
        String originalOp = origop.getAMDType();
        if (originalOp.equalsIgnoreCase("DELETE")) {
            MVDLogger.Log("Provisioning: Could not create a complex member (MODIFY on DELETE operation)", 3);
            throw new Exception("Could not create a complex member (MODIFY on DELETE operation)");
        }
        if (originalOp.equalsIgnoreCase("MODIFY")) {
            MxModify modreq = ((MVDModifyOperation)origop).getOriginalModifyRequest();
            memberModify = (MxModify)modreq.clone();
            memberModify.setDn(fixedDn);
            boolean acceptAll = false;
            if (cpuxElem.Attributes().size() == 0 || cpuxElem.Attributes().contains("*")) {
                acceptAll = true;
            }
            Vector candidates = memberModify.getAttrAndModValues();
            for (int x = 0; x < candidates.size(); ++x) {
                MVDModAttrValues oneOfModifications = (MVDModAttrValues)candidates.elementAt(x);
                String aname = oneOfModifications.getAttrName();
                if (acceptAll || cpuxElem.Attributes().contains(aname)) continue;
                candidates.removeElement(oneOfModifications);
                --x;
            }
            if (MVDLogger.IsLogging(2)) {
                String s = "";
                for (int x = 0; x < candidates.size(); ++x) {
                    MVDModAttrValues oneOfModifications = (MVDModAttrValues)candidates.elementAt(x);
                    String aname = oneOfModifications.getAttrName();
                    if (s.length() > 0) {
                        s = s + ",";
                    }
                    s = s + aname;
                }
                MVDLogger.Log("Cleaning by the target source (modify) :" + s, 2);
            }
            return memberModify;
        }
        if (originalOp.equalsIgnoreCase("ADD")) {
            memberModify.setDn(fixedDn);
            MxAdd addreq = ((MVDAddOperation)origop).getOriginalAddRequest();
            MxAttrSet attrSet = addreq.getAttrSetAndValues();
            Vector<MVDModAttrValues> convertedVector = new Vector<MVDModAttrValues>();
            boolean acceptAll = false;
            if (cpuxElem.Attributes().size() == 0 || cpuxElem.Attributes().contains("*")) {
                acceptAll = true;
            }
            Iterator i = attrSet.getAttrAndValues().keySet().iterator();
            while (i.hasNext()) {
                String aName = (String)i.next();
                if (!acceptAll && !cpuxElem.Attributes().contains(aName)) continue;
                Vector aVal = attrSet.getAttrValues(aName);
                MVDModAttrValues modAttr = new MVDModAttrValues();
                modAttr.setAttrName(aName);
                modAttr.setModType(2);
                modAttr.addAll(aVal);
                convertedVector.add(modAttr);
            }
            if (MVDLogger.IsLogging(2)) {
                String s = "";
                for (int x = 0; x < convertedVector.size(); ++x) {
                    MVDModAttrValues oneOfModifications = (MVDModAttrValues)convertedVector.elementAt(x);
                    String aname = oneOfModifications.getAttrName();
                    if (s.length() > 0) {
                        s = s + ",";
                    }
                    s = s + aname;
                }
                MVDLogger.Log("Cleaning by the target source (add) :" + s, 2);
            }
            memberModify.setAttrAndModValues(convertedVector);
            return memberModify;
        }
        MVDLogger.Log("Provisioning: Could not create a modify request - invalid operation type:" + originalOp, 3);
        throw new Exception("Invalid operation type");
    }

    public static MxRequest constructAddRequest(MVDCommonAMDOperation origop, MVDProvisioningUpdateElem cpuxElem, String virtualPath) throws Exception {
        MxAdd memberAdd = new MxAdd();
        MVDSource elemSource = cpuxElem.Source();
        String fixedDn = MVDUtilities.fixStartingPoint(origop.getDNOfTheOriginalRequest(), elemSource.getNestedDN(), virtualPath);
        String originalOp = origop.getAMDType();
        if (originalOp.equalsIgnoreCase("DELETE")) {
            MVDLogger.Log("Provisioning: Could not create a complex member (ADD on DELETE operation)", 3);
            throw new Exception("Could not create a complex member (MODIFY on DELETE operation)");
        }
        if (originalOp.equalsIgnoreCase("MODIFY")) {
            memberAdd.setDn(fixedDn);
            boolean acceptAll = false;
            if (cpuxElem.Attributes().size() == 0 || cpuxElem.Attributes().contains("*")) {
                acceptAll = true;
            }
            MxModify modreq = ((MVDModifyOperation)origop).getOriginalModifyRequest();
            Vector vvv = modreq.getAttrAndModValues();
            for (int x = 0; x < vvv.size(); ++x) {
                MVDModAttrValues oneOfModifications = (MVDModAttrValues)vvv.elementAt(x);
                String aname = oneOfModifications.getAttrName();
                if (!acceptAll && !cpuxElem.Attributes().contains(aname)) continue;
                Vector v = new Vector(oneOfModifications);
                memberAdd.getAttrSetAndValues().setAttrValue(aname, true, v);
            }
            MVDLogger.Log("Cleaning by the target source (modify) :" + memberAdd.getAttrSetAndValues().getAttributes().toString(), 2);
            return memberAdd;
        }
        if (originalOp.equalsIgnoreCase("ADD")) {
            MxAdd addreq = ((MVDAddOperation)origop).getOriginalAddRequest();
            memberAdd = (MxAdd)addreq.clone();
            memberAdd.setDn(fixedDn);
            HashMap candidates = memberAdd.getAttrSetAndValues().getAttrAndValues();
            if (cpuxElem.Attributes().size() != 0 && !cpuxElem.Attributes().contains("*")) {
                candidates.keySet().retainAll(cpuxElem.Attributes());
                MVDLogger.Log("Cleaning by the target source (add) :" + candidates.keySet().toString(), 2);
            }
            return memberAdd;
        }
        MVDLogger.Log("Provisioning: Could not create a add request - invalid operation type:" + originalOp, 3);
        throw new Exception("Invalid operation type");
    }

    public static MVDProvisionExecElem constructDeleteRollbackRequest(MVDCommonAMDOperation origop, MVDProvisioningUpdateElem cpuxElem, String desiredRollback, String virtualPath) throws Exception {
        if (desiredRollback.equalsIgnoreCase("ignore")) {
            return null;
        }
        MVDLogger.Log("Provisioning: Could not create a rollback " + desiredRollback + " on DELETE operation", 3);
        throw new Exception("Invalid rollback type: " + desiredRollback);
    }

    public static MVDProvisionExecElem constructAddRollbackRequest(MVDCommonAMDOperation origop, MVDProvisioningUpdateElem cpuxElem, String desiredRollback, String virtualPath) throws Exception {
        try {
            if (desiredRollback.equalsIgnoreCase("delete")) {
                MxRequest memberTransaction = MVDProvisioningUtil.constructDeleteRequest(origop, cpuxElem, virtualPath);
                MVDProvisionExecElem retElem = new MVDProvisionExecElem();
                retElem.setRequest(memberTransaction);
                retElem.setSource(cpuxElem.Source());
                return retElem;
            }
            if (desiredRollback.equalsIgnoreCase("ignore")) {
                return null;
            }
            MVDLogger.Log("Provisioning: Could not create a rollback " + desiredRollback + " on ADD operation", 3);
            throw new Exception("Invalid rollback type: " + desiredRollback);
        }
        catch (Exception e) {
            MVDLogger.Log("Provisioning: Could not create a rollback " + desiredRollback + " on ADD operation", 3);
            throw new Exception("Could not create a rollback " + desiredRollback + " on ADD operation");
        }
    }

    public static MVDProvisionExecElem constructModifyRollbackRequest(MVDCommonAMDOperation origop, MVDProvisioningUpdateElem cpuxElem, String desiredRollback, String virtualPath) throws Exception {
        try {
            if (desiredRollback.equalsIgnoreCase("delete")) {
                MxRequest memberTransaction = MVDProvisioningUtil.constructDeleteRequest(origop, cpuxElem, virtualPath);
                MVDProvisionExecElem retElem = new MVDProvisionExecElem();
                retElem.setRequest(memberTransaction);
                retElem.setSource(cpuxElem.Source());
                return retElem;
            }
            if (desiredRollback.equalsIgnoreCase("ignore")) {
                return null;
            }
            MVDLogger.Log("Provisioning: Could not create a rollback " + desiredRollback + " on MODIFY operation", 3);
            throw new Exception("Invalid rollback type: " + desiredRollback);
        }
        catch (Exception e) {
            MVDLogger.Log("Provisioning: Could not create a rollback " + desiredRollback + " on MODIFY operation", 3);
            throw new Exception("Could not create a rollback " + desiredRollback + " on MODIFY operation");
        }
    }

    /*
     * WARNING - void declaration
     */
    public static int constructComplexRequest(MVDCommonAMDOperation origop, MVDProvisioningUpdateElem cpuxElem, String desiredOperation, String revereseOperation, MVDOrderedHashMap operations, String virtualPath) {
        try {
            void var7_9;
            MVDProvisionExecElem complexRollbackOp;
            MxRequest request;
            MVDSource elemSource = cpuxElem.Source();
            if (desiredOperation.equalsIgnoreCase("DELETE")) {
                request = MVDProvisioningUtil.constructDeleteRequest(origop, cpuxElem, virtualPath);
                complexRollbackOp = MVDProvisioningUtil.constructDeleteRollbackRequest(origop, cpuxElem, revereseOperation, virtualPath);
            } else if (desiredOperation.equalsIgnoreCase("ADD")) {
                request = MVDProvisioningUtil.constructAddRequest(origop, cpuxElem, virtualPath);
                complexRollbackOp = MVDProvisioningUtil.constructAddRollbackRequest(origop, cpuxElem, revereseOperation, virtualPath);
            } else if (desiredOperation.equalsIgnoreCase("MODIFY")) {
                request = MVDProvisioningUtil.constructModifyRequest(origop, cpuxElem, virtualPath);
                complexRollbackOp = MVDProvisioningUtil.constructModifyRollbackRequest(origop, cpuxElem, revereseOperation, virtualPath);
            } else {
                MVDLogger.Log("Provisioning: Could not create a complex member:" + desiredOperation, 3);
                return -1;
            }
            MVDProvisionExecElem cxelem = new MVDProvisionExecElem();
            cxelem.setRequest(request);
            cxelem.setSource(elemSource);
            operations.put(cxelem, (Object)var7_9);
        }
        catch (Exception ignore) {
            MVDLogger.Log("Provisioning: Could not create a complex member: " + desiredOperation + " OR needed rollback operation:" + desiredOperation, 3);
            return -1;
        }
        return 0;
    }
}

