/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.config.MVDAcl;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.config.MVDProvisioningGroup;
import com.sap.idm.vds.config.MVDProvisioningUpdateElem;
import com.sap.idm.vds.config.MVDSource;
import com.sap.idm.vds.config.MVDSourceList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MVDProvisioningList {
    private static Hashtable allProvisioningGroups = new Hashtable();
    private static Hashtable newProvisioningGroups = new Hashtable();

    public static MVDProvisioningGroup getProvisioningGroupByID(int id) {
        return (MVDProvisioningGroup)allProvisioningGroups.get(new Integer(id));
    }

    public static void applyChanges() {
        allProvisioningGroups = newProvisioningGroups;
    }

    public static void reloadConfig(Node dsTopNode) throws MVDConfigException {
        MVDProvisioningList.readProvisioningGroup(dsTopNode);
    }

    public static void loadConfig(Node dsTopNode) throws MVDConfigException {
        MVDProvisioningList.readProvisioningGroup(dsTopNode);
        MVDProvisioningList.applyChanges();
    }

    public static void readProvisioningGroup(Node dsTopNode) throws MVDConfigException {
        newProvisioningGroups = new Hashtable();
        NodeList nodeList = dsTopNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            MVDProvisioningGroup ds = new MVDProvisioningGroup();
            if (!MVDProvisioningList.fillProvisioningGroup(ds, nodeList.item(i))) continue;
            newProvisioningGroups.put(new Integer(ds.ID()), ds);
        }
    }

    private static boolean fillProvisioningGroup(MVDProvisioningGroup ds, Node dsRecordNode) throws MVDConfigException {
        if (!dsRecordNode.hasChildNodes()) {
            return false;
        }
        try {
            NodeList nodeList = dsRecordNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                MVDProvisioningUpdateElem cr;
                String strVal;
                Node node = nodeList.item(i);
                if (!node.hasChildNodes()) continue;
                String nodeStr = node.getNodeName();
                if (nodeStr.equalsIgnoreCase("ID")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetID(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Name")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetName(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Enabled")) {
                    boolean boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    ds.SetIsAllowed(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Description")) continue;
                if (nodeStr.equalsIgnoreCase("Source")) {
                    MVDSource sss = new MVDSource();
                    MVDSourceList.FillSource(sss, node);
                    ds.AddUpdateElements(sss);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("AddUpdateDS")) {
                    cr = new MVDProvisioningUpdateElem();
                    if (!MVDProvisioningList.fillProvisioningGroupElem(cr, node)) continue;
                    ds.getAddUpdateElements().add(cr);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ModUpdateDS")) {
                    cr = new MVDProvisioningUpdateElem();
                    if (!MVDProvisioningList.fillProvisioningGroupElem(cr, node)) continue;
                    ds.getModifyUpdateElements().add(cr);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("DeleteUpdateDS")) {
                    cr = new MVDProvisioningUpdateElem();
                    if (!MVDProvisioningList.fillProvisioningGroupElem(cr, node)) continue;
                    ds.getDeleteUpdateElements().add(cr);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("UniqueName")) {
                    strVal = node.getFirstChild().getNodeValue();
                    if (strVal == null || strVal.length() <= 0) continue;
                    ds.setUniqueName(strVal);
                    continue;
                }
                throw new MVDConfigException("Configuration error: Wrong node type in Provisioning group config: " + nodeStr);
            }
        }
        catch (NumberFormatException nfe) {
            throw new MVDConfigException("Provisioning Configuration error: invalid format: " + nfe.getMessage());
        }
        catch (DOMException de) {
            throw new MVDConfigException("Provisioning Configuration error: Cannot get node value: " + de.getMessage());
        }
        try {
            ds.SetSources(ds.getAddUpdateElements());
            ds.SetSources(ds.getModifyUpdateElements());
            ds.SetSources(ds.getDeleteUpdateElements());
        }
        catch (Exception e) {
            throw new MVDConfigException("Provisioning config, Could not find proper source");
        }
        return true;
    }

    private static boolean fillProvisioningGroupElem(MVDProvisioningUpdateElem ds, Node dsRecordNode) throws MVDConfigException {
        if (!dsRecordNode.hasChildNodes()) {
            return false;
        }
        try {
            NodeList nodeList = dsRecordNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String strVal;
                Node node = nodeList.item(i);
                if (!node.hasChildNodes()) continue;
                String nodeStr = node.getNodeName();
                if (nodeStr.equalsIgnoreCase("SrcID")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetSrcID(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("UpdID")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetUpdID(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Operation")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetOperation(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("OnError")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetOnError(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Attributes")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetAttributes(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Enabled")) {
                    boolean boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    ds.SetEnabled(boolVal);
                    continue;
                }
                throw new MVDConfigException("Configuration error: Wrong node type in Provisioning group config: " + nodeStr);
            }
        }
        catch (NumberFormatException nfe) {
            throw new MVDConfigException("Provisioning Elem Configuration error: invalid format: " + nfe.getMessage());
        }
        catch (DOMException de) {
            throw new MVDConfigException("Provisioning Elem Configuration error: Cannot get node value: " + de.getMessage());
        }
        return true;
    }

    public static void createInternalTree() throws MVDConfigException {
        Iterator iter = allProvisioningGroups.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry element = iter.next();
            MVDProvisioningGroup src = (MVDProvisioningGroup)element.getValue();
            if (!src.IsAllowed()) continue;
            MVDAcl.createReferralTree(src);
        }
    }
}

