/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.queue.QueueClassConfig;
import com.sap.idm.vds.util.ConfigUtil;
import java.util.HashMap;
import java.util.Vector;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MVDPriorityObject {
    private static boolean mEnabled = false;
    private static int mNumberofPriorityLevels = 4;
    private static int mQueueSizeLimit = 100;
    private static int mEngineLimit = 12;
    private static int mMillisecondsToWaitWhenQueueIsFull = 5000;
    private static int mWaitForGo = 5000;
    private static int mBusyLDAPCode = 50;
    private static String mBusyMessage = "The system is at very high load at this moment. Your request could not be served. Please, try later";
    private static QueueClassConfig mLevelClass = new QueueClassConfig();
    private static HashMap mClassParams = new HashMap();
    private static int[] mPriorityValues;

    public static int[] getPriorityValues() {
        return mPriorityValues;
    }

    public static void setPriorityValues(int[] priorityValues) {
        mPriorityValues = priorityValues;
    }

    public static void setPriorityValues(String priorityValues) {
        Vector v = MVDUtil.splitString(priorityValues, ",");
        mPriorityValues = new int[v.size()];
        for (int ix = 0; ix < v.size(); ++ix) {
            MVDPriorityObject.mPriorityValues[ix] = Integer.parseInt((String)v.elementAt(ix));
        }
    }

    public static String getLevelClassName() {
        return mLevelClass.getClassName();
    }

    public static void setLevelClassName(String aclass) {
        mLevelClass.setClassName(aclass);
    }

    public static HashMap getClassParams() {
        return mLevelClass.getParams();
    }

    public static void setClassParams(HashMap h) {
        mLevelClass.setParams(h);
    }

    public static QueueClassConfig getLevelClass() {
        return mLevelClass;
    }

    public static boolean getEnabled() {
        return mEnabled;
    }

    public static void setEnabled(boolean i) {
        mEnabled = i;
    }

    public static String getBusyMessage() {
        return mBusyMessage;
    }

    public static void setBusyMessage(String busyMessage) {
        mBusyMessage = busyMessage;
    }

    public static int getBusyLDAPCode() {
        return mBusyLDAPCode;
    }

    public static void setBusyLDApCode(int busyCode) {
        mBusyLDAPCode = busyCode;
    }

    public static int getNumberofPriorityLevels() {
        return mNumberofPriorityLevels;
    }

    public static void setNumberofPriorityLevels(int numberofPriorityLevels) {
        mNumberofPriorityLevels = numberofPriorityLevels;
    }

    public static int getQueueSizeLimit() {
        return mQueueSizeLimit;
    }

    public static void setQueueSizeLimit(int queueSizeLimit) {
        mQueueSizeLimit = queueSizeLimit;
    }

    public static int getEngineLimit() {
        return mEngineLimit;
    }

    public static void setEngineLimit(int engineLimit) {
        mEngineLimit = engineLimit;
    }

    public static int getWaitForGo() {
        return mWaitForGo;
    }

    public static void setWaitForGo(int waitForGo) {
        mWaitForGo = waitForGo;
    }

    public static int getWaitWhenQueueIsFull() {
        return mMillisecondsToWaitWhenQueueIsFull;
    }

    public static void setWaitWhenQueueIsFull(int waitWhenQueueIsFull) {
        mMillisecondsToWaitWhenQueueIsFull = waitWhenQueueIsFull;
    }

    public static void FillQueueDef(Node QueueRecordNode) throws MVDConfigException {
        if (!QueueRecordNode.hasChildNodes()) {
            return;
        }
        try {
            NodeList nodeList = QueueRecordNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String strVal;
                int intVal;
                Node node = nodeList.item(i);
                if (!node.hasChildNodes()) continue;
                String nodeStr = node.getNodeName();
                if (nodeStr.equalsIgnoreCase("Enabled")) {
                    boolean boolVal;
                    mEnabled = boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Levels")) {
                    mNumberofPriorityLevels = intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("QueueLimit")) {
                    mQueueSizeLimit = intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("EngineLimit")) {
                    mEngineLimit = intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("WaitForQueue")) {
                    mMillisecondsToWaitWhenQueueIsFull = intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("WaitForGo")) {
                    mWaitForGo = intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("BusyCode")) {
                    mBusyLDAPCode = intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("BusyMessage")) {
                    mBusyMessage = strVal = node.getFirstChild().getNodeValue();
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Values")) {
                    strVal = node.getFirstChild().getNodeValue();
                    MVDPriorityObject.setPriorityValues(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ClassName")) {
                    strVal = node.getFirstChild().getNodeValue();
                    MVDPriorityObject.setLevelClassName(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Parameters")) {
                    HashMap actionparams = ConfigUtil.readParams(node);
                    MVDPriorityObject.setClassParams(actionparams);
                    continue;
                }
                MVDLogger.Debug("Unknown node type in Queue definition: " + nodeStr);
            }
        }
        catch (NumberFormatException nfe) {
            throw new MVDConfigException("QueueEmployment Configuration error: Expected int but got String: " + nfe.getMessage());
        }
        catch (DOMException de) {
            throw new MVDConfigException("QueueEmployment Configuration error: Cannot get node value: " + de.getMessage());
        }
    }
}

