/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.config.MVDLDAPDeployment;
import java.util.Hashtable;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MVDLDAPDeploymentList {
    private static Hashtable allLdapDeployments = new Hashtable();
    private static Hashtable newLdapDeployments;
    private static MVDLDAPDeployment mMainLDAPDeployment;

    public static MVDLDAPDeployment getMainLDAPDeployment() {
        return mMainLDAPDeployment;
    }

    public static boolean isMainDeployment(MVDLDAPDeployment aDep) {
        if (mMainLDAPDeployment == null) {
            return false;
        }
        return aDep.getName().equalsIgnoreCase(mMainLDAPDeployment.getName());
    }

    public static boolean isMainDeploymentsName(String aKey) {
        if (mMainLDAPDeployment == null) {
            return false;
        }
        return aKey.equalsIgnoreCase(mMainLDAPDeployment.getName());
    }

    public static Hashtable getLDAPDeployments() {
        return allLdapDeployments;
    }

    public static MVDLDAPDeployment getLDAPDeploymentByName(String aName) {
        return (MVDLDAPDeployment)allLdapDeployments.get(aName);
    }

    public static void reloadConfig(Node ldapdeplTopNode) throws MVDConfigException {
        MVDLDAPDeploymentList.readAllLDAPDeployments(ldapdeplTopNode);
    }

    public static void applyChanges() {
        allLdapDeployments = newLdapDeployments;
    }

    public static void loadConfig(Node ldapdeplTopNode) throws MVDConfigException {
        MVDLDAPDeploymentList.readAllLDAPDeployments(ldapdeplTopNode);
        MVDLDAPDeploymentList.applyChanges();
    }

    private static void readAllLDAPDeployments(Node ldapdeplTopNode) throws MVDConfigException {
        newLdapDeployments = new Hashtable();
        NodeList nodeList = ldapdeplTopNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            MVDLDAPDeployment ldapdepl = new MVDLDAPDeployment();
            if (!MVDLDAPDeploymentList.fillLDAPDeployment(ldapdepl, nodeList.item(i))) continue;
            if (newLdapDeployments.put(ldapdepl.getName(), ldapdepl) != null) {
                throw new MVDConfigException("LDAPDeployment config: Identical hash " + ldapdepl.getName());
            }
            if (mMainLDAPDeployment != null) continue;
            mMainLDAPDeployment = ldapdepl;
        }
    }

    private static boolean fillLDAPDeployment(MVDLDAPDeployment ldapdepl, Node ldapdeploymentRecordNode) throws MVDConfigException {
        if (!ldapdeploymentRecordNode.hasChildNodes()) {
            return false;
        }
        try {
            NodeList nodeList = ldapdeploymentRecordNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                boolean boolVal;
                String strVal;
                Node node = nodeList.item(i);
                if (!node.hasChildNodes()) continue;
                String nodeStr = node.getNodeName();
                if (nodeStr.equalsIgnoreCase("Name")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ldapdepl.setName(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Enabled")) {
                    boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    ldapdepl.setEnabled(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("PortNumber")) {
                    int intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    ldapdepl.setPortNumber(intVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("NetworkInterface")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ldapdepl.setNetworkInterface(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("EnableSecureServer") || nodeStr.equalsIgnoreCase("SecureServer")) {
                    boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    ldapdepl.setSecureServer(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("KeystoreID")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ldapdepl.setKeystoreID(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("TrustStoreID")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ldapdepl.setTrustStoreID(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ClientAuthentication")) {
                    boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    ldapdepl.setClientAuthentication(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Description")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ldapdepl.setDescription(strVal);
                    continue;
                }
                throw new MVDConfigException("Configuration error: Wrong node type in LDAP Deployment config: " + nodeStr);
            }
        }
        catch (NumberFormatException nfe) {
            throw new MVDConfigException("LDAP Deployment Configuration error: Expected int but got String: " + nfe.getMessage());
        }
        catch (DOMException de) {
            throw new MVDConfigException("LDAP Deployment Configuration error: Cannot get node value: " + de.getMessage());
        }
        return true;
    }

    static {
        mMainLDAPDeployment = null;
    }
}

