/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.config.MVDAcl;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.config.MVDJoinGroup;
import com.sap.idm.vds.config.MVDSource;
import com.sap.idm.vds.config.MVDSourceList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MVDJoinGroupList {
    private static Hashtable allJoinGroups = new Hashtable();
    private static Hashtable reloadJoinGroups = new Hashtable();

    public static MVDJoinGroup getJoinGroupByID(int aID) {
        return (MVDJoinGroup)allJoinGroups.get(new Integer(aID));
    }

    public static void reloadConfig(Node aTopNode) throws MVDConfigException {
        MVDJoinGroupList.readJoinGroup(aTopNode);
    }

    public static void applyChanges() {
        allJoinGroups = reloadJoinGroups;
        reloadJoinGroups = new Hashtable();
    }

    public static void loadConfig(Node aTopNode) throws MVDConfigException {
        MVDJoinGroupList.readJoinGroup(aTopNode);
        MVDJoinGroupList.applyChanges();
    }

    public static void readJoinGroup(Node aTopNode) throws MVDConfigException {
        NodeList nodeList = aTopNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            MVDJoinGroup group = new MVDJoinGroup();
            if (!MVDJoinGroupList.fillJoinGroup(group, nodeList.item(i))) continue;
            reloadJoinGroups.put(new Integer(group.getID()), group);
        }
    }

    private static boolean fillJoinGroup(MVDJoinGroup aGroup, Node aRecordNode) throws MVDConfigException {
        String configuredAttrVal = "";
        if (!aRecordNode.hasChildNodes()) {
            return false;
        }
        try {
            NodeList nodeList = aRecordNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String strVal;
                boolean boolVal;
                int intVal;
                Node node = nodeList.item(i);
                if (!node.hasChildNodes()) continue;
                String nodeStr = node.getNodeName();
                if (nodeStr.equalsIgnoreCase("ID")) {
                    intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    aGroup.setID(intVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Source")) {
                    MVDSource sss = new MVDSource();
                    MVDSourceList.FillSource(sss, node);
                    aGroup.setMaster(sss);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("AttributeSources")) continue;
                if (nodeStr.equalsIgnoreCase("Enabled")) {
                    boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    aGroup.setEnabled(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("JoinLimit")) {
                    intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    aGroup.setJoinLimit(intVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("UseJoinLimit")) {
                    boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    aGroup.setUseJoinLimit(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Joinonoperation")) {
                    strVal = node.getFirstChild().getNodeValue();
                    aGroup.setJoinOnOperation(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("MasterMandatoryFields")) {
                    strVal = node.getFirstChild().getNodeValue();
                    aGroup.setMasterMandatoryFields(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Name")) {
                    strVal = node.getFirstChild().getNodeValue();
                    aGroup.setName(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Attributes")) {
                    configuredAttrVal = node.getFirstChild().getNodeValue();
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Description")) continue;
                if (nodeStr.equalsIgnoreCase("UniqueName")) {
                    strVal = node.getFirstChild().getNodeValue();
                    if (strVal == null || strVal.length() <= 0) continue;
                    aGroup.setUniqueName(strVal);
                    continue;
                }
                throw new MVDConfigException("Configuration error: Wrong node type in join group config: " + nodeStr);
            }
        }
        catch (NumberFormatException nfe) {
            throw new MVDConfigException("Join group Configuration error: invalid format: " + nfe.getMessage());
        }
        catch (DOMException de) {
            throw new MVDConfigException("Join group Configuration error: Cannot get node value: " + de.getMessage());
        }
        aGroup.setJoinAttributeEntries(configuredAttrVal);
        return true;
    }

    public static void createInternalTree() throws MVDConfigException {
        Iterator iter = allJoinGroups.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry element = iter.next();
            MVDJoinGroup src = (MVDJoinGroup)element.getValue();
            if (!src.isEnabled()) continue;
            MVDAcl.createReferralTree(src);
        }
    }
}

