/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.config.MVDAcl;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.config.MVDTree;
import com.sap.idm.vds.config.MVDUserGroupList;
import java.util.HashMap;
import java.util.Iterator;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MVDForestList {
    public static int INTERNAL_TREE_ID = 999999999;
    public static String INTERNAL_TREE_NAME = "INTERNAL_TREE";
    private static HashMap myForest = new HashMap();
    private static HashMap newForest = new HashMap();

    public static int getIdByName(String treeName) {
        return (Integer)myForest.get(treeName.toLowerCase());
    }

    public static MVDAcl getTreeByName(String treeName) {
        Integer treeId = (Integer)myForest.get(treeName.toLowerCase());
        if (treeId == null) {
            return null;
        }
        int userGroup = MVDUserGroupList.getUGIdByTreeId(treeId);
        return MVDAcl.getChild("", userGroup);
    }

    public static MVDAcl getNodeByName(String treeName, String childName) {
        Integer treeId = null;
        treeId = treeName.equals(INTERNAL_TREE_NAME) ? new Integer(INTERNAL_TREE_ID) : (Integer)myForest.get(treeName.toLowerCase());
        if (treeId == null) {
            return null;
        }
        int userGroup = MVDUserGroupList.getUGIdByTreeId(treeId);
        return MVDAcl.getChild(childName, userGroup);
    }

    public static String getDefaultTree() {
        Iterator it = myForest.keySet().iterator();
        if (it.hasNext()) {
            String aTree = (String)it.next();
            return aTree;
        }
        return null;
    }

    public static void reloadConfig(Node forestTopNode) throws MVDConfigException {
        MVDForestList.readForest(forestTopNode);
    }

    public static void applyChanges() {
        myForest = newForest;
    }

    public static void loadConfig(Node forestTopNode) throws MVDConfigException {
        MVDForestList.readForest(forestTopNode);
        MVDForestList.applyChanges();
    }

    private static void readForest(Node forestTopNode) throws MVDConfigException {
        newForest = new HashMap();
        NodeList nodeList = forestTopNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node aTreeNode = nodeList.item(i);
            if (!aTreeNode.hasChildNodes()) continue;
            MVDTree tree = new MVDTree();
            try {
                MVDForestList.fillTree(tree, aTreeNode);
                newForest.put(tree.Name().toLowerCase(), new Integer(tree.ID()));
                MVDUserGroupList.createUserGroup(tree.ID(), "INTERNAL_" + tree.Name());
                continue;
            }
            catch (MVDConfigException e) {
                if (tree.Name() != null) {
                    throw new MVDConfigException("Tree '" + tree.Name() + "' failed. " + e.getMessage());
                }
                throw e;
            }
        }
        MVDTree internalTree = new MVDTree();
        internalTree.setId(INTERNAL_TREE_ID);
        internalTree.setName(INTERNAL_TREE_NAME);
        MVDUserGroupList.createUserGroup(internalTree.ID(), "INTERNAL_" + internalTree.Name());
    }

    private static void fillTree(MVDTree aTree, Node treeNode) throws MVDConfigException {
        try {
            NodeList nodeList = treeNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!node.hasChildNodes()) continue;
                String nodeStr = node.getNodeName();
                if (nodeStr.equalsIgnoreCase("ID")) {
                    aTree.setId(Integer.parseInt(node.getFirstChild().getNodeValue()));
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Name")) {
                    aTree.setName(node.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Description")) {
                    aTree.setDescription(node.getFirstChild().getNodeValue());
                    continue;
                }
                throw new MVDConfigException("Configuration error: Wrong node type in Forest config: " + nodeStr);
            }
        }
        catch (NumberFormatException nfe) {
            throw new MVDConfigException("Forest Configuration error: Expected int but got String: " + nfe.getMessage());
        }
        catch (DOMException de) {
            throw new MVDConfigException("Forest Configuration error: Cannot get node value: " + de.getMessage());
        }
    }
}

