/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.config.MVDAcl;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.config.MVDDynamicAddGroup;
import com.sap.idm.vds.config.MVDSource;
import com.sap.idm.vds.config.MVDSourceList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MVDDynamicAddGroupList {
    private static Hashtable allDynamicAddGroups = new Hashtable();
    private static Hashtable reloadDynamicAddGroups = new Hashtable();

    public static MVDDynamicAddGroup getDynamicAddGroupByID(int aID) {
        return (MVDDynamicAddGroup)allDynamicAddGroups.get(new Integer(aID));
    }

    public static void reloadConfig(Node aTopNode) throws MVDConfigException {
        MVDDynamicAddGroupList.readDynamicAddGroup(aTopNode);
    }

    public static void applyChanges() {
        allDynamicAddGroups = reloadDynamicAddGroups;
        reloadDynamicAddGroups = new Hashtable();
    }

    public static void loadConfig(Node aTopNode) throws MVDConfigException {
        MVDDynamicAddGroupList.readDynamicAddGroup(aTopNode);
        MVDDynamicAddGroupList.applyChanges();
    }

    public static void readDynamicAddGroup(Node aTopNode) throws MVDConfigException {
        NodeList nodeList = aTopNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            MVDDynamicAddGroup group = new MVDDynamicAddGroup();
            if (!MVDDynamicAddGroupList.fillDynamicAddGroup(group, nodeList.item(i))) continue;
            reloadDynamicAddGroups.put(new Integer(group.getID()), group);
        }
    }

    private static boolean fillDynamicAddGroup(MVDDynamicAddGroup aGroup, Node aRecordNode) throws MVDConfigException {
        String configuredAttrVal = "";
        if (!aRecordNode.hasChildNodes()) {
            return false;
        }
        try {
            NodeList nodeList = aRecordNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String strVal;
                Node node = nodeList.item(i);
                if (!node.hasChildNodes()) continue;
                String nodeStr = node.getNodeName();
                if (nodeStr.equalsIgnoreCase("ID")) {
                    int intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    aGroup.setID(intVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Source")) {
                    MVDSource sss = new MVDSource();
                    MVDSourceList.FillSource(sss, node);
                    aGroup.setMaster(sss);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("AttributeSources")) continue;
                if (nodeStr.equalsIgnoreCase("Enabled")) {
                    boolean boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    aGroup.setEnabled(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Name")) {
                    strVal = node.getFirstChild().getNodeValue();
                    aGroup.setName(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Attributes")) {
                    configuredAttrVal = node.getFirstChild().getNodeValue();
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Description")) continue;
                if (nodeStr.equalsIgnoreCase("UniqueName")) {
                    strVal = node.getFirstChild().getNodeValue();
                    if (strVal == null || strVal.length() <= 0) continue;
                    aGroup.setUniqueName(strVal);
                    continue;
                }
                throw new MVDConfigException("Configuration error: Wrong node type in Dynamic add group config: " + nodeStr);
            }
        }
        catch (NumberFormatException nfe) {
            throw new MVDConfigException("Dynamic add group Configuration error: invalid format: " + nfe.getMessage());
        }
        catch (DOMException de) {
            throw new MVDConfigException("Dynamic add group Configuration error: Cannot get node value: " + de.getMessage());
        }
        aGroup.setDynamicAddEntries(configuredAttrVal);
        return true;
    }

    public static void createInternalTree() throws MVDConfigException {
        Iterator iter = allDynamicAddGroups.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry element = iter.next();
            MVDDynamicAddGroup src = (MVDDynamicAddGroup)element.getValue();
            if (!src.isEnabled()) continue;
            MVDAcl.createReferralTree(src);
        }
    }
}

