/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDOrderedHashMap;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.config.MVDAttributeSource;
import com.sap.idm.vds.config.MVDAttributeSourceList;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.config.MVDSource;
import com.sap.idm.vds.implicitattr.Attribute;
import com.sap.idm.vds.implicitattr.AttributeSource;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class MVDDynamicAddGroup {
    private String mName;
    private int mId;
    private boolean mEnabled;
    private MVDSource mMaster;
    private MVDOrderedHashMap mDynamicAddEntries;
    private MVDOrderedHashMap mDynamicAddHashmapAttributes;
    private String mUniqueName;

    public int getID() {
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public MVDSource getMaster() {
        return this.mMaster;
    }

    public MVDOrderedHashMap getDynamicAddAttributes() {
        MVDOrderedHashMap h = new MVDOrderedHashMap();
        Iterator iter = this.mDynamicAddHashmapAttributes.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Attribute value = new Attribute((Attribute)this.mDynamicAddHashmapAttributes.get(key));
            h.put(key, value);
        }
        return h;
    }

    public MVDOrderedHashMap getDynamicAddEntries() {
        MVDOrderedHashMap map = new MVDOrderedHashMap();
        Iterator iter = this.mDynamicAddEntries.keySet().iterator();
        while (iter.hasNext()) {
            String srcName = (String)iter.next();
            AttributeSource srcCopy = new AttributeSource((AttributeSource)this.mDynamicAddEntries.get(srcName));
            map.put(srcName, srcCopy);
        }
        return map;
    }

    public String getUniqueName() {
        if (this.mUniqueName == null) {
            String tmp = this.mId + this.mName.replace(' ', '_');
            this.mUniqueName = tmp.length() <= 10 ? tmp : tmp.substring(0, 10);
        }
        return this.mUniqueName;
    }

    public void setName(String aName) {
        this.mName = aName;
    }

    public void setID(int aID) {
        this.mId = aID;
    }

    public void setEnabled(boolean aVal) {
        this.mEnabled = aVal;
    }

    public void setMaster(MVDSource am) {
        this.mMaster = am;
    }

    public void setDynamicAddEntries(String aDynAdd) throws MVDConfigException {
        this.mDynamicAddHashmapAttributes = new MVDOrderedHashMap();
        this.mDynamicAddEntries = new MVDOrderedHashMap();
        if (aDynAdd == null || aDynAdd.length() == 0) {
            return;
        }
        Vector dynamicaddrows = MVDUtil.splitString(aDynAdd, ";");
        HashMap allSources = new HashMap();
        Iterator iter = dynamicaddrows.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            Vector split = MVDUtil.splitString(element, "::");
            if (split.size() != 6) {
                throw new MVDConfigException("Wrong number of values in datasource.dynamicadd");
            }
            boolean enabled = Boolean.valueOf((String)split.elementAt(0));
            if (!enabled) continue;
            Vector attrnames = MVDUtil.splitString((String)split.elementAt(1), ',');
            Iterator it = attrnames.iterator();
            while (it.hasNext()) {
                String attrname = ((String)it.next()).trim();
                String operation = (String)split.elementAt(2);
                boolean mandatory = Boolean.valueOf((String)split.elementAt(3));
                String sources = (String)split.elementAt(4);
                Vector sourcesAsVector = MVDUtil.splitString(sources, ",");
                boolean single = ((String)split.elementAt(5)).equalsIgnoreCase("S");
                Attribute attr = new Attribute(operation, attrname, single, mandatory);
                Iterator iterator = sourcesAsVector.iterator();
                while (iterator.hasNext()) {
                    String s = (String)iterator.next();
                    this.addToDynamicAddAttributeSource(s, allSources, attr);
                }
                this.mDynamicAddHashmapAttributes.put(attr.getName().toLowerCase(), attr);
            }
        }
    }

    private AttributeSource addToDynamicAddAttributeSource(String aSrcName, HashMap aAllSources, Attribute aAttr) throws MVDConfigException {
        AttributeSource source = (AttributeSource)this.mDynamicAddEntries.get(aSrcName.toLowerCase());
        if (aSrcName.startsWith("\"") || aSrcName.startsWith("$req") || aSrcName.startsWith("$dn")) {
            if (source == null) {
                String newsourcename = MVDUtil.replace(aSrcName, "\"", "");
                source = new AttributeSource(newsourcename);
                this.mDynamicAddEntries.put(aSrcName, source);
            }
            source.addAttribute(aAttr.getName().toLowerCase());
            aAttr.addSource(aSrcName);
        } else {
            if (source == null) {
                int attrsrcid;
                try {
                    attrsrcid = Integer.parseInt(aSrcName);
                }
                catch (NumberFormatException e) {
                    throw new MVDConfigException("Attribute source misconfigured " + aSrcName + " is not a valid ID");
                }
                MVDAttributeSource tmp = MVDAttributeSourceList.getAttributeSourceByID(attrsrcid);
                if (tmp == null) {
                    MVDLogger.Log("Attribute source not found", 7);
                    throw new MVDConfigException("Attribute source not found " + aSrcName);
                }
                source = new AttributeSource(tmp);
                this.mDynamicAddEntries.put(aSrcName.toLowerCase(), source);
            }
            source.addAttribute(aAttr.getName().toLowerCase());
            aAttr.addSource(aSrcName.toLowerCase());
        }
        return source;
    }

    public void setUniqueName(String aName) {
        this.mUniqueName = aName;
    }
}

