/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.config.MVDAcl;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.config.MVDDataSourceSequentialGroup;
import com.sap.idm.vds.config.MVDSource;
import com.sap.idm.vds.config.MVDSourceList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MVDDataSourceSequentialGroupList {
    private static Hashtable allDS = new Hashtable();
    private static Hashtable newDS = new Hashtable();

    public static MVDDataSourceSequentialGroup getDSByID(int id) {
        return (MVDDataSourceSequentialGroup)allDS.get(new Integer(id));
    }

    public static void applyChanges() {
        allDS = newDS;
    }

    public static void reloadConfig(Node dsTopNode) throws MVDConfigException {
        MVDDataSourceSequentialGroupList.readDSGroup(dsTopNode);
    }

    public static void loadConfig(Node dsTopNode) throws MVDConfigException {
        MVDDataSourceSequentialGroupList.readDSGroup(dsTopNode);
        MVDDataSourceSequentialGroupList.applyChanges();
    }

    public static void readDSGroup(Node dsTopNode) throws MVDConfigException {
        newDS = new Hashtable();
        NodeList nodeList = dsTopNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            MVDDataSourceSequentialGroup ds = new MVDDataSourceSequentialGroup();
            if (!MVDDataSourceSequentialGroupList.FillDataSourceSequentialGroup(ds, nodeList.item(i))) continue;
            newDS.put(new Integer(ds.IID()), ds);
        }
    }

    private static boolean FillDataSourceSequentialGroup(MVDDataSourceSequentialGroup ds, Node dsRecordNode) throws MVDConfigException {
        try {
            NodeList nodeList = dsRecordNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                boolean boolVal;
                String strVal;
                Node node = nodeList.item(i);
                if (!node.hasChildNodes()) continue;
                String nodeStr = node.getNodeName();
                if (nodeStr.equalsIgnoreCase("Name") || nodeStr.equalsIgnoreCase("NiceName")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetNiceName(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ID")) {
                    int intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    ds.SetIID(intVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Enabled")) {
                    boolean bl = boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    if (!boolVal) {
                        MVDLogger.Log("Data source configuration: Cleaning unused DS group: " + ds.NiceName(), 4);
                        return false;
                    }
                    ds.SetIsAllowed(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("MemberIDs") || nodeStr.equalsIgnoreCase("IncludedDS")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetIncludedDS(strVal.toLowerCase());
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Source")) {
                    MVDSource sss = new MVDSource();
                    MVDSourceList.FillSource(sss, node);
                    ds.AddIncludedDS(sss);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ServerSelectClass")) {
                    ds.setServerSelectClass(node.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("EnableServerSelect")) {
                    boolVal = Boolean.valueOf(node.getFirstChild().getNodeValue());
                    ds.setEnableServerSelect(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("MasterDS") || nodeStr.equalsIgnoreCase("Description")) continue;
                if (nodeStr.equalsIgnoreCase("SearchOneServerOnly")) {
                    boolVal = Boolean.valueOf(node.getFirstChild().getNodeValue());
                    ds.setSearchOneServerOnly(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ReturnMoreThanLimit")) continue;
                if (nodeStr.equalsIgnoreCase("UniqueName")) {
                    strVal = node.getFirstChild().getNodeValue();
                    if (strVal == null || strVal.length() <= 0) continue;
                    ds.setUniqueName(strVal);
                    continue;
                }
                throw new MVDConfigException("Configuration error: Wrong node type in DS group config: " + nodeStr);
            }
        }
        catch (NumberFormatException nfe) {
            throw new MVDConfigException("Data Source Group Configuration error: Expected int but got String: " + nfe.getMessage());
        }
        catch (DOMException de) {
            throw new MVDConfigException("Data Source Group Configuration error: Cannot get node value: " + de.getMessage());
        }
        return true;
    }

    public static void createInternalTree() throws MVDConfigException {
        Iterator iter = allDS.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry element = iter.next();
            MVDDataSourceSequentialGroup src = (MVDDataSourceSequentialGroup)element.getValue();
            if (!src.IsAllowed()) continue;
            MVDAcl.createReferralTree(src);
        }
    }
}

