/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.config.MVDAcl;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.config.MVDDataSource;
import com.sap.idm.vds.util.MxJNDISocketFactory;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MVDDataSourceList {
    private static Hashtable allDS = new Hashtable();
    private static Hashtable allDSName = new Hashtable();
    private static Hashtable allDSUniqueNames = new Hashtable();
    private static Hashtable newDS;
    private static Hashtable newDSName;
    private static Hashtable newDSUniqueNames;

    public static MVDDataSource getDSByID(int id) {
        return (MVDDataSource)allDS.get(new Integer(id));
    }

    public static MVDDataSource getDSByName(String name) {
        return (MVDDataSource)allDSName.get(name.toLowerCase());
    }

    public static MVDDataSource getDSByUniqueName(String aUniqueName) {
        return (MVDDataSource)allDSUniqueNames.get(aUniqueName.toLowerCase());
    }

    public static void reloadConfig(Node dsTopNode) throws MVDConfigException {
        MVDDataSourceList.readDS(dsTopNode);
    }

    public static void applyChanges() {
        allDS = newDS;
        allDSName = newDSName;
        allDSUniqueNames = newDSUniqueNames;
        MxJNDISocketFactory.applyChanges();
    }

    public static void loadConfig(Node dsTopNode) throws MVDConfigException {
        MVDDataSourceList.readDS(dsTopNode);
        MVDDataSourceList.applyChanges();
    }

    private static void readDS(Node dsTopNode) throws MVDConfigException {
        newDS = new Hashtable();
        newDSName = new Hashtable();
        newDSUniqueNames = new Hashtable();
        NodeList nodeList = dsTopNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            MVDDataSource ds = new MVDDataSource();
            try {
                if (!MVDDataSourceList.FillDataSource(ds, nodeList.item(i))) continue;
                if (ds.IsAllowed()) {
                    ds.SetEffectiveValues();
                }
                newDS.put(new Integer(ds.IID()), ds);
                newDSName.put(ds.NiceName().toLowerCase(), ds);
                newDSUniqueNames.put(ds.getUniqueName().toLowerCase(), ds);
                continue;
            }
            catch (MVDConfigException e) {
                if (ds.NiceName() != null) {
                    throw new MVDConfigException("Data source '" + ds.NiceName() + "' failed. " + e.getMessage());
                }
                throw e;
            }
        }
    }

    public static void createInternalTree() throws MVDConfigException {
        Iterator iter = allDS.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry element = iter.next();
            MVDDataSource src = (MVDDataSource)element.getValue();
            if (!src.IsAllowed()) continue;
            MVDAcl.createReferralTree(src);
        }
    }

    private static boolean FillDataSource(MVDDataSource ds, Node dsRecordNode) throws MVDConfigException {
        boolean datasource_is_enabled = false;
        if (!dsRecordNode.hasChildNodes()) {
            return false;
        }
        try {
            block61: {
                boolean ret = false;
                try {
                    NodeList nl = ((Element)dsRecordNode).getElementsByTagName("Enabled");
                    if (nl.getLength() > 0 && !nl.item(0).getFirstChild().getNodeValue().equalsIgnoreCase("true")) {
                        ret = true;
                        nl = ((Element)dsRecordNode).getElementsByTagName("Name");
                        String name = "";
                        if (nl.getLength() > 0) {
                            name = nl.item(0).getFirstChild().getNodeValue();
                        }
                        MVDLogger.Log("Data source configuration: Cleaning unused DS: " + name, 4);
                        return false;
                    }
                }
                catch (Exception e) {
                    if (!ret) break block61;
                    return false;
                }
            }
            NodeList nodeList = dsRecordNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                boolean boolVal;
                int intVal;
                String strVal;
                Node node = nodeList.item(i);
                if (!node.hasChildNodes()) continue;
                String nodeStr = node.getNodeName();
                if (nodeStr.equalsIgnoreCase("Name") || nodeStr.equalsIgnoreCase("SourceNiceName")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetNiceName(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("CharSet")) continue;
                if (nodeStr.equalsIgnoreCase("ID")) {
                    intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    ds.SetIID(intVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("JDBCdriver")) {
                    if (!ds.DSType().equalsIgnoreCase("database")) continue;
                    strVal = node.getFirstChild().getNodeValue();
                    try {
                        Class.forName(strVal);
                        MVDLogger.Log("Loaded JDBC driver: " + strVal, 1);
                        continue;
                    }
                    catch (Exception e) {
                        throw new MVDConfigException("Check your CLASSPATH! (in Tools -> Options) Could not load JDBC driver '" + strVal + "'");
                    }
                }
                if (nodeStr.equalsIgnoreCase("PreOpScript")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetPreOpScript(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("PostOpScript")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetPostOpScript(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("SearchScript")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetSearchScript(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ModifyScript")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetModifyScript(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("AddScript")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetAddScript(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("DeleteScript")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetDeleteScript(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("CompareScript")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetCompareScript(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ForbidNonIdxFilt")) {
                    boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    ds.SetForbidNonIdxFilt(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ForbidNonAvailFields")) {
                    boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    ds.SetForbidNonAvailFields(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("DoIgnoreAttributes") || nodeStr.equalsIgnoreCase("IgnoreAttributes")) {
                    boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    ds.SetIgnoreAttributes(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("IsCaseSensitive")) {
                    boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    ds.SetIsCaseSensitive(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("AvailableFields")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetConfiguredAvailableFields(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("FilterFields") || nodeStr.equalsIgnoreCase("IndexedFields")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetConfiguredIndexedFields(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("IgnoredAttributes") || nodeStr.equalsIgnoreCase("IgnoredAttr")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetConfiguredIgnoredAttr(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("EnableConvFromDataSource") || nodeStr.equalsIgnoreCase("EnableConvServer")) {
                    boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    ds.SetEnableConvServer(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("EnableConvToDataSource") || nodeStr.equalsIgnoreCase("EnableConvClient")) {
                    boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    ds.SetEnableConvClient(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("AttrConvToDataSource") || nodeStr.equalsIgnoreCase("AttrConvIn")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetConfiguredInMapping(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("AttrConvFromDataSource") || nodeStr.equalsIgnoreCase("AttrConvOut")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetConfiguredOutMapping(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("AttrConvConstructFromDataSource")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetConfiguredOutConstruct(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("AttrConvDeleteFromDataSource")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetConfiguredOutDelete(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Enabled") || nodeStr.equalsIgnoreCase("Allowed")) {
                    boolean bl = boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    if (!boolVal) {
                        MVDLogger.Log("Data source configuration: Cleaning unused DS: " + ds.NiceName(), 4);
                        return false;
                    }
                    ds.SetIsAllowed(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("DoEditAttributeSet")) {
                    boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    ds.SetEditAttrIsRequired(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("EditAttributeSetMethod")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetEditAttrMethod(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("DefaultStartingPoint")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetDefaultStartingPoint(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("DefaultDN")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetDefaultDN(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("DefaultBaseFilter")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetDefaultBaseFilter(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("DefaultAddHelper")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetDefaultAddHelper(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("DefaultDNFields")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetDefaultDNFields(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ParamFields")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetParamFields(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("EnableSyntaxCheck")) {
                    boolVal = Boolean.valueOf(node.getFirstChild().getNodeValue());
                    ds.setEnableSyntaxCheck(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("SyntaxCheck")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.setSyntaxCheck(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("SyntaxCheckAddSetMethod")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.setSyntaxCheckAddSetMethod(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("SyntaxCheckModSetMethod")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.setSyntaxCheckModSetMethod(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("EnableSyntaxCheckModSet")) {
                    boolVal = Boolean.valueOf(node.getFirstChild().getNodeValue());
                    ds.setEnableSyntaxCheckModSet(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("EnableSyntaxCheckAddSet")) {
                    boolVal = Boolean.valueOf(node.getFirstChild().getNodeValue());
                    ds.setEnableSyntaxCheckAddSet(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("MICRepository")) continue;
                if (nodeStr.equalsIgnoreCase("EnableMultipleServers")) {
                    ds.SetEnableMultipleServers(false);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Type") || nodeStr.equalsIgnoreCase("DSType")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetDSType(strVal.toLowerCase());
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("EnableProvision") || nodeStr.equalsIgnoreCase("Provision")) continue;
                if (nodeStr.equalsIgnoreCase("JoinEnabled")) {
                    boolVal = Boolean.valueOf(node.getFirstChild().getNodeValue());
                    ds.setJoinEnabled(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("JoinEntries")) {
                    ds.setJoinAttributeEntries(node.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("JoinSizeLimit")) {
                    intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    ds.setJoinLimit(intVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("JoinOnOperation")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.setJoinOnOperation(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("UniqueName")) {
                    strVal = node.getFirstChild().getNodeValue();
                    if (strVal == null || strVal.length() <= 0) continue;
                    ds.setUniqueName(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ClientKeystoreID")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.setKeystoreID(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ClientTrustStoreID")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.setTruststoreID(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("AvailableScript") || nodeStr.equalsIgnoreCase("IndexedScript") || nodeStr.equalsIgnoreCase("HelpClass") || nodeStr.equalsIgnoreCase("HelpIndClass") || nodeStr.equalsIgnoreCase("DSEScript") || nodeStr.equalsIgnoreCase("BindScript") || nodeStr.equalsIgnoreCase("SourceEnabled") || nodeStr.equalsIgnoreCase("Description") || nodeStr.equalsIgnoreCase("param1") || nodeStr.equalsIgnoreCase("param2") || nodeStr.equalsIgnoreCase("param3") || nodeStr.equalsIgnoreCase("param4") || nodeStr.equalsIgnoreCase("param5") || nodeStr.equalsIgnoreCase("param6")) continue;
                throw new MVDConfigException("Configuration error: Wrong node type in DS config: " + nodeStr);
            }
        }
        catch (NumberFormatException nfe) {
            throw new MVDConfigException("Data Source Configuration error: Expected int but got String: " + nfe.getMessage());
        }
        catch (DOMException de) {
            throw new MVDConfigException("Data Source Configuration error: Cannot get node value: " + de.getMessage());
        }
        ds.SetDefaultParamFields();
        try {
            ds.SetDefaultClasses();
        }
        catch (Exception nfe) {
            throw new MVDConfigException("Invalid configuration - missing class" + nfe.getMessage());
        }
        return true;
    }

    public static void loadHelperConfig(Node dsTopNode, int dsID) throws MVDConfigException {
        newDS = new Hashtable();
        newDSName = new Hashtable();
        NodeList nodeList = dsTopNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            MVDDataSource ds = new MVDDataSource();
            if (!MVDDataSourceList.FillHelperDataSource(ds, nodeList.item(i), dsID)) continue;
            newDS.put(new Integer(ds.IID()), ds);
        }
        MVDDataSourceList.applyChanges();
    }

    private static boolean FillHelperDataSource(MVDDataSource ds, Node dsRecordNode, int dsID) throws MVDConfigException {
        boolean datasource_is_enabled = false;
        if (!dsRecordNode.hasChildNodes()) {
            return false;
        }
        try {
            NodeList nodeList = dsRecordNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String strVal;
                Node node = nodeList.item(i);
                if (!node.hasChildNodes()) continue;
                String nodeStr = node.getNodeName();
                if (nodeStr.equalsIgnoreCase("ParamFields")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetParamFields(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ID")) {
                    int intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    ds.SetIID(intVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("JDBCdriver")) {
                    if (ds.IID() != dsID) continue;
                    strVal = node.getFirstChild().getNodeValue();
                    try {
                        Class.forName(strVal);
                        continue;
                    }
                    catch (Throwable e) {
                        throw new MVDConfigException("Could not load JDBC driver '" + strVal + "' for database '" + ds.NiceName() + "': " + e.getMessage());
                    }
                }
                if (!nodeStr.equalsIgnoreCase("Type") && !nodeStr.equalsIgnoreCase("DSType")) continue;
                strVal = node.getFirstChild().getNodeValue();
                ds.SetDSType(strVal);
            }
        }
        catch (NumberFormatException nfe) {
            throw new MVDConfigException("Data Source Configuration error: Expected int but got String: " + nfe.getMessage());
        }
        catch (DOMException de) {
            throw new MVDConfigException("Data Source Configuration error: Cannot get node value: " + de.getMessage());
        }
        return true;
    }
}

