/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.config.MVDDataSourceGroup;
import java.util.Hashtable;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MVDDataSourceGroupList {
    private static Hashtable allDS = new Hashtable();

    public static MVDDataSourceGroup getDSByID(int id) {
        return (MVDDataSourceGroup)allDS.get(new Integer(id));
    }

    public static void reloadConfig(Node dsTopNode) throws MVDConfigException {
        allDS.clear();
        MVDDataSourceGroupList.readDSGroup(dsTopNode);
    }

    public static void loadConfig(Node dsTopNode) throws MVDConfigException {
        MVDDataSourceGroupList.readDSGroup(dsTopNode);
    }

    public static void readDSGroup(Node dsTopNode) throws MVDConfigException {
        NodeList nodeList = dsTopNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            MVDDataSourceGroup ds = new MVDDataSourceGroup();
            if (!MVDDataSourceGroupList.FillDataSourceGroup(ds, nodeList.item(i))) continue;
            allDS.put(new Integer(ds.IID()), ds);
        }
    }

    private static boolean FillDataSourceGroup(MVDDataSourceGroup ds, Node dsRecordNode) throws MVDConfigException {
        boolean datasource_is_enabled = false;
        if (!dsRecordNode.hasChildNodes()) {
            return false;
        }
        try {
            NodeList nodeList = dsRecordNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                boolean boolVal;
                int intVal;
                String strVal;
                Node node = nodeList.item(i);
                if (!node.hasChildNodes()) continue;
                String nodeStr = node.getNodeName();
                if (nodeStr.equalsIgnoreCase("Name") || nodeStr.equalsIgnoreCase("NiceName")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetNiceName(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("AdditionalAttributes")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetAdditionalAttributes(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ID")) {
                    intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    ds.SetIID(intVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("JoinLimit")) {
                    intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    ds.SetJoinLimit(intVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("JoinOnAllSearchTypes") || nodeStr.equalsIgnoreCase("JoinOnAllOps")) {
                    boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    ds.SetJoinOnAllOperations(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Enabled")) {
                    boolean bl = boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    if (!boolVal) {
                        MVDLogger.Log("Data source configuration: Cleaning unused DS group: " + ds.NiceName(), 4);
                        return false;
                    }
                    ds.SetIsAllowed(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ConnectionArray")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetConnectionArray(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("MemberIDs") || nodeStr.equalsIgnoreCase("IncludedDS")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.SetIncludedDS(strVal.toLowerCase());
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("LimitMasterEntries")) {
                    boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    ds.SetLimitMasterEntries(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("MasterDS") || nodeStr.equalsIgnoreCase("Description") || nodeStr.equalsIgnoreCase("ReturnMoreThanLimit")) continue;
                if (nodeStr.equalsIgnoreCase("UniqueName")) {
                    strVal = node.getFirstChild().getNodeValue();
                    if (strVal == null || strVal.length() <= 0) continue;
                    ds.setUniqueName(strVal);
                    continue;
                }
                throw new MVDConfigException("Configuration error: Wrong node type in DS group config: " + nodeStr);
            }
        }
        catch (NumberFormatException nfe) {
            throw new MVDConfigException("Data Source Group Configuration error: Expected int but got String: " + nfe.getMessage());
        }
        catch (DOMException de) {
            throw new MVDConfigException("Data Source Group Configuration error: Cannot get node value: " + de.getMessage());
        }
        return true;
    }
}

