/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.Globals;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDOrderedHashMap;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.MVDUtilities;
import com.sap.idm.vds.config.MVDAttributeSource;
import com.sap.idm.vds.config.MVDAttributeSourceList;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.config.MVDProxy;
import com.sap.idm.vds.config.MVDTopFailover;
import com.sap.idm.vds.config.MVDTopLoadBalancing;
import com.sap.idm.vds.config.MVDTopMultiServerGroup;
import com.sap.idm.vds.config.MVDTopMultiServerGroupAbstract;
import com.sap.idm.vds.config.MVDTopMultiServerGroupList;
import com.sap.idm.vds.config.SyntaxMethod;
import com.sap.idm.vds.event.EventTriggerConfig;
import com.sap.idm.vds.ie.op.common.util.MVDMic_Util;
import com.sap.idm.vds.implicitattr.Attribute;
import com.sap.idm.vds.implicitattr.AttributeSource;
import com.sap.idm.vds.util.MxJNDISocketFactory;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class MVDDataSource {
    private int mIID;
    private boolean mInitPerSessionDone = false;
    private String mNiceName;
    private String mIpAddr;
    private boolean mIsAllowed;
    private boolean mEditAttrIsRequired;
    private String mEditAttrMethod;
    private String mDefaultStartingPoint;
    private String mDefaultDN;
    private String mDefaultDNFields;
    private String mDefaultBaseFilter;
    private String mDefaultAddHelper;
    private boolean mEnableConvServer;
    private boolean mEnableConvClient;
    private String mConfiguredInMappingString;
    private String mConfiguredOutMappingString;
    private String mConfiguredOutConstructString;
    private String mConfiguredOutDeleteString;
    private HashMap mConfiguredRequestAttrMapping;
    private HashMap mConfiguredRequestAttrScripts;
    private HashMap mConfiguredResponseAttrMapping;
    private HashMap mConfiguredResponseAttrMappingScripts;
    private HashMap mConfiguredResponseAttrConstruct;
    private HashMap mConfiguredResponseAttrConstructScripts;
    private HashMap mConfiguredResponseAttrConstructIfExists;
    private HashMap mConfiguredResponseAttrDelete;
    private HashMap mEffectiveRequestAttrMapping;
    private HashMap mEffectiveRequestAttrScripts;
    private HashMap mEffectiveResponseAttrMapping;
    private HashMap mEffectiveResponseAttrMappingScripts;
    private HashMap mEffectiveResponseAttrConstruct;
    private HashMap mEffectiveResponseAttrConstructScripts;
    private HashMap mEffectiveResponseAttrConstructIfExists;
    private HashMap mEffectiveResponseAttrDelete;
    private HashMap mSensitivityConversionMap;
    private boolean mIsCaseSensitive = false;
    private boolean mForbidNonIdxFilt;
    private boolean mForbidNonAvailFields;
    private boolean mIgnoreAttributes;
    private HashMap mConfiguredIgnoredAttr;
    private HashMap mConfiguredAvailableFieldsTypes = new HashMap();
    private HashMap mConfiguredAvailableFields;
    private HashMap mConfiguredIndexedFields;
    private String mConfiguredAvailableFieldsKeys;
    private String mConfiguredIndexedFieldsKeys;
    private HashMap mEffectiveIgnoredAttr;
    private HashMap mEffectiveAvailableFieldsForFilter;
    private HashMap mEffectiveAvailableFieldsForAttributes;
    private HashMap mEffectiveAvailableAndIgnoredAttr;
    private MVDOrderedHashMap mProvisionEntries;
    private MVDOrderedHashMap mProvisionHashMapAttributes;
    private boolean mJoinEnabled;
    private MVDOrderedHashMap mJoinEntries;
    private MVDOrderedHashMap mJoinHashMapAttributes;
    private int mJoinLimit;
    private boolean[] mJoinOnOperation;
    private String mBindScript;
    private String mPreOpScript;
    private String mPostOpScript;
    private String mDSEScript;
    private String mSearchScript;
    private String mModifyScript;
    private String mAddScript;
    private String mDeleteScript;
    private String mCompareScript;
    private String mAvailableScript;
    private String mIndexedScript;
    private String mUniqueName;
    private String mKeystoreID;
    private String mTruststoreID;
    private String mDSType = "";
    private HashMap mParamFields = new HashMap();
    private boolean mIsIdentityStore;
    private boolean mEnableMultipleServers = false;
    private MVDTopMultiServerGroupAbstract mTopMultiServerGroup = null;
    private Vector mConfiguredSyntaxCheck;
    private String mSyntaxCheckAddSetMethod;
    private String mSyntaxCheckModSetMethod;
    private boolean mEnableSyntaxCheck = false;
    private boolean mEnableSyntaxCheckAddSet = false;
    private boolean mEnableSyntaxCheckModSet = false;
    private Vector mTriggers = new Vector();

    public MVDTopMultiServerGroupAbstract getTopMultiServerGroup() {
        return this.mTopMultiServerGroup;
    }

    public int IID() {
        return this.mIID;
    }

    public boolean InitPerSessionDone() {
        return this.mInitPerSessionDone;
    }

    public HashMap EffectiveRequestAttrMapping() {
        return this.mEffectiveRequestAttrMapping;
    }

    public HashMap EffectiveRequestAttrScripts() {
        return this.mEffectiveRequestAttrScripts;
    }

    public HashMap EffectiveResponseAttrMapping() {
        return this.mEffectiveResponseAttrMapping;
    }

    public HashMap EffectiveResponseAttrMappingScripts() {
        return this.mEffectiveResponseAttrMappingScripts;
    }

    public HashMap EffectiveResponseAttrConstruct() {
        return this.mEffectiveResponseAttrConstruct;
    }

    public HashMap EffectiveResponseAttrConstructScripts() {
        return this.mEffectiveResponseAttrConstructScripts;
    }

    public HashMap EffectiveResponseAttrConstructIfExists() {
        return this.mEffectiveResponseAttrConstructIfExists;
    }

    public HashMap EffectiveResponseAttrDelete() {
        return this.mEffectiveResponseAttrDelete;
    }

    public String NiceName() {
        return this.mNiceName;
    }

    public String IpAddr() {
        return this.mIpAddr;
    }

    public boolean IsAllowed() {
        return this.mIsAllowed;
    }

    public boolean EditAttrIsRequired() {
        return this.mEditAttrIsRequired;
    }

    public String EditAttrMethod() {
        return this.mEditAttrMethod;
    }

    public String BindScript() {
        return this.mBindScript;
    }

    public String PreOpScript() {
        return this.mPreOpScript;
    }

    public String PostOpScript() {
        return this.mPostOpScript;
    }

    public String DSEScript() {
        return this.mDSEScript;
    }

    public String SearchScript() {
        return this.mSearchScript;
    }

    public String ModifyScript() {
        return this.mModifyScript;
    }

    public String AddScript() {
        return this.mAddScript;
    }

    public String DeleteScript() {
        return this.mDeleteScript;
    }

    public String CompareScript() {
        return this.mCompareScript;
    }

    public String AvailableScript() {
        return this.mAvailableScript;
    }

    public String IndexedScript() {
        return this.mIndexedScript;
    }

    public HashMap ConfiguredAvailableFieldsTypes() {
        return this.mConfiguredAvailableFieldsTypes;
    }

    public String ConfiguredAvailableFieldsKeys() {
        return this.mConfiguredAvailableFieldsKeys;
    }

    public String ConfiguredIndexedFieldsKeys() {
        return this.mConfiguredIndexedFieldsKeys;
    }

    public HashMap EffectiveIgnoredAttr() {
        return this.mEffectiveIgnoredAttr;
    }

    public HashMap EffectiveAvailableFieldsForFilter() {
        return this.mEffectiveAvailableFieldsForFilter;
    }

    public HashMap EffectiveAvailableFieldsForAttributes() {
        return this.mEffectiveAvailableFieldsForAttributes;
    }

    public HashMap EffectiveAvailableAndIgnoredAttr() {
        return this.mEffectiveAvailableAndIgnoredAttr;
    }

    public HashMap CaseSensitivityMap() {
        if (!this.mIsCaseSensitive) {
            return null;
        }
        return this.mSensitivityConversionMap;
    }

    public boolean ForbidNonIdxFilt() {
        return this.mForbidNonIdxFilt;
    }

    public boolean ForbidNonAvailFields() {
        return this.mForbidNonAvailFields;
    }

    public boolean IgnoreAttributes() {
        return this.mIgnoreAttributes;
    }

    public boolean EnableConvServer() {
        return this.mEnableConvServer;
    }

    public boolean EnableConvClient() {
        return this.mEnableConvClient;
    }

    public boolean EnableMultipleServers() {
        return this.mEnableMultipleServers;
    }

    public String DSType() {
        return this.mDSType;
    }

    public HashMap ParamFields() {
        return this.mParamFields;
    }

    public boolean IsIdentityStore() {
        return this.mIsIdentityStore;
    }

    public MVDOrderedHashMap ProvisionAttributes() {
        MVDOrderedHashMap h = new MVDOrderedHashMap();
        Iterator iter = this.mProvisionHashMapAttributes.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Attribute value = new Attribute((Attribute)this.mProvisionHashMapAttributes.get(key));
            h.put(key, value);
        }
        return h;
    }

    public MVDOrderedHashMap ProvisionEntries() {
        MVDOrderedHashMap map = new MVDOrderedHashMap();
        Iterator iter = this.mProvisionEntries.keySet().iterator();
        while (iter.hasNext()) {
            String srcName = (String)iter.next();
            AttributeSource srcCopy = new AttributeSource((AttributeSource)this.mProvisionEntries.get(srcName));
            map.put(srcName, srcCopy);
        }
        return map;
    }

    public boolean JoinEnabled() {
        return this.mJoinEnabled;
    }

    public MVDOrderedHashMap JoinAttributes() {
        MVDOrderedHashMap h = new MVDOrderedHashMap();
        Iterator iter = this.mJoinHashMapAttributes.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Attribute value = new Attribute((Attribute)this.mJoinHashMapAttributes.get(key));
            h.put(key, value);
        }
        return h;
    }

    public MVDOrderedHashMap JoinEntries() {
        MVDOrderedHashMap map = new MVDOrderedHashMap();
        Iterator iter = this.mJoinEntries.keySet().iterator();
        while (iter.hasNext()) {
            String srcName = (String)iter.next();
            AttributeSource srcCopy = new AttributeSource((AttributeSource)this.mJoinEntries.get(srcName));
            map.put(srcName, srcCopy);
        }
        return map;
    }

    public int JoinLimit() {
        return this.mJoinLimit;
    }

    public boolean JoinOnOperation(int operation) {
        return this.mJoinOnOperation[operation];
    }

    public String getUniqueName() {
        if (this.mUniqueName == null) {
            String tmp = this.mIID + this.mNiceName.replace(' ', '_');
            this.mUniqueName = tmp.length() <= 10 ? tmp : tmp.substring(0, 10);
        }
        return this.mUniqueName;
    }

    public String getKeystoreID() {
        return this.mKeystoreID;
    }

    public String getTruststoreID() {
        return this.mTruststoreID;
    }

    public void SetIID(int id) {
        this.mIID = id;
    }

    public void SetInitPerSessionDone(boolean b) {
        this.mInitPerSessionDone = b;
    }

    public void SetConfiguredInMapping(String s) {
        this.mConfiguredInMappingString = s;
    }

    private void CreateConfiguredInMapping(String s) throws MVDConfigException {
        this.mConfiguredRequestAttrMapping = new HashMap();
        this.mConfiguredRequestAttrScripts = new HashMap();
        if (s.length() > 0) {
            Vector sss = MVDUtil.splitString(s, ",");
            Enumeration e = sss.elements();
            while (e.hasMoreElements()) {
                String tempString = (String)e.nextElement();
                Vector kkk = MVDUtil.splitString(tempString, "::");
                if (this.mConfiguredRequestAttrMapping.put(((String)kkk.elementAt(0)).toLowerCase(), ((String)kkk.elementAt(1)).toLowerCase()) != null) {
                    throw new MVDConfigException("DataSource config, RequestAttrMapping: Identical hash");
                }
                if (kkk.size() <= 2 || (tempString = (String)kkk.elementAt(2)).equalsIgnoreCase("none") || this.mConfiguredRequestAttrScripts.put(((String)kkk.elementAt(1)).toLowerCase(), (String)kkk.elementAt(2)) == null) continue;
                throw new MVDConfigException("DataSource config, RequestAttrMapping: Identical hash");
            }
        }
    }

    public void SetConfiguredOutMapping(String s) {
        this.mConfiguredOutMappingString = s;
    }

    private void CreateConfiguredOutMapping(String s) throws MVDConfigException {
        this.mConfiguredResponseAttrMapping = new HashMap();
        this.mConfiguredResponseAttrMappingScripts = new HashMap();
        if (s.length() > 0) {
            Vector sss = MVDUtil.splitString(s, ",");
            Enumeration e = sss.elements();
            while (e.hasMoreElements()) {
                String tempString = (String)e.nextElement();
                Vector kkk = MVDUtil.splitString(tempString, "::");
                if (kkk.size() == 3) {
                    kkk.add("A");
                    kkk.add(0, "->");
                }
                if (this.mConfiguredResponseAttrMapping.put(((String)kkk.elementAt(1)).toLowerCase(), ((String)kkk.elementAt(2)).toLowerCase()) != null) {
                    throw new MVDConfigException("DataSource config, ResponseAttrMapping: Identical hash");
                }
                if (kkk.size() <= 2 || (tempString = (String)kkk.elementAt(3)).equalsIgnoreCase("none") || this.mConfiguredResponseAttrMappingScripts.put(((String)kkk.elementAt(2)).toLowerCase(), tempString) == null) continue;
                throw new MVDConfigException("DataSource config, ResponseAttrMapingScript: Identical hash");
            }
        }
    }

    public void SetConfiguredOutConstruct(String s) {
        this.mConfiguredOutConstructString = s;
    }

    private void CreateConfiguredOutConstruct(String s) throws MVDConfigException {
        this.mConfiguredResponseAttrConstruct = new HashMap();
        this.mConfiguredResponseAttrConstructScripts = new HashMap();
        this.mConfiguredResponseAttrConstructIfExists = new HashMap();
        if (s.length() > 0) {
            s = MVDUtil.replace(s, "\\,", "[COMMA]");
            Vector sss = MVDUtil.splitString(s, ",");
            Enumeration e = sss.elements();
            while (e.hasMoreElements()) {
                String tempString = (String)e.nextElement();
                tempString = MVDUtil.replace(tempString, "[COMMA]", ",");
                Vector kkk = MVDUtil.splitString(tempString, "::");
                String element1 = (String)kkk.elementAt(1);
                Vector multiv = MVDUtil.splitString(element1, "||");
                Iterator iter = multiv.iterator();
                while (iter.hasNext()) {
                    String el = (String)iter.next();
                    if (this.mConfiguredResponseAttrConstruct.put(el.toLowerCase(), ((String)kkk.elementAt(2)).toLowerCase()) == null) continue;
                    throw new MVDConfigException("DataSource config, ResponseAttrConstruct: Identical hash");
                }
                if (kkk.size() > 2 && !(tempString = (String)kkk.elementAt(3)).equalsIgnoreCase("none") && this.mConfiguredResponseAttrConstructScripts.put(((String)kkk.elementAt(2)).toLowerCase(), tempString) != null) {
                    throw new MVDConfigException("DataSource config, ResponseAttrConstructScript: Identical hash");
                }
                if (kkk.size() <= 3 || this.mConfiguredResponseAttrConstructIfExists.put(((String)kkk.elementAt(2)).toLowerCase(), (String)kkk.elementAt(4)) == null) continue;
                throw new MVDConfigException("DataSource config, ResponseAttrConstructScript: Identical hash");
            }
        }
    }

    public void SetConfiguredOutDelete(String s) {
        this.mConfiguredOutDeleteString = s;
    }

    private void CreateConfiguredOutDelete(String s) throws MVDConfigException {
        this.mConfiguredResponseAttrDelete = new HashMap();
        if (s.length() > 0) {
            Vector sss = MVDUtil.splitString(s, ",");
            Enumeration e = sss.elements();
            while (e.hasMoreElements()) {
                String tempString = (String)e.nextElement();
                Vector kkk = MVDUtil.splitString(tempString, "::");
                if (this.mConfiguredResponseAttrDelete.put(((String)kkk.elementAt(1)).toLowerCase(), "") == null) continue;
                throw new MVDConfigException("DataSource config, ResponseAttrConstruct: Identical hash");
            }
        }
    }

    public void SetNiceName(String s) {
        this.mNiceName = s;
    }

    public void SetIpAddr(String s) {
        this.mIpAddr = s;
    }

    public void SetIsAllowed(boolean b) {
        this.mIsAllowed = b;
    }

    public void SetEditAttrIsRequired(boolean b) {
        this.mEditAttrIsRequired = b;
    }

    public void SetEditAttrMethod(String s) {
        this.mEditAttrMethod = s;
    }

    public void SetDefaultStartingPoint(String s) {
        this.mDefaultStartingPoint = s;
    }

    public void SetDefaultDN(String s) {
        this.mDefaultDN = s;
    }

    public void SetDefaultDNFields(String s) {
        this.mDefaultDNFields = s;
    }

    public void SetDefaultBaseFilter(String s) {
        this.mDefaultBaseFilter = s;
    }

    public void SetDefaultAddHelper(String s) {
        this.mDefaultAddHelper = s;
    }

    public void SetDefaultParamFields() {
        if (this.mDefaultStartingPoint != null || this.mDSType.equalsIgnoreCase("LDAP")) {
            this.mParamFields.put("DS_REALSP", this.mDefaultStartingPoint != null ? this.mDefaultStartingPoint : "");
        }
        if (this.mDefaultDN != null && this.mDefaultDN.length() > 0) {
            this.mParamFields.put("DS_DN", this.mDefaultDN);
        }
        if (this.mDefaultDNFields != null && this.mDefaultDNFields.length() > 0) {
            this.mParamFields.put("DS_DNFIELDS", this.mDefaultDNFields);
        }
        if (this.mDefaultBaseFilter != null && this.mDefaultBaseFilter.length() > 0) {
            this.mParamFields.put("DS_BASEFILTER", this.mDefaultBaseFilter);
        }
        if (this.mDefaultAddHelper != null && this.mDefaultAddHelper.length() > 0) {
            this.mParamFields.put("DS_ADDHELPER", this.mDefaultAddHelper);
        }
    }

    private String getDefaultName(String aClassName) throws Exception {
        if (aClassName != null && aClassName.equalsIgnoreCase("Default")) {
            if (this.mDSType.equalsIgnoreCase("LDAP")) {
                return "MxLDAPConnector";
            }
            return "MxDBConnector";
        }
        throw new Exception("continue");
    }

    private void addExternal(String aClassName, Vector areLoaded) throws Exception {
        if (aClassName != null && !aClassName.equalsIgnoreCase("None") && !areLoaded.contains(aClassName)) {
            Globals.AddExternalClass(aClassName);
            areLoaded.add(aClassName);
        }
    }

    public void SetDefaultClasses() throws Exception {
        try {
            this.mPreOpScript = this.getDefaultName(this.mPreOpScript);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            this.mPostOpScript = this.getDefaultName(this.mPostOpScript);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            this.mSearchScript = this.getDefaultName(this.mSearchScript);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            this.mModifyScript = this.getDefaultName(this.mModifyScript);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            this.mAddScript = this.getDefaultName(this.mAddScript);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            this.mDeleteScript = this.getDefaultName(this.mDeleteScript);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            this.mCompareScript = this.getDefaultName(this.mCompareScript);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        Vector isLoaded = new Vector();
        this.addExternal(this.mPreOpScript, isLoaded);
        this.addExternal(this.mPostOpScript, isLoaded);
        this.addExternal(this.mSearchScript, isLoaded);
        this.addExternal(this.mModifyScript, isLoaded);
        this.addExternal(this.mAddScript, isLoaded);
        this.addExternal(this.mDeleteScript, isLoaded);
        this.addExternal(this.mCompareScript, isLoaded);
    }

    public void SetBindScript(String s) {
        this.mBindScript = s;
    }

    public void SetPreOpScript(String s) {
        this.mPreOpScript = s;
    }

    public void SetPostOpScript(String s) {
        this.mPostOpScript = s;
    }

    public void SetDSEScript(String s) {
        this.mDSEScript = s;
    }

    public void SetSearchScript(String s) {
        this.mSearchScript = s;
    }

    public void SetModifyScript(String s) {
        this.mModifyScript = s;
    }

    public void SetAddScript(String s) {
        this.mAddScript = s;
    }

    public void SetDeleteScript(String s) {
        this.mDeleteScript = s;
    }

    public void SetCompareScript(String s) {
        this.mCompareScript = s;
    }

    public void SetAvailableScript(String s) {
        this.mAvailableScript = s;
    }

    public void SetIndexedScript(String s) {
        this.mIndexedScript = s;
    }

    public void SetConfiguredIgnoredAttr(String s) throws MVDConfigException {
        this.mConfiguredIgnoredAttr = new HashMap();
        if (s.length() > 0) {
            Vector sss = MVDUtil.splitString(s, ",");
            Enumeration e = sss.elements();
            while (e.hasMoreElements()) {
                String tempString = (String)e.nextElement();
                if (this.mConfiguredIgnoredAttr.put(tempString.toLowerCase(), "") == null) continue;
                throw new MVDConfigException("DataSource config, Ignored attr: Identical hash");
            }
        }
    }

    public boolean IsCaseSensitive() {
        return this.mIsCaseSensitive;
    }

    public void SetIsCaseSensitive(boolean b) {
        this.mIsCaseSensitive = b;
    }

    public void SetConfiguredAvailableFields(String s) throws MVDConfigException {
        this.mConfiguredAvailableFields = new HashMap();
        this.mConfiguredAvailableFieldsTypes = new HashMap();
        this.mSensitivityConversionMap = new HashMap();
        if (s.length() > 0) {
            Vector sss = MVDUtil.splitString(s, ",");
            Enumeration e = sss.elements();
            while (e.hasMoreElements()) {
                String tempString = (String)e.nextElement();
                int tix = tempString.indexOf(":");
                if (tix >= 0) {
                    String temptype = tempString.substring(tix + 1);
                    tempString = tempString.substring(0, tix);
                    this.mConfiguredAvailableFieldsTypes.put(tempString.toLowerCase(), temptype);
                } else {
                    this.mConfiguredAvailableFieldsTypes.put(tempString.toLowerCase(), "0");
                }
                if (this.mConfiguredAvailableFields.put(tempString.toLowerCase(), tempString) != null) {
                    throw new MVDConfigException("DataSource config, Available fields: Identical hash");
                }
                this.mSensitivityConversionMap.put(tempString.toLowerCase(), tempString);
            }
        }
        this.mConfiguredAvailableFieldsKeys = this.mConfiguredAvailableFields.values().toString();
    }

    public void SetConfiguredIndexedFields(String s) throws MVDConfigException {
        this.mConfiguredIndexedFields = new HashMap();
        if (s.length() > 0) {
            Vector sss = MVDUtil.splitString(s, ",");
            Enumeration e = sss.elements();
            while (e.hasMoreElements()) {
                String tempString = (String)e.nextElement();
                if (this.mConfiguredIndexedFields.put(tempString.toLowerCase(), tempString) == null) continue;
                throw new MVDConfigException("DataSource config, Indexed fields: Identical hash");
            }
        }
        this.mConfiguredIndexedFieldsKeys = this.mConfiguredIndexedFields.keySet().toString();
    }

    public void SetForbidNonIdxFilt(boolean b) {
        this.mForbidNonIdxFilt = b;
    }

    public void SetForbidNonAvailFields(boolean b) {
        this.mForbidNonAvailFields = b;
    }

    public void SetIgnoreAttributes(boolean b) {
        this.mIgnoreAttributes = b;
    }

    public void SetEnableConvServer(boolean b) {
        this.mEnableConvServer = b;
    }

    public void SetEnableConvClient(boolean b) {
        this.mEnableConvClient = b;
    }

    public void SetEnableMultipleServers(boolean b) {
        this.mEnableMultipleServers = b;
    }

    public void SetDSType(String s) {
        this.mDSType = s;
    }

    public void SetParamFields(String s) throws MVDConfigException {
        Vector<String> doNotLowerCase = new Vector<String>();
        doNotLowerCase.add("SCOPE");
        doNotLowerCase.add("DATABASE");
        doNotLowerCase.add("USER");
        doNotLowerCase.add("PASSWORD");
        doNotLowerCase.add("URL");
        doNotLowerCase.add("SCHEMA");
        doNotLowerCase.add("FAILOVER_LIST");
        this.mParamFields = new HashMap();
        if (s.length() > 0) {
            Vector kkk;
            String tempString;
            Vector sss = MVDUtil.splitString(s, "[&&]");
            Enumeration e = sss.elements();
            while (e.hasMoreElements()) {
                Iterator iter;
                tempString = (String)e.nextElement();
                kkk = MVDUtil.splitString(tempString, "[$]");
                String keyname = (String)kkk.elementAt(0);
                if (!keyname.equalsIgnoreCase("CASE_SENSITIVE")) continue;
                String listOfCaseSensAttrs = (String)kkk.elementAt(1);
                if (listOfCaseSensAttrs.equalsIgnoreCase("ALL")) {
                    Vector tmpSSS = MVDUtil.splitString(s, "[&&]");
                    iter = tmpSSS.iterator();
                    while (iter.hasNext()) {
                        String tmpKeyValPair = ((String)iter.next()).trim();
                        Vector tmpKKK = MVDUtil.splitString(tmpKeyValPair, "[$]");
                        doNotLowerCase.add((String)tmpKKK.elementAt(0));
                    }
                    continue;
                }
                Vector attrs = MVDUtil.splitString(listOfCaseSensAttrs, ',');
                iter = attrs.iterator();
                while (iter.hasNext()) {
                    String attrname = (String)iter.next();
                    doNotLowerCase.add(attrname.toUpperCase());
                }
            }
            e = sss.elements();
            while (e.hasMoreElements()) {
                tempString = (String)e.nextElement();
                kkk = MVDUtil.splitString(tempString, "[$]");
                String prot = null;
                prot = (String)kkk.elementAt(1);
                prot = MVDUtilities.masterDcString(prot);
                if (!(doNotLowerCase.contains((String)kkk.elementAt(0)) ? this.mParamFields.put("DS_" + kkk.elementAt(0), prot) != null : this.mParamFields.put("DS_" + kkk.elementAt(0), prot.toLowerCase()) != null)) continue;
                throw new MVDConfigException("DataSource config, Param fields: Identical hash");
            }
            String isIdS = (String)this.mParamFields.get("DS_IS_IDS");
            this.mIsIdentityStore = isIdS != null && isIdS.equalsIgnoreCase("true");
        }
    }

    public void SetEffectiveValues() throws MVDConfigException {
        String secprot;
        if (this.mEnableConvClient && this.mConfiguredInMappingString != null) {
            this.CreateConfiguredInMapping(this.mConfiguredInMappingString);
        }
        if (this.mEnableConvServer) {
            if (this.mConfiguredOutMappingString != null) {
                this.CreateConfiguredOutMapping(this.mConfiguredOutMappingString);
            }
            if (this.mConfiguredOutConstructString != null) {
                this.CreateConfiguredOutConstruct(this.mConfiguredOutConstructString);
            }
            if (this.mConfiguredOutDeleteString != null) {
                this.CreateConfiguredOutDelete(this.mConfiguredOutDeleteString);
            }
        }
        if (!this.mForbidNonAvailFields) {
            this.mEffectiveAvailableFieldsForFilter = null;
            this.mEffectiveAvailableFieldsForAttributes = null;
            this.mEffectiveAvailableAndIgnoredAttr = null;
        } else {
            this.mEffectiveAvailableFieldsForFilter = this.mConfiguredAvailableFields;
            this.mEffectiveAvailableFieldsForAttributes = this.mConfiguredAvailableFields;
            if (this.mConfiguredAvailableFields != null) {
                this.mEffectiveAvailableAndIgnoredAttr = new HashMap(this.mConfiguredAvailableFields);
            }
        }
        if (this.mForbidNonIdxFilt) {
            this.mEffectiveAvailableFieldsForFilter = this.mConfiguredIndexedFields;
        }
        if (!this.mIgnoreAttributes) {
            this.mEffectiveIgnoredAttr = null;
        } else {
            this.mEffectiveIgnoredAttr = this.mConfiguredIgnoredAttr;
            if (this.mEffectiveAvailableAndIgnoredAttr != null) {
                this.mEffectiveAvailableAndIgnoredAttr.putAll(this.mConfiguredIgnoredAttr);
            }
        }
        if (!this.mEnableConvClient) {
            this.mEffectiveRequestAttrMapping = null;
            this.mEffectiveRequestAttrScripts = null;
        } else {
            this.mEffectiveRequestAttrMapping = this.mConfiguredRequestAttrMapping;
            this.mEffectiveRequestAttrScripts = this.mConfiguredRequestAttrScripts;
        }
        if (!this.mEnableConvServer) {
            this.mEffectiveResponseAttrMapping = null;
            this.mEffectiveResponseAttrMappingScripts = null;
            this.mEditAttrIsRequired = false;
            this.mEffectiveResponseAttrConstruct = null;
            this.mEffectiveResponseAttrConstructScripts = null;
            this.mEffectiveResponseAttrConstructIfExists = null;
            this.mEffectiveResponseAttrDelete = null;
        } else {
            this.mEffectiveResponseAttrMapping = this.mConfiguredResponseAttrMapping;
            this.mEffectiveResponseAttrMappingScripts = this.mConfiguredResponseAttrMappingScripts;
            this.mEffectiveResponseAttrConstruct = this.mConfiguredResponseAttrConstruct;
            this.mEffectiveResponseAttrConstructScripts = this.mConfiguredResponseAttrConstructScripts;
            this.mEffectiveResponseAttrConstructIfExists = this.mConfiguredResponseAttrConstructIfExists;
            this.mEffectiveResponseAttrDelete = this.mConfiguredResponseAttrDelete;
        }
        this.checkForMultServers();
        if (this.mDSType != null && this.mDSType.equalsIgnoreCase("LDAP") && (secprot = (String)this.mParamFields.get("DS_SECPROT")) != null && secprot.equalsIgnoreCase("ssl")) {
            MxJNDISocketFactory.initializeSocketFactory((String)this.mParamFields.get("DS_SERVER"), (String)this.mParamFields.get("DS_PORT"), this.mKeystoreID, this.mTruststoreID);
            String failover = (String)this.mParamFields.get("DS_FAILOVER_GROUP");
            if (failover != null && failover.length() > 0) {
                Vector MultiServerGrouplist = MVDUtil.splitString(failover, ";");
                for (int xi = 0; xi < MultiServerGrouplist.size(); ++xi) {
                    Vector MultiServerGroup;
                    String MultiServerGroupConfig = (String)MultiServerGrouplist.elementAt(xi);
                    int exix = MultiServerGroupConfig.indexOf("!");
                    if (exix >= 0) {
                        MultiServerGroupConfig = MultiServerGroupConfig.substring(0, exix);
                    }
                    if ((MultiServerGroup = MVDUtil.splitString(MultiServerGroupConfig, ":")).size() >= 2) {
                        MxJNDISocketFactory.initializeSocketFactory((String)MultiServerGroup.elementAt(0), (String)MultiServerGroup.elementAt(1), this.mKeystoreID, this.mTruststoreID);
                        continue;
                    }
                    if (MultiServerGroup.size() != 1) continue;
                    MxJNDISocketFactory.initializeSocketFactory((String)MultiServerGroup.elementAt(0), (String)this.mParamFields.get("DS_PORT"), this.mKeystoreID, this.mTruststoreID);
                }
            }
        }
    }

    public void expandMVDGlobals() {
        HashMap globals = MVDProxy.MVDGlobals();
        Set globalkeys = globals.keySet();
        HashMap<String, String> globalkeymapping = new HashMap<String, String>();
        Iterator<Object> iter = globalkeys.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            globalkeymapping.put(key.toUpperCase(), key);
        }
        if (this.mParamFields == null) {
            return;
        }
        iter = this.mParamFields.entrySet().iterator();
        while (iter.hasNext()) {
            String value;
            Map.Entry element = (Map.Entry)iter.next();
            String newValue = value = (String)element.getValue();
            Vector v = MVDUtil.splitString(value, "%");
            Vector newV = new Vector();
            int lastindex = -1;
            for (int i = 0; i < v.size(); ++i) {
                String isThisConst = (String)v.elementAt(i);
                if (isThisConst.startsWith("$const.")) {
                    int start = "$const.".length();
                    int stop = isThisConst.length();
                    String varname = isThisConst.substring(start, stop);
                    isThisConst = (String)globals.get("GLOBAL_" + varname);
                    if (isThisConst == null) {
                        String key = (String)globalkeymapping.get("GLOBAL_" + varname.toUpperCase());
                        if (key != null) {
                            isThisConst = (String)globals.get(key);
                        }
                        if (isThisConst == null) {
                            MVDLogger.Log("Expanding " + varname + " FAILED", 6);
                            newV.add(v.elementAt(i));
                            continue;
                        }
                        isThisConst = MVDMic_Util.dcString((String)isThisConst);
                    } else {
                        isThisConst = MVDMic_Util.dcString((String)isThisConst);
                    }
                    if (lastindex < 0) {
                        MVDLogger.Log("Encountered $const. (" + isThisConst + ")in DS Additional Parameters. Was that the intention?", 6);
                        newV.add(isThisConst);
                        ++lastindex;
                        continue;
                    }
                    if (v.size() <= i + 1) {
                        MVDLogger.Log("Constant not properly terminated: " + varname, 6);
                    }
                    String tmp = (String)newV.elementAt(lastindex);
                    String tmp2 = (String)v.elementAt(++i);
                    tmp = tmp + isThisConst + tmp2;
                    newV.set(lastindex, tmp);
                    continue;
                }
                ++lastindex;
                newV.add(isThisConst);
            }
            newValue = MVDUtil.joinStrings(newV, "%");
            if (newValue.equalsIgnoreCase(value)) continue;
            element.setValue(newValue);
        }
    }

    private AttributeSource addToAttributeSource(String sourcename, HashMap allSources, Attribute aAttr) throws MVDConfigException {
        AttributeSource source = (AttributeSource)this.mProvisionEntries.get(sourcename.toLowerCase());
        if (sourcename.startsWith("\"") || sourcename.startsWith("$req") || sourcename.startsWith("$dn")) {
            if (source == null) {
                String newsourcename = MVDUtil.replace(sourcename, "\"", "");
                source = new AttributeSource(newsourcename);
                this.mProvisionEntries.put(sourcename.toLowerCase(), source);
            }
            source.addAttribute(aAttr.getName().toLowerCase());
            aAttr.addSource(sourcename.toLowerCase());
        } else {
            if (source == null) {
                int attrsrcid;
                try {
                    attrsrcid = Integer.parseInt(sourcename);
                }
                catch (NumberFormatException e) {
                    throw new MVDConfigException("Attribute source misconfigured " + sourcename + " is not a valid ID");
                }
                MVDAttributeSource tmp = MVDAttributeSourceList.getAttributeSourceByID(attrsrcid);
                if (tmp == null) {
                    MVDLogger.Log("Attribute source not found", 7);
                    throw new MVDConfigException("Attribute source not found " + sourcename);
                }
                source = new AttributeSource(tmp);
                this.mProvisionEntries.put(sourcename.toLowerCase(), source);
            }
            source.addAttribute(aAttr.getName().toLowerCase());
            aAttr.addSource(sourcename.toLowerCase());
        }
        return source;
    }

    public void setJoinEnabled(boolean aVal) {
        this.mJoinEnabled = aVal;
    }

    public void setJoinLimit(int aVal) {
        this.mJoinLimit = aVal;
    }

    public void setJoinOnOperation(String strVal) {
        this.mJoinOnOperation = new boolean[3];
        Vector v = MVDUtil.splitString(strVal, ",");
        Iterator iter = v.iterator();
        while (iter.hasNext()) {
            String op = (String)iter.next();
            if (op.equalsIgnoreCase("base")) {
                this.mJoinOnOperation[0] = true;
                continue;
            }
            if (op.equalsIgnoreCase("one")) {
                this.mJoinOnOperation[1] = true;
                continue;
            }
            if (!op.equalsIgnoreCase("sub")) continue;
            this.mJoinOnOperation[2] = true;
        }
    }

    public void setJoinAttributeEntries(String prov) throws MVDConfigException {
        this.mJoinEntries = new MVDOrderedHashMap();
        this.mJoinHashMapAttributes = new MVDOrderedHashMap();
        Vector provrows = MVDUtil.splitString(prov.toLowerCase(), ";");
        HashMap allSources = new HashMap();
        Iterator iter = provrows.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            Vector split = MVDUtil.splitString(element, "::");
            if (split.size() != 6) {
                throw new MVDConfigException("Wrong number of values in datasource.join");
            }
            boolean enabled = Boolean.valueOf((String)split.elementAt(0));
            if (!enabled) continue;
            String attrname = (String)split.elementAt(1);
            String operation = (String)split.elementAt(2);
            boolean mandatory = Boolean.valueOf((String)split.elementAt(3));
            String sources = (String)split.elementAt(4);
            Vector sourcesAsVector = MVDUtil.splitString(sources, ",");
            boolean single = ((String)split.elementAt(5)).equalsIgnoreCase("S");
            Attribute attr = new Attribute(operation, attrname, single, mandatory);
            Iterator iterator = sourcesAsVector.iterator();
            while (iterator.hasNext()) {
                String s = (String)iterator.next();
                this.addToJoinAttributeSource(s, allSources, attr);
            }
            this.mJoinHashMapAttributes.put(attr.getName().toLowerCase(), attr);
        }
    }

    private AttributeSource addToJoinAttributeSource(String sourcename, HashMap allSources, Attribute aAttr) throws MVDConfigException {
        AttributeSource source = (AttributeSource)this.mJoinEntries.get(sourcename.toLowerCase());
        if (sourcename.startsWith("\"") || sourcename.startsWith("$req") || sourcename.startsWith("$dn")) {
            if (source == null) {
                String newsourcename = MVDUtil.replace(sourcename, "\"", "");
                source = new AttributeSource(newsourcename);
                this.mJoinEntries.put(sourcename.toLowerCase(), source);
            }
            source.addAttribute(aAttr.getName().toLowerCase());
            aAttr.addSource(sourcename.toLowerCase());
        } else {
            if (source == null) {
                int attrsrcid;
                try {
                    attrsrcid = Integer.parseInt(sourcename);
                }
                catch (NumberFormatException e) {
                    throw new MVDConfigException("Attribute source misconfigured " + sourcename + " is not a valid ID");
                }
                MVDAttributeSource tmp = MVDAttributeSourceList.getAttributeSourceByID(attrsrcid);
                if (tmp == null) {
                    MVDLogger.Log("Attribute source not found", 7);
                    throw new MVDConfigException("Attribute source not found " + sourcename);
                }
                source = new AttributeSource(tmp);
                this.mJoinEntries.put(sourcename.toLowerCase(), source);
            }
            source.addAttribute(aAttr.getName().toLowerCase());
            aAttr.addSource(sourcename.toLowerCase());
        }
        return source;
    }

    public void setEnableSyntaxCheck(boolean aEnabled) {
        this.mEnableSyntaxCheck = aEnabled;
    }

    public void setSyntaxCheck(String aConfiguration) {
        this.mConfiguredSyntaxCheck = new Vector();
        Vector lines = MVDUtil.splitString(aConfiguration, "[&&]");
        Iterator iter = lines.iterator();
        while (iter.hasNext()) {
            String line = (String)iter.next();
            Vector columns = MVDUtil.splitString(line, "[$]");
            String attrname = (String)columns.elementAt(0);
            String tmp = (String)columns.elementAt(1);
            boolean returnmode = Boolean.valueOf(tmp);
            String method = (String)columns.elementAt(2);
            String params = (String)columns.elementAt(3);
            Vector v = MVDUtil.splitString(params, ',');
            String[] paramsarray = new String[v.size()];
            paramsarray = v.toArray(paramsarray);
            SyntaxMethod obj = new SyntaxMethod(attrname, returnmode, method, paramsarray);
            this.mConfiguredSyntaxCheck.add(obj);
        }
    }

    public void setSyntaxCheckAddSetMethod(String aMethodName) {
        this.mSyntaxCheckAddSetMethod = aMethodName;
    }

    public void setSyntaxCheckModSetMethod(String aMethodName) {
        this.mSyntaxCheckModSetMethod = aMethodName;
    }

    public void setEnableSyntaxCheckAddSet(boolean aEnabled) {
        this.mEnableSyntaxCheckAddSet = aEnabled;
    }

    public void setEnableSyntaxCheckModSet(boolean aEnabled) {
        this.mEnableSyntaxCheckModSet = aEnabled;
    }

    public void setUniqueName(String aName) {
        this.mUniqueName = aName;
    }

    public void setKeystoreID(String aKeystoreID) {
        this.mKeystoreID = aKeystoreID;
    }

    public void setTruststoreID(String aTruststoreID) {
        this.mTruststoreID = aTruststoreID;
    }

    public Vector getConfiguredSyntaxCheck() {
        if (this.mEnableSyntaxCheck) {
            return this.mConfiguredSyntaxCheck;
        }
        return null;
    }

    public String getSyntaxCheckAddSetMethod() {
        if (!this.mEnableSyntaxCheck || !this.mEnableSyntaxCheckAddSet || this.mSyntaxCheckAddSetMethod == null || this.mSyntaxCheckAddSetMethod.equalsIgnoreCase("None")) {
            return "";
        }
        return this.mSyntaxCheckAddSetMethod;
    }

    public String getSyntaxCheckModSetMethod() {
        if (!this.mEnableSyntaxCheckModSet || this.mSyntaxCheckModSetMethod == null || this.mSyntaxCheckModSetMethod.equalsIgnoreCase("None")) {
            return "";
        }
        return this.mSyntaxCheckModSetMethod;
    }

    public void addTrigger(EventTriggerConfig aTrigger) {
        this.mTriggers.add(aTrigger);
    }

    public Vector getTriggers() {
        return this.mTriggers;
    }

    private void checkForMultServers() {
        String loadbalancinggroup;
        MVDTopMultiServerGroup xxx;
        String failovergroup = (String)this.mParamFields.get("DS_FAILOVER_GROUPNAME");
        if (failovergroup != null && failovergroup.length() > 0) {
            MVDTopMultiServerGroup xxx2 = MVDTopMultiServerGroupList.getTopMultiServerGroupByName(failovergroup);
            this.mTopMultiServerGroup = new MVDTopFailover(xxx2);
            if (this.mTopMultiServerGroup != null) {
                this.SetEnableMultipleServers(true);
                return;
            }
        } else {
            String failoverdefinition = (String)this.mParamFields.get("DS_FAILOVER_GROUP");
            if (failoverdefinition != null && failoverdefinition.length() > 0) {
                try {
                    xxx = new MVDTopMultiServerGroup(failoverdefinition);
                    this.mTopMultiServerGroup = new MVDTopFailover(xxx);
                    if (this.mTopMultiServerGroup != null) {
                        this.SetEnableMultipleServers(true);
                        return;
                    }
                }
                catch (Exception e) {
                    MVDLogger.Log("Could not create a proper multi server definition;" + e, 7);
                }
            }
        }
        if ((loadbalancinggroup = (String)this.mParamFields.get("DS_LOADBALANCING_GROUP")) != null && loadbalancinggroup.length() > 0) {
            try {
                xxx = new MVDTopMultiServerGroup(loadbalancinggroup);
                this.mTopMultiServerGroup = new MVDTopLoadBalancing(xxx);
                if (this.mTopMultiServerGroup != null) {
                    this.SetEnableMultipleServers(true);
                    return;
                }
            }
            catch (Exception e) {
                MVDLogger.Log("Could not create a proper multi server definition;" + e, 7);
            }
        }
    }
}

