/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.Globals;
import com.sap.idm.vds.MVDDebitInfo;
import com.sap.idm.vds.MVDError;
import com.sap.idm.vds.MVDGlobals;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDServer;
import com.sap.idm.vds.MVDSnmpSettings;
import com.sap.idm.vds.MVDStatistics;
import com.sap.idm.vds.config.Config;
import com.sap.idm.vds.config.EventTriggerList;
import com.sap.idm.vds.config.FailoverGroupList;
import com.sap.idm.vds.config.LoadBalancingGroupList;
import com.sap.idm.vds.config.LogConfig;
import com.sap.idm.vds.config.MVDAcl;
import com.sap.idm.vds.config.MVDAttributeSourceList;
import com.sap.idm.vds.config.MVDCacheList;
import com.sap.idm.vds.config.MVDDataSourceList;
import com.sap.idm.vds.config.MVDDataSourceSequentialGroupList;
import com.sap.idm.vds.config.MVDDynamicAddGroupList;
import com.sap.idm.vds.config.MVDForestList;
import com.sap.idm.vds.config.MVDJoinGroupList;
import com.sap.idm.vds.config.MVDKeyStoreList;
import com.sap.idm.vds.config.MVDLDAPDeployment;
import com.sap.idm.vds.config.MVDLDAPDeploymentList;
import com.sap.idm.vds.config.MVDPriorityObject;
import com.sap.idm.vds.config.MVDProvisioningList;
import com.sap.idm.vds.config.MVDProxy;
import com.sap.idm.vds.config.MVDProxyLoggerDebitList;
import com.sap.idm.vds.config.MVDRulesList;
import com.sap.idm.vds.config.MVDSourceList;
import com.sap.idm.vds.config.MVDTopMultiServerGroupList;
import com.sap.idm.vds.config.MVDUserGroupList;
import com.sap.idm.vds.config.MVDUserList;
import com.sap.idm.vds.config.MVDWSDeployment;
import com.sap.idm.vds.config.MVDWSDeploymentList;
import com.sap.idm.vds.queue.MVDPriorityQueue;
import com.sap.idm.vds.util.ConfigUtil;
import java.util.Iterator;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MVDConfig {
    private String mVersion = "1.0";

    public MVDConfig(Config config, String aUniqueID) throws Exception {
        Document doc = config.getDoc();
        try {
            String aLoggerKey;
            Object dep;
            String lid;
            Node parent;
            boolean mvdMode = false;
            new MVDProxy();
            NodeList nl = doc.getElementsByTagName("Proxy");
            Node node = nl.item(0);
            MVDProxyLoggerDebitList.loadStartUpParameters(node);
            if (aUniqueID == null || aUniqueID.length() == 0) {
                config.setUniqueInstanceID("null");
            } else if (aUniqueID.equals("USE_PORT")) {
                String aPort = MVDProxyLoggerDebitList.getPort();
                config.setUniqueInstanceID(aPort);
                mvdMode = true;
            } else {
                config.setUniqueInstanceID(aUniqueID);
            }
            Globals.initReload();
            nl = doc.getElementsByTagName("MVDConfig");
            node = nl.item(0);
            NamedNodeMap attrMap = node.getAttributes();
            Node oneAttrNode = attrMap.getNamedItem("Version");
            if (oneAttrNode != null) {
                this.mVersion = oneAttrNode.getNodeValue();
            }
            String operationaAttributes = MVDGlobals.getGlobalParameter("GLOBAL_OPERATIONAL_ATTRIBUTES", "");
            Globals.setOperationalAttributes(operationaAttributes);
            String extendedCacheAttributes = MVDGlobals.getGlobalParameter("GLOBAL_EXTENDED_CACHE_ATTRIBUTES", "");
            if (extendedCacheAttributes.length() != 0) {
                Globals.setOperationalAttributes(extendedCacheAttributes);
            }
            if ((parent = node.getParentNode()) == doc) {
                MVDGlobals.setOperationMode(0);
                nl = ((Element)node).getElementsByTagName("Logging");
                node = nl.item(0);
            } else if (mvdMode) {
                MVDGlobals.setOperationMode(2);
                nl = doc.getElementsByTagName("Logging");
                node = nl.item(0);
            } else {
                MVDGlobals.setOperationMode(1);
                nl = doc.getElementsByTagName("Logging");
                node = nl.item(0);
            }
            Vector<String> loggerKeys = new Vector<String>();
            loggerKeys.add(MVDGlobals.getMainGroupName());
            loggerKeys.add("Web Service:" + config.getUniqueInstanceID());
            LogConfig.readLogConfig(node, loggerKeys);
            loggerKeys.clear();
            nl = doc.getElementsByTagName("KeyStores");
            node = nl.item(0);
            MVDKeyStoreList.loadConfig(node);
            nl = doc.getElementsByTagName("Proxy");
            node = nl.item(0);
            MVDProxyLoggerDebitList.loadConfig(node, false);
            MVDLogger.Log("Reading LDAP Deployments configuration", 2);
            nl = doc.getElementsByTagName("LDAPDeployments");
            node = nl.item(0);
            MVDLDAPDeploymentList.loadConfig(node);
            Iterator iter = MVDLDAPDeploymentList.getLDAPDeployments().keySet().iterator();
            while (iter.hasNext()) {
                lid = (String)iter.next();
                dep = (MVDLDAPDeployment)MVDLDAPDeploymentList.getLDAPDeployments().get(lid);
                aLoggerKey = "LDAP Sessions:" + ((MVDLDAPDeployment)dep).getName() + "_" + ((MVDLDAPDeployment)dep).getPortNumber();
                loggerKeys.add(aLoggerKey);
            }
            LogConfig.addLoggers(loggerKeys);
            loggerKeys.clear();
            MVDLogger.Log("Reading WS Deployments configuration", 2);
            nl = doc.getElementsByTagName("WSDeployments");
            node = nl.item(0);
            MVDWSDeploymentList.loadConfig(node);
            iter = MVDWSDeploymentList.getWsDeployments().keySet().iterator();
            while (iter.hasNext()) {
                lid = (String)iter.next();
                dep = (MVDWSDeployment)MVDWSDeploymentList.getWsDeployments().get(lid);
                aLoggerKey = "Web Service:" + ((MVDWSDeployment)dep).getApplicationName();
                loggerKeys.add(aLoggerKey);
            }
            LogConfig.addLoggers(loggerKeys);
            MVDLogger.Log("<<<<  Virtual Directory Server starts  >>>>", 4);
            MVDServer.logVersions();
            MVDLogger.Log("Reading cache configuration", 2);
            nl = doc.getElementsByTagName("Cache");
            node = nl.item(0);
            if (node != null) {
                MVDCacheList.loadConfig(node);
            }
            MVDLogger.Log("Reading request queue configuration", 2);
            nl = doc.getElementsByTagName("RequestQueue");
            node = nl.item(0);
            if (node != null) {
                MVDPriorityObject.FillQueueDef(node);
            }
            MVDLogger.Log("Reading rules configuration", 2);
            nl = doc.getElementsByTagName("Rules");
            node = nl.item(0);
            MVDRulesList.loadConfig(node);
            MVDLogger.Log("Reading attribute source configuration", 2);
            MVDAttributeSourceList.initReload();
            nl = doc.getElementsByTagName("AttributeSources");
            for (int i = 0; i < nl.getLength(); ++i) {
                node = nl.item(i);
                MVDAttributeSourceList.loadConfig(node);
            }
            MVDAttributeSourceList.applyChanges();
            MVDLogger.Log("Reading forest configuration", 2);
            nl = doc.getElementsByTagName("Forest");
            node = nl.item(0);
            MVDForestList.loadConfig(node);
            MVDLogger.Log("Reading user group configuration", 2);
            nl = doc.getElementsByTagName("UserGroups");
            node = nl.item(0);
            MVDUserGroupList.loadConfig(node);
            MVDLogger.Log("Reading users configuration", 2);
            nl = doc.getElementsByTagName("Users");
            node = nl.item(0);
            MVDUserList.loadConfig(node);
            MVDLogger.Log("Reading multi server groups configuration", 2);
            nl = doc.getElementsByTagName("MultiServerGroups");
            if (nl.getLength() > 0) {
                node = nl.item(0);
                MVDTopMultiServerGroupList.loadConfig(node);
            }
            MVDLogger.Log("Reading data source configuration", 2);
            nl = doc.getElementsByTagName("DataSources");
            node = nl.item(0);
            MVDDataSourceList.loadConfig(node);
            if (this.mVersion.equalsIgnoreCase("1.5") || this.mVersion.equalsIgnoreCase("8.2") || this.mVersion.equalsIgnoreCase("8.3") || this.mVersion.equalsIgnoreCase("8.4")) {
                MVDLogger.Log("Reading unlinked data source group configuration", 2);
                nl = doc.getElementsByTagName("UnlinkedDataSourceGroups");
                node = nl.item(0);
                if (node != null) {
                    MVDDataSourceSequentialGroupList.loadConfig(node);
                }
                MVDLogger.Log("Reading provisioning data source group configuration", 2);
                nl = doc.getElementsByTagName("ProvisioningGroups");
                if (nl != null && nl.getLength() > 0) {
                    node = nl.item(0);
                    MVDProvisioningList.loadConfig(node);
                }
                MVDLogger.Log("Reading join data source group configuration", 2);
                nl = doc.getElementsByTagName("JoinGroups");
                if (nl != null && nl.getLength() > 0) {
                    node = nl.item(0);
                    MVDJoinGroupList.loadConfig(node);
                }
                MVDLogger.Log("Reading dynamic add data source group configuration", 2);
                nl = doc.getElementsByTagName("DynamicAddGroups");
                if (nl != null && nl.getLength() > 0) {
                    node = nl.item(0);
                    MVDDynamicAddGroupList.loadConfig(node);
                }
                MVDLogger.Log("Reading load balancing data source group configuration", 2);
                nl = doc.getElementsByTagName("LoadBalancingGroups");
                if (nl != null && nl.getLength() > 0) {
                    node = nl.item(0);
                    LoadBalancingGroupList.loadConfig(node);
                }
                MVDLogger.Log("Reading failover data source group configuration", 2);
                nl = doc.getElementsByTagName("FailoverGroups");
                if (nl != null && nl.getLength() > 0) {
                    node = nl.item(0);
                    FailoverGroupList.loadConfig(node);
                }
            } else {
                MVDError.ConfigError("The version of this configuration is too old. Please open in n the GUI first.");
            }
            MVDLogger.Log("Reading event trigger configuration", 2);
            nl = doc.getElementsByTagName("EventTriggers");
            if (nl != null && nl.getLength() > 0) {
                node = nl.item(0);
                EventTriggerList.readEventTriggers(node);
            }
            nl = doc.getElementsByTagName("ACLs");
            node = nl.item(0);
            MVDAcl.loadConfig(node);
            MVDDataSourceList.createInternalTree();
            MVDDataSourceSequentialGroupList.createInternalTree();
            MVDProvisioningList.createInternalTree();
            MVDJoinGroupList.createInternalTree();
            MVDDynamicAddGroupList.createInternalTree();
            LoadBalancingGroupList.createInternalTree();
            FailoverGroupList.createInternalTree();
            MVDSourceList.connectSourcesToInternalTree();
            if (MVDSnmpSettings.EnableSnmpTraps()) {
                MVDLogger.initSNMP(MVDSnmpSettings.SnmpServer(), MVDSnmpSettings.SnmpPort());
            }
            MVDAttributeSourceList.applyChanges();
            new MVDDebitInfo();
            new MVDError();
            Globals.applyReload();
            MVDPriorityQueue aQueue = new MVDPriorityQueue();
            if (!aQueue.getEnabled()) {
                aQueue = null;
            }
            Globals.setPriorityQueue(aQueue);
            String sc = MVDGlobals.getConfigurationName();
            MVDStatistics.setLoggerName("com.sap.idm.vds." + sc + ".statistics");
            MVDStatistics.getInstance().configReloadFinished();
            MVDProxy.reInitializeTransformationClass();
            MVDLogger.Log("Completed configuration start up", 3);
            String base = config.getUniqueConfigBase();
            ConfigUtil.writeKKRFile(base + ".kkr", null);
        }
        catch (Exception e) {
            String base = config.getUniqueConfigBase();
            ConfigUtil.writeKKRFile(base + ".kkr", e);
            MVDError.ConfigError("Exception: " + e.getMessage());
            throw e;
        }
    }
}

