/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.cache.MVDCachePool;
import com.sap.idm.vds.config.MVDCache;
import com.sap.idm.vds.config.MVDConfigException;
import java.util.Hashtable;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MVDCacheList {
    private static Hashtable allCache = null;
    private static Hashtable newCache = new Hashtable();

    public static MVDCache getCacheByDSID(int id) {
        return (MVDCache)allCache.get(new Integer(id));
    }

    public static Hashtable getAllCaches() {
        return allCache;
    }

    public static void applyChanges() {
        allCache = newCache;
        newCache = new Hashtable();
    }

    public static void applyReload() {
        MVDCacheList.applyChanges();
        MVDCachePool.instance().reload();
    }

    public static void reloadConfig(Node node) throws MVDConfigException {
        MVDCacheList.readCache(node);
    }

    public static void loadConfig(Node node) throws MVDConfigException {
        MVDCacheList.readCache(node);
        MVDCacheList.applyChanges();
        MVDCachePool.instance().ready();
    }

    private static void readCache(Node cacheTopNode) throws MVDConfigException {
        NodeList nodeList = cacheTopNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!node.hasChildNodes()) continue;
            MVDCacheList.FillCachePool(MVDCachePool.instance(), node);
        }
    }

    private static boolean FillCachePool(MVDCachePool cp, Node cacheRecordNode) throws MVDConfigException {
        if (!cacheRecordNode.hasChildNodes()) {
            return false;
        }
        try {
            NodeList nodeList = cacheRecordNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String strVal;
                int intVal;
                boolean boolVal;
                Node node = nodeList.item(i);
                if (!node.hasChildNodes()) continue;
                String nodeStr = node.getNodeName();
                if (nodeStr.equalsIgnoreCase("Enabled")) {
                    boolVal = Boolean.valueOf(node.getFirstChild().getNodeValue());
                    cp.setEnabled(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Cleaninterval")) {
                    intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    cp.setCleaninterval(intVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("CleanOnFullCache")) {
                    intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    cp.setCleanPolicy(intVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("SzLimit")) {
                    intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    cp.setSzLimit(intVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ttl")) {
                    intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    cp.setGlobalTTL(intVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("UseGlobals")) {
                    boolVal = Boolean.valueOf(node.getFirstChild().getNodeValue());
                    cp.setUseGlobals(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("cache_base")) {
                    boolVal = Boolean.valueOf(node.getFirstChild().getNodeValue());
                    cp.setCacheBase(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("cacheone_sub")) {
                    boolVal = Boolean.valueOf(node.getFirstChild().getNodeValue());
                    cp.setCacheone_sub(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("override_attrs")) {
                    boolVal = Boolean.valueOf(node.getFirstChild().getNodeValue());
                    cp.setOverride_attrs(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("override_sub_attrs")) {
                    boolVal = Boolean.valueOf(node.getFirstChild().getNodeValue());
                    cp.setOverrideSub_attrs(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("expand_sub")) {
                    strVal = node.getFirstChild().getNodeValue();
                    cp.setExpandSub(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("HeapSettings")) {
                    strVal = node.getFirstChild().getNodeValue();
                    cp.setHeapSettings(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("AvailableMemory")) {
                    strVal = node.getFirstChild().getNodeValue();
                    cp.setAvailableMemory(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("DoMemoryCaching")) {
                    strVal = node.getFirstChild().getNodeValue();
                    cp.setDoMemoryCaching(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("SoftMemoryLimit")) {
                    strVal = node.getFirstChild().getNodeValue();
                    cp.setSoftLimit(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("HardMemoryLimit")) {
                    strVal = node.getFirstChild().getNodeValue();
                    cp.setHardLimit(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("CleanPercentageMemory")) {
                    strVal = node.getFirstChild().getNodeValue();
                    cp.setMemBasedCleanPercentage(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("GCEntryLimit")) {
                    strVal = node.getFirstChild().getNodeValue();
                    cp.setMemBasedGCLimit(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("InitialCacheSize")) {
                    strVal = node.getFirstChild().getNodeValue();
                    cp.setInitialCacheSize(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("CacheDataSource")) {
                    MVDCache cr = new MVDCache();
                    if (!MVDCacheList.FillCache(cr, node)) continue;
                    newCache.put(new Integer(cr.DataSource()), cr);
                    MVDCachePool.instance().createCache(cr);
                    continue;
                }
                throw new MVDConfigException("Configuration error: Wrong node type in Cache config: " + nodeStr);
            }
        }
        catch (NumberFormatException nfe) {
            throw new MVDConfigException("Cache Configuration error: Expected int but got String: " + nfe.getMessage());
        }
        catch (DOMException de) {
            throw new MVDConfigException("Cache Configuration error: Cannot get node value: " + de.getMessage());
        }
        return true;
    }

    private static boolean FillCache(MVDCache cr, Node cacheRecordNode) throws MVDConfigException {
        if (!cacheRecordNode.hasChildNodes()) {
            return false;
        }
        try {
            NodeList nodeList = cacheRecordNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                boolean boolVal;
                int intVal;
                Node node = nodeList.item(i);
                if (!node.hasChildNodes()) continue;
                String nodeStr = node.getNodeName();
                if (nodeStr.equalsIgnoreCase("datasource")) {
                    intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    cr.SetDataSource(intVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("enabled")) {
                    boolVal = Boolean.valueOf(node.getFirstChild().getNodeValue());
                    cr.setEnabled(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ttl")) {
                    intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    cr.SetTTL(intVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("szlimit")) {
                    intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    cr.SetSzLimit(intVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("override_attrs")) {
                    boolVal = Boolean.valueOf(node.getFirstChild().getNodeValue());
                    cr.SetOverride_attrs(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("cache_base")) {
                    boolVal = Boolean.valueOf(node.getFirstChild().getNodeValue());
                    cr.setCacheBase(boolVal);
                    continue;
                }
                throw new MVDConfigException("Configuration error: Wrong node type in Cache config: " + nodeStr);
            }
        }
        catch (NumberFormatException nfe) {
            throw new MVDConfigException("Cache Configuration error: Expected int but got String: " + nfe.getMessage());
        }
        catch (DOMException de) {
            throw new MVDConfigException("Cache Configuration error: Cannot get node value: " + de.getMessage());
        }
        return true;
    }
}

