/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.util.MVDDebitLogger;
import java.util.Hashtable;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MVDAuditList {
    private static Hashtable allAudit = null;
    private static Hashtable newAudit = new Hashtable();

    public static void applyChanges() {
        allAudit = newAudit;
        newAudit = new Hashtable();
    }

    public static void reloadConfig(Node node) throws MVDConfigException {
        MVDAuditList.readAudit(node);
    }

    public static void applyReload() {
        MVDAuditList.applyChanges();
    }

    public static void loadConfig(Node node) throws MVDConfigException {
        MVDAuditList.readAudit(node);
        MVDAuditList.applyChanges();
    }

    private static void readAudit(Node statTopNode) throws MVDConfigException {
        MVDAuditList.FillAudit(statTopNode);
    }

    private static void FillAudit(Node proxyRecordNode) throws MVDConfigException {
        try {
            NodeList nodeList = proxyRecordNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                boolean boolVal;
                String nodeStr;
                Node node = nodeList.item(i);
                if (!node.hasChildNodes() || (nodeStr = node.getNodeName()).equalsIgnoreCase("LogTrafficFileName")) continue;
                if (nodeStr.equalsIgnoreCase("DoLogTraffic") || nodeStr.equalsIgnoreCase("LogTraffic")) {
                    boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    MVDDebitLogger.SetLogTraffic(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("DoLogEmptySearchTraffic") || nodeStr.equalsIgnoreCase("LogEmptyTraffic")) {
                    boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    MVDDebitLogger.SetLogEmptyTraffic(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("TrafficLogAllOperations")) continue;
                if (nodeStr.equalsIgnoreCase("LogTrafficOperationMask") || nodeStr.equalsIgnoreCase("LogTrafficOperationTypes")) {
                    String strVal = node.getFirstChild().getNodeValue();
                    MVDDebitLogger.SetLogTrafficOperationTypes(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("LogDestination") || nodeStr.equalsIgnoreCase("LogLocation")) continue;
                throw new MVDConfigException("Configuration error: Wrong node type in Audit config: " + nodeStr);
            }
        }
        catch (NumberFormatException nfe) {
            throw new MVDConfigException("Audit Configuration error: Expected int but got String: " + nfe.getMessage());
        }
        catch (DOMException de) {
            throw new MVDConfigException("Audit Configuration error: Cannot get node value: " + de.getMessage());
        }
    }
}

