/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.MVDAuthGlobals;
import com.sap.idm.vds.MVDHashMap;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.config.ACLHash;
import com.sap.idm.vds.config.FailoverGroup;
import com.sap.idm.vds.config.FailoverGroupContainer;
import com.sap.idm.vds.config.FailoverGroupList;
import com.sap.idm.vds.config.LoadBalancingGroup;
import com.sap.idm.vds.config.LoadBalancingGroupContainer;
import com.sap.idm.vds.config.LoadBalancingGroupList;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.config.MVDDataSource;
import com.sap.idm.vds.config.MVDDataSourceGroup;
import com.sap.idm.vds.config.MVDDataSourceGroupList;
import com.sap.idm.vds.config.MVDDataSourceList;
import com.sap.idm.vds.config.MVDDataSourceSequentialGroup;
import com.sap.idm.vds.config.MVDDataSourceSequentialGroupList;
import com.sap.idm.vds.config.MVDDynamicAddGroup;
import com.sap.idm.vds.config.MVDDynamicAddGroupList;
import com.sap.idm.vds.config.MVDForestList;
import com.sap.idm.vds.config.MVDJoinGroup;
import com.sap.idm.vds.config.MVDJoinGroupList;
import com.sap.idm.vds.config.MVDProvisioningGroup;
import com.sap.idm.vds.config.MVDProvisioningList;
import com.sap.idm.vds.config.MVDProxy;
import com.sap.idm.vds.config.MVDRule;
import com.sap.idm.vds.config.MVDRuleCriteria;
import com.sap.idm.vds.config.MVDRulesList;
import com.sap.idm.vds.config.MVDUserGroup;
import com.sap.idm.vds.config.MVDUserGroupList;
import com.sap.idm.vds.filter.MVDFilter;
import com.sap.idm.vds.filter.MVDFilterUtilities;
import com.sap.idm.vds.util.MVDOpUtilities;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MVDAcl {
    private static HashMap topnodes = new HashMap();
    private static HashMap newTopnodes = new HashMap();
    private static HashMap forestLookup = new HashMap();
    private static boolean reloading = false;
    private MVDAcl mParent = null;
    private ACLHash mChildren = new ACLHash();
    private String mNodeName = "";
    private int mAclID = -123;
    private String mQName = "";
    private int mACLParentId = -123;
    private int mRefType = -100;
    private int mTempMapping = -100;
    private MVDDataSource mMappingTo;
    private MVDDataSourceGroup mMappingToGroup;
    private MVDDataSourceSequentialGroup mMappingToSequentialGroup;
    private MVDProvisioningGroup mMappingToProvisioningGroup;
    private MVDJoinGroup mMappingToJoinGroup;
    private MVDDynamicAddGroup mMappingToDynamicAddGroup;
    private LoadBalancingGroup mMappingToLoadBalancingGroup;
    private FailoverGroup mMappingToFailoverGroup;
    private HashMap mDescription = new HashMap();
    private HashMap mACLRules = new HashMap();
    private String mObjectClass = "";
    private int mPriority = 50;
    private HashMap mParamFields = new HashMap();
    private boolean mExpOneLevel = false;
    private boolean mProhibitSub_Inherited = false;
    private boolean mProhibitSub_Exact = false;
    private boolean mEnableOwner = false;
    private boolean mEnableMember = false;
    private int mOwnerRuleID = -123;
    private int mMemberRuleID = -123;
    private MVDRule mOwnerRule;
    private MVDRule mMemberRule;
    private int mVTree;
    private static int mReferralCounter = Integer.MIN_VALUE;
    private static MVDAcl internalTopNode;

    public static void addUG(MVDUserGroup ug) {
        Integer i = new Integer(ug.TreeID());
        MVDAcl tempAcl = (MVDAcl)forestLookup.get(i);
        if (tempAcl == null) {
            tempAcl = new MVDAcl();
            forestLookup.put(i, tempAcl);
        }
        newTopnodes.put(new Integer(ug.ID()), tempAcl);
    }

    public void addChild(MVDAcl child) throws MVDConfigException {
        if (this.mChildren.put(child.getNodeName(), child) != null) {
            throw new MVDConfigException("MVDAcl: adding of child failed, something lost");
        }
    }

    public static MVDAcl getChild(String childName, int userGroup) {
        MVDAcl tree = (MVDAcl)topnodes.get(new Integer(userGroup));
        if (!tree.hasChildren()) {
            MVDUserGroup ug = MVDUserGroupList.getUGByID(userGroup);
            MVDLogger.Log("This usergroup '" + ug.Name() + "' is not connected to any tree," + " or connected to a tree without content.", 2);
            return tree;
        }
        if (childName.length() == 0) {
            return tree;
        }
        return tree.getChild(childName);
    }

    public static void createReferralTree(Object aGroup) throws MVDConfigException {
        MVDAcl.createInternalTree();
        MVDAcl acl = new MVDAcl();
        acl.mAclID = mReferralCounter++;
        acl.mNodeName = MVDAcl.getNodeName(aGroup);
        acl.mQName = "o=internal," + acl.getNodeName();
        acl.mParent = internalTopNode;
        acl.mACLParentId = internalTopNode.getAclID();
        Vector<String> displayname = new Vector<String>();
        Vector<String> cn = new Vector<String>();
        acl.mDescription.put("displayname", displayname);
        acl.mDescription.put("cn", cn);
        acl.mObjectClass = "organizationalUnit";
        internalTopNode.addChild(acl);
        MVDAcl dynacl = new MVDAcl();
        dynacl.mAclID = mReferralCounter++;
        dynacl.mNodeName = "*";
        dynacl.mQName = acl.mQName + "," + dynacl.mNodeName;
        dynacl.mParent = acl;
        dynacl.mACLParentId = acl.getAclID();
        dynacl.mObjectClass = "*";
        if (aGroup instanceof MVDDataSource) {
            dynacl.mMappingTo = (MVDDataSource)aGroup;
            displayname.add(dynacl.mMappingTo.NiceName());
            cn.add(dynacl.mMappingTo.getUniqueName());
        } else if (aGroup instanceof MVDDataSourceSequentialGroup) {
            dynacl.mMappingToSequentialGroup = (MVDDataSourceSequentialGroup)aGroup;
            displayname.add(dynacl.mMappingToSequentialGroup.NiceName());
            cn.add(dynacl.mMappingToSequentialGroup.getUniqueName());
        } else if (aGroup instanceof MVDProvisioningGroup) {
            dynacl.mMappingToProvisioningGroup = (MVDProvisioningGroup)aGroup;
            displayname.add(dynacl.mMappingToProvisioningGroup.getName());
            cn.add(dynacl.mMappingToProvisioningGroup.getUniqueName());
        } else if (aGroup instanceof MVDJoinGroup) {
            dynacl.mMappingToJoinGroup = (MVDJoinGroup)aGroup;
            displayname.add(dynacl.mMappingToJoinGroup.getName());
            cn.add(dynacl.mMappingToJoinGroup.getUniqueName());
        } else if (aGroup instanceof MVDDynamicAddGroup) {
            dynacl.mMappingToDynamicAddGroup = (MVDDynamicAddGroup)aGroup;
            displayname.add(dynacl.mMappingToDynamicAddGroup.getName());
            cn.add(dynacl.mMappingToDynamicAddGroup.getUniqueName());
        } else if (aGroup instanceof LoadBalancingGroup) {
            dynacl.mMappingToLoadBalancingGroup = (LoadBalancingGroup)aGroup;
            displayname.add(dynacl.mMappingToLoadBalancingGroup.getName());
            cn.add(dynacl.mMappingToLoadBalancingGroup.getUniqueName());
        } else if (aGroup instanceof FailoverGroup) {
            dynacl.mMappingToFailoverGroup = (FailoverGroup)aGroup;
            displayname.add(dynacl.mMappingToFailoverGroup.getName());
            cn.add(dynacl.mMappingToFailoverGroup.getUniqueName());
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("NODE_VIRTUALSP", acl.mNodeName + ",o=internal");
        dynacl.mParamFields = new HashMap();
        dynacl.mParamFields.put("-1", params);
        acl.addChild(dynacl);
    }

    private static String getNodeName(Object aObj) throws MVDConfigException {
        if (aObj instanceof MVDDataSource) {
            int id = ((MVDDataSource)aObj).IID();
            return "ou=ds_" + id;
        }
        if (aObj instanceof MVDDataSourceSequentialGroup) {
            int id = ((MVDDataSourceSequentialGroup)aObj).IID();
            return "ou=unlinked_" + id;
        }
        if (aObj instanceof MVDProvisioningGroup) {
            String id = ((MVDProvisioningGroup)aObj).ID();
            return "ou=provisioning_" + id;
        }
        if (aObj instanceof MVDJoinGroup) {
            int id = ((MVDJoinGroup)aObj).getID();
            return "ou=join_" + id;
        }
        if (aObj instanceof MVDDynamicAddGroup) {
            int id = ((MVDDynamicAddGroup)aObj).getID();
            return "ou=dynamicadd" + id;
        }
        if (aObj instanceof LoadBalancingGroup) {
            int id = ((LoadBalancingGroup)aObj).getId();
            return "ou=loadbalancing_" + id;
        }
        if (aObj instanceof FailoverGroup) {
            int id = ((FailoverGroup)aObj).getId();
            return "ou=failover_" + id;
        }
        throw new MVDConfigException("Unknown type: " + aObj.getClass());
    }

    public static void createInternalTree() throws MVDConfigException {
        MVDAcl temptopnode = (MVDAcl)forestLookup.get(new Integer(MVDForestList.INTERNAL_TREE_ID));
        if (temptopnode.getChild("o=internal") == null) {
            internalTopNode = new MVDAcl();
            MVDAcl.internalTopNode.mParent = temptopnode;
            MVDAcl.internalTopNode.mACLParentId = temptopnode.mAclID;
            MVDAcl.internalTopNode.mAclID = mReferralCounter++;
            MVDAcl.internalTopNode.mNodeName = "o=internal";
            MVDAcl.internalTopNode.mQName = "o=internal";
            MVDAcl.internalTopNode.mObjectClass = "organization";
            Vector<MVDRuleCriteria> v = new Vector<MVDRuleCriteria>();
            v.add(new MVDRuleCriteria(MVDRulesList.getSuperRule(), null));
            MVDAcl.internalTopNode.mACLRules.put(MVDUserGroupList.getUGByID(MVDUserGroupList.getUGIdByTreeId(new Integer(MVDForestList.INTERNAL_TREE_ID))), v);
            newTopnodes.put(new Integer(MVDUserGroupList.getUGIdByTreeId(new Integer(MVDForestList.INTERNAL_TREE_ID))), temptopnode);
            temptopnode.addChild(internalTopNode);
        }
    }

    public MVDAcl getChild(String childName) {
        MVDAcl tempAcl = this;
        Vector tempVector = MVDUtil.splitString(childName, ",");
        Enumeration nenum = tempVector.elements();
        while (nenum.hasMoreElements()) {
            String tempStr = (String)nenum.nextElement();
            MVDAcl tempRes = tempAcl.getRDN(tempStr);
            if (tempRes == null) {
                if (tempAcl.getNodeName().startsWith("*")) continue;
                return null;
            }
            tempAcl = tempRes;
        }
        return tempAcl;
    }

    private MVDAcl getRDN(String childName) {
        MVDAcl ma = this.mChildren.get(childName.toLowerCase());
        if (ma != null) {
            return ma;
        }
        ma = this.mChildren.getRange(childName.toLowerCase());
        if (ma != null) {
            return ma;
        }
        ma = this.mChildren.getWild(childName.toLowerCase());
        if (ma != null) {
            return ma;
        }
        Vector tempVector = MVDUtil.splitString(childName, '=');
        if (tempVector.size() == 2) {
            String tempName = tempVector.get(0) + "=*";
            ma = this.mChildren.get(tempName.toLowerCase());
            if (ma != null) {
                return ma;
            }
            ma = this.mChildren.get("*");
            return ma;
        }
        ma = this.mChildren.get("*");
        return ma;
    }

    public boolean hasChildren() {
        return this.mChildren.size() > 0;
    }

    public Hashtable getChildren() {
        return this.mChildren;
    }

    public MVDRule FindProperRule(String bindName, String aStartingPoint, MVDUserGroup ug, MVDHashMap aSessionGlobals) {
        MVDRule rl;
        boolean bDoCheckOnOwner = false;
        MVDAcl temp = this;
        MVDLogger.Log("Bind name before attempt to find rule: '" + bindName + "'", 1);
        MVDAcl bindNameNode = MVDAcl.getChild(MVDOpUtilities.reverseDN(bindName), ug.ID());
        if (bindNameNode != null && bindNameNode.getEnableOwner() && MVDUtil.isBellowMe(bindName, aStartingPoint)) {
            MVDLogger.Log("Starting point is in scope of bindname, assigning owner rule configured on node: " + bindNameNode.getQName(), 1);
            return bindNameNode.getOwnerRule();
        }
        String commonDN = MVDUtil.commonDN(bindName, aStartingPoint);
        MVDAcl commonNode = commonDN.equalsIgnoreCase(bindName) ? bindNameNode : MVDAcl.getChild(MVDOpUtilities.reverseDN(commonDN), ug.ID());
        MVDAcl limit = bindName.length() == 0 ? bindNameNode : MVDAcl.getChild("", ug.ID());
        if (commonNode != null) {
            for (temp = commonNode; temp != limit; temp = temp.Parent()) {
                if (!temp.getEnableMember() || (rl = temp.getMemberRule()) == null) continue;
                MVDLogger.Log("Assigning member rule configured on node: " + temp.getQName(), 1);
                return rl;
            }
        }
        MVDAuthGlobals authGlobals = null;
        if (aSessionGlobals != null) {
            authGlobals = (MVDAuthGlobals)aSessionGlobals.get("AUTH_GLOBALS");
        }
        for (temp = this; temp != limit; temp = temp.Parent()) {
            rl = temp.getRuleByUserGroup(ug, authGlobals);
            if (rl == null) continue;
            MVDLogger.Log("Assigning rule: " + rl.Name() + " for user group: " + ug.Name() + ", configured on node: " + temp.getQName(), 1);
            return rl;
        }
        return null;
    }

    public void setParent(MVDAcl parent) {
        this.mParent = parent;
    }

    public int getVTree() {
        return this.mVTree;
    }

    public MVDAcl Parent() {
        return this.mParent;
    }

    public String getLDAPattr(String key) {
        return (String)this.mDescription.get(key.toLowerCase());
    }

    public MVDRule getRuleByUserGroup(MVDUserGroup ugr, MVDAuthGlobals authGlobals) {
        Vector vRuleC = (Vector)this.mACLRules.get(ugr);
        if (vRuleC == null) {
            return null;
        }
        for (int ix = 0; ix < vRuleC.size(); ++ix) {
            MVDRuleCriteria aRuleCriteria = (MVDRuleCriteria)vRuleC.elementAt(ix);
            MVDFilter aCriteria = aRuleCriteria.getFilter();
            if (aCriteria == null || authGlobals == null) {
                return aRuleCriteria.getRule();
            }
            boolean evaluateCriteria = aCriteria.evaluate(authGlobals.getValues());
            if (!evaluateCriteria) continue;
            return aRuleCriteria.getRule();
        }
        return null;
    }

    public MVDDataSource getDataSource() {
        return this.mMappingTo;
    }

    public MVDDataSourceGroup getDataSourceGroup() {
        return this.mMappingToGroup;
    }

    public MVDDataSourceSequentialGroup getDataSourceSequentialGroup() {
        return this.mMappingToSequentialGroup;
    }

    public MVDProvisioningGroup getProvisioningGroup() {
        return this.mMappingToProvisioningGroup;
    }

    public MVDJoinGroup getJoinGroup() {
        return this.mMappingToJoinGroup;
    }

    public MVDDynamicAddGroup getDynamicAddGroup() {
        return this.mMappingToDynamicAddGroup;
    }

    public LoadBalancingGroupContainer getLoadBalancingGroup() {
        if (this.mMappingToLoadBalancingGroup != null) {
            return new LoadBalancingGroupContainer(this.mMappingToLoadBalancingGroup);
        }
        return null;
    }

    public FailoverGroupContainer getFailoverGroup() {
        if (this.mMappingToFailoverGroup != null) {
            return new FailoverGroupContainer(this.mMappingToFailoverGroup);
        }
        return null;
    }

    public boolean IsVirtualNode() {
        return this.mMappingTo != null || this.mMappingToGroup != null || this.mMappingToSequentialGroup != null || this.mMappingToProvisioningGroup != null || this.mMappingToJoinGroup != null || this.mMappingToDynamicAddGroup != null || this.mMappingToLoadBalancingGroup != null || this.mMappingToFailoverGroup != null;
    }

    public String getNodeName() {
        return this.mNodeName;
    }

    public int getAclID() {
        return this.mAclID;
    }

    public String getQName() {
        return this.mQName;
    }

    public int getACLParentId() {
        return this.mACLParentId;
    }

    public HashMap getDescription() {
        return this.mDescription;
    }

    public String getObjectClass() {
        return this.mObjectClass;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public HashMap getParamFields() {
        return this.mParamFields;
    }

    public boolean getExpOneLevel() {
        return this.mExpOneLevel;
    }

    public boolean getProhibitSub_Inherited() {
        return this.mProhibitSub_Inherited;
    }

    public boolean getProhibitSub_Exact() {
        return this.mProhibitSub_Exact;
    }

    public boolean getEnableOwner() {
        return this.mEnableOwner;
    }

    public MVDRule getOwnerRule() {
        return this.mOwnerRule;
    }

    public boolean getEnableMember() {
        return this.mEnableMember;
    }

    public MVDRule getMemberRule() {
        return this.mMemberRule;
    }

    public int getTempMapping() {
        return this.mTempMapping;
    }

    public int getRefType() {
        return this.mRefType;
    }

    public void setDataSource(MVDDataSource ds) {
        this.mMappingTo = ds;
        this.mRefType = 0;
    }

    public MVDAcl() {
    }

    public static void applyChanges() {
        topnodes = newTopnodes;
        newTopnodes = new HashMap();
    }

    public static void initReload() {
        reloading = true;
        forestLookup.clear();
    }

    public static void reloadConfig(Node ACLtopNode) throws MVDConfigException {
        MVDAcl.readACLs(ACLtopNode);
    }

    public static void loadConfig(Node ACLtopNode) throws MVDConfigException {
        MVDAcl.readACLs(ACLtopNode);
        MVDAcl.applyChanges();
    }

    private static void readACLs(Node ACLtopNode) throws MVDConfigException {
        NodeList nodeList = ACLtopNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!node.hasChildNodes() || !MVDAcl.checkEnabled(node)) continue;
            MVDAcl tempACL = new MVDAcl(node, null);
            MVDAcl temptopnode = (MVDAcl)forestLookup.get(new Integer(tempACL.getVTree()));
            tempACL.setParent(temptopnode);
            if (temptopnode == null) continue;
            temptopnode.addChild(tempACL);
        }
    }

    private static boolean checkEnabled(Node aACLNode) {
        if (aACLNode instanceof Element) {
            Element el = (Element)aACLNode;
            NodeList nl = el.getElementsByTagName("Enabled");
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                if (n.getParentNode() != aACLNode) continue;
                String val = n.getFirstChild().getNodeValue();
                boolean b = Boolean.valueOf(val);
                return b;
            }
        }
        return true;
    }

    public MVDAcl(Node ACLnode, MVDAcl parent) throws MVDConfigException {
        HashMap map;
        String addToLog = "";
        this.mParent = parent;
        this.mParamFields.put("-1", new HashMap());
        try {
            NodeList nodeList = ACLnode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Vector strVector;
                Enumeration nenum;
                Vector pairVector;
                String tempStr;
                Node node = nodeList.item(i);
                if (!node.hasChildNodes()) continue;
                String nodeStr = node.getNodeName();
                if (nodeStr.equalsIgnoreCase("Name") || nodeStr.equalsIgnoreCase("NodeName")) {
                    this.mNodeName = node.getFirstChild().getNodeValue().toLowerCase();
                    if (addToLog.length() != 0) continue;
                    addToLog = this.mNodeName;
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("QName")) {
                    addToLog = this.mQName = node.getFirstChild().getNodeValue().toLowerCase();
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ID") || nodeStr.equalsIgnoreCase("aclID")) {
                    this.mAclID = Integer.parseInt(node.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ForestID") || nodeStr.equalsIgnoreCase("VTree")) {
                    this.mVTree = Integer.parseInt(node.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Priority")) {
                    this.mPriority = Integer.parseInt(node.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ParentId") || nodeStr.equalsIgnoreCase("ACLParentId")) {
                    this.mACLParentId = Integer.parseInt(node.getFirstChild().getNodeValue());
                    if (this.mACLParentId == -1 || parent.getAclID() == this.mACLParentId) continue;
                    throw new MVDConfigException("Node " + addToLog + " - Parent ID: Parent mismatch");
                }
                if (nodeStr.equalsIgnoreCase("MappingID") || nodeStr.equalsIgnoreCase("MappingTo")) {
                    this.mTempMapping = Integer.parseInt(node.getFirstChild().getNodeValue());
                    if (this.mTempMapping == -1 || this.mRefType == -100) continue;
                    if (this.mRefType == 0) {
                        this.mMappingTo = MVDDataSourceList.getDSByID(this.mTempMapping);
                        if (this.mMappingTo != null) continue;
                        throw new MVDConfigException("Node " + addToLog + " - MappingId: No data source found with this id " + this.mTempMapping);
                    }
                    if (this.mRefType == 1) {
                        this.mMappingToGroup = MVDDataSourceGroupList.getDSByID(this.mTempMapping);
                        if (this.mMappingToGroup != null) continue;
                        throw new MVDConfigException("Node " + addToLog + " - MappingId: No data source group found with this id " + this.mTempMapping);
                    }
                    if (this.mRefType == 2) {
                        this.mMappingToSequentialGroup = MVDDataSourceSequentialGroupList.getDSByID(this.mTempMapping);
                        if (this.mMappingToSequentialGroup != null) continue;
                        throw new MVDConfigException("Node " + addToLog + " - MappingId: No data source sequential group found with this id " + this.mTempMapping);
                    }
                    if (this.mRefType == 3) {
                        this.mMappingToProvisioningGroup = MVDProvisioningList.getProvisioningGroupByID(this.mTempMapping);
                        if (this.mMappingToProvisioningGroup != null) continue;
                        throw new MVDConfigException("Node " + addToLog + " - MappingType: No provisioning group found, id " + this.mTempMapping);
                    }
                    if (this.mRefType == 4) {
                        this.mMappingToJoinGroup = MVDJoinGroupList.getJoinGroupByID(this.mTempMapping);
                        if (this.mMappingToJoinGroup != null) continue;
                        throw new MVDConfigException("Node " + addToLog + " - MappingType: No join group found, id " + this.mTempMapping);
                    }
                    if (this.mRefType == 5) {
                        this.mMappingToDynamicAddGroup = MVDDynamicAddGroupList.getDynamicAddGroupByID(this.mTempMapping);
                        if (this.mMappingToDynamicAddGroup != null) continue;
                        throw new MVDConfigException("Node " + addToLog + " - MappingType: No dynamic add group found, id " + this.mTempMapping);
                    }
                    if (this.mRefType == 6) {
                        this.mMappingToLoadBalancingGroup = LoadBalancingGroupList.getLBGroupByID(this.mTempMapping);
                        if (this.mMappingToLoadBalancingGroup != null) continue;
                        throw new MVDConfigException("Node " + addToLog + " - MappingType: No load balancing group found, id " + this.mTempMapping);
                    }
                    if (this.mRefType == 7) {
                        this.mMappingToFailoverGroup = FailoverGroupList.getFailoverGroupByID(this.mTempMapping);
                        if (this.mMappingToFailoverGroup != null) continue;
                        throw new MVDConfigException("Node " + addToLog + " - MappingType: No failover group found, id " + this.mTempMapping);
                    }
                    MVDLogger.Log("Unknown mappingtype", 2);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("MappingType") || nodeStr.equalsIgnoreCase("RefType")) {
                    this.mRefType = Integer.parseInt(node.getFirstChild().getNodeValue());
                    if (this.mTempMapping == -100 || this.mTempMapping == -1) continue;
                    if (this.mRefType == 0) {
                        this.mMappingTo = MVDDataSourceList.getDSByID(this.mTempMapping);
                        if (this.mMappingTo != null) continue;
                        throw new MVDConfigException("Node " + addToLog + " - MappingType: No data source found, id " + this.mTempMapping);
                    }
                    if (this.mRefType == 1) {
                        this.mMappingToGroup = MVDDataSourceGroupList.getDSByID(this.mTempMapping);
                        if (this.mMappingToGroup != null) continue;
                        throw new MVDConfigException("Node " + addToLog + " - MappingType: No data source group found, id " + this.mTempMapping);
                    }
                    if (this.mRefType == 2) {
                        this.mMappingToSequentialGroup = MVDDataSourceSequentialGroupList.getDSByID(this.mTempMapping);
                        if (this.mMappingToSequentialGroup != null) continue;
                        throw new MVDConfigException("Node " + addToLog + " - MappingType: No data source sequential group found, id " + this.mTempMapping);
                    }
                    if (this.mRefType == 3) {
                        this.mMappingToProvisioningGroup = MVDProvisioningList.getProvisioningGroupByID(this.mTempMapping);
                        if (this.mMappingToProvisioningGroup != null) continue;
                        throw new MVDConfigException("Node " + addToLog + " - MappingType: No provisioning group found, id " + this.mTempMapping);
                    }
                    if (this.mRefType == 4) {
                        this.mMappingToJoinGroup = MVDJoinGroupList.getJoinGroupByID(this.mTempMapping);
                        if (this.mMappingToJoinGroup != null) continue;
                        throw new MVDConfigException("Node " + addToLog + " - MappingType: No join group found, id " + this.mTempMapping);
                    }
                    if (this.mRefType == 5) {
                        this.mMappingToDynamicAddGroup = MVDDynamicAddGroupList.getDynamicAddGroupByID(this.mTempMapping);
                        if (this.mMappingToDynamicAddGroup != null) continue;
                        throw new MVDConfigException("Node " + addToLog + " - MappingType: No dynamic add group found, id " + this.mTempMapping);
                    }
                    if (this.mRefType == 6) {
                        this.mMappingToLoadBalancingGroup = LoadBalancingGroupList.getLBGroupByID(this.mTempMapping);
                        if (this.mMappingToLoadBalancingGroup != null) continue;
                        throw new MVDConfigException("Node " + addToLog + " - MappingType: No load balancing group found, id " + this.mTempMapping);
                    }
                    if (this.mRefType == 7) {
                        this.mMappingToFailoverGroup = FailoverGroupList.getFailoverGroupByID(this.mTempMapping);
                        if (this.mMappingToFailoverGroup != null) continue;
                        throw new MVDConfigException("Node " + addToLog + " - MappingType: No failover group found, id " + this.mTempMapping);
                    }
                    MVDLogger.Log("Unknown mappingtype", 2);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("LDAPProperties") || nodeStr.equalsIgnoreCase("Description")) {
                    try {
                        tempStr = node.getFirstChild().getNodeValue();
                        pairVector = MVDUtil.splitString(tempStr, "[&&]");
                        nenum = pairVector.elements();
                        while (nenum.hasMoreElements()) {
                            String realVal = null;
                            tempStr = (String)nenum.nextElement();
                            strVector = MVDUtil.splitString(tempStr, "[$]");
                            String attrName = ((String)strVector.elementAt(0)).toLowerCase();
                            String val = (String)strVector.elementAt(1);
                            boolean doBinary = false;
                            boolean doIgnoreLineEnd = false;
                            if (val.toLowerCase().indexOf("include=") >= 0) {
                                if (val.toLowerCase().startsWith("include=")) {
                                    val = val.substring(8);
                                    doBinary = MVDProxy.IsBinaryAttribute(attrName);
                                    doIgnoreLineEnd = false;
                                } else if (val.toLowerCase().startsWith("binary_include=")) {
                                    if (!MVDProxy.IsBinaryAttribute(attrName)) {
                                        MVDLogger.Log("Node '" + addToLog + "': Attribute " + attrName + " is not defined as binary in Internal Attributes, but a binary_include is performed." + "The attribute will not be returned correctly to the client.", 6);
                                    }
                                    val = val.substring(15);
                                    doBinary = true;
                                    doIgnoreLineEnd = false;
                                } else if (val.toLowerCase().startsWith("text_include=")) {
                                    val = val.substring(13);
                                    doBinary = false;
                                    doIgnoreLineEnd = false;
                                } else if (val.toLowerCase().startsWith("ignorelineending_include=")) {
                                    val = val.substring(25);
                                    doBinary = false;
                                    doIgnoreLineEnd = true;
                                } else {
                                    realVal = val;
                                }
                                if (realVal == null && (realVal = MVDUtil.ReadFile(val, doBinary, doIgnoreLineEnd)) == null) {
                                    MVDLogger.Log("Node '" + addToLog + "': " + attrName + ": Could not find file to include: " + val, 6);
                                }
                            } else {
                                realVal = val;
                            }
                            if (realVal == null) continue;
                            Object valueToAdd = null;
                            valueToAdd = !MVDProxy.IsBinaryAttribute(attrName) ? MVDUtil.splitString(realVal, "|") : (realVal.startsWith("{HEX}") ? (Object)MVDUtil.hexToByte(realVal.substring(5)) : (Object)MVDUtil.ToUTF8(realVal));
                            if (valueToAdd == null) continue;
                            Vector<Object> oldValues = (Vector<Object>)this.mDescription.get(attrName);
                            if (oldValues == null) {
                                oldValues = new Vector<Object>();
                            }
                            if (valueToAdd instanceof Vector) {
                                oldValues.addAll((Vector)valueToAdd);
                            } else {
                                oldValues.add(valueToAdd);
                            }
                            this.mDescription.put(attrName, oldValues);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        throw new MVDConfigException("Failed parsing LDAP attr. Is this an old config? Verify in node: '" + addToLog + "'. " + e);
                    }
                }
                if (nodeStr.equalsIgnoreCase("UserGroupRuleMapping") || nodeStr.equalsIgnoreCase("ACLRules")) {
                    tempStr = node.getFirstChild().getNodeValue();
                    Vector tempVector = MVDUtil.splitString(tempStr, "//");
                    Enumeration nenum2 = tempVector.elements();
                    while (nenum2.hasMoreElements()) {
                        String criteria;
                        tempStr = (String)nenum2.nextElement();
                        strVector = MVDUtil.splitString(tempStr, ":");
                        MVDUserGroup ug = MVDUserGroupList.getUGByID(Integer.parseInt((String)strVector.elementAt(0)));
                        if (ug == null) {
                            throw new MVDConfigException("Node " + addToLog + " - UserGroupRuleMapping: user group is null");
                        }
                        MVDRule rule = MVDRulesList.getRuleByID(Integer.parseInt((String)strVector.elementAt(1)));
                        if (rule == null) {
                            throw new MVDConfigException("Node " + addToLog + " - UserGroupRuleMapping: rule is null");
                        }
                        MVDFilter filtercriteria = null;
                        if (strVector.size() > 2 && (criteria = (String)strVector.elementAt(2)).length() > 0) {
                            filtercriteria = MVDFilterUtilities.constructFilter(criteria.toLowerCase());
                        }
                        MVDRuleCriteria rulecriteria = new MVDRuleCriteria(rule, filtercriteria);
                        Vector<MVDRuleCriteria> alreadyExisting = (Vector<MVDRuleCriteria>)this.mACLRules.get(ug);
                        if (alreadyExisting == null && this.mACLRules.put(ug, alreadyExisting = new Vector<MVDRuleCriteria>()) != null) {
                            throw new MVDConfigException("Node " + addToLog + " - UserGroupRuleMapping: identical hash " + ug);
                        }
                        alreadyExisting.add(rulecriteria);
                    }
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ObjectClass")) {
                    this.mObjectClass = MVDUtil.replace(node.getFirstChild().getNodeValue(), " ", "");
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ParamFields")) {
                    tempStr = node.getFirstChild().getNodeValue();
                    if (this.mTempMapping == -1) continue;
                    pairVector = MVDUtil.splitString(tempStr, "[&&]");
                    HashMap<String, String> commonParamFields = new HashMap<String, String>();
                    nenum = pairVector.elements();
                    while (nenum.hasMoreElements()) {
                        HashMap tempParamFields;
                        tempStr = (String)nenum.nextElement();
                        strVector = MVDUtil.splitString(tempStr, "[$]");
                        Vector strIfGroup = MVDUtil.splitString((String)strVector.elementAt(0), "[x]");
                        if (strIfGroup.size() == 1) {
                            if (commonParamFields.put("NODE_" + strVector.elementAt(0), (String)strVector.elementAt(1)) == null) continue;
                            throw new MVDConfigException("Node " + addToLog + " - param fields: Identical hash " + strVector.elementAt(0));
                        }
                        String dsID = (String)strIfGroup.elementAt(0);
                        if (dsID.equals("-1")) {
                            if (commonParamFields.put("NODE_" + strIfGroup.elementAt(1), (String)strVector.elementAt(1)) == null) continue;
                            throw new MVDConfigException("Node " + addToLog + " - param fields: Identical hash " + strIfGroup.elementAt(1));
                        }
                        if (this.mParamFields.containsKey(dsID)) {
                            tempParamFields = (HashMap)this.mParamFields.get(dsID);
                        } else {
                            tempParamFields = new HashMap();
                            this.mParamFields.put(dsID, tempParamFields);
                        }
                        if (tempParamFields.put("NODE_" + strIfGroup.elementAt(1), (String)strVector.elementAt(1)) == null) continue;
                        throw new MVDConfigException("Node " + addToLog + " - param fields: Identical hash " + strIfGroup.elementAt(1));
                    }
                    Iterator iw = this.mParamFields.keySet().iterator();
                    while (iw.hasNext()) {
                        String sss = (String)iw.next();
                        HashMap speciall = (HashMap)this.mParamFields.get(sss);
                        speciall.putAll(commonParamFields);
                    }
                    this.mParamFields.put("-1", commonParamFields);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("EnableOwnerAccess") || nodeStr.equalsIgnoreCase("EnableOwner")) {
                    this.mEnableOwner = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("EnableMemberAccess") || nodeStr.equalsIgnoreCase("EnableMember")) {
                    this.mEnableMember = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("OwnerRuleID") || nodeStr.equalsIgnoreCase("OwnerRule")) {
                    this.mOwnerRuleID = Integer.parseInt(node.getFirstChild().getNodeValue());
                    if (this.mOwnerRuleID == -1) continue;
                    this.mOwnerRule = MVDRulesList.getRuleByID(this.mOwnerRuleID);
                    if (this.mOwnerRule != null) continue;
                    throw new MVDConfigException("Node " + addToLog + " - Owner rule: No matching rule for id " + this.mOwnerRuleID);
                }
                if (nodeStr.equalsIgnoreCase("MemberRuleID") || nodeStr.equalsIgnoreCase("MemberRule")) {
                    this.mMemberRuleID = Integer.parseInt(node.getFirstChild().getNodeValue());
                    if (this.mMemberRuleID == -1) continue;
                    this.mMemberRule = MVDRulesList.getRuleByID(this.mMemberRuleID);
                    if (this.mMemberRule != null) continue;
                    throw new MVDConfigException("Node " + addToLog + " - Member rule: No matching rule for id " + this.mMemberRuleID);
                }
                if (nodeStr.equalsIgnoreCase("ProhibitExactSubSearch") || nodeStr.equalsIgnoreCase("ProhibitSub_Exact")) {
                    this.mProhibitSub_Exact = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ProhibitInheritedSubSearch") || nodeStr.equalsIgnoreCase("ProhibitSub_Inherited")) {
                    this.mProhibitSub_Inherited = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Initialize") || nodeStr.equalsIgnoreCase("Terminate") || nodeStr.equalsIgnoreCase("SearchScript") || nodeStr.equalsIgnoreCase("ModifyScript") || nodeStr.equalsIgnoreCase("AddScript") || nodeStr.equalsIgnoreCase("DeleteScript") || nodeStr.equalsIgnoreCase("UseAllDefaultScripts")) continue;
                if (nodeStr.equalsIgnoreCase("ProhibitOneLevelSearch") || nodeStr.equalsIgnoreCase("ExpOneLevel")) {
                    this.mExpOneLevel = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("OneLevelProcessing") || nodeStr.equalsIgnoreCase("ExpSub") || nodeStr.equalsIgnoreCase("Param1") || nodeStr.equalsIgnoreCase("Param2") || nodeStr.equalsIgnoreCase("Param3") || nodeStr.equalsIgnoreCase("Param4") || nodeStr.equalsIgnoreCase("Param5") || nodeStr.equalsIgnoreCase("InsteadOf")) continue;
                if (nodeStr.equalsIgnoreCase("Record")) {
                    if (!MVDAcl.checkEnabled(node)) continue;
                    MVDAcl tempACL = new MVDAcl(node, this);
                    String nameNode = tempACL.getNodeName().toLowerCase();
                    this.mChildren.put(nameNode, tempACL);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Enabled")) continue;
                throw new MVDConfigException("Node " + addToLog + " - error: Wrong node type: " + nodeStr);
            }
            this.addInternalUserGroup();
        }
        catch (NumberFormatException nfe) {
            throw new MVDConfigException("Node " + addToLog + " - error: Expected int but got String: " + nfe.getMessage());
        }
        catch (DOMException de) {
            throw new MVDConfigException("Node  " + addToLog + " - error: Cannot get node value: " + de.getMessage());
        }
        if (this.mRefType == -100 && this.mTempMapping != -100 && this.mTempMapping != -1) {
            this.mMappingTo = MVDDataSourceList.getDSByID(this.mTempMapping);
            if (this.mMappingTo == null) {
                throw new MVDConfigException("Node " + addToLog + " - MappingId: No data source found with id " + this.mTempMapping);
            }
        }
        if (!(map = (HashMap)this.mParamFields.get("-1")).containsKey("NODE_VIRTUALSP") && this.IsVirtualNode()) {
            String x = this.getVirtualSp();
            map.put("NODE_VIRTUALSP", x);
        }
    }

    private String getVirtualSp() {
        if (this.mParent != null) {
            if (this.IsVirtualNode()) {
                return this.mParent.getVirtualSp();
            }
            return this.getNodeName() + "," + this.mParent.getVirtualSp();
        }
        if (this.IsVirtualNode()) {
            return "";
        }
        return this.getNodeName();
    }

    public void addInternalUserGroup() {
        MVDRule rule = MVDRulesList.getSuperRule();
        MVDUserGroup ug = MVDUserGroupList.getUGByID(Integer.MAX_VALUE - this.mVTree);
        if (ug != null) {
            Vector<MVDRuleCriteria> v = new Vector<MVDRuleCriteria>();
            v.add(new MVDRuleCriteria(MVDRulesList.getSuperRule(), null));
            this.mACLRules.put(ug, v);
        }
    }

    public String toString() {
        return this.mQName;
    }
}

