/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.MVDGlobals;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.config.MVDAuditList;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.config.MVDSnmpList;
import com.sap.idm.vds.config.MVDStatisticsList;
import com.sap.idm.vds.util.MVDDebitLogger;
import java.io.File;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LogConfig {
    public static void readLogConfig(Node aLogConfNode, Vector aLoggerKeys) throws MVDConfigException {
        Node destnode = null;
        Node auditnode = null;
        Node statisticsnode = null;
        Node snmpnode = null;
        try {
            destnode = ((Element)aLogConfNode).getElementsByTagName("Destination").item(0);
            snmpnode = ((Element)aLogConfNode).getElementsByTagName("SNMP").item(0);
            auditnode = ((Element)aLogConfNode).getElementsByTagName("Audit").item(0);
            statisticsnode = ((Element)aLogConfNode).getElementsByTagName("Statistics").item(0);
        }
        catch (Exception e) {
            throw new MVDConfigException("Unable to find node. " + e.getMessage());
        }
        if (aLoggerKeys != null) {
            new MVDLogger(aLoggerKeys);
            new MVDDebitLogger(aLoggerKeys);
        }
        MVDSnmpList.loadConfig(snmpnode);
        MVDStatisticsList.loadConfig(statisticsnode);
        MVDAuditList.loadConfig(auditnode);
    }

    private static String evalFileName(String file) {
        File f = new File(file);
        String logfile = "";
        if (!f.isAbsolute()) {
            String conffile = MVDGlobals.getConfigurationFile();
            File workarea = new File(conffile).getParentFile();
            File logsdir = new File(workarea, "logs");
            logfile = new File(logsdir, file).getAbsolutePath();
        } else {
            logfile = file;
        }
        logfile = MVDUtil.replace(logfile, "\\", "\\\\");
        return logfile;
    }

    private static String convertLevel(String aLevel) {
        if (aLevel.equalsIgnoreCase("MINIMAL")) {
            return "MINIMAL#com.sap.idm.vds.config.MVDLogLevel";
        }
        if (aLevel.equalsIgnoreCase("COMPACT")) {
            return "COMPACT#com.sap.idm.vds.config.MVDLogLevel";
        }
        return aLevel;
    }

    public static void addLoggers(Vector aLoggerKeys) {
        if (aLoggerKeys != null) {
            MVDLogger.addLoggers(aLoggerKeys);
            MVDDebitLogger.addLoggers(aLoggerKeys);
        }
    }

    public static void removeLoggers(Vector aLoggerKeys) {
        if (aLoggerKeys != null) {
            MVDLogger.removeLoggers(aLoggerKeys);
            MVDDebitLogger.removeLoggers(aLoggerKeys);
        }
    }
}

