/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.MVDOrderedHashMap;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.config.FailedSource;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.config.MVDSource;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Vector;

public class LoadBalancingGroup {
    public static final int ROUND_ROBIN = 0;
    public static final int PERCENTAGE = 1;
    private String mName;
    private int mId;
    private boolean mEnabled;
    private int mSearchAlgorithm;
    private int mUpdateAlgorithm;
    private int mMarkAsDown = 300;
    private MVDOrderedHashMap mSearchWeights;
    private MVDOrderedHashMap mUpdateWeights;
    private HashMap mAllSources = new HashMap();
    private Vector mActiveSearchSources = new Vector();
    private Vector mActiveUpdateSources = new Vector();
    private Random mRandomizer;
    private int mLastSearchIndex = 0;
    private int mLastUpdateIndex = 0;
    private int mSearchSumWeight;
    private int mUpdateSumWeight;
    private Vector mUnavailableSources;
    private long mNextScheduledSourceAvailable;
    private String mUniqueName;

    public LoadBalancingGroup() {
        this.mSearchWeights = new MVDOrderedHashMap();
        this.mUpdateWeights = new MVDOrderedHashMap();
        this.mUnavailableSources = new Vector();
        this.mRandomizer = new Random();
        this.mNextScheduledSourceAvailable = Long.MAX_VALUE;
    }

    public MVDSource getNextSource(int aOperation) throws NoSuchElementException {
        if (this.mNextScheduledSourceAvailable < System.currentTimeMillis()) {
            this.recoverFailedSources();
        }
        if (aOperation == 0) {
            MVDSource src = this.getNextSearchSource();
            return src;
        }
        if (aOperation == 1) {
            MVDSource src = this.getNextUpdateSource();
            return src;
        }
        throw new IllegalArgumentException("Operation " + aOperation + " is not a valid argument");
    }

    private MVDSource getNextSearchSource() throws NoSuchElementException {
        switch (this.mSearchAlgorithm) {
            case 0: {
                MVDSource src = (MVDSource)this.mActiveSearchSources.get(this.mLastSearchIndex++ % this.mActiveSearchSources.size());
                return src;
            }
            case 1: {
                if (this.mSearchSumWeight > 0) {
                    int num = this.mRandomizer.nextInt(this.mSearchSumWeight);
                    int cumulative = 0;
                    MVDSource curSrc = null;
                    for (int i = 0; i < this.mActiveSearchSources.size(); ++i) {
                        curSrc = (MVDSource)this.mActiveSearchSources.elementAt(i);
                        Integer weight = (Integer)this.mSearchWeights.get(curSrc.getSrcID());
                        if (weight == null || (cumulative += weight.intValue()) <= num) continue;
                        return curSrc;
                    }
                    if (curSrc == null) {
                        String message = "";
                        message = this.mAllSources != null && this.mAllSources.size() > 0 ? "No sources defined in LoadBalancing group" : (this.mUnavailableSources != null && this.mUnavailableSources.size() > 0 ? "All sources defined for LoadBalancing unavailable" : "This message isn't here");
                        throw new NoSuchElementException(message);
                    }
                } else {
                    try {
                        MVDSource failSrc = (MVDSource)this.mActiveSearchSources.firstElement();
                        return failSrc;
                    }
                    catch (NoSuchElementException e) {
                        throw new NoSuchElementException("All sources defined for LoadBalancing unavailable");
                    }
                }
                return (MVDSource)this.mActiveSearchSources.lastElement();
            }
        }
        throw new NoSuchElementException();
    }

    private MVDSource getNextUpdateSource() throws NoSuchElementException {
        switch (this.mUpdateAlgorithm) {
            case 0: {
                MVDSource src = (MVDSource)this.mActiveUpdateSources.get(this.mLastUpdateIndex++ % this.mActiveUpdateSources.size());
                return src;
            }
            case 1: {
                int sumWeight = this.mUpdateSumWeight;
                if (sumWeight > 0) {
                    int num = this.mRandomizer.nextInt(sumWeight);
                    int cumulative = 0;
                    MVDSource curSrc = null;
                    for (int i = 0; i < this.mActiveUpdateSources.size(); ++i) {
                        curSrc = (MVDSource)this.mActiveUpdateSources.elementAt(i);
                        Integer weight = (Integer)this.mUpdateWeights.get(curSrc.getSrcID());
                        if (weight == null || (cumulative += weight.intValue()) <= num) continue;
                        return curSrc;
                    }
                    if (curSrc == null) {
                        String message = "";
                        message = this.mAllSources != null && this.mAllSources.size() > 0 ? "No sources defined in LoadBalancing group" : (this.mUnavailableSources != null && this.mUnavailableSources.size() > 0 ? "All sources defined for LoadBalancing unavailable" : "This message isn't here");
                        throw new NoSuchElementException(message);
                    }
                } else {
                    try {
                        MVDSource failSrc = (MVDSource)this.mActiveUpdateSources.firstElement();
                        return failSrc;
                    }
                    catch (NoSuchElementException e) {
                        throw new NoSuchElementException("All sources defined for LoadBalancing unavailable");
                    }
                }
                return (MVDSource)this.mActiveUpdateSources.lastElement();
            }
        }
        throw new NoSuchElementException();
    }

    public void sourceFailed(MVDSource aSource) {
        boolean wasActive = this.mActiveSearchSources.remove(aSource) | this.mActiveUpdateSources.remove(aSource);
        if (!wasActive) {
            MVDSource element;
            String ID = aSource.getSrcID();
            Iterator iter = this.mActiveSearchSources.iterator();
            while (iter.hasNext()) {
                element = (MVDSource)iter.next();
                if (!element.getSrcID().equals(ID)) continue;
                wasActive = true;
                iter.remove();
                break;
            }
            iter = this.mActiveUpdateSources.iterator();
            while (iter.hasNext()) {
                element = (MVDSource)iter.next();
                if (!element.getSrcID().equals(ID)) continue;
                wasActive = true;
                iter.remove();
                break;
            }
        }
        if (wasActive) {
            FailedSource src = new FailedSource(aSource, this.mMarkAsDown);
            this.mUnavailableSources.add(src);
            if (this.mNextScheduledSourceAvailable == Long.MAX_VALUE) {
                this.mNextScheduledSourceAvailable = src.getAvailableTimestamp();
            }
        }
        this.normalizeWeights();
    }

    private void recoverFailedSources() {
        if (this.mUnavailableSources.size() <= 0) {
            return;
        }
        boolean doContinue = true;
        while (doContinue) {
            try {
                FailedSource src = (FailedSource)this.mUnavailableSources.firstElement();
                if (src.getAvailableTimestamp() < System.currentTimeMillis()) {
                    this.mUnavailableSources.removeElementAt(0);
                    String srcid = src.getSource().getSrcID();
                    if (this.mSearchWeights.containsKey(srcid)) {
                        this.mActiveSearchSources.add(src.getSource());
                    }
                    if (!this.mUpdateWeights.containsKey(srcid)) continue;
                    this.mActiveUpdateSources.add(src.getSource());
                    continue;
                }
                doContinue = false;
            }
            catch (NoSuchElementException e) {
                doContinue = false;
            }
        }
        this.mNextScheduledSourceAvailable = this.mUnavailableSources.size() == 0 ? Long.MAX_VALUE : ((FailedSource)this.mUnavailableSources.firstElement()).getAvailableTimestamp();
        this.normalizeWeights();
    }

    private void normalizeWeights() {
        Integer weight;
        MVDSource element;
        this.mSearchSumWeight = 0;
        this.mUpdateSumWeight = 0;
        Iterator iter = this.mActiveSearchSources.iterator();
        while (iter.hasNext()) {
            element = (MVDSource)iter.next();
            weight = (Integer)this.mSearchWeights.get(element.getSrcID());
            this.mSearchSumWeight += weight.intValue();
        }
        iter = this.mActiveUpdateSources.iterator();
        while (iter.hasNext()) {
            element = (MVDSource)iter.next();
            weight = (Integer)this.mUpdateWeights.get(element.getSrcID());
            this.mUpdateSumWeight += weight.intValue();
        }
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public String getUniqueName() {
        if (this.mUniqueName == null) {
            String tmp = this.mId + this.mName.replace(' ', '_');
            this.mUniqueName = tmp.length() <= 10 ? tmp : tmp.substring(0, 10);
        }
        return this.mUniqueName;
    }

    public void setEnabled(boolean aEnabled) {
        this.mEnabled = aEnabled;
    }

    public void setMarkAsDown(int aMarkAsDown) {
        this.mMarkAsDown = aMarkAsDown;
    }

    public int getId() {
        return this.mId;
    }

    public void setId(int aId) {
        this.mId = aId;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String aName) {
        this.mName = aName;
    }

    public void setSearchWeight(String aWeights) {
        Vector lines = MVDUtil.splitString(aWeights, ',');
        Iterator iter = lines.iterator();
        while (iter.hasNext()) {
            String line = (String)iter.next();
            Vector fields = MVDUtil.splitString(line, "::");
            boolean enabled = Boolean.valueOf((String)fields.elementAt(0));
            String srcID = (String)fields.elementAt(1);
            int searchPercentage = Integer.parseInt((String)fields.elementAt(2));
            if (!enabled) continue;
            this.mSearchWeights.put(srcID, new Integer(searchPercentage));
        }
    }

    public void setUpdateWeight(String aWeights) {
        Vector lines = MVDUtil.splitString(aWeights, ',');
        Iterator iter = lines.iterator();
        while (iter.hasNext()) {
            String line = (String)iter.next();
            Vector fields = MVDUtil.splitString(line, "::");
            boolean enabled = Boolean.valueOf((String)fields.elementAt(0));
            String srcID = (String)fields.elementAt(1);
            int searchPercentage = Integer.parseInt((String)fields.elementAt(2));
            if (!enabled) continue;
            this.mUpdateWeights.put(srcID, new Integer(searchPercentage));
        }
    }

    public void setSearchAlgorithm(int aAlgorithm) {
        this.mSearchAlgorithm = aAlgorithm;
    }

    public void setUpdateAlgorithm(int aAlgorithm) {
        this.mUpdateAlgorithm = aAlgorithm;
    }

    public void connectReferencesAndNormalize() throws MVDConfigException {
        Object x;
        String srcid;
        Iterator siter = this.mSearchWeights.keySet().iterator();
        while (siter.hasNext()) {
            srcid = (String)siter.next();
            x = this.mAllSources.get(srcid);
            if (x == null) {
                throw new MVDConfigException("Source " + srcid + " Referenced in LoadBalancingGroup " + this.mName + ", but not defined.");
            }
            this.mActiveSearchSources.add(x);
        }
        siter = this.mUpdateWeights.keySet().iterator();
        while (siter.hasNext()) {
            srcid = (String)siter.next();
            x = this.mAllSources.get(srcid);
            if (x == null) {
                throw new MVDConfigException("Source " + srcid + " Referenced in LoadBalancingGroup " + this.mName + ", but not defined.");
            }
            this.mActiveUpdateSources.add(x);
        }
        this.normalizeWeights();
    }

    public void addSource(MVDSource aSource) {
        this.mAllSources.put(aSource.getSrcID(), aSource);
    }

    public void setUniqueName(String aName) {
        this.mUniqueName = aName;
    }
}

