/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.asn1.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

public class HexOutputStream
extends OutputStream {
    protected PrintWriter print = new PrintWriter(System.out, true);
    private int n;
    private boolean bol = true;
    public static final char[] hexdigitsUC = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final char[] hexdigitsLC = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public int newline = 16;
    public int separate = 1;
    public int offset;
    public String flushMarker = "";
    public boolean lowercase = false;

    public HexOutputStream() {
    }

    public HexOutputStream(OutputStream outputstream) {
        this.print = new PrintWriter(outputstream, true);
    }

    public HexOutputStream(PrintWriter printwriter) {
        this.print = printwriter;
    }

    public void startNewLine() {
        if (!this.bol) {
            this.insertNewLine();
        }
    }

    public void resetOffset() {
        this.n = 0;
        this.startNewLine();
    }

    protected void insertNewLine() {
        this.print.println();
        this.bol = true;
    }

    protected void insertBlank() {
        this.print.print(' ');
    }

    protected void insertOffsetLabel(int i) {
        char[] cs;
        int i_0_ = this.offset;
        char[] cArray = cs = this.lowercase ? hexdigitsLC : hexdigitsUC;
        while (--i_0_ >= 0) {
            this.print.print(cs[i >>> i_0_ * 4 & 0xF]);
        }
        this.print.print(": ");
    }

    public void write(int i) throws IOException {
        byte[] is = new byte[]{(byte)i};
        this.write(is);
    }

    public void write(byte[] is) throws IOException {
        this.write(is, 0, is.length);
    }

    public void write(byte[] is, int i, int i_1_) throws IOException {
        char[] cs;
        char[] cArray = cs = this.lowercase ? hexdigitsLC : hexdigitsUC;
        while (i_1_-- > 0) {
            if (this.bol & this.offset > 0) {
                this.insertOffsetLabel(this.n);
            }
            this.bol = false;
            this.print.print(cs[is[i] >> 4 & 0xF]);
            this.print.print(cs[is[i] & 0xF]);
            ++this.n;
            if (this.newline > 0 && this.n % this.newline == 0) {
                this.insertNewLine();
            } else if (this.separate > 0 && this.n % this.separate == 0) {
                this.insertBlank();
            }
            ++i;
        }
    }

    public void flush() {
        this.print.print(this.flushMarker);
        this.print.flush();
    }

    public void close() throws IOException {
        this.resetOffset();
        this.print.close();
    }
}

