/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.asn1.util;

import com.sap.idm.vds.asn1.util.Comparable;
import com.sap.idm.vds.asn1.util.Constants;
import com.sap.idm.vds.asn1.util.CopyInByteData;
import com.sap.idm.vds.asn1.util.CopyOutByteData;
import java.io.Serializable;
import java.util.Random;

public final class BigInt
implements Comparable,
Constants,
Serializable {
    public static final int MASK = Integer.MAX_VALUE;
    public static final int BITSPERDIGIT = 31;
    public static final long RADIX = 0x80000000L;
    public static final BigInt ZERO = new BigInt(0L);
    public static final BigInt ONE = new BigInt(1L);
    public static final BigInt NEGATIVE_ONE = new BigInt(-1L);
    public static final BigInt TWO = new BigInt(2L);
    public static final BigInt NEGATIVE_TWO = new BigInt(-2L);
    public static final BigInt THREE = new BigInt(3L);
    public static final BigInt NEGATIVE_THREE = new BigInt(-3L);
    public static final BigInt FERMAT4 = new BigInt(65537L);
    public static final BigInt MIN_INT_VALUE = new BigInt(Integer.MIN_VALUE);
    public static final BigInt MAX_INT_VALUE = new BigInt(Integer.MAX_VALUE);
    public static final BigInt MIN_LONG_VALUE = new BigInt(Long.MIN_VALUE);
    public static final BigInt MAX_LONG_VALUE = new BigInt(Long.MAX_VALUE);
    public static final int POS = 0;
    public static final int NEG = Integer.MIN_VALUE;
    private static final int MSDMASK = Integer.MAX_VALUE;
    int signNmsd;
    int[] digits;
    private static final int QUOTIENT = 1;
    private static final int REMAINDER = 2;
    static final int GCD = 0;
    static final int INV = 1;
    static final int XEU = 2;
    private static short[] smallPrimes = new short[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233};

    private BigInt(int i, int[] is) {
        this.signNmsd = i == Integer.MIN_VALUE ? 0 : i;
        this.digits = is;
    }

    private BigInt(int i, int i_0_, int[] is) {
        while (i_0_ >= 0 && is[i_0_] == 0) {
            --i_0_;
        }
        if (i_0_ < 0) {
            this.digits = BigInt.ZERO.digits;
            i = 0;
        } else {
            this.digits = is;
        }
        this.signNmsd = i | i_0_ + 1;
    }

    public BigInt(long l) {
        if (l < 0L) {
            l = -l;
            this.signNmsd = Integer.MIN_VALUE;
        } else {
            this.signNmsd = 0;
        }
        this.digits = (l & 0xC000000000000000L) != 0L ? new int[3] : (l >= 0x80000000L ? new int[2] : (l != 0L ? new int[1] : new int[0]));
        this.signNmsd |= this.digits.length;
        int i = 0;
        while (l != 0L) {
            this.digits[i] = (int)(l & Integer.MAX_VALUE);
            l >>>= 31;
            ++i;
        }
    }

    public BigInt(byte[] is) {
        this(is, true);
    }

    public BigInt(byte[] is, boolean bool) {
        this(is, 0, is.length, true, bool);
    }

    public BigInt(byte[] is, int i, int i_1_, boolean bool, boolean bool_2_) {
        CopyInByteData copyinbytedata = new CopyInByteData();
        copyinbytedata.copyIn(bool, bool_2_, is, i, i_1_, this);
    }

    public static int fatDigitsForBits(int i) {
        return (i + 31 - 1) / 31;
    }

    public boolean isZero() {
        return (this.signNmsd & Integer.MAX_VALUE) == 0;
    }

    public boolean isOne() {
        return (this.signNmsd & Integer.MAX_VALUE) == 1 && this.digits[0] == 1 && this.signNmsd >= 0;
    }

    public boolean isNegativeOne() {
        return (this.signNmsd & Integer.MAX_VALUE) == 1 && this.digits[0] == 1 && this.signNmsd < 0;
    }

    public boolean isPositive() {
        return this.signNmsd >= 0;
    }

    public boolean isNegative() {
        return this.signNmsd < 0;
    }

    public int sign() {
        if (this.signNmsd < 0) {
            return -1;
        }
        return 0;
    }

    public int lengthInDigits() {
        return this.signNmsd & Integer.MAX_VALUE;
    }

    public int lengthInUnits(int i, boolean bool) {
        return (this.lengthInBits() + (bool ? 0 : 1) + i - 1) / i;
    }

    public int lengthInBits() {
        if (this.isZero()) {
            return 0;
        }
        int i = (this.signNmsd & Integer.MAX_VALUE) - 1;
        int i_8_ = this.digits[i];
        int i_9_ = i * 31;
        while (i_8_ != 0) {
            if (i_8_ >= 256) {
                i_8_ >>>= 8;
                i_9_ += 8;
                continue;
            }
            i_8_ >>>= 1;
            ++i_9_;
        }
        return i_9_;
    }

    public int leastSignificantZeros() {
        int i_10_;
        if (this.isZero()) {
            return -1;
        }
        int i = this.lengthInDigits();
        int i_11_ = this.digits[i_10_];
        for (i_10_ = 0; i_10_ < i && (i_11_ = this.digits[i_10_]) == 0; ++i_10_) {
        }
        i_10_ *= 31;
        while ((i_11_ & 1) == 0) {
            i_11_ >>= 1;
            ++i_10_;
        }
        return i_10_;
    }

    public int digit(int i) {
        return this.digits[i];
    }

    public BigInt negate() {
        if (this.isZero()) {
            return this;
        }
        return new BigInt(this.signNmsd ^ Integer.MIN_VALUE, this.digits);
    }

    public BigInt abs() {
        if (this.isPositive()) {
            return this;
        }
        return new BigInt(this.signNmsd ^ Integer.MIN_VALUE, this.digits);
    }

    public BigInt withSign(int i) {
        if ((this.signNmsd ^ i) >= 0) {
            return this;
        }
        return new BigInt(this.signNmsd & Integer.MAX_VALUE | i & Integer.MIN_VALUE, this.digits);
    }

    public int test() {
        if (this.isNegative()) {
            return -1;
        }
        if (this.isZero()) {
            return 0;
        }
        return 1;
    }

    public boolean equals(Object object) {
        return object instanceof BigInt && BigInt.compare(this, (BigInt)object) == 0;
    }

    public boolean lessThan(BigInt bigint_12_) {
        return BigInt.compare(this, bigint_12_) < 0;
    }

    public boolean lessEqual(BigInt bigint_13_) {
        return BigInt.compare(this, bigint_13_) <= 0;
    }

    public boolean greaterThan(BigInt bigint_14_) {
        return BigInt.compare(this, bigint_14_) > 0;
    }

    public boolean greaterEqual(BigInt bigint_15_) {
        return BigInt.compare(this, bigint_15_) >= 0;
    }

    public int compareTo(Object object) {
        return BigInt.compare(this, (BigInt)object);
    }

    public int compare(BigInt bigint_16_) {
        return BigInt.compare(this, bigint_16_);
    }

    public static int compare(BigInt bigint, BigInt bigint_17_) {
        if (bigint.isNegative()) {
            if (bigint_17_.isNegative()) {
                return -1 * BigInt.compareDigits(bigint, bigint_17_);
            }
            return -1;
        }
        if (bigint.isZero()) {
            if (bigint_17_.isZero()) {
                return 0;
            }
            if (bigint_17_.isNegative()) {
                return 1;
            }
            return -1;
        }
        if (bigint_17_.isNegative()) {
            return 1;
        }
        return BigInt.compareDigits(bigint, bigint_17_);
    }

    private static int compareDigits(BigInt bigint, BigInt bigint_18_) {
        int[] is = bigint.digits;
        int[] is_19_ = bigint_18_.digits;
        int i = (bigint.signNmsd & Integer.MAX_VALUE) - 1;
        int i_20_ = (bigint_18_.signNmsd & Integer.MAX_VALUE) - 1;
        int i_21_ = i - i_20_;
        if (i_21_ != 0) {
            if (i_21_ < 0) {
                return -1;
            }
            return 1;
        }
        for (int i_22_ = i; i_22_ >= 0; --i_22_) {
            i_21_ = is[i_22_] - is_19_[i_22_];
            if (i_21_ == 0) continue;
            if (i_21_ < 0) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    public BigInt add(BigInt bigint_23_) {
        return BigInt.add(this, bigint_23_, Integer.MAX_VALUE);
    }

    public static BigInt add(BigInt bigint, BigInt bigint_24_) {
        return BigInt.add(bigint, bigint_24_, Integer.MAX_VALUE);
    }

    public BigInt add(BigInt bigint_25_, int i) {
        return BigInt.add(this, bigint_25_, i);
    }

    public static BigInt add(BigInt bigint, BigInt bigint_26_, int i) {
        int i_27_ = bigint.signNmsd ^ bigint_26_.signNmsd;
        if (i_27_ < 0) {
            if (bigint.signNmsd < 0) {
                return BigInt.subtract(Integer.MIN_VALUE, bigint, bigint_26_, i);
            }
            return BigInt.subtract(0, bigint, bigint_26_, i);
        }
        return BigInt.add(bigint.signNmsd & Integer.MIN_VALUE, bigint, bigint_26_, i);
    }

    private static BigInt add(int i, BigInt bigint, BigInt bigint_28_, int i_29_) {
        int i_39_;
        int[] is_37_;
        int i_35_;
        int[] is_34_;
        int i_33_;
        int[] is = bigint.digits;
        int[] is_30_ = bigint_28_.digits;
        int i_31_ = (bigint.signNmsd & Integer.MAX_VALUE) - 1;
        int i_32_ = (bigint_28_.signNmsd & Integer.MAX_VALUE) - 1;
        if (i_31_ < 0) {
            return new BigInt(i, i_29_ <= i_32_ ? i_29_ - 1 : i_32_, bigint_28_.digits);
        }
        if (i_32_ < 0) {
            return new BigInt(i, i_29_ <= i_31_ ? i_29_ - 1 : i_31_, bigint.digits);
        }
        if (i_31_ == i_32_) {
            i_33_ = i_31_;
            is_34_ = is;
            i_35_ = i_31_ + 1;
        } else if (i_31_ < i_32_) {
            i_33_ = i_31_;
            is_34_ = is_30_;
            i_35_ = i_32_ + 1;
        } else {
            i_33_ = i_32_;
            is_34_ = is;
            i_35_ = i_31_ + 1;
        }
        int i_36_ = i_35_ - 1;
        if (i_29_ > i_35_) {
            is_37_ = new int[i_35_ + 1];
        } else {
            is_37_ = new int[i_29_];
            i_35_ = i_29_ - 1;
            if (i_33_ > i_35_) {
                i_33_ = i_35_;
            }
            if (i_36_ > i_35_) {
                i_36_ = i_35_;
            }
        }
        int i_38_ = 0;
        for (i_39_ = 0; i_39_ <= i_33_; ++i_39_) {
            i_38_ = is[i_39_] + is_30_[i_39_] + i_38_;
            is_37_[i_39_] = i_38_ & Integer.MAX_VALUE;
            i_38_ >>>= 31;
        }
        while (i_38_ != 0 && i_39_ <= i_36_) {
            i_38_ = is_34_[i_39_] + i_38_;
            is_37_[i_39_] = i_38_ & Integer.MAX_VALUE;
            i_38_ >>>= 31;
            ++i_39_;
        }
        if (i_39_ <= i_35_ && i_38_ != 0) {
            is_37_[i_39_++] = i_38_;
            boolean bool = false;
        }
        if (i_39_ <= i_35_ && i_39_ <= i_36_) {
            System.arraycopy(is_34_, i_39_, is_37_, i_39_, i_36_ - i_39_ + 1);
        }
        return new BigInt(i, i_35_, is_37_);
    }

    public BigInt subtract(BigInt bigint_40_) {
        return BigInt.subtract(this, bigint_40_, Integer.MAX_VALUE);
    }

    public static BigInt subtract(BigInt bigint, BigInt bigint_41_) {
        return BigInt.subtract(bigint, bigint_41_, Integer.MAX_VALUE);
    }

    public BigInt subtract(BigInt bigint_42_, int i) {
        return BigInt.subtract(this, bigint_42_, i);
    }

    public static BigInt subtract(BigInt bigint, BigInt bigint_43_, int i) {
        int i_44_ = bigint.signNmsd ^ bigint_43_.signNmsd;
        if (i_44_ < 0) {
            if (bigint.signNmsd < 0) {
                return BigInt.add(Integer.MIN_VALUE, bigint, bigint_43_, i);
            }
            return BigInt.add(0, bigint, bigint_43_, i);
        }
        return BigInt.subtract(bigint.signNmsd & Integer.MIN_VALUE, bigint, bigint_43_, i);
    }

    public static BigInt subtract(int i, BigInt bigint, BigInt bigint_45_, int i_46_) {
        int i_60_;
        int[] is_58_;
        int i_57_;
        int i_51_;
        int[] is = bigint.digits;
        int[] is_47_ = bigint_45_.digits;
        int i_48_ = (bigint.signNmsd & Integer.MAX_VALUE) - 1;
        int i_49_ = (bigint_45_.signNmsd & Integer.MAX_VALUE) - 1;
        boolean bool = false;
        if (i_48_ < 0) {
            return new BigInt(Integer.MIN_VALUE ^ i, i_46_ <= i_49_ ? i_46_ - 1 : i_49_, bigint_45_.digits);
        }
        if (i_49_ < 0) {
            return new BigInt(i, i_46_ <= i_48_ ? i_46_ - 1 : i_48_, bigint.digits);
        }
        int i_50_ = i_48_ - i_49_;
        if (i_50_ == 0) {
            int i_52_;
            for (i_52_ = i_48_; i_52_ >= 0; --i_52_) {
                i_50_ = is[i_52_] - is_47_[i_52_];
                if (i_50_ == 0) continue;
                if (i_50_ >= 0) break;
                int[] is_53_ = is_47_;
                is_47_ = is;
                is = is_53_;
                int i_54_ = i_49_;
                i_49_ = i_48_;
                i_48_ = i_54_;
                break;
            }
            if (i_52_ < 0) {
                return ZERO;
            }
            i_51_ = i_52_;
        } else {
            if (i_50_ < 0) {
                int[] is_55_ = is_47_;
                is_47_ = is;
                is = is_55_;
                int i_56_ = i_49_;
                i_49_ = i_48_;
                i_48_ = i_56_;
            }
            i_51_ = i_48_;
        }
        int n = i_57_ = i_49_ < i_51_ ? i_49_ : i_51_;
        if (i_46_ > i_51_) {
            is_58_ = new int[i_51_ + 1];
        } else {
            is_58_ = new int[i_46_];
            i_51_ = i_46_ - 1;
            if (i_57_ > i_51_) {
                i_57_ = i_51_;
            }
        }
        int i_59_ = 0;
        for (i_60_ = 0; i_60_ <= i_57_; ++i_60_) {
            i_59_ = is[i_60_] - is_47_[i_60_] - i_59_;
            is_58_[i_60_] = i_59_ & Integer.MAX_VALUE;
            i_59_ >>>= 31;
        }
        while (i_59_ != 0 && i_60_ <= i_51_) {
            i_59_ = is[i_60_] - i_59_;
            is_58_[i_60_] = i_59_ & Integer.MAX_VALUE;
            i_59_ >>>= 31;
            ++i_60_;
        }
        if (i_60_ <= i_51_) {
            System.arraycopy(is, i_60_, is_58_, i_60_, i_51_ - i_60_ + 1);
        }
        return new BigInt(i_50_ & Integer.MIN_VALUE ^ i, i_51_, is_58_);
    }

    public BigInt shift(int i) {
        return BigInt.shift(this, i);
    }

    public static BigInt shift(BigInt bigint, int i) {
        if (i > 0) {
            return BigInt.shiftLeft(bigint, i, null);
        }
        if (i < 0) {
            return BigInt.shiftRight(bigint, -i, null);
        }
        return bigint;
    }

    public BigInt shiftRight(int i) {
        return BigInt.shiftRight(this, i, null);
    }

    public static BigInt shiftRight(BigInt bigint, int i) {
        return BigInt.shiftRight(bigint, i, null);
    }

    private static BigInt shiftRight(BigInt bigint, int i, BigInt bigint_61_) {
        if (i <= 0 || bigint.isZero()) {
            return bigint;
        }
        int i_62_ = i / 31;
        int i_63_ = i % 31;
        int i_64_ = 31 - i_63_;
        int[] is = bigint.digits;
        int i_65_ = (bigint.signNmsd & Integer.MAX_VALUE) - 1;
        if (i_62_ > i_65_) {
            return ZERO;
        }
        int i_66_ = i_65_ - i_62_ - (is[i_65_] >>> i_63_ == 0 ? 1 : 0);
        int[] is_67_ = bigint_61_ != null ? bigint_61_.digits : new int[i_66_ + 1];
        int i_68_ = is[i_62_++] >>> i_63_;
        int i_69_ = 0;
        while (i_62_ <= i_65_) {
            int i_70_ = is[i_62_];
            is_67_[i_69_] = i_68_ | i_70_ << i_64_ & Integer.MAX_VALUE;
            i_68_ = i_70_ >>> i_63_;
            ++i_69_;
            ++i_62_;
        }
        if (i_68_ != 0) {
            is_67_[i_69_++] = i_68_;
        }
        if (bigint_61_ != null) {
            bigint_61_.signNmsd = bigint.signNmsd & Integer.MIN_VALUE | i_69_;
            return bigint_61_;
        }
        return new BigInt(bigint.signNmsd & Integer.MIN_VALUE | i_69_, is_67_);
    }

    public BigInt shiftLeft(int i) {
        return BigInt.shiftLeft(this, i, null);
    }

    public static BigInt shiftLeft(BigInt bigint, int i) {
        return BigInt.shiftLeft(bigint, i, null);
    }

    private static BigInt shiftLeft(BigInt bigint, int i, BigInt bigint_71_) {
        int i_75_;
        if (i <= 0 || bigint.isZero()) {
            return bigint;
        }
        int i_72_ = i / 31;
        int[] is = bigint.digits;
        int i_73_ = i % 31;
        int i_74_ = 31 - i_73_;
        int i_76_ = i_75_ + i_72_ + (is[i_75_ = (bigint.signNmsd & Integer.MAX_VALUE) - 1] >>> i_74_ == 0 ? 0 : 1);
        int[] is_77_ = bigint_71_ != null ? bigint_71_.digits : new int[i_76_ + 1];
        int i_78_ = 0;
        int i_79_ = 0;
        while (i_79_ <= i_75_) {
            int i_80_ = is[i_79_];
            is_77_[i_72_] = i_80_ << i_73_ & Integer.MAX_VALUE | i_78_;
            i_78_ = i_80_ >>> i_74_;
            ++i_79_;
            ++i_72_;
        }
        if (i_78_ != 0) {
            is_77_[i_72_++] = i_78_;
        }
        if (bigint_71_ != null) {
            bigint_71_.signNmsd = bigint.signNmsd & Integer.MIN_VALUE | i_72_;
            return bigint_71_;
        }
        return new BigInt(bigint.signNmsd & Integer.MIN_VALUE | i_72_, is_77_);
    }

    public BigInt multiply(BigInt bigint_81_) {
        return BigInt.multiply(this, bigint_81_, Integer.MAX_VALUE, null);
    }

    public static BigInt multiply(BigInt bigint, BigInt bigint_82_) {
        return BigInt.multiply(bigint, bigint_82_, Integer.MAX_VALUE, null);
    }

    public BigInt multiply(BigInt bigint_83_, int i) {
        return BigInt.multiply(this, bigint_83_, i, null);
    }

    public static BigInt multiply(BigInt bigint, BigInt bigint_84_, int i) {
        return BigInt.multiply(bigint, bigint_84_, i, null);
    }

    public static BigInt multiply(BigInt bigint, BigInt bigint_85_, int i, BigInt bigint_86_) {
        int[] is_93_;
        int i_87_ = (bigint.signNmsd & Integer.MAX_VALUE) - 1;
        int i_88_ = (bigint_85_.signNmsd & Integer.MAX_VALUE) - 1;
        int i_89_ = i_87_ + i_88_ + 1;
        int[] is = bigint.digits;
        int[] is_90_ = bigint_85_.digits;
        if (i_87_ < 0 || i_88_ < 0) {
            if (bigint_86_ != null) {
                bigint_86_.signNmsd = 0;
                return bigint_86_;
            }
            return ZERO;
        }
        if (i_87_ < i_88_) {
            int i_91_ = i_87_;
            i_87_ = i_88_;
            i_88_ = i_91_;
            int[] is_92_ = is;
            is = is_90_;
            is_90_ = is_92_;
        }
        if (bigint_86_ != null) {
            is_93_ = bigint_86_.digits;
            if (is_93_.length <= i_89_) {
                i_89_ = is_93_.length - 1;
            }
        } else {
            if (i <= i_89_) {
                i_89_ = i - 1;
            }
            is_93_ = new int[i_89_ + 1];
        }
        long l = 0L;
        long l_94_ = 0L;
        int i_95_ = -1;
        i_95_ = 0;
        int i_97_ = 0;
        int i_96_ = 0;
        while (i_95_ <= i_89_) {
            int i_98_;
            if (i_95_ <= i_88_) {
                i_96_ = i_95_;
                i_97_ = 0;
                i_98_ = i_95_;
            } else if (i_95_ <= i_87_) {
                i_96_ = i_95_;
                i_97_ = 0;
                i_98_ = i_88_;
            } else {
                i_96_ = i_87_;
                i_97_ = i_95_ - i_87_;
                i_98_ = i_88_;
            }
            while (i_97_ <= i_98_) {
                if ((l += (long)is[i_96_] * (long)is_90_[i_97_]) < 0L) {
                    ++l_94_;
                    l &= Long.MAX_VALUE;
                }
                --i_96_;
                ++i_97_;
            }
            is_93_[i_95_++] = (int)l & Integer.MAX_VALUE;
            l = (l >>> 31) + (l_94_ << 32);
            l_94_ = 0L;
        }
        if (bigint_86_ != null) {
            while (i_89_ >= 0 && bigint_86_.digits[i_89_] == 0) {
                --i_89_;
            }
            bigint_86_.signNmsd = (bigint.signNmsd ^ bigint_85_.signNmsd) & Integer.MIN_VALUE | i_89_ + 1;
            return bigint_86_;
        }
        return new BigInt((bigint.signNmsd ^ bigint_85_.signNmsd) & Integer.MIN_VALUE, i_89_, is_93_);
    }

    public BigInt[] divide(BigInt bigint_99_) {
        return BigInt.divide(this, bigint_99_, Integer.MAX_VALUE);
    }

    public BigInt quotient(BigInt bigint_100_) {
        return BigInt.quotient(this, bigint_100_, Integer.MAX_VALUE);
    }

    public BigInt remainder(BigInt bigint_101_) {
        return BigInt.remainder(this, bigint_101_, Integer.MAX_VALUE);
    }

    public static BigInt[] divide(BigInt bigint, BigInt bigint_102_) {
        return (BigInt[])BigInt.divide(bigint, bigint_102_, 3, Integer.MAX_VALUE);
    }

    public static BigInt quotient(BigInt bigint, BigInt bigint_103_) {
        return (BigInt)BigInt.divide(bigint, bigint_103_, 1, Integer.MAX_VALUE);
    }

    public static BigInt remainder(BigInt bigint, BigInt bigint_104_) {
        return (BigInt)BigInt.divide(bigint, bigint_104_, 2, Integer.MAX_VALUE);
    }

    public BigInt[] divide(BigInt bigint_105_, int i) {
        return BigInt.divide(this, bigint_105_, i);
    }

    public BigInt quotient(BigInt bigint_106_, int i) {
        return BigInt.quotient(this, bigint_106_, i);
    }

    public BigInt remainder(BigInt bigint_107_, int i) {
        return BigInt.remainder(this, bigint_107_, i);
    }

    public static BigInt[] divide(BigInt bigint, BigInt bigint_108_, int i) {
        return (BigInt[])BigInt.divide(bigint, bigint_108_, 3, i);
    }

    public static BigInt quotient(BigInt bigint, BigInt bigint_109_, int i) {
        return (BigInt)BigInt.divide(bigint, bigint_109_, 1, i);
    }

    public static BigInt remainder(BigInt bigint, BigInt bigint_110_, int i) {
        return (BigInt)BigInt.divide(bigint, bigint_110_, 2, i);
    }

    private static Object divide(BigInt bigint, BigInt bigint_111_, int i, int i_112_) {
        if (bigint_111_.isZero()) {
            throw new ArithmeticException("Cannot divide by zero");
        }
        BigInt bigint_113_ = null;
        BigInt bigint_114_ = null;
        if (bigint.isZero()) {
            bigint_113_ = bigint_114_ = ZERO;
        } else {
            int i_115_ = bigint.signNmsd & Integer.MIN_VALUE;
            int i_116_ = bigint_111_.signNmsd < 0 ? i_115_ ^ Integer.MIN_VALUE : i_115_;
            switch (BigInt.compareDigits(bigint, bigint_111_)) {
                case 0: {
                    bigint_113_ = i_116_ < 0 ? NEGATIVE_ONE : ONE;
                    bigint_114_ = ZERO;
                    break;
                }
                case -1: {
                    bigint_113_ = ZERO;
                    bigint_114_ = i_112_ < bigint.lengthInDigits() ? new BigInt(bigint.sign(), i_112_ - 1, bigint.digits) : bigint;
                    break;
                }
                case 1: {
                    if ((bigint_111_.signNmsd & Integer.MAX_VALUE) == 1) {
                        if (bigint_111_.digits[0] == 1) {
                            bigint_113_ = new BigInt(i_116_, (i_112_ < bigint.lengthInDigits() ? i_112_ : bigint.lengthInDigits()) - 1, bigint.digits);
                            bigint_114_ = ZERO;
                            break;
                        }
                        if (i == 2) {
                            return BigInt.modSmall(bigint, bigint_111_.digits[0], i_115_);
                        }
                        return BigInt.divSmall(bigint, bigint_111_.digits[0], i, i_116_, i_115_, i_112_, false);
                    }
                    return BigInt.divBig(bigint, bigint_111_, i, i_116_, i_115_, i_112_, false);
                }
            }
        }
        return BigInt.resultDivMod(bigint_113_, bigint_114_, i);
    }

    private static Object resultDivMod(BigInt bigint, BigInt bigint_117_, int i) {
        switch (i) {
            case 1: {
                return bigint;
            }
            case 2: {
                return bigint_117_;
            }
        }
        BigInt[] bigints = new BigInt[]{bigint, bigint_117_};
        return bigints;
    }

    private static Object divSmall(BigInt bigint, int i, int i_118_, int i_119_, int i_120_, int i_121_, boolean bool) {
        int i_122_;
        int[] is = bigint.digits;
        int i_123_ = i_122_ + (is[i_122_ = (bigint.signNmsd & Integer.MAX_VALUE) - 1] / i > 0 ? 0 : -1);
        if (i_121_ <= i_123_) {
            i_123_ = i_121_ - 1;
        }
        int[] is_124_ = bool ? bigint.digits : new int[i_123_ + 1];
        int i_125_ = BigInt.divideByDigit(is_124_, is, i_122_, i);
        BigInt bigint_126_ = null;
        BigInt bigint_127_ = null;
        if ((i_118_ & 1) != 0) {
            bigint_126_ = new BigInt(i_119_, i_123_, is_124_);
        }
        if ((i_118_ & 2) != 0) {
            if (bool) {
                bigint.signNmsd = i_120_ | (i_125_ > 0 ? 1 : 0);
                bigint.digits[0] = i_125_;
                bigint_127_ = bigint;
            } else if (i_125_ != 0) {
                int[] is_128_ = new int[]{i_125_};
                bigint_127_ = new BigInt(i_120_ | is_128_.length, is_128_);
            } else {
                bigint_127_ = ZERO;
            }
        }
        return BigInt.resultDivMod(bigint_126_, bigint_127_, i_118_);
    }

    private static BigInt modSmall(BigInt bigint, int i, int i_129_) {
        int[] is = bigint.digits;
        int i_130_ = (bigint.signNmsd & Integer.MAX_VALUE) - 1;
        int i_131_ = BigInt.modulusByDigit(is, i_130_, i);
        if (i_131_ == 0) {
            return ZERO;
        }
        int[] is_132_ = new int[]{i_131_};
        return new BigInt(i_129_ | is_132_.length, is_132_);
    }

    private static int[] normalize(int[] is, int i, int i_133_, boolean bool) {
        int[] is_134_ = bool && i + 1 < is.length ? is : new int[i + 2];
        long l = 0L;
        for (int i_135_ = 0; i_135_ <= i; ++i_135_) {
            is_134_[i_135_] = (int)(l |= (long)is[i_135_] << i_133_) & Integer.MAX_VALUE;
            l >>>= 31;
        }
        is_134_[i_135_] = (int)l;
        return is_134_;
    }

    private static Object divBig(BigInt bigint, BigInt bigint_136_, int i, int i_137_, int i_138_, int i_139_, boolean bool) {
        int i_150_;
        boolean bool_147_;
        int[] is = bigint.digits;
        int[] is_140_ = bigint_136_.digits;
        int i_141_ = (bigint.signNmsd & Integer.MAX_VALUE) - 1;
        int i_142_ = (bigint_136_.signNmsd & Integer.MAX_VALUE) - 1;
        if (i_141_ < 0) {
            if (bool) {
                bigint.signNmsd = 0;
            }
            return BigInt.resultDivMod(ZERO, bool ? bigint : ZERO, i);
        }
        if (i_142_ == 0) {
            return BigInt.divSmall(bigint, is_140_[0], i, i_137_, i_138_, i_139_, bool);
        }
        int[] is_143_ = null;
        int i_144_ = 0;
        int i_145_ = i_141_ - i_142_;
        boolean bool_146_ = false;
        boolean bl = bool_147_ = (i & 1) != 0;
        for (long l = (long)is_140_[i_142_]; l < 0x40000000L; l <<= 1) {
            ++i_144_;
        }
        is = BigInt.normalize(is, i_141_, i_144_, bool);
        ++i_141_;
        if (i_144_ != 0) {
            is_140_ = BigInt.normalize(is_140_, i_142_, i_144_, false);
        }
        long l_148_ = is_140_[i_142_];
        long l_149_ = is_140_[i_142_ - 1];
        for (i_150_ = i_141_; i_150_ > i_142_; --i_150_) {
            long l_151_ = is[i_150_];
            long l_152_ = is[i_150_ - 1];
            long l_153_ = is[i_150_ - 2];
            long l_154_ = (l_151_ << 31) + l_152_;
            long l_155_ = l_151_ == l_148_ ? Integer.MAX_VALUE : l_154_ / l_148_;
            long l_156_ = (l_154_ - l_155_ * l_148_ << 31) + l_153_;
            long l_157_ = l_149_ * l_155_;
            while (l_157_ > l_156_) {
                l_157_ -= l_149_;
                l_156_ += l_148_ << 31;
                --l_155_;
            }
            int i_158_ = BigInt.divSub(is, i_150_ - i_142_ - 1, is_140_, i_142_, l_155_);
            if (bool_147_ && i_145_ < i_139_ && i_158_ != 0) {
                if (is_143_ == null) {
                    is_143_ = new int[i_145_ + 1];
                }
                is_143_[i_145_] = i_158_;
            }
            --i_145_;
        }
        BigInt bigint_159_ = null;
        BigInt bigint_160_ = null;
        if ((i & 1) != 0) {
            BigInt bigInt = bigint_159_ = is_143_ == null ? ZERO : new BigInt(i_137_ | is_143_.length, is_143_);
        }
        if ((i & 2) != 0) {
            i_141_ = i_150_;
            long l_161_ = 0L;
            while (i_150_ >= 0) {
                l_161_ = l_161_ << 31 | (long)is[i_150_];
                is[i_150_--] = (int)(l_161_ >> i_144_ & Integer.MAX_VALUE);
            }
            while (i_141_ >= 0 && is[i_141_] == 0) {
                --i_141_;
            }
            if (bool) {
                bigint.signNmsd = i_138_ | (i_139_ <= i_141_ ? i_139_ : i_141_ + 1);
                bigint.digits = is;
                bigint_160_ = bigint;
            } else {
                bigint_160_ = new BigInt(i_138_, i_139_ <= i_141_ ? i_139_ - 1 : i_141_, is);
            }
        }
        return BigInt.resultDivMod(bigint_159_, bigint_160_, i);
    }

    private static int divSub(int[] is, int i, int[] is_162_, int i_163_, long l) {
        long l_165_;
        int i_164_;
        block9: {
            block8: {
                if (l == 0L) {
                    return 0;
                }
                i_164_ = i;
                l_165_ = 0L;
                for (int i_166_ = 0; i_166_ <= i_163_; ++i_166_) {
                    l_165_ = (long)is_162_[i_166_] * l + l_165_;
                    int n = i_164_;
                    is[n] = is[n] - ((int)l_165_ & Integer.MAX_VALUE);
                    if (is[n] < 0) {
                        int n2 = i_164_;
                        is[n2] = is[n2] & Integer.MAX_VALUE;
                        l_165_ += 0x80000000L;
                    }
                    l_165_ >>>= 31;
                    ++i_164_;
                }
                if (l_165_ == 0L) break block8;
                int n = i_164_;
                is[n] = is[n] - (int)l_165_;
                if (is[n] < 0) break block9;
            }
            return (int)l;
        }
        int n = i_164_;
        is[n] = (int)((long)is[n] + 0x80000000L);
        l_165_ = 0L;
        i_164_ = i;
        for (int i_167_ = 0; i_167_ <= i_163_; ++i_167_) {
            l_165_ = (long)is[i_164_] + (long)is_162_[i_167_] + l_165_;
            is[i_164_] = (int)l_165_ & Integer.MAX_VALUE;
            l_165_ >>>= 31;
            ++i_164_;
        }
        if (l_165_ != 0L) {
            is[i_164_] = is[i_164_] + (int)l_165_ & Integer.MAX_VALUE;
        }
        return (int)(l - 1L);
    }

    private static int multByDigit(int[] is, int[] is_168_, int i, int i_169_, int i_170_) {
        long l = i_170_;
        long l_171_ = i_169_;
        int i_172_ = 0;
        while (i_172_ <= i) {
            l = (long)is_168_[i_172_] * l_171_ + l;
            is[i_172_++] = (int)(l & Integer.MAX_VALUE);
            l >>>= 31;
        }
        if (l != 0L) {
            is[i_172_++] = (int)l;
        }
        return i_172_ - 1;
    }

    private static int divideByDigit(int[] is, int[] is_173_, int i, int i_174_) {
        long l = 0L;
        while (i >= 0) {
            l = (long)is_173_[i] + (l << 31);
            if (i < is.length) {
                is[i] = (int)(l / (long)i_174_);
            }
            l %= (long)i_174_;
            --i;
        }
        return (int)l;
    }

    private static int modulusByDigit(int[] is, int i, int i_175_) {
        long l = 0L;
        while (i >= 0) {
            l = ((long)is[i] + (l << 31)) % (long)i_175_;
            --i;
        }
        return (int)l;
    }

    public BigInt power(BigInt bigint_176_) {
        return BigInt.power(this, bigint_176_, Integer.MAX_VALUE, null);
    }

    public BigInt power(BigInt bigint_177_, int i) {
        return BigInt.power(this, bigint_177_, i, null);
    }

    public static BigInt power(BigInt bigint, BigInt bigint_178_) {
        return BigInt.power(bigint, bigint_178_, Integer.MAX_VALUE, null);
    }

    public static BigInt power(BigInt bigint, BigInt bigint_179_, int i) {
        return BigInt.power(bigint, bigint_179_, i, null);
    }

    public BigInt modExp(BigInt bigint_180_, BigInt bigint_181_) {
        return BigInt.power(this, bigint_180_, Integer.MAX_VALUE, bigint_181_);
    }

    public static BigInt modExp(BigInt bigint, BigInt bigint_182_, BigInt bigint_183_) {
        return BigInt.power(bigint, bigint_182_, Integer.MAX_VALUE, bigint_183_);
    }

    static BigInt power(BigInt bigint, BigInt bigint_184_, int i, BigInt bigint_185_) {
        if (bigint_184_.isNegative()) {
            throw new ArithmeticException("Negative exponent");
        }
        if (bigint.isZero() || bigint.isOne() || bigint_184_.isOne()) {
            return bigint;
        }
        if (bigint_184_.isZero()) {
            return ONE;
        }
        int i_186_ = bigint.lengthInDigits();
        int i_187_ = i;
        int i_188_ = bigint_184_.lengthInBits();
        if (bigint_185_ != null) {
            int i_189_ = bigint_185_.lengthInDigits();
            long l = (long)(i_186_ > i_189_ ? i_186_ : i_189_) * 2L + (long)i_189_ + 2L;
            if (l > Integer.MAX_VALUE) {
                throw new ArithmeticException("Overflow in power");
            }
            i_187_ = (int)l;
        } else if (i_187_ == Integer.MAX_VALUE) {
            long l = (long)i_186_ << i_188_;
            if (i_188_ >= 31 || l > Integer.MAX_VALUE) {
                throw new ArithmeticException("Overflow in power");
            }
            i_187_ = (int)l;
        }
        BigInt bigint_190_ = new BigInt(1, new int[i_187_ + 1]);
        BigInt bigint_191_ = new BigInt(i_187_, new int[i_187_ + 1]);
        BigInt bigint_192_ = new BigInt(bigint.signNmsd, new int[i_187_ + 1]);
        BigInt bigint_193_ = new BigInt(i_187_, new int[i_187_ + 1]);
        System.arraycopy(bigint.digits, 0, bigint_192_.digits, 0, i_186_);
        bigint_190_.digits[0] = 1;
        int i_194_ = 0;
        while (true) {
            if ((bigint_184_.digits[i_194_ / 31] >> i_194_ % 31 & 1) != 0) {
                BigInt bigint_195_ = BigInt.multiply(bigint_192_, bigint_190_, i, bigint_191_);
                if (bigint_185_ != null) {
                    BigInt.divBig(bigint_195_, bigint_185_, 2, 0, bigint_195_.signNmsd & Integer.MIN_VALUE, i, true);
                    if (bigint_195_.isZero()) {
                        return ZERO;
                    }
                }
                bigint_191_ = bigint_190_;
                bigint_190_ = bigint_195_;
            }
            if (++i_194_ >= i_188_) break;
            BigInt bigint_196_ = BigInt.multiply(bigint_192_, bigint_192_, i, bigint_193_);
            if (bigint_185_ != null && !bigint_196_.isZero()) {
                BigInt.divBig(bigint_196_, bigint_185_, 2, 0, bigint_196_.signNmsd & Integer.MIN_VALUE, i, true);
            }
            bigint_193_ = bigint_192_;
            bigint_192_ = bigint_196_;
        }
        return bigint_190_;
    }

    public BigInt multInv(BigInt bigint_197_) {
        return BigInt.multInv(this, bigint_197_);
    }

    public static BigInt multInv(BigInt bigint, BigInt bigint_198_) {
        BigInt bigint_199_ = (BigInt)BigInt.extendedEuclid(bigint, bigint_198_, 1);
        if (bigint_199_.isNegative()) {
            bigint_199_ = bigint_198_.add(bigint_199_);
        }
        return bigint_199_.remainder(bigint_198_);
    }

    public BigInt gcd(BigInt bigint_200_) {
        return (BigInt)BigInt.extendedEuclid(this, bigint_200_, 0);
    }

    public static BigInt gcd(BigInt bigint, BigInt bigint_201_) {
        return (BigInt)BigInt.extendedEuclid(bigint, bigint_201_, 0);
    }

    public static BigInt[] extendedEuclid(BigInt bigint, BigInt bigint_202_) {
        return (BigInt[])BigInt.extendedEuclid(bigint, bigint_202_, 2);
    }

    static Object extendedEuclid(BigInt bigint, BigInt bigint_203_, int i) {
        BigInt bigint_204_ = ONE;
        BigInt bigint_205_ = bigint;
        BigInt bigint_206_ = ZERO;
        BigInt bigint_208_ = bigint_203_;
        while (!bigint_208_.isZero()) {
            BigInt bigint_209_ = BigInt.quotient(bigint_205_, bigint_208_);
            BigInt bigint_210_ = bigint_204_.subtract(bigint_209_.multiply(bigint_206_));
            BigInt bigint_207_ = bigint_205_.subtract(bigint_209_.multiply(bigint_208_));
            bigint_204_ = bigint_206_;
            bigint_205_ = bigint_208_;
            bigint_206_ = bigint_210_;
            bigint_208_ = bigint_207_;
        }
        if (i == 0) {
            return bigint_205_;
        }
        if (i == 1) {
            if (!bigint_205_.isOne()) {
                throw new ArithmeticException("Multiplicative inverse does not exist");
            }
            return bigint_204_;
        }
        BigInt[] bigints = new BigInt[]{bigint_204_, bigint_205_.subtract(bigint.multiply(bigint_204_)).quotient(bigint_203_), bigint_205_};
        return bigints;
    }

    private boolean hasSmallPrimeFactor() {
        int i = this.lengthInDigits();
        boolean bool = i > 1;
        for (int i_211_ = 0; i_211_ < smallPrimes.length; ++i_211_) {
            if (!bool && this.digits[0] <= smallPrimes[i_211_] || BigInt.modulusByDigit(this.digits, i - 1, smallPrimes[i_211_]) != 0) continue;
            return true;
        }
        return false;
    }

    public boolean isProbablePrime(int i, Random random) {
        BigInt bigint_212_ = this.abs();
        if (bigint_212_.equals(TWO) || bigint_212_.equals(THREE)) {
            return true;
        }
        if (bigint_212_.isZero() || bigint_212_.isOne() || bigint_212_.hasSmallPrimeFactor()) {
            return false;
        }
        return BigInt.probabilisticPrimeTest(bigint_212_, i, random);
    }

    private static boolean probabilisticPrimeTest(BigInt bigint, int i, Random random) {
        int i_213_ = i < 2 ? 1 : (i + 1) / 2;
        BigInt bigint_214_ = bigint.subtract(ONE);
        int i_215_ = bigint_214_.leastSignificantZeros();
        if (i_215_ == 0) {
            return false;
        }
        BigInt bigint_216_ = bigint_214_.shiftRight(i_215_);
        block0: while (--i_213_ >= 0) {
            BigInt bigint_217_;
            while ((bigint_217_ = BigInt.random(bigint_214_, random)).lessEqual(ONE)) {
            }
            BigInt bigint_218_ = bigint_217_.modExp(bigint_216_, bigint);
            int i_219_ = 0;
            while (true) {
                if (bigint_218_.isOne()) {
                    if (i_219_ <= 0) continue block0;
                    return false;
                }
                if (bigint_218_.equals(bigint_214_)) continue block0;
                if (++i_219_ >= i_215_) {
                    return false;
                }
                bigint_218_ = bigint_218_.multiply(bigint_218_).remainder(bigint);
            }
        }
        return true;
    }

    public static BigInt findProbablePrime(BigInt bigint, int i, BigInt bigint_220_, BigInt bigint_221_, Random random) {
        if (bigint_220_.lessThan(bigint) || bigint_220_.lessEqual(ONE)) {
            throw new IllegalArgumentException("Empty range for prime search");
        }
        if (bigint.lessEqual(TWO)) {
            return TWO;
        }
        if ((bigint.digits[0] & 1) == 0) {
            bigint = bigint.add(ONE);
        }
        if ((bigint_220_.digits[0] & 1) == 0) {
            bigint_220_ = bigint_220_.subtract(ONE);
        }
        if (bigint_221_.lessEqual(ZERO) || (bigint_221_.digits[0] & 1) == 1) {
            throw new IllegalArgumentException("Bad step value " + bigint_221_ + " in findProbablePrime");
        }
        int i_222_ = bigint.lengthInDigits() - 1;
        if (i_222_ == 0 && bigint.digits[0] <= smallPrimes[smallPrimes.length - 1]) {
            for (int i_223_ = smallPrimes.length - 2; i_223_ >= 0; --i_223_) {
                if (smallPrimes[i_223_] >= bigint.digits[0]) continue;
                return new BigInt(smallPrimes[i_223_ + 1]);
            }
            throw new Error("Never reached has been reached");
        }
        BigInt bigint_224_ = bigint_220_.subtract(bigint).quotient(bigint_221_);
        long[] ls = new long[smallPrimes.length];
        long[] ls_225_ = new long[smallPrimes.length];
        long l = 0L;
        long l_226_ = (bigint_224_.greaterThan(MAX_INT_VALUE) ? Integer.MAX_VALUE : bigint_224_.longValue()) - 1L;
        int i_227_ = bigint_221_.lengthInDigits() - 1;
        for (int i_228_ = 1; i_228_ < ls.length; ++i_228_) {
            ls[i_228_] = BigInt.modulusByDigit(bigint.digits, i_222_, smallPrimes[i_228_]);
            ls_225_[i_228_] = BigInt.modulusByDigit(bigint_221_.digits, i_227_, smallPrimes[i_228_]);
        }
        BigInt bigint_229_ = null;
        block2: while (l < l_226_) {
            for (int i_230_ = 1; i_230_ < ls.length; ++i_230_) {
                if ((ls[i_230_] + ls_225_[i_230_] * l) % (long)smallPrimes[i_230_] != 0L) continue;
                ++l;
                continue block2;
            }
            bigint_229_ = bigint.add(bigint_221_.multiply(new BigInt(l)));
            if (bigint_229_.isProbablePrime(i, random)) break;
            bigint_229_ = null;
            ++l;
        }
        return bigint_229_;
    }

    public String toString() {
        return this.toString(10);
    }

    public String toString(int i) {
        if (this.isZero()) {
            return "0";
        }
        int i_231_ = (this.signNmsd & Integer.MAX_VALUE) - 1;
        int i_232_ = (int)((double)((i_231_ + 1) * 31) * 0.693 / Math.log(i)) + 2;
        char[] cs = new char[i_232_];
        int[] is = new int[i_231_ + 1];
        int[] is_233_ = this.digits;
        while (i_231_ >= 0) {
            if (is_233_[i_231_] == 0) {
                --i_231_;
                continue;
            }
            cs[--i_232_] = Character.forDigit(BigInt.divideByDigit(is, is_233_, i_231_, i), i);
            is_233_ = is;
        }
        if (this.isNegative()) {
            cs[--i_232_] = 45;
        }
        return new String(cs, i_232_, cs.length - i_232_);
    }

    public int toInt() {
        return (int)this.toLong();
    }

    public long toLong() {
        int i_234_;
        if (this.isZero()) {
            return 0L;
        }
        long l = 0L;
        int i = this.signNmsd & Integer.MAX_VALUE;
        int n = i_234_ = i < 3 ? i - 1 : 2;
        while (i_234_ >= 0) {
            l = l << 31 | (long)this.digits[i_234_];
            --i_234_;
        }
        l &= Long.MAX_VALUE;
        if (this.isNegative()) {
            l = -l;
        }
        return l;
    }

    public int intValue() {
        int i = this.signNmsd & Integer.MAX_VALUE;
        if (i >= 2) {
            throw new ArithmeticException("BigInt value doesn't fit into an int");
        }
        if (this.isZero()) {
            return 0;
        }
        if (this.isNegative()) {
            return -this.digits[0];
        }
        return this.digits[0];
    }

    public long longValue() {
        int i = this.signNmsd & Integer.MAX_VALUE;
        if (i > 3 || i == 3 && this.digits[2] >= 2) {
            throw new ArithmeticException("BigInt value doesn't fit into a long");
        }
        if (this.isZero()) {
            return 0L;
        }
        long l = 0L;
        for (int i_235_ = i - 1; i_235_ >= 0; --i_235_) {
            l = l << 31 | (long)this.digits[i_235_];
        }
        if (this.isNegative()) {
            return -l;
        }
        return l;
    }

    public float floatValue() {
        return (float)this.doubleValue();
    }

    public double doubleValue() {
        int i_237_;
        double d = 0.0;
        double d_236_ = 0.0;
        int i = this.signNmsd & Integer.MAX_VALUE;
        for (i_237_ = i - 1; i_237_ >= 0 && i_237_ >= i - 4; --i_237_) {
            d *= 2.147483648E9;
            d = d_236_ = d + (double)this.digits[i_237_];
        }
        if (i_237_ >= 0) {
            d_236_ *= Math.pow(2.147483648E9, i_237_ + 1);
        }
        if (this.isNegative()) {
            return -d_236_;
        }
        return d_236_;
    }

    public static BigInt valueOf(String string) throws NumberFormatException {
        return BigInt.valueOf(string, 10);
    }

    public static BigInt valueOf(String string, int i) throws NumberFormatException {
        char c;
        int i_238_ = 0;
        int i_239_ = string.length();
        int i_240_ = 0;
        if (i_239_ > 0 && string.charAt(0) == '-') {
            i_240_ = Integer.MIN_VALUE;
            i_238_ = 1;
        }
        if (i_238_ >= i_239_) {
            throw new NumberFormatException("No digits");
        }
        while ((c = string.charAt(i_238_)) == '0') {
            if (++i_238_ < i_239_) continue;
            return ZERO;
        }
        if (Character.digit(c, i) < 0) {
            throw new NumberFormatException("Bad digit(s) for radix " + i + ": " + string);
        }
        int i_241_ = (int)((Math.log(Character.digit(c, i) + 1) + (double)(i_239_ - i_238_ - 1) * Math.log(i)) * 1.443 / 31.0);
        int[] is = new int[i_241_ + 1];
        int i_242_ = -1;
        while (i_238_ < i_239_) {
            int i_243_ = Character.digit(string.charAt(i_238_), i);
            if (i_243_ < 0) {
                throw new NumberFormatException(string + "(radix " + i + ")");
            }
            i_242_ = BigInt.multByDigit(is, is, i_242_, i, i_243_);
            ++i_238_;
        }
        if (i_242_ < 0) {
            return ZERO;
        }
        return new BigInt(i_240_, i_241_, is);
    }

    public static BigInt random(BigInt bigint, Random random) {
        if (bigint.isNegative() || bigint.isZero()) {
            throw new ArithmeticException("Random limit must be non-zero and positive");
        }
        int i = bigint.lengthInDigits() - 1;
        int[] is = null;
        boolean bool = false;
        do {
            int i_244_;
            if (bool) {
                i_244_ = random.nextInt() & Integer.MAX_VALUE;
            } else {
                i_244_ = (int)((double)((float)bigint.digits[i] * random.nextFloat()) + 0.5);
                if (i_244_ > bigint.digits[i]) {
                    i_244_ = bigint.digits[i];
                }
                boolean bl = bool = i_244_ < bigint.digits[i];
            }
            if (i_244_ == 0) continue;
            if (is == null) {
                is = new int[i + 1];
            }
            is[i] = i_244_ & Integer.MAX_VALUE;
        } while (--i >= 0);
        if (is == null) {
            return ZERO;
        }
        return new BigInt(bigint.signNmsd & Integer.MIN_VALUE | is.length, is);
    }

    public byte[] toByteArray() {
        return this.toByteArray(true, false);
    }

    public byte[] toByteArray(boolean bool, boolean bool_245_) {
        CopyOutByteData copyoutbytedata = new CopyOutByteData();
        return copyoutbytedata.copyOut(null, 0, bool, bool_245_, this);
    }

    public String debug(int i) {
        StringBuffer stringbuffer = new StringBuffer();
        int i_252_ = this.lengthInDigits();
        stringbuffer.append('<');
        stringbuffer.append(this.isNegative() ? (char)'-' : '+');
        if (i_252_ < this.digits.length) {
            stringbuffer.append('[');
        }
        for (int i_253_ = this.digits.length - 1; i_253_ >= 0; --i_253_) {
            stringbuffer.append(Integer.toString(this.digits[i_253_], i));
            if (i_253_ == i_252_) {
                stringbuffer.append(']');
            }
            if (i_253_ <= 0) continue;
            stringbuffer.append(' ');
        }
        stringbuffer.append(" / ");
        stringbuffer.append(this.digits.toString());
        stringbuffer.append('>');
        return stringbuffer.toString();
    }
}

