/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.asn1;

import com.sap.idm.vds.asn1.ASN1Exception;

public class ASN1Tag {
    public static final int UNIVERSAL_TAG_CLASS = 0;
    public static final int APPLICATION_TAG_CLASS = 1;
    public static final int CONTEXT_TAG_CLASS = 2;
    public static final int PRIVATE_TAG_CLASS = 3;
    public static final int INVALID = 0;
    public static final int BOOLEAN = 1;
    public static final int INTEGER = 2;
    public static final int BITSTRING = 3;
    public static final int OCTETSTRING = 4;
    public static final int NULL = 5;
    public static final int OBJECTIDENTIFIER = 6;
    public static final int OD = 7;
    public static final int EXTERNAL = 8;
    public static final int REAL = 9;
    public static final int ENUMERATION = 10;
    public static final int SEQUENCE = 16;
    public static final int SEQUENCEOF = 16;
    public static final int SET = 17;
    public static final int SETOF = 17;
    public static final int NUMERICSTRING = 18;
    public static final int PRINTABLESTRING = 19;
    public static final int T61STRING = 20;
    public static final int VIDEOTEXSTRING = 21;
    public static final int IA5STRING = 22;
    public static final int UTCTIME = 23;
    public static final int GENERALIZEDTIME = 24;
    public static final int GRAPHICSTRING = 25;
    public static final int VISIBLESTRING = 26;
    public static final int GENERALSTRING = 27;
    public static final int BMPSTRING = 30;
    private static final int TAG_CLASS_SHIFT = 30;
    private static final int TAG_NUMBER_MASK = 0x3FFFFFFF;
    private static final int TAG_CLASS_MASK = -1073741824;
    public static final int MAX_TAG_NUMBER = 0x3FFFFFFF;
    private static final String[] tagClasses = new String[]{"Universal", "Application", "Context", "Private"};
    private static final String[] universalTagNames = new String[]{"End-of-Indefinite-Encoding", "Boolean", "Integer", "BitString", "OctetString", "Null", "ObjectIdentifier", "OD", "External", "Real", "Enumeration", "11", "12", "13", "14", "15", "Sequence (of)", "Set (of)", "NumericString", "PrintableString", "T61String", "TeletexString", "IA5String", "UTCTime", "GeneralizedTime", "GraphicString", "VisibleString", "GeneralString"};
    private static long stringTags = 243007512L;

    public static boolean isUniversalStringTag(int i) {
        if (ASN1Tag.getTagClass(i) != 0) {
            throw new IllegalArgumentException("Tag is not universal");
        }
        if (i >= 64) {
            return false;
        }
        return (stringTags & (long)(1 << i)) != 0L;
    }

    public static int getTagClass(int i) {
        return i >>> 30;
    }

    public static int getTagNumber(int i) {
        return i & 0x3FFFFFFF;
    }

    public static int makeTag(int i, int i_0_) throws ASN1Exception {
        if (i_0_ < 0 || i_0_ > 0x3FFFFFFF) {
            throw new ASN1Exception("Illegal tag number");
        }
        return i << 30 | i_0_;
    }

    public static int makeUniversalTag(int i) throws ASN1Exception {
        return ASN1Tag.makeTag(0, i);
    }

    public static int makeContextTag(int i) throws ASN1Exception {
        return ASN1Tag.makeTag(2, i);
    }

    public static int makeApplicationTag(int i) throws ASN1Exception {
        return ASN1Tag.makeTag(1, i);
    }

    public static String universalTagNumberToString(int i) {
        if (ASN1Tag.getTagClass(i) != 0) {
            throw new IllegalArgumentException("Tag is not universal");
        }
        if (i >= universalTagNames.length) {
            return Integer.toString(i);
        }
        return universalTagNames[i];
    }

    public static String tagClassToString(int i) {
        return tagClasses[ASN1Tag.getTagClass(i)];
    }

    public static String tagToString(int i) {
        if (ASN1Tag.getTagClass(i) != 0) {
            return ASN1Tag.tagClassToString(i) + " " + Integer.toString(ASN1Tag.getTagNumber(i));
        }
        return ASN1Tag.tagClassToString(i) + " " + ASN1Tag.universalTagNumberToString(i);
    }
}

