/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.asn1;

import com.sap.idm.vds.asn1.ASN1Decoder;
import com.sap.idm.vds.asn1.ASN1Encoder;
import com.sap.idm.vds.asn1.ASN1Exception;
import com.sap.idm.vds.asn1.ASN1Type;
import com.sap.idm.vds.asn1.util.Comparable;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public final class ASN1OID
implements ASN1Type,
Comparable,
Serializable {
    public static final int PREFIX = -2;
    public static final int LESS = -1;
    public static final int EQUAL = 0;
    public static final int GREATER = 1;
    public static final int EXTENSION = 2;
    private int[] ids;
    private String nm;
    private static Hashtable internedOIDs = new Hashtable();
    private static Hashtable namedInterns = new Hashtable();

    public ASN1OID(String string, String string_0_) {
        int i = string_0_.length();
        int i_1_ = 0;
        boolean bool = false;
        int i_2_ = 0;
        char c = '\u0000';
        int[] is = new int[100];
        String string_3_ = null;
        if (string_0_.charAt(i_1_) == '{') {
            if (string_0_.charAt(i - 1) != '}') {
                throw new IllegalArgumentException("No terminating }");
            }
            ++i_1_;
            --i;
        }
        int i_4_ = i_1_;
        while (true) {
            if (i_4_ < i && ((c = string_0_.charAt(i_4_)) == ' ' || c == '\t' || c == '\n' || c == '\r')) {
                ++i_4_;
                continue;
            }
            int i_5_ = i_4_;
            int c_6_ = 88;
            if (i_4_ < i && ((c = string_0_.charAt(i_4_)) == '-' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                while (i_4_ < i && (c = string_0_.charAt(i_4_)) != '(' && c != ',' && c != '.' && c != ' ' && c != '\t' && c != '\r' && c != '\n') {
                    ++i_4_;
                }
                if (i_4_ <= i && c == '(') {
                    ++i_4_;
                    c_6_ = c;
                } else {
                    if (string_3_ != null) {
                        throw new IllegalArgumentException("Already have OID prefix: " + string_3_ + " " + string_0_.substring(i_5_, i_4_));
                    }
                    string_3_ = string_0_.substring(i_5_, i_4_);
                    ASN1OID asn1oid_7_ = ASN1OID.find(string_3_);
                    if (asn1oid_7_ == null) {
                        throw new IllegalArgumentException("Unregistered ASN.1 OID: " + string_3_);
                    }
                    for (int i_8_ = 0; i_8_ < asn1oid_7_.ids.length; ++i_8_) {
                        is[i_2_++] = asn1oid_7_.ids[i_8_];
                    }
                    c_6_ = 0;
                }
            }
            if (c_6_ != 0) {
                long l = 0L;
                i_5_ = i_4_;
                while (i_4_ < i && (c = string_0_.charAt(i_4_)) >= '0' && c <= '9') {
                    ++i_4_;
                    if ((l = l * 10L + (long)(c - 48)) <= Integer.MAX_VALUE) continue;
                    throw new IllegalArgumentException("Components exceed int, position " + i_4_);
                }
                if (i_5_ == i_4_) {
                    throw new IllegalArgumentException("Illegal ASN.1 OID format: " + i_4_);
                }
                if (c_6_ == 40) {
                    if (i_4_ >= i || c != ')') {
                        throw new IllegalArgumentException("No closing paranthesis, position " + i_5_);
                    }
                    ++i_4_;
                }
                is[i_2_++] = (int)l;
            }
            while (i_4_ < i && ((c = string_0_.charAt(i_4_)) == ' ' || c == '\t' || c == '\n' || c == '\r')) {
                ++i_4_;
            }
            if (i_4_ >= i) break;
            c = string_0_.charAt(i_4_);
            if (c != '.' && c != ',') continue;
            ++i_4_;
        }
        if (i_2_ == 0) {
            throw new IllegalArgumentException("Empty ASN.1 OID");
        }
        this.ids = new int[i_2_];
        System.arraycopy(is, 0, this.ids, 0, i_2_);
        this.nm = string;
    }

    public ASN1OID(String string, ASN1OID asn1oid_9_) {
        this.ids = (int[])asn1oid_9_.ids.clone();
        this.nm = string;
    }

    public ASN1OID(String string, int[] is) {
        this(string, is, 0, is.length);
    }

    public ASN1OID(String string, ASN1OID asn1oid_10_, int[] is) {
        this(string, asn1oid_10_, is, 0, is.length);
    }

    public ASN1OID(String string, ASN1OID asn1oid_11_, int i) {
        int i_12_ = asn1oid_11_.ids.length;
        this.ids = new int[i_12_ + 1];
        System.arraycopy(asn1oid_11_.ids, 0, this.ids, 0, i_12_);
        this.ids[i_12_] = i;
        this.nm = string;
    }

    public ASN1OID(String string, ASN1OID asn1oid_13_, int[] is, int i, int i_14_) {
        int i_15_ = asn1oid_13_.ids.length;
        this.ids = new int[i_15_ + i_14_];
        System.arraycopy(asn1oid_13_.ids, 0, this.ids, 0, i_15_);
        System.arraycopy(is, 0, this.ids, i_15_, i_14_);
        this.nm = string;
    }

    public ASN1OID(String string, int[] is, int i, int i_16_) {
        this.ids = new int[i_16_];
        System.arraycopy(is, i, this.ids, 0, i_16_);
        this.nm = string;
    }

    public ASN1OID() {
        this.ids = null;
    }

    public void decode(ASN1Decoder asn1decoder) throws ASN1Exception {
        if (this.ids != null) {
            throw new SecurityException("Invalid decode operation");
        }
        ASN1OID asn1oid_17_ = asn1decoder.decodeObjectIdentifier();
        this.ids = asn1oid_17_.ids;
        this.nm = asn1oid_17_.nm;
    }

    public void encode(ASN1Encoder asn1encoder) throws ASN1Exception {
        asn1encoder.encodeObjectIdentifier(this);
    }

    public String name() {
        return this.nm;
    }

    public int level() {
        return this.ids.length;
    }

    public int nthComponent(int i) {
        return this.ids[i];
    }

    public int compareTo(Object object) {
        return this.compareTo((ASN1OID)object);
    }

    public int compareTo(ASN1OID asn1oid_18_) {
        int i = this.ids.length;
        int i_19_ = asn1oid_18_.ids.length;
        int i_20_ = i < i_19_ ? i : i_19_;
        for (int i_21_ = 0; i_21_ < i_20_; ++i_21_) {
            int i_22_ = this.ids[i_21_] - asn1oid_18_.ids[i_21_];
            if (i_22_ == 0) continue;
            if (i_22_ < 0) {
                return -1;
            }
            return 1;
        }
        if (i == i_19_) {
            return 0;
        }
        if (i < i_19_) {
            return -2;
        }
        return 2;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof ASN1OID)) {
            return object.equals(this);
        }
        return this.compareTo((ASN1OID)object) == 0;
    }

    public ASN1OID prefix(String string, int i) {
        return new ASN1OID(string, this.ids, 0, i);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer(this.ids.length * 6);
        stringbuffer.append(Integer.toString(this.ids[0]));
        for (int i = 1; i < this.ids.length; ++i) {
            stringbuffer.append('.');
            stringbuffer.append(Integer.toString(this.ids[i]));
        }
        return stringbuffer.toString();
    }

    public String toASN1String() {
        StringBuffer stringbuffer = new StringBuffer(this.ids.length * 6);
        stringbuffer.append("{ ");
        for (int i = 0; i < this.ids.length; ++i) {
            stringbuffer.append(Integer.toString(this.ids[i]));
            stringbuffer.append(' ');
        }
        stringbuffer.append('}');
        return stringbuffer.toString();
    }

    private static int hashNextComponent(int i, int i_24_) {
        return i << 3 ^ i_24_ ^ i >>> 29;
    }

    public int hashCode() {
        int i = 0;
        for (int i_25_ = 0; i_25_ < this.ids.length; ++i_25_) {
            i = ASN1OID.hashNextComponent(i, this.ids[i_25_]);
        }
        return i;
    }

    public ASN1OID intern() {
        ASN1OID asn1oid_26_ = (ASN1OID)internedOIDs.get(this);
        if (asn1oid_26_ != null) {
            return asn1oid_26_;
        }
        internedOIDs.put(this, this);
        if (this.nm != null && namedInterns.get(this.nm) == null) {
            namedInterns.put(this.nm, this);
        }
        return this;
    }

    public ASN1OID internedOrIdentity() {
        ASN1OID asn1oid_27_ = (ASN1OID)internedOIDs.get(this);
        if (asn1oid_27_ != null) {
            return asn1oid_27_;
        }
        return this;
    }

    public static ASN1OID find(String string) {
        return (ASN1OID)namedInterns.get(string);
    }

    public static Enumeration enumerateInternedOIDs() {
        return internedOIDs.keys();
    }
}

