/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds;

import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDUtil;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Hashtable;
import java.util.StringTokenizer;

class ReloadableClassLoader
extends ClassLoader {
    private Hashtable classes;
    private ClassLoader myClassLoader;
    private URLClassLoader myURLClassLoader;
    private final String CLASSPATH = System.getProperty("java.class.path");
    private File[] CLASSPATH_DIRS;

    ReloadableClassLoader(String aWorkArea, URLClassLoader aURLLoader) {
        this.classes = new Hashtable();
        this.myURLClassLoader = aURLLoader;
        this.myClassLoader = this.getClass().getClassLoader();
        StringTokenizer st = new StringTokenizer(this.CLASSPATH, File.pathSeparator);
        int count = st.countTokens();
        this.CLASSPATH_DIRS = new File[count + 1];
        this.CLASSPATH_DIRS[0] = aWorkArea != null ? new File(aWorkArea) : new File(".");
        for (int i = 0; i < count; ++i) {
            this.CLASSPATH_DIRS[i + 1] = new File(st.nextToken());
        }
    }

    public Class loadDaClass(String name, boolean resolve) throws ClassNotFoundException {
        Object value = this.classes.get(name);
        if (value != null) {
            Class klass = (Class)value;
            if (resolve) {
                this.resolveClass(klass);
            }
            return klass;
        }
        byte[] data = MVDUtil.readFile(this.findFile(name));
        if (data != null) {
            return this.load(name, data, resolve);
        }
        Class<?> c = null;
        boolean bLoaded = false;
        try {
            MVDLogger.Log("Could not load class: " + name + " using VDS Classloader, using system classloader", 0);
            c = this.myClassLoader.loadClass(name);
            if (c != null) {
                MVDLogger.Log("Found class using system classloader", 0);
            } else {
                MVDLogger.Log("Could not load class using system classloader", 0);
            }
            if (resolve) {
                MVDLogger.Log("Not able to link class", 0);
            }
        }
        catch (ClassNotFoundException classexception) {
            try {
                c = super.loadClass(name);
                if (c != null) {
                    MVDLogger.Log("Found class using system classloader", 0);
                } else {
                    MVDLogger.Log("Could not load class using system classloader", 0);
                }
                if (resolve) {
                    MVDLogger.Log("Not able to link class", 0);
                }
            }
            catch (ClassNotFoundException classexception1) {
                MVDLogger.Log("Could not load class: " + classexception.getMessage(), 2);
                c = super.loadClass(name, resolve);
                MVDLogger.Log("super.loadClass did not throw exception", 2);
            }
        }
        return c;
    }

    private Class load(String name, byte[] data, boolean resolve) {
        Class<?> klass = this.defineClass(name, data, 0, data.length);
        if (resolve) {
            this.resolveClass(klass);
        }
        this.classes.put(name, klass);
        return klass;
    }

    private File findFile(String name) {
        String className = name + ".class";
        for (int i = 0; i < this.CLASSPATH_DIRS.length; ++i) {
            File file = new File(this.CLASSPATH_DIRS[i], className);
            if (!file.canRead()) continue;
            return file;
        }
        return null;
    }

    public URL getResource(String aName) {
        return this.myClassLoader.getResource(aName);
    }

    public InputStream getResourceAsStream(String aName) {
        return this.myClassLoader.getResourceAsStream(aName);
    }

    public Class loadClass(String aName) throws ClassNotFoundException {
        return this.myClassLoader.loadClass(aName);
    }
}

