/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds;

import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDSearchResults;
import com.sap.idm.vds.PartialResultCallbackHandler;
import java.util.Arrays;
import java.util.Vector;

public class PartialResultSender
extends Thread {
    private static int sMaxthread = 0;
    private Vector mResultBuffer = new Vector();
    private PartialResultCallbackHandler mSender;
    private boolean mSenderBusy = false;
    private String mRealSp;
    private String mVirtSp;
    private int mScope;
    private Vector mReqAttrs;
    private boolean mAlive = true;
    private int mMaxNumberOfPackets = 2;

    public PartialResultSender(PartialResultCallbackHandler aSender, String aRealSp, String aVirtSp, int aScope, String[] aReqAttrs) {
        super("PRC_" + sMaxthread++);
        this.mSender = aSender;
        this.mRealSp = aRealSp;
        this.mVirtSp = aVirtSp;
        this.mScope = aScope;
        this.mReqAttrs = new Vector<String>(Arrays.asList(aReqAttrs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(MVDSearchResults aRes) {
        MVDLogger.Log("Queuing partial result", 0);
        Vector vector = this.mResultBuffer;
        synchronized (vector) {
            this.mResultBuffer.add(aRes);
            this.mResultBuffer.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean i = false;
        while (this.mAlive) {
            MVDSearchResults tmp;
            Vector vector = this.mResultBuffer;
            synchronized (vector) {
                this.mSenderBusy = false;
                if (this.mResultBuffer.size() <= 0) {
                    try {
                        this.mResultBuffer.wait();
                    }
                    catch (Exception e) {
                        MVDLogger.Log("Exception waiting for resource", 7);
                    }
                }
                if (this.mResultBuffer.size() > 0) {
                    tmp = (MVDSearchResults)this.mResultBuffer.remove(0);
                    this.mSenderBusy = true;
                } else {
                    this.mSenderBusy = false;
                    tmp = null;
                }
            }
            if (tmp == null) continue;
            this.sendResults(tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldWait() {
        int x = 0;
        Vector vector = this.mResultBuffer;
        synchronized (vector) {
            x = this.mResultBuffer.size();
        }
        return x >= this.mMaxNumberOfPackets;
    }

    private void sendResults(MVDSearchResults aRes) {
        MVDLogger.Log("Sending partial result", 0);
        this.mSender.sendResults(aRes, this.mRealSp, this.mVirtSp, this.mScope, this.mReqAttrs);
        aRes.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasMoreResults() {
        Vector vector = this.mResultBuffer;
        synchronized (vector) {
            return this.mSenderBusy || this.mResultBuffer.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        while (this.hasMoreResults()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        this.mAlive = false;
        Vector vector = this.mResultBuffer;
        synchronized (vector) {
            this.mResultBuffer.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.mAlive = false;
        Vector vector = this.mResultBuffer;
        synchronized (vector) {
            this.mResultBuffer.clear();
            this.mResultBuffer.notify();
        }
    }

    public void setPackets(int aPackets) {
        this.mMaxNumberOfPackets = aPackets;
    }
}

