/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds;

import com.sap.idm.vds.MVDEngineData;
import com.sap.idm.vds.MVDHashMap;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDModAttrValues;
import com.sap.idm.vds.MVDOperationResult;
import com.sap.idm.vds.MVDSearchResults;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.asn1.BERDecoder;
import com.sap.idm.vds.asn1.BEREncoder;
import com.sap.idm.vds.config.MVDDataSource;
import com.sap.idm.vds.config.MVDDataSourceList;
import com.sap.idm.vds.config.MVDProxy;
import com.sap.idm.vds.ie.op.common.util.MVDMic_Util;
import com.sap.idm.vds.ldapv3.LDAPMessage;
import com.sap.idm.vds.message.MxContext;
import com.sap.idm.vds.message.MxResponse;
import com.sap.idm.vds.message.MxSearch;
import com.sap.idm.vds.util.HidedIDStoreOperations;
import com.sap.idm.vds.util.HidedJDBCOperations;
import com.sap.idm.vds.util.HidedJNDIOperations;
import com.sap.idm.vds.util.OneShutJNDI;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class MVDUtilities {
    public static HashMap DoDirectServerUsingBER(MVDEngineData aEngineData, String ip, int port, byte[] aMess) {
        int BIG_BUFFER_SIZE = 10000;
        int CONST_WAIT_FIRST = 4000;
        int BYTE_WORKING_MODE = 2;
        int VECTOR_WORKING_MODE = 3;
        int WorkingMode = 2;
        String defaultErrorMessage = "Not connected";
        Socket localS = null;
        try {
            localS = aEngineData.getTransparentAuthSocket();
            if (localS == null) {
                localS = new Socket(ip, port);
                aEngineData.setTransparentAuthSocket(localS);
            }
            OutputStream bOut = localS.getOutputStream();
            InputStream bIn = localS.getInputStream();
            BufferedInputStream bInBuff = new BufferedInputStream(bIn);
            localS.setSoTimeout(4000);
            BERDecoder mBerDecoder = new BERDecoder(bInBuff);
            Object masterStringBuffer = null;
            byte[] masterBuffer = null;
            Vector respVector = null;
            int previousBufferPos = 0;
            int currentBufferPos = 0;
            String SessionShouldcontinue = "STOP";
            switch (WorkingMode) {
                case 2: {
                    masterBuffer = new byte[10000];
                    break;
                }
                case 3: {
                    respVector = new Vector();
                    break;
                }
            }
            MVDLogger.LogDataToFile("TranspAuth_to", aMess);
            bOut.write(aMess);
            int responseType = 0;
            boolean bContinue = true;
            do {
                LDAPMessage anewresponse = new LDAPMessage();
                anewresponse.decode(mBerDecoder);
                BEREncoder mBerEncoder = new BEREncoder();
                mBerEncoder.init();
                anewresponse.encode(mBerEncoder);
                mBerEncoder.finish();
                byte[] smallBuffer = mBerEncoder.toByteArray();
                switch (WorkingMode) {
                    case 2: {
                        previousBufferPos = currentBufferPos;
                        System.arraycopy(smallBuffer, 0, masterBuffer, previousBufferPos, smallBuffer.length);
                        currentBufferPos = previousBufferPos + smallBuffer.length;
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                responseType = anewresponse.protocolOp.choiceId;
                if (responseType == 5) {
                    bContinue = false;
                    continue;
                }
                if (responseType != 1) continue;
                bContinue = false;
                SessionShouldcontinue = "STOP";
                int aCode = anewresponse.protocolOp.bindResponse.resultCode.value;
                SessionShouldcontinue = aCode == 14 || aCode == 0 ? "CONTINUE" : "STOP";
            } while (bContinue);
            HashMap<String, Object> reshash = new HashMap<String, Object>();
            switch (WorkingMode) {
                case 2: {
                    byte[] r = new byte[currentBufferPos];
                    if (currentBufferPos > 0) {
                        System.arraycopy(masterBuffer, 0, r, 0, currentBufferPos);
                    }
                    MVDLogger.LogDataToFile("TranspAuth_from", r);
                    reshash.put("SESSION_CONTINUES", SessionShouldcontinue);
                    reshash.put("RAW_RESPONSE", r);
                    return reshash;
                }
                case 3: {
                    break;
                }
            }
            return null;
        }
        catch (Throwable e) {
            MVDLogger.Log("Transparent auth failed: " + e, 2);
            try {
                aEngineData.setTransparentAuthSocket(null);
                if (localS != null) {
                    localS.close();
                }
                localS = null;
            }
            catch (Exception ee) {
                // empty catch block
            }
            HashMap<String, Object> reshash = new HashMap<String, Object>();
            reshash.put("SESSION_CONTINUES", "STOP");
            reshash.put("RAW_RESPONSE", MVDUtil.ToUTF8(defaultErrorMessage));
            return reshash;
        }
    }

    public static byte[] DoDirectServer(MVDEngineData aEngineData, String ip, int port, byte[] aMess) {
        int CONST_WAIT_FIRST = 4000;
        int CONST_WAIT_REST = 10;
        int SMALL_BUFFER_SIZE = 1024;
        int BIG_BUFFER_SIZE = 10000;
        boolean STRING_WORKING_MODE = true;
        int BYTE_WORKING_MODE = 2;
        int WorkingMode = 2;
        String defaultErrorMessage = "Not connected";
        Socket localS = null;
        try {
            localS = aEngineData.getTransparentAuthSocket();
            if (localS == null) {
                localS = new Socket(ip, port);
                aEngineData.setTransparentAuthSocket(localS);
            }
            OutputStream bOut = localS.getOutputStream();
            InputStream bIn = localS.getInputStream();
            BufferedInputStream bInBuff = new BufferedInputStream(bIn);
            MVDLogger.LogDataToFile("TranspAuth_to", aMess);
            bOut.write(aMess);
            localS.setSoTimeout(4000);
            int readBytes = 0;
            int previousBufferPos = 0;
            int currentBufferPos = 0;
            byte[] masterBuffer = null;
            StringBuffer masterStringBuffer = null;
            if (WorkingMode == 2) {
                masterBuffer = new byte[10000];
            } else {
                masterStringBuffer = new StringBuffer();
            }
            byte[] smallBuffer = new byte[1024];
            readBytes = bInBuff.read(smallBuffer);
            localS.setSoTimeout(10);
            while (readBytes >= 0) {
                if (readBytes <= 0) continue;
                if (WorkingMode == 2) {
                    previousBufferPos = currentBufferPos;
                    System.arraycopy(smallBuffer, 0, masterBuffer, previousBufferPos, readBytes);
                    currentBufferPos = previousBufferPos + readBytes;
                } else {
                    String tmpStr = new String(smallBuffer);
                    masterStringBuffer = masterStringBuffer.append(tmpStr.substring(0, readBytes));
                }
                smallBuffer = new byte[1024];
                try {
                    readBytes = bInBuff.read(smallBuffer);
                }
                catch (Exception e) {
                    readBytes = -1;
                }
            }
            System.out.println("Left the loop");
            if (WorkingMode == 2) {
                byte[] r = new byte[currentBufferPos];
                if (currentBufferPos > 0) {
                    System.arraycopy(masterBuffer, 0, r, 0, currentBufferPos);
                }
                MVDLogger.LogDataToFile("TranspAuth_from", r);
                return r;
            }
            byte[] bsr = masterStringBuffer.toString().getBytes();
            MVDLogger.LogDataToFile("TranspAuth_from", bsr);
            return bsr;
        }
        catch (Throwable e) {
            MVDLogger.Log("Transparent auth failed: " + e, 2);
            try {
                aEngineData.setTransparentAuthSocket(null);
                if (localS != null) {
                    localS.close();
                }
                localS = null;
            }
            catch (Exception ee) {
                // empty catch block
            }
            return defaultErrorMessage.getBytes();
        }
    }

    public static void fixDNSyntaxAttributes_MOD(String attributes, Vector attrNamesAndModValues, String virtSP, String realSP) {
        Vector candidates = MVDUtil.splitString(attributes, ",");
        for (int x = 0; x < attrNamesAndModValues.size(); ++x) {
            MVDModAttrValues modv = (MVDModAttrValues)attrNamesAndModValues.elementAt(x);
            String aName = modv.getAttrName();
            if (!candidates.contains(aName)) continue;
            for (int y = 0; y < modv.size(); ++y) {
                String t = (String)modv.elementAt(y);
                try {
                    t = MVDUtil.NiceDN(t);
                }
                catch (Exception e) {
                    // empty catch block
                }
                t = MVDUtilities.fixStartingPoint(t, realSP, virtSP);
                modv.setElementAt(t, y);
            }
        }
    }

    public static void fixDNSyntaxAttributes_ADD(String attributes, HashMap attrNamesAndValues, String virtSP, String realSP) {
        Vector candidates = MVDUtil.splitString(attributes, ",");
        for (int x = 0; x < candidates.size(); ++x) {
            String cand = (String)candidates.elementAt(x);
            Vector v = (Vector)attrNamesAndValues.get(cand);
            if (v == null) continue;
            for (int y = 0; y < v.size(); ++y) {
                String t = (String)v.elementAt(y);
                try {
                    t = MVDUtil.NiceDN(t);
                }
                catch (Exception e) {
                    // empty catch block
                }
                t = MVDUtilities.fixStartingPoint(t, realSP, virtSP);
                v.setElementAt(t, y);
            }
        }
    }

    public static String fixStartingPoint(String dn, String replace, String find) {
        if (dn == null || replace == null || find == null) {
            return dn;
        }
        String aDn = dn.trim();
        replace = replace.trim();
        if ((find = find.trim()).length() > 0) {
            if (!aDn.toLowerCase().endsWith(find.toLowerCase())) {
                return aDn;
            }
        } else {
            if (replace.length() > 0) {
                if (aDn.length() == 0) {
                    return replace;
                }
                return aDn + "," + replace;
            }
            return aDn;
        }
        aDn = aDn.substring(0, aDn.length() - find.length());
        if (aDn.length() == 0) {
            aDn = replace;
        } else if (aDn.endsWith(",")) {
            aDn = replace.length() > 0 ? aDn + replace : aDn.substring(0, aDn.length() - 1);
        } else {
            return dn;
        }
        return aDn;
    }

    public static String matchBracketTemplate(String dn, String template, HashMap result) {
        return MVDUtilities.matchBracketTemplateDelim(dn, template, result, " ");
    }

    public static String matchBracketTemplateDelim(String dn, String template, HashMap result, String delim) {
        String h;
        int ix;
        if (result == null) {
            return "ERROR:No result HashMap";
        }
        if (delim.startsWith("\"")) {
            delim = delim.substring(1, delim.length() - 1);
        }
        boolean bDN = false;
        boolean bTemplate = false;
        int index = dn.indexOf("\\,");
        if (index >= 0) {
            bDN = true;
            dn = MVDUtil.replace(dn, "\\,", "--**XX**--");
        }
        if ((index = template.indexOf("\\,")) >= 0) {
            bTemplate = true;
            template = MVDUtil.replace(template, "\\,", "--**XX**--");
        }
        boolean bDNEqual = false;
        index = dn.indexOf("\\=");
        if (index >= 0) {
            bDNEqual = true;
            dn = MVDUtil.replace(dn, "\\=", "--**YY**--");
        }
        Vector dnRDNs = MVDUtil.splitString(dn, ",");
        Vector templateRDNs = MVDUtil.splitString(template, ",");
        if (dnRDNs.size() != templateRDNs.size()) {
            return "ERROR";
        }
        if (bDN) {
            for (ix = 0; ix < dnRDNs.size(); ++ix) {
                h = (String)dnRDNs.elementAt(ix);
                h = MVDUtil.replace(h, "--**XX**--", "\\,");
                dnRDNs.remove(ix);
                dnRDNs.add(ix, h);
            }
        }
        if (bTemplate) {
            for (ix = 0; ix < templateRDNs.size(); ++ix) {
                h = (String)templateRDNs.elementAt(ix);
                h = MVDUtil.replace(h, "--**XX**--", "\\,");
                templateRDNs.remove(ix);
                templateRDNs.add(ix, h);
            }
        }
        int ls = templateRDNs.size();
        for (int x = ls - 1; x >= 0; --x) {
            String dnElem;
            String templateElem = (String)templateRDNs.elementAt(x);
            if (templateElem.equalsIgnoreCase(dnElem = (String)dnRDNs.elementAt(x))) continue;
            if (templateElem.indexOf("<") > -1) {
                String templateKey;
                Vector dnKeyAndValue = MVDUtil.splitString(dnElem, "=");
                Vector templateKeyAndValue = MVDUtil.splitString(templateElem, "=");
                String dnKey = (String)dnKeyAndValue.elementAt(0);
                if (dnKey.equalsIgnoreCase(templateKey = (String)templateKeyAndValue.elementAt(0))) {
                    Vector templateMultipleValues = MVDUtil.splitString((String)templateKeyAndValue.elementAt(1), delim);
                    Vector dnMultipleValues = MVDUtil.splitString((String)dnKeyAndValue.elementAt(1), delim);
                    if (dnMultipleValues.size() == templateMultipleValues.size()) {
                        for (int y = 0; y < templateMultipleValues.size(); ++y) {
                            if (bDNEqual) {
                                String h2 = MVDUtil.replace((String)dnMultipleValues.elementAt(y), "--**YY**--", "\\=");
                                result.put(templateMultipleValues.elementAt(y), h2);
                                continue;
                            }
                            result.put(templateMultipleValues.elementAt(y), dnMultipleValues.elementAt(y));
                        }
                        continue;
                    }
                    if (templateMultipleValues.size() == 1) {
                        result.put(templateKeyAndValue.elementAt(1), dnKeyAndValue.elementAt(1));
                        continue;
                    }
                    result.clear();
                    return "ERROR:Number of RDNs not equal";
                }
                result.clear();
                return "ERROR:Not equal RDN keys";
            }
            result.clear();
            return "ERROR:Not equal RDN keys";
        }
        return "OK";
    }

    public static boolean isBracketTemplateMatched(String dn, String template) {
        String h;
        int ix;
        boolean bDN = false;
        boolean bTemplate = false;
        int index = dn.indexOf("\\,");
        if (index >= 0) {
            bDN = true;
            dn = MVDUtil.replace(dn, "\\,", "--**XX**--");
        }
        if ((index = template.indexOf("\\,")) >= 0) {
            bTemplate = true;
            template = MVDUtil.replace(template, "\\,", "--**XX**--");
        }
        Vector dnRDNs = MVDUtil.splitString(dn, ",");
        Vector templateRDNs = MVDUtil.splitString(template, ",");
        if (dnRDNs.size() != templateRDNs.size()) {
            return false;
        }
        if (bDN) {
            for (ix = 0; ix < dnRDNs.size(); ++ix) {
                h = (String)dnRDNs.elementAt(ix);
                h = MVDUtil.replace(h, "--**XX**--", "\\,");
                dnRDNs.remove(ix);
                dnRDNs.add(ix, h);
            }
        }
        if (bTemplate) {
            for (ix = 0; ix < templateRDNs.size(); ++ix) {
                h = (String)templateRDNs.elementAt(ix);
                h = MVDUtil.replace(h, "--**XX**--", "\\,");
                templateRDNs.remove(ix);
                templateRDNs.add(ix, h);
            }
        }
        int ls = templateRDNs.size();
        for (int x = ls - 1; x >= 0; --x) {
            String dnElem;
            String templateElem = (String)templateRDNs.elementAt(x);
            if (templateElem.equalsIgnoreCase(dnElem = (String)dnRDNs.elementAt(x))) continue;
            if (templateElem.indexOf("<") > -1) {
                String templateKey;
                Vector dnKeyAndValue = MVDUtil.splitString(dnElem, "=");
                Vector templateKeyAndValue = MVDUtil.splitString(templateElem, "=");
                String dnKey = (String)dnKeyAndValue.elementAt(0);
                if (dnKey.equalsIgnoreCase(templateKey = (String)templateKeyAndValue.elementAt(0))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static String matchBracketTemplatePortion(String dn, String template, HashMap result) {
        if (result == null) {
            return "ERROR:No result HashMap";
        }
        if (template.length() == 0) {
            return "OK:Nothing to match";
        }
        Vector dnRDNs = MVDUtil.splitString(dn.toLowerCase(), ",");
        Vector templateRDNs = MVDUtil.splitString(template.toLowerCase(), ",");
        String templateElem = (String)templateRDNs.elementAt(0);
        Vector templateKeyAndValue = MVDUtil.splitString(templateElem, "=");
        String templateKey = (String)templateKeyAndValue.elementAt(0);
        int offset = 0;
        while (!((String)dnRDNs.elementAt(offset)).startsWith(templateKey + "=")) {
            if (++offset < dnRDNs.size()) continue;
            return "ERROR";
        }
        if (dnRDNs.size() < templateRDNs.size() + offset) {
            return "ERROR: DN too short for template";
        }
        int ls = templateRDNs.size();
        for (int x = ls - 1; x >= 0; --x) {
            String dnElem;
            templateElem = (String)templateRDNs.elementAt(x);
            if (templateElem.equalsIgnoreCase(dnElem = (String)dnRDNs.elementAt(x + offset))) continue;
            if (templateElem.indexOf("<") > -1) {
                Vector dnKeyAndValue = MVDUtil.splitString(dnElem, "=");
                templateKeyAndValue = MVDUtil.splitString(templateElem, "=");
                String dnKey = (String)dnKeyAndValue.elementAt(0);
                if (dnKey.equalsIgnoreCase(templateKey = (String)templateKeyAndValue.elementAt(0))) {
                    Vector templateMultipleValues = MVDUtil.splitString((String)templateKeyAndValue.elementAt(1), " ");
                    Vector dnMultipleValues = MVDUtil.splitString((String)dnKeyAndValue.elementAt(1), " ");
                    if (dnMultipleValues.size() == templateMultipleValues.size()) {
                        for (int y = 0; y < templateMultipleValues.size(); ++y) {
                            result.put(templateMultipleValues.elementAt(y), dnMultipleValues.elementAt(y));
                        }
                        continue;
                    }
                    if (templateMultipleValues.size() == 1) {
                        result.put(templateKeyAndValue.elementAt(1), dnKeyAndValue.elementAt(1));
                        continue;
                    }
                    result.clear();
                    return "ERROR:Number of RDNs not equal";
                }
                result.clear();
                return "ERROR:Not equal RDN keys";
            }
            result.clear();
            return "ERROR:Not equal RDN keys";
        }
        return "OK";
    }

    public static boolean IsBinaryAttribute(String attr) {
        return MVDProxy.IsBinaryAttribute(attr);
    }

    public static boolean TestCompare(String mvdDataSource, String startingpoint, String urlfilter) {
        String pwd;
        MVDDataSource ds = MVDDataSourceList.getDSByName(mvdDataSource);
        if (ds == null) {
            return false;
        }
        String server = (String)ds.ParamFields().get("DS_SERVER");
        String port = (String)ds.ParamFields().get("DS_PORT");
        String user = (String)ds.ParamFields().get("DS_USER");
        if (user == null) {
            user = "";
        }
        if ((pwd = (String)ds.ParamFields().get("DS_PASSWORD")) == null) {
            pwd = "";
        }
        MVDLogger.Log("Binding to '" + server + "' port:" + port, 2);
        OneShutJNDI osj = new OneShutJNDI();
        MVDSearchResults ss = osj.Compare(server, port, user, pwd, startingpoint, urlfilter);
        return ss.size() > 0;
    }

    public static boolean TestCompare(String mServer, String mPort, String mUser, String mPassword, String startingpoint, String urlfilter) {
        OneShutJNDI osj = new OneShutJNDI();
        MVDSearchResults ss = osj.Compare(mServer, mPort, mUser, mPassword, startingpoint, urlfilter);
        return ss.size() > 0;
    }

    public static boolean LdapCompare(String mServer, String mPort, String mUser, String mPassword, String startingpoint, int scope, String urlfilter, String securityProtocol, boolean cacheConnections, MVDHashMap engineGlobals) {
        HidedJNDIOperations hjo = new HidedJNDIOperations();
        MVDOperationResult ss = hjo.Compare(mServer, mPort, mUser, mPassword, startingpoint, urlfilter, securityProtocol, cacheConnections, engineGlobals);
        return ss.isOK();
    }

    public static MVDSearchResults RawLdapSearch(String mServer, String mPort, String mUser, String mPassword, String startingpoint, int scope, Vector attr, String urlfilter, int szLimit, int tmLimit) {
        OneShutJNDI osj = new OneShutJNDI();
        return osj.Search(mServer, mPort, mUser, mPassword, startingpoint, scope, attr, urlfilter, szLimit, tmLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MVDSearchResults LdapInternalSearch(String startingpoint, int scope, Vector attr, String urlfilter, int szLimit, int tmLimit, String aSuperUser, String aPassword) {
        MxResponse res = null;
        MxContext internalServerConnection = null;
        try {
            try {
                internalServerConnection = new MxContext();
                internalServerConnection.bind(aSuperUser, aPassword, "127.0.0.1");
                MxSearch search = new MxSearch();
                search.setRequestedAttributes(attr);
                search.setOperationScope(scope);
                search.setRequestedFilter(urlfilter);
                search.setStartingPoint(startingpoint);
                search.setSizeLimit(szLimit);
                res = internalServerConnection.answerRequest(search);
                internalServerConnection.close();
                internalServerConnection = null;
            }
            catch (Exception e) {
                if (internalServerConnection != null) {
                    internalServerConnection.close();
                    internalServerConnection = null;
                }
                res = new MxResponse();
                res.setError(82, e.getMessage());
                Object var12_13 = null;
                if (internalServerConnection != null) {
                    internalServerConnection.close();
                    internalServerConnection = null;
                }
            }
            Object var12_12 = null;
            if (internalServerConnection != null) {
                internalServerConnection.close();
                internalServerConnection = null;
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (internalServerConnection != null) {
                internalServerConnection.close();
                internalServerConnection = null;
            }
            throw throwable;
        }
        return (MVDSearchResults)res;
    }

    public static MVDSearchResults LdapSearch(String mServer, String mPort, String mUser, String mPassword, String startingpoint, int scope, Vector attr, String urlfilter, int szLimit, int tmLimit, String securityProtocol, String additionalBinaryAttributes, boolean cacheConnections, MVDHashMap engineGlobals) {
        HidedJNDIOperations hjo = new HidedJNDIOperations();
        return hjo.Search(mServer, mPort, mUser, mPassword, startingpoint, scope, attr, urlfilter, szLimit, tmLimit, securityProtocol, additionalBinaryAttributes, cacheConnections, engineGlobals);
    }

    public static MVDSearchResults LdapPagedSearch(String mServer, String mPort, String mUser, String mPassword, String startingpoint, int scope, Vector attr, String urlfilter, int szLimit, int tmLimit, String securityProtocol, String additionalBinaryAttributes, boolean cacheConnections, MVDHashMap engineGlobals, int aPageSize) {
        HidedJNDIOperations hjo = new HidedJNDIOperations();
        return hjo.PagedSearch(mServer, mPort, mUser, mPassword, startingpoint, scope, attr, urlfilter, szLimit, tmLimit, securityProtocol, additionalBinaryAttributes, cacheConnections, engineGlobals, aPageSize);
    }

    public static boolean TestConnect(String mvdDataSource, String replaceUser, String replacePwd, String aUser, String aPassword) {
        MVDDataSource ds = MVDDataSourceList.getDSByName(mvdDataSource);
        if (ds == null) {
            return false;
        }
        String conString = (String)ds.ParamFields().get("DS_DATABASE");
        conString = MVDUtil.replace(conString, replaceUser, aUser);
        conString = MVDUtil.replace(conString, replacePwd, aPassword);
        boolean res = MVDUtilities.TestConnect(conString);
        return res;
    }

    public static boolean TestConnect(String mDatabaseConnString) {
        HidedJDBCOperations hjdbco = new HidedJDBCOperations();
        MVDLogger.Log("Connecting : " + mDatabaseConnString, 2);
        return hjdbco.testConnection(mDatabaseConnString);
    }

    public static MVDSearchResults JdbcSearch(String mDatabaseConnString, String mQuery, String additionalBinaryAttributes, boolean cacheConnections) {
        HidedJDBCOperations hjdbco = new HidedJDBCOperations();
        return hjdbco.Search(mDatabaseConnString, mQuery, additionalBinaryAttributes, cacheConnections);
    }

    public static MVDSearchResults IDStoreSearch(String aDatabaseConnString, String mQuery, boolean bBaseCollect, boolean cacheConnections) {
        try {
            HidedIDStoreOperations hjdbco = new HidedIDStoreOperations();
            return hjdbco.Search(aDatabaseConnString, mQuery, bBaseCollect, cacheConnections, 1);
        }
        catch (Exception e) {
            return new MVDSearchResults();
        }
    }

    public static MVDOperationResult IDStoreModify(String aDatabaseConnString, String is_id, String aID, Vector aValues, boolean cacheConnections) {
        try {
            HidedIDStoreOperations hjdbco = new HidedIDStoreOperations(aDatabaseConnString, cacheConnections);
            return hjdbco.Modify(is_id, aID, aValues);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new MVDOperationResult();
        }
    }

    public static MVDOperationResult IDStoreAdd(String aDatabaseConnString, String is_id, String aID, HashMap aValues, boolean cacheConnections) {
        try {
            HidedIDStoreOperations hjdbco = new HidedIDStoreOperations(aDatabaseConnString, cacheConnections);
            return hjdbco.Add(is_id, aID, aValues);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new MVDOperationResult();
        }
    }

    public static MVDOperationResult IDStoreDelete(String aDatabaseConnString, String is_id, String aID, boolean cacheConnections) {
        try {
            HidedIDStoreOperations hjdbco = new HidedIDStoreOperations(aDatabaseConnString, cacheConnections);
            return hjdbco.Delete(is_id, aID);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new MVDOperationResult();
        }
    }

    public static MVDSearchResults JdbcPreparedSearch(String mDatabaseConnString, String aPrepStmtQuery, MVDHashMap parEngineGlobals, String value) {
        HidedJDBCOperations hjdbco = new HidedJDBCOperations();
        return hjdbco.PreparedSearch(mDatabaseConnString, aPrepStmtQuery, parEngineGlobals, value);
    }

    public static MVDSearchResults JdbcBaseSearch(String mvdDataSource, String dn, String query, String dntemplate) {
        MVDDataSource ds = MVDDataSourceList.getDSByName(mvdDataSource);
        if (ds == null) {
            return null;
        }
        HashMap tmpHashmap = new HashMap();
        String conString = (String)ds.ParamFields().get("DS_DATABASE");
        String strRes = MVDUtilities.matchBracketTemplate(dn, dntemplate, tmpHashmap);
        if (!strRes.equals("OK")) {
            return null;
        }
        Iterator it = tmpHashmap.keySet().iterator();
        while (it.hasNext()) {
            String sss = (String)it.next();
            query = MVDUtil.replace(query, sss, (String)tmpHashmap.get(sss));
        }
        HidedJDBCOperations hjdbco = new HidedJDBCOperations();
        return hjdbco.Search(conString, query, "", true);
    }

    public static MVDOperationResult RawLdapModify(String mServer, String mPort, String mUser, String mPassword, String startingpoint, Vector attrNamesAndModValues) {
        OneShutJNDI osj = new OneShutJNDI();
        return osj.Modify(mServer, mPort, mUser, mPassword, startingpoint, attrNamesAndModValues);
    }

    public static MVDOperationResult LdapModify(String mServer, String mPort, String mUser, String mPassword, String startingpoint, Vector attrNamesAndModValues, String securityProtocol, String additionalBinaryAttributes, boolean cacheConnections, MVDHashMap engineGlobals) {
        HidedJNDIOperations hjo = new HidedJNDIOperations();
        return hjo.Modify(mServer, mPort, mUser, mPassword, startingpoint, attrNamesAndModValues, securityProtocol, additionalBinaryAttributes, cacheConnections, engineGlobals);
    }

    public static MVDOperationResult SetADPassword(String aServer, String aPort, String adminUser, String adminPassword, String username, String oldPassword, String newPassword) {
        OneShutJNDI osj = new OneShutJNDI();
        return osj.SetADPassword(aServer, aPort, adminUser, adminPassword, username, oldPassword, newPassword);
    }

    public static MVDOperationResult JdbcModify(String mDatabaseConnString, String aQuery, boolean cacheConnections) {
        HidedJDBCOperations hjdbco = new HidedJDBCOperations();
        return hjdbco.UpdateDB(mDatabaseConnString, aQuery, cacheConnections);
    }

    public static MVDOperationResult RawLdapAdd(String mServer, String mPort, String mUser, String mPassword, String startingpoint, HashMap attrNamesValues) {
        OneShutJNDI osj = new OneShutJNDI();
        return osj.Add(mServer, mPort, mUser, mPassword, startingpoint, attrNamesValues);
    }

    public static MVDOperationResult LdapAdd(String mServer, String mPort, String mUser, String mPassword, String startingpoint, HashMap attrNamesAndValues, String securityProtocol, String additionalBinaryAttributes, boolean cacheConnections, MVDHashMap engineGlobals) {
        HidedJNDIOperations hjo = new HidedJNDIOperations();
        return hjo.Add(mServer, mPort, mUser, mPassword, startingpoint, attrNamesAndValues, securityProtocol, additionalBinaryAttributes, cacheConnections, engineGlobals);
    }

    public static MVDOperationResult JdbcAdd(String mDatabaseConnString, String aQuery, boolean cacheConnections) {
        HidedJDBCOperations hjdbco = new HidedJDBCOperations();
        return hjdbco.UpdateDB(mDatabaseConnString, aQuery, cacheConnections);
    }

    public static MVDOperationResult RawLdapDelete(String mServer, String mPort, String mUser, String mPassword, String startingpoint) {
        OneShutJNDI osj = new OneShutJNDI();
        return osj.Delete(mServer, mPort, mUser, mPassword, startingpoint);
    }

    public static MVDOperationResult LdapDelete(String mServer, String mPort, String mUser, String mPassword, String startingpoint, String securityProtocol, boolean cacheConnections, MVDHashMap engineGlobals) {
        HidedJNDIOperations hjo = new HidedJNDIOperations();
        return hjo.Delete(mServer, mPort, mUser, mPassword, startingpoint, securityProtocol, cacheConnections, engineGlobals);
    }

    public static MVDOperationResult JdbcDelete(String mDatabaseConnString, String aQuery, boolean cacheConnections) {
        HidedJDBCOperations hjdbco = new HidedJDBCOperations();
        return hjdbco.UpdateDB(mDatabaseConnString, aQuery, cacheConnections);
    }

    public static boolean TestBind(String mvdDataSource, String aUser, String aPassword) {
        MVDDataSource ds = MVDDataSourceList.getDSByName(mvdDataSource);
        if (ds == null) {
            return false;
        }
        String server = (String)ds.ParamFields().get("DS_SERVER");
        String port = (String)ds.ParamFields().get("DS_PORT");
        MVDLogger.Log("Binding to '" + server + "' port:" + port, 2);
        boolean res = MVDUtilities.TestBind(server, port, aUser, aPassword);
        return res;
    }

    public static boolean TestBind(String mvdDataSource, String mPort, String aUser, String aPassword, String aSecurityProtocol) {
        MVDDataSource ds = MVDDataSourceList.getDSByName(mvdDataSource);
        if (ds == null) {
            return false;
        }
        String server = (String)ds.ParamFields().get("DS_SERVER");
        MVDLogger.Log("Binding to '" + server + "' port:" + mPort, 2);
        boolean res = MVDUtilities.TestBindSec(server, mPort, aUser, aPassword, aSecurityProtocol);
        return res;
    }

    public static boolean TestBind(String mServer, String mPort, String mUser, String mPassword) {
        OneShutJNDI osj = new OneShutJNDI();
        return osj.TestBind(mServer, mPort, mUser, mPassword);
    }

    public static boolean TestBindSec(String mServer, String mPort, String mUser, String mPassword, String aSecurityProtocol) {
        OneShutJNDI osj = new OneShutJNDI();
        return osj.TestBind(mServer, mPort, mUser, mPassword, aSecurityProtocol);
    }

    public static String RawLdapLookup(String mvdDataSource, int scope, String attr, String urlfilter) {
        String defaultstartingpoint;
        String password;
        MVDDataSource ds = MVDDataSourceList.getDSByName(mvdDataSource);
        if (ds == null) {
            return "";
        }
        String server = (String)ds.ParamFields().get("DS_SERVER");
        String port = (String)ds.ParamFields().get("DS_PORT");
        String user = (String)ds.ParamFields().get("DS_USER");
        if (user == null) {
            user = "";
        }
        if ((password = (String)ds.ParamFields().get("DS_PASSWORD")) == null) {
            password = "";
        }
        if ((defaultstartingpoint = (String)ds.ParamFields().get("DS_REALSP")) == null) {
            defaultstartingpoint = "";
        }
        return MVDUtilities.RawLdapLookup(server, port, user, password, defaultstartingpoint, scope, attr, urlfilter, 1);
    }

    public static String RawLdapLookup(String mvdDataSource, String startingpoint, int scope, String attr, String urlfilter, int returnType) {
        String password;
        MVDDataSource ds = MVDDataSourceList.getDSByName(mvdDataSource);
        if (ds == null) {
            return "";
        }
        String server = (String)ds.ParamFields().get("DS_SERVER");
        String port = (String)ds.ParamFields().get("DS_PORT");
        String user = (String)ds.ParamFields().get("DS_USER");
        if (user == null) {
            user = "";
        }
        if ((password = (String)ds.ParamFields().get("DS_PASSWORD")) == null) {
            password = "";
        }
        return MVDUtilities.RawLdapLookup(server, port, user, password, startingpoint, scope, attr, urlfilter, returnType);
    }

    public static String RawLdapLookup(String mServer, String mPort, String mUser, String mPassword, String startingpoint, int scope, String attr, String urlfilter) {
        OneShutJNDI osj = new OneShutJNDI();
        return osj.Lookup(mServer, mPort, mUser, mPassword, startingpoint, scope, attr, urlfilter, 1, null);
    }

    public static String RawLdapLookup(String mServer, String mPort, String mUser, String mPassword, String startingpoint, int scope, String attr, String urlfilter, int returnType) {
        OneShutJNDI osj = new OneShutJNDI();
        return osj.Lookup(mServer, mPort, mUser, mPassword, startingpoint, scope, attr, urlfilter, returnType, null);
    }

    public static String LdapLookup(String mServer, String mPort, String mUser, String mPassword, String startingpoint, int scope, String attr, String urlfilter, String securityProtocol, String additionalBinaryAttributes, boolean cacheConnections, MVDHashMap engineGlobals) {
        HidedJNDIOperations hjo = new HidedJNDIOperations();
        return hjo.Lookup(mServer, mPort, mUser, mPassword, startingpoint, scope, attr, urlfilter, securityProtocol, additionalBinaryAttributes, cacheConnections, engineGlobals);
    }

    public static String ProcessModifyAttributes(Vector modVector) {
        String setString = "";
        String aString = "";
        HashMap<String, String> tempHashMap = new HashMap<String, String>();
        try {
            for (int i = 0; i < modVector.size(); ++i) {
                MVDModAttrValues aModOp = (MVDModAttrValues)modVector.elementAt(i);
                String attrName = aModOp.getAttrName();
                if (aModOp.getModType() == 1) {
                    aString = attrName + "=null";
                    tempHashMap.put(attrName, aString);
                    continue;
                }
                boolean bBin = MVDProxy.IsBinaryAttribute(attrName);
                aString = attrName + "=";
                String multiString = "";
                for (int x = 0; x < aModOp.size(); ++x) {
                    String oneValue;
                    Object value = aModOp.elementAt(x);
                    if (bBin) {
                        oneValue = "{HEX}" + MVDUtil.byteToHex((byte[])value);
                    } else {
                        oneValue = (String)value;
                        oneValue = MVDUtil.replace(oneValue, "'", "''");
                    }
                    if (multiString.length() > 0) {
                        multiString = multiString + "|";
                    }
                    multiString = multiString + oneValue;
                }
                aString = attrName + "='" + multiString + "'";
                tempHashMap.put(attrName, aString);
            }
            Iterator it = tempHashMap.keySet().iterator();
            while (it.hasNext()) {
                String a = (String)it.next();
                aString = (String)tempHashMap.get(a);
                if (setString.length() > 0) {
                    setString = setString + ",";
                }
                setString = setString + aString;
            }
            return setString;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Vector ProcessAddAttributes(HashMap attrNamesAndValues) {
        String attrNameListn = "";
        String attrValueList = "";
        Vector attrValues = null;
        String multiString = "";
        Vector<String> listsForDbQuery = new Vector<String>();
        try {
            Iterator ii = attrNamesAndValues.keySet().iterator();
            while (ii.hasNext()) {
                multiString = "";
                String attrName = (String)ii.next();
                boolean bBin = MVDProxy.IsBinaryAttribute(attrName);
                attrValues = (Vector)attrNamesAndValues.get(attrName);
                for (int x = 0; x < attrValues.size(); ++x) {
                    String oneValue;
                    Object value = attrValues.elementAt(x);
                    if (bBin) {
                        oneValue = "{HEX}" + MVDUtil.byteToHex((byte[])value);
                    } else {
                        oneValue = (String)value;
                        oneValue = MVDUtil.replace(oneValue, "'", "''");
                    }
                    if (multiString.length() > 0) {
                        multiString = multiString + "|";
                    }
                    multiString = multiString + oneValue;
                }
                multiString = "'" + multiString + "'";
                if (attrNameListn.length() == 0) {
                    attrNameListn = attrName;
                    attrValueList = multiString;
                    continue;
                }
                attrNameListn = attrNameListn + "," + attrName;
                attrValueList = attrValueList + "," + multiString;
            }
            listsForDbQuery.add(attrNameListn);
            listsForDbQuery.add(attrValueList);
            return listsForDbQuery;
        }
        catch (Exception ne) {
            return null;
        }
    }

    public static String shellExecute(String cmdLine) {
        try {
            Process p = Runtime.getRuntime().exec(cmdLine, null, null);
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String linefeed = System.getProperty("line.separator", "\n");
            String retval = "";
            String line = reader.readLine();
            while (line != null) {
                retval = retval + line + linefeed;
                line = reader.readLine();
            }
            return retval;
        }
        catch (Exception e) {
            MVDLogger.Log("Error executing command: " + cmdLine + "(" + e.getMessage() + ")", 3);
            return null;
        }
    }

    public static String shellExecute(Vector cmdVector) {
        try {
            String[] cmdLine = new String[cmdVector.size()];
            int i = 0;
            Iterator iter = cmdVector.iterator();
            while (iter.hasNext()) {
                String element = (String)iter.next();
                cmdLine[i++] = element;
            }
            Process p = Runtime.getRuntime().exec(cmdLine);
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String linefeed = System.getProperty("line.separator", "\n");
            String retval = "";
            String line = reader.readLine();
            while (line != null) {
                retval = retval + line + linefeed;
                line = reader.readLine();
            }
            return retval;
        }
        catch (Exception e) {
            MVDLogger.Log("Error executing command: " + cmdVector.toString() + "(" + e.getMessage() + ")", 3);
            return null;
        }
    }

    public static Properties parseStatisticsString(String message) {
        String pairseparator = ",";
        StringTokenizer st = new StringTokenizer(message, pairseparator);
        Properties props = new Properties();
        String line = "";
        while (st.hasMoreTokens()) {
            line = st.nextToken();
            int kolindex = line.indexOf(61);
            if (kolindex < 0) continue;
            String key = line.substring(0, kolindex);
            String value = line.substring(kolindex + 1, line.length());
            props.put(key, value);
        }
        return props;
    }

    public static Document ConvertFromStringToDOM(String aString) {
        Document DOMObject = null;
        try {
            boolean isTokenized = false;
            String request = "";
            StringTokenizer tokens = new StringTokenizer(aString, "\n");
            while (tokens.hasMoreTokens()) {
                isTokenized = true;
                String token = tokens.nextToken().trim();
                request = request + token;
            }
            if (!isTokenized) {
                request = aString;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            ByteArrayInputStream instream = new ByteArrayInputStream(request.getBytes());
            BufferedInputStream in = new BufferedInputStream(instream);
            DOMObject = builder.parse(in);
        }
        catch (Exception e) {
            MVDLogger.Log("Error converting String to DOM: " + e.getMessage(), 3);
        }
        return DOMObject;
    }

    public static String ConvertFromDOMToString(Document aDOMObject) {
        try {
            DOMSource domSource = new DOMSource(aDOMObject);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (TransformerException ex) {
            MVDLogger.Log("Error converting DOM to String: " + ex.getMessage(), 3);
            return ex.getMessage();
        }
    }

    public static String ConvertFromDOMToString(Document aDOMObject, boolean aLiberty) {
        try {
            DOMSource domSource = new DOMSource(aDOMObject);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            if (!aLiberty) {
                return writer.toString();
            }
            String responseString = writer.toString();
            int rootLenght = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><DummyRoot/>".length() - 1;
            return responseString.substring(rootLenght, responseString.indexOf("</DummyRoot>"));
        }
        catch (TransformerException ex) {
            MVDLogger.Log("Error converting DOM to String: " + ex.getMessage(), 3);
            return ex.getMessage();
        }
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        byte[] f;
        String s;
        int ix;
        String ss = "\u00ef\u00bf\u00bd";
        byte[] sbutf8 = MVDUtil.ToUTF8(ss);
        String detteskjermedloggen = new String(sbutf8);
        String ff = MVDUtil.FromUTF8(sbutf8);
        byte[] passwordsomblirkonverterttilutf8igjen = ff.getBytes("UTF-8");
        byte[] dd = new byte[1];
        System.out.println("   -   ,    -  ");
        for (ix = -128; ix <= 127; ++ix) {
            dd[0] = (byte)ix;
            s = new String(dd);
            f = s.getBytes();
            if (f[0] == dd[0]) continue;
            System.out.println("Diff:" + ix + "  :" + dd[0] + "   :" + f[0]);
        }
        System.out.println("   -   , Cp1252 ");
        for (ix = -128; ix <= 127; ++ix) {
            dd[0] = (byte)ix;
            s = new String(dd);
            f = s.getBytes("Cp1252");
            if (f[0] == dd[0]) continue;
            System.out.println("Diff:" + ix + "  :" + dd[0] + "   :" + f[0]);
        }
        System.out.println("   -   ,ISO-8859-1 ");
        for (ix = -128; ix <= 127; ++ix) {
            dd[0] = (byte)ix;
            s = new String(dd);
            f = s.getBytes("ISO-8859-1");
            if (f[0] == dd[0]) continue;
            System.out.println("Diff:" + ix + "  :" + dd[0] + "   :" + f[0]);
        }
        System.out.println("   -   ,UTF-8 ");
        for (ix = -128; ix <= 127; ++ix) {
            dd[0] = (byte)ix;
            s = new String(dd);
            f = s.getBytes("UTF-8");
            if (f[0] == dd[0]) continue;
            System.out.println("Diff:" + ix + "  :" + dd[0] + "   :" + f[0]);
        }
        System.out.println("===============================");
        System.out.println("ISO-8859-1");
        System.out.println("===============================");
        System.out.println("ISO-8859-1,    -  ");
        for (ix = -128; ix <= 127; ++ix) {
            dd[0] = (byte)ix;
            s = new String(dd, "ISO-8859-1");
            f = s.getBytes();
            if (f[0] == dd[0]) continue;
            System.out.println("Diff:" + ix + "  :" + dd[0] + "   :" + f[0]);
        }
        System.out.println("ISO-8859-1,, Cp1252 ");
        for (ix = -128; ix <= 127; ++ix) {
            dd[0] = (byte)ix;
            s = new String(dd, "ISO-8859-1");
            f = s.getBytes("Cp1252");
            if (f[0] == dd[0]) continue;
            System.out.println("Diff:" + ix + "  :" + dd[0] + "   :" + f[0]);
        }
        System.out.println("ISO-8859-1,ISO-8859-1");
        for (ix = -128; ix <= 127; ++ix) {
            dd[0] = (byte)ix;
            s = new String(dd, "ISO-8859-1");
            f = s.getBytes("ISO-8859-1");
            if (f[0] == dd[0]) continue;
            System.out.println("Diff:" + ix + "  :" + dd[0] + "   :" + f[0]);
        }
        System.out.println("ISO-8859-1,UTF-8 ");
        for (ix = -128; ix <= 127; ++ix) {
            dd[0] = (byte)ix;
            s = new String(dd, "ISO-8859-1");
            f = s.getBytes("UTF-8");
            if (f[0] == dd[0]) continue;
            System.out.println("Diff:" + ix + "  :" + dd[0] + "   :" + f[0]);
        }
        System.out.println("===============================");
        System.out.println("UTF-8,   -   ");
        System.out.println("===============================");
        System.out.println("UTF-8,    -  ");
        for (ix = -128; ix <= 127; ++ix) {
            dd[0] = (byte)ix;
            s = new String(dd, "UTF-8");
            f = s.getBytes();
            if (f[0] == dd[0]) continue;
            System.out.println("Diff:" + ix + "  :" + dd[0] + "   :" + f[0]);
        }
        System.out.println("UTF-8,, Cp1252 ");
        for (ix = -128; ix <= 127; ++ix) {
            dd[0] = (byte)ix;
            s = new String(dd, "UTF-8");
            f = s.getBytes("Cp1252");
            if (f[0] == dd[0]) continue;
            System.out.println("Diff:" + ix + "  :" + dd[0] + "   :" + f[0]);
        }
        System.out.println("UTF-8,ISO-8859-1");
        for (ix = -128; ix <= 127; ++ix) {
            dd[0] = (byte)ix;
            s = new String(dd, "UTF-8");
            f = s.getBytes("ISO-8859-1");
            if (f[0] == dd[0]) continue;
            System.out.println("Diff:" + ix + "  :" + dd[0] + "   :" + f[0]);
        }
        System.out.println("UTF-8,UTF-8 ");
        for (ix = -128; ix <= 127; ++ix) {
            dd[0] = (byte)ix;
            s = new String(dd, "UTF-8");
            f = s.getBytes("UTF-8");
            if (f[0] == dd[0]) continue;
            System.out.println("Diff:" + ix + "  :" + dd[0] + "   :" + f[0]);
        }
        System.out.println("UTF-8,IBM1047");
        for (ix = -128; ix <= 127; ++ix) {
            dd[0] = (byte)ix;
            s = new String(dd, "UTF-8");
            f = s.getBytes("IBM1047");
            if (f[0] == dd[0]) continue;
            System.out.println("Diff:" + ix + "  :" + dd[0] + "   :" + f[0]);
        }
    }

    public static String masterDcString(String aSource) {
        String result = aSource;
        if (result == null || result.equals("")) {
            result = "";
            return result;
        }
        String oldresult = "";
        HashMap globals = MVDProxy.MVDGlobals();
        Set globalkeys = globals.keySet();
        HashMap<String, String> globalKeyMapping = new HashMap<String, String>();
        Iterator iter = globalkeys.iterator();
        while (iter.hasNext()) {
            String akey = (String)iter.next();
            globalKeyMapping.put(akey.toUpperCase(), akey);
        }
        while (!(oldresult = result).equals(result = MVDMic_Util.fixCryptedString((String)oldresult, (HashMap)globals, globalKeyMapping))) {
        }
        return result;
    }
}

