/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds;

import com.sap.idm.vds.MVDException;
import com.sap.idm.vds.MVDHashMap;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDModAttrValues;
import com.sap.idm.vds.MVDServer;
import com.sap.idm.vds.MVDUtilities;
import com.sap.idm.vds.config.MVDAcl;
import com.sap.idm.vds.config.MVDDataSource;
import com.sap.idm.vds.config.MVDDataSourceList;
import com.sap.idm.vds.config.MVDForestList;
import com.sap.idm.vds.message.MxAdd;
import com.sap.idm.vds.message.MxDelete;
import com.sap.idm.vds.message.MxModify;
import com.sap.idm.vds.message.MxRequest;
import com.sap.idm.vds.util.Base64;
import com.sap.idm.vds.util.IllegalBase64Exception;
import com.sap.idm.vds.util.MVDOpUtilities;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class MVDUtil {
    public static final int REQUESTED_ONLY_ALL_ATTRIBUTES = 0;
    public static final int REQUESTED_ONLY_DISTINCT_ATTRIBUTES = 1;
    public static final int REQUESTED_MIX_ALL_AND_DISTINCT_ATTRIBUTES = 2;

    public static int areAllAttributesRequested(Vector requestedAttributes) {
        int bResult = 0;
        if (requestedAttributes == null) {
            MVDLogger.Debug("All attributes were requested", 2);
            bResult = 0;
        } else if (requestedAttributes.contains("*")) {
            if (requestedAttributes.size() == 1) {
                MVDLogger.Debug("All attributes were requested", 2);
                bResult = 0;
            } else {
                bResult = 2;
            }
        } else if (requestedAttributes.size() == 0) {
            MVDLogger.Debug("All attributes were requested", 2);
            bResult = 0;
        } else {
            bResult = 1;
        }
        return bResult;
    }

    public static HashMap pickAttrsFromFilter(String urlFilter) {
        int len = urlFilter.length();
        HashMap<String, String> h = new HashMap<String, String>();
        Stack<String> stck = new Stack<String>();
        for (int x = 0; x < len; ++x) {
            int aEqual;
            if (urlFilter.charAt(x) == '(') {
                stck.push("" + x);
                continue;
            }
            if (urlFilter.charAt(x) != ')') continue;
            int lastOpen = Integer.parseInt((String)stck.pop());
            String s = urlFilter.substring(lastOpen + 1, x);
            if (!s.startsWith("&") && !s.startsWith("|") && (aEqual = s.indexOf("=")) > 0) {
                String aAttributeName = s.substring(0, aEqual);
                String aAttributeValue = s.substring(aEqual + 1);
                h.put(aAttributeName, aAttributeValue);
            }
            urlFilter = urlFilter.substring(0, lastOpen) + urlFilter.substring(x + 1);
            System.out.println(urlFilter);
            int change = x + 1 - lastOpen;
            x -= change;
            len -= change;
        }
        return h;
    }

    public static byte[] ToUTF8(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (NullPointerException p) {
            return null;
        }
        catch (Exception e) {
            return s.getBytes();
        }
    }

    public static String FromUTF8(byte[] bRes) {
        try {
            return new String(bRes, "UTF-8");
        }
        catch (NullPointerException p) {
            return null;
        }
        catch (Exception e) {
            return new String(bRes);
        }
    }

    public static void replaceVectorValue(Vector v, String oldValue, String newValue) {
        if (v != null) {
            String oneA = null;
            for (int i = 0; i < v.size(); ++i) {
                oneA = (String)v.elementAt(i);
                if (!oneA.equalsIgnoreCase(oldValue)) continue;
                v.remove(oneA);
                if (newValue.startsWith("{HEX}")) {
                    v.add(MVDUtil.hexToByte(newValue.substring(5)));
                    break;
                }
                v.add(newValue);
                break;
            }
        }
    }

    public static void replaceVectorValues(Vector m, HashMap h) {
        if (m != null) {
            String newValue = null;
            String oldValue = null;
            Iterator it = h.keySet().iterator();
            while (it.hasNext()) {
                oldValue = (String)it.next();
                newValue = (String)h.get(oldValue);
                MVDUtil.replaceVectorValue(m, oldValue, newValue);
            }
        }
    }

    public static String NiceFilter(String urlfilter, String DnAttributes) {
        Vector vDNSyntaxAttributes = MVDUtil.splitString(DnAttributes, ",");
        String theDN = "";
        String tempString = "";
        String origFilter = urlfilter;
        try {
            for (int x = 0; x < vDNSyntaxAttributes.size(); ++x) {
                String stxAttr = (String)vDNSyntaxAttributes.elementAt(x);
                int ind = 0;
                int currInd = urlfilter.indexOf(stxAttr, ind);
                while (currInd >= 0) {
                    if (currInd == 0) {
                        theDN = urlfilter.substring(currInd + stxAttr.length() + 1);
                        tempString = MVDUtil.NiceDN(theDN);
                    } else {
                        boolean bStartBFound = false;
                        for (int w = currInd - 1; w >= 0; --w) {
                            char c = urlfilter.charAt(w);
                            if (c == '(') {
                                bStartBFound = true;
                                break;
                            }
                            if (c == ' ') continue;
                        }
                        int currPos = currInd + stxAttr.length() + 1;
                        tempString = urlfilter.substring(0, currPos);
                        if (bStartBFound) {
                            int endPar = urlfilter.indexOf(")", currPos);
                            theDN = urlfilter.substring(currPos, endPar);
                            tempString = tempString + MVDUtil.NiceDN(theDN);
                            tempString = tempString + urlfilter.substring(endPar);
                        } else {
                            theDN = urlfilter.substring(currPos);
                            tempString = tempString + MVDUtil.NiceDN(theDN);
                        }
                    }
                    urlfilter = tempString;
                    ind = currInd + stxAttr.length() + 1;
                    currInd = urlfilter.indexOf(stxAttr, ind);
                }
            }
            return urlfilter;
        }
        catch (Exception ee) {
            MVDLogger.Log("Error Nice Filter:" + origFilter, 2);
            return origFilter;
        }
    }

    public static MVDDataSource getDSbyDN(String treeName, String dnname) {
        if ((treeName == null || treeName.length() == 0) && (treeName = MVDForestList.getDefaultTree()) == null) {
            return null;
        }
        try {
            String nice = MVDUtil.NiceDN(dnname);
            MVDAcl match = MVDForestList.getNodeByName(treeName, MVDOpUtilities.reverseDN(nice));
            if (match != null) {
                MVDDataSource ds = match.getDataSource();
                return ds;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getDSNameByDN(String treeName, String dnname) {
        MVDDataSource ds = MVDUtil.getDSbyDN(treeName, dnname);
        if (ds != null) {
            return ds.NiceName();
        }
        return null;
    }

    public static String getUniqueDSNameByDN(String treeName, String dnname) {
        MVDDataSource ds = MVDUtil.getDSbyDN(treeName, dnname);
        if (ds != null) {
            return ds.getUniqueName();
        }
        return null;
    }

    public static String getProperDN(String treeName, String dnname) {
        String vsp;
        MVDDataSource ds;
        if ((treeName == null || treeName.length() == 0) && (treeName = MVDForestList.getDefaultTree()) == null) {
            return null;
        }
        String nice = null;
        try {
            nice = MVDUtil.NiceDN(dnname);
        }
        catch (Exception e) {
            return null;
        }
        MVDAcl match = MVDForestList.getNodeByName(treeName, MVDOpUtilities.reverseDN(nice));
        if (match == null) {
            return null;
        }
        HashMap vs = (HashMap)match.getParamFields().get("-1");
        if (vs == null) {
            return dnname;
        }
        String realsp = (String)vs.get("NODE_REALSP");
        if (realsp == null && (ds = match.getDataSource()) != null) {
            realsp = (String)ds.ParamFields().get("DS_REALSP");
        }
        if ((vsp = (String)vs.get("NODE_VIRTUALSP")) != null && realsp != null) {
            String s = MVDUtilities.fixStartingPoint(nice, realsp, vsp);
            return s;
        }
        return dnname;
    }

    public static String getVirtualSP(String treeName, String dnname) {
        if ((treeName == null || treeName.length() == 0) && (treeName = MVDForestList.getDefaultTree()) == null) {
            return null;
        }
        String nice = null;
        try {
            nice = MVDUtil.NiceDN(dnname);
        }
        catch (Exception e) {
            return null;
        }
        MVDAcl match = MVDForestList.getNodeByName(treeName, MVDOpUtilities.reverseDN(nice));
        if (match == null) {
            return null;
        }
        HashMap vs = (HashMap)match.getParamFields().get("-1");
        if (vs == null) {
            return dnname;
        }
        String vsp = (String)vs.get("NODE_VIRTUALSP");
        if (vsp != null) {
            return vsp;
        }
        return dnname;
    }

    public static MVDDataSource getDSbyName(String aName) {
        return MVDDataSourceList.getDSByName(aName);
    }

    public static HashMap getDSParametersByDSName(String aName) {
        MVDDataSource ds = MVDDataSourceList.getDSByName(aName);
        HashMap params = new HashMap(ds.ParamFields());
        return params;
    }

    public static MVDDataSource getDSbyUniqueName(String aUniqueName) {
        return MVDDataSourceList.getDSByUniqueName(aUniqueName);
    }

    public static HashMap getDSParametersByDSUniqueName(String aUniqueName) {
        MVDDataSource ds = MVDDataSourceList.getDSByUniqueName(aUniqueName);
        MVDHashMap params = new MVDHashMap(ds.ParamFields());
        return params;
    }

    public static void setDSParameterByDSUniqueName(String aUniqueName, String aKey, String aValue) {
        MVDDataSource ds = MVDDataSourceList.getDSByUniqueName(aUniqueName);
        HashMap params = ds.ParamFields();
        params.put(aKey, aValue);
    }

    public static HashMap readPropertyFile(String aPropFileName) {
        File propFile = new File(aPropFileName);
        if (!propFile.exists()) {
            return null;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        Properties temp = new Properties();
        try {
            FileInputStream instream = new FileInputStream(aPropFileName);
            temp.load(instream);
            instream.close();
            Iterator<Object> i = temp.keySet().iterator();
            while (i.hasNext()) {
                String key = i.next().toString();
                String value = temp.getProperty(key);
                props.put(key, value);
            }
        }
        catch (Exception e) {
            return null;
        }
        return props;
    }

    public static HashMap getNodeParametersByNodeName(String treeName, String dnname) {
        HashMap params = null;
        if ((treeName == null || treeName.length() == 0) && (treeName = MVDForestList.getDefaultTree()) == null) {
            return null;
        }
        try {
            String nice = MVDUtil.NiceDN(dnname);
            MVDAcl match = MVDForestList.getNodeByName(treeName, MVDOpUtilities.reverseDN(nice));
            if (match != null) {
                params = new HashMap(match.getParamFields());
                return params;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return params;
    }

    public static boolean IsDSDirectoryType(String aName) {
        MVDDataSource a = MVDDataSourceList.getDSByName(aName);
        return a.DSType().equalsIgnoreCase("LDAP");
    }

    public static String removeAllChar(String inStr, char remove) {
        StringBuffer strBuf = new StringBuffer(inStr);
        int i = 0;
        while (i < strBuf.length()) {
            if (remove == strBuf.charAt(i)) {
                strBuf.deleteCharAt(i);
                continue;
            }
            ++i;
        }
        return strBuf.toString();
    }

    public static String ReadFile(String strFileName, boolean doBinary, boolean doIgnoreLineEnding) {
        try {
            InputStream is = MVDServer.openFileOrURL(strFileName);
            int iLength = is.available();
            if (doBinary) {
                Vector<byte[]> vv = new Vector<byte[]>();
                int iTotal = 0;
                int iPlace = 0;
                while (iLength > 0) {
                    byte[] bb = new byte[iLength];
                    is.read(bb, 0, iLength);
                    vv.add(bb);
                    iTotal += iLength;
                    iLength = is.available();
                }
                is.close();
                byte[] bbuf = new byte[iTotal];
                for (int x = 0; x < vv.size(); ++x) {
                    byte[] bb = (byte[])vv.elementAt(x);
                    System.arraycopy(bb, 0, bbuf, iPlace, bb.length);
                    iPlace += bb.length;
                }
                return "{HEX}" + MVDUtil.byteToHex(bbuf);
            }
            InputStreamReader ir = new InputStreamReader(is);
            char[] cbuf = new char[iLength];
            ir.read(cbuf, 0, iLength);
            ir.close();
            is.close();
            if (!doIgnoreLineEnding) {
                return new String(cbuf);
            }
            String sb = new String(cbuf);
            sb = MVDUtil.removeAllChar(sb, '\r');
            sb = MVDUtil.removeAllChar(sb, '\n');
            return sb;
        }
        catch (FileNotFoundException fnfe) {
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public static byte[] readFile(String filename) {
        return MVDUtil.readFile(new File(filename));
    }

    public static byte[] readFile(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        byte[] data = new byte[(int)file.length()];
        try {
            new FileInputStream(file).read(data);
            return data;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static byte[] readFile(InputStream Stream2) {
        BufferedInputStream bf = new BufferedInputStream(Stream2);
        int i = 1;
        String str = "";
        byte[] s = new byte[6000];
        try {
            while (i > 0) {
                i = bf.read(s);
                if (i <= 0) continue;
                String tempS = new String(s, 0, i);
                str = str + tempS;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return MVDUtil.ToUTF8(str);
    }

    public static String commonDN(String s1, String s2) {
        Vector v1 = MVDUtil.splitString(s1, ",");
        Vector v2 = MVDUtil.splitString(s2, ",");
        int x1 = v1.size();
        int x2 = v2.size();
        String res = "";
        int minx = x1;
        if (x1 > x2) {
            minx = x2;
        }
        for (int x = 1; x <= minx; ++x) {
            String as2;
            String as1 = (String)v1.elementAt(x1 - x);
            if (!as1.equalsIgnoreCase(as2 = (String)v2.elementAt(x2 - x))) continue;
            res = res.length() > 0 ? as1 + "," + res : as1;
        }
        return res;
    }

    public static boolean isBellowMe(String over, String under) {
        if (over == null || over.length() == 0) {
            return false;
        }
        if (under == null) {
            return false;
        }
        return under.toLowerCase().endsWith(over.toLowerCase());
    }

    public static final Vector splitString(String aString, char aDelimiter) {
        char[] d = new char[]{aDelimiter};
        return MVDUtil.splitString(aString, d);
    }

    public static final Vector splitString(String aString, char[] aDelimiter) {
        Vector<String> result = new Vector<String>();
        StringTokenizer t = new StringTokenizer(aString, new String(aDelimiter));
        while (t.hasMoreTokens()) {
            result.add(t.nextToken());
        }
        return result;
    }

    public static final Vector splitString(String aString, String aDelimiter) {
        String temp = aString;
        Vector<String> result = new Vector<String>();
        if (aDelimiter.length() == 0) {
            result.add(aString);
            return result;
        }
        int idx = temp.indexOf(aDelimiter);
        while (idx >= 0) {
            result.add(temp.substring(0, idx));
            temp = temp.substring(idx + aDelimiter.length());
            idx = temp.indexOf(aDelimiter);
        }
        result.add(temp);
        return result;
    }

    public static final Vector splitStringIgnoreCase(String aString, String aDelimiter) {
        String temp = aString;
        String tempLCase = temp.toLowerCase();
        String delimLCase = aDelimiter.toLowerCase();
        Vector<String> result = new Vector<String>();
        int idx = tempLCase.indexOf(delimLCase);
        while (idx >= 0) {
            result.add(temp.substring(0, idx));
            tempLCase = tempLCase.substring(idx + delimLCase.length());
            temp = temp.substring(idx + aDelimiter.length());
            idx = tempLCase.indexOf(delimLCase);
        }
        result.add(temp);
        return result;
    }

    public static final String joinStrings(String[] aStrings, String aDelimiter) {
        String result = "";
        for (int i = 0; i < aStrings.length; ++i) {
            result = i == 0 ? aStrings[i] : result + aDelimiter + aStrings[i];
        }
        return result;
    }

    public static final String joinStrings(Vector aStrings, String aDelimiter) {
        String result = "";
        boolean first = true;
        Iterator it = aStrings.iterator();
        while (it.hasNext()) {
            if (first) {
                result = (String)it.next();
                first = false;
                continue;
            }
            result = result + aDelimiter + (String)it.next();
        }
        return result;
    }

    public static final String replace(String aSource, String aOldString, String aNewString) {
        return MVDUtil.joinStrings(MVDUtil.splitString(aSource, aOldString), aNewString);
    }

    public static final String replaceIgnoreCase(String aSource, String aOldString, String aNewString) {
        return MVDUtil.joinStrings(MVDUtil.splitStringIgnoreCase(aSource, aOldString), aNewString);
    }

    public static String NiceDN(String inputDN) throws MVDException {
        int index = inputDN.indexOf("\\,");
        if (index >= 0) {
            String withoutEscapes = MVDUtil.NiceDN(MVDUtil.replace(inputDN, "\\,", "--**XX**--"));
            String withEscapesAgain = MVDUtil.replace(withoutEscapes, "--**XX**--", "\\,");
            return withEscapesAgain;
        }
        String tempString = "";
        int x = inputDN.indexOf(34);
        if (x < 0) {
            tempString = MVDOpUtilities.SimpleNiceDN(inputDN);
        } else {
            Vector dnVector = MVDUtil.splitString(inputDN, "\"");
            int len = dnVector.size();
            if (len % 2 == 0) {
                throw new MVDException(-23);
            }
            String[] dnStrArr = dnVector.toArray(new String[0]);
            for (x = 1; x < len; x += 2) {
                dnStrArr[x] = "--XX--";
            }
            tempString = MVDUtil.joinStrings(dnStrArr, "\"");
            tempString = MVDOpUtilities.SimpleNiceDN(tempString);
            Vector tempVector = MVDUtil.splitString(tempString, "\"");
            dnStrArr = tempVector.toArray(new String[0]);
            for (x = 0; x < len; ++x) {
                if (!dnStrArr[x].equals("--XX--")) continue;
                dnStrArr[x] = (String)dnVector.elementAt(x);
            }
            tempString = MVDUtil.joinStrings(dnStrArr, "\"");
        }
        return tempString;
    }

    public static boolean StringToBool(String aInput) {
        try {
            if (aInput.length() == 0) {
                return false;
            }
            if ("true".equalsIgnoreCase(aInput)) {
                return true;
            }
            Integer i = new Integer(aInput);
            if (i > 0) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static int stringToInt(String aInput, int aDefval) {
        try {
            return Integer.parseInt(aInput);
        }
        catch (NumberFormatException e) {
            return aDefval;
        }
    }

    public static String byteToHex(byte aByte) {
        return new String(MVDUtil.byteToHexHelper(aByte));
    }

    public static String byteToHex(byte[] aByteArray) {
        StringBuffer hex = new StringBuffer(2 * aByteArray.length);
        for (int i = 0; i < aByteArray.length; ++i) {
            hex.append(MVDUtil.byteToHexHelper(aByteArray[i]));
        }
        return new String(hex);
    }

    public static String byteToEscapedHex(byte[] aByteArray) {
        StringBuffer hex = new StringBuffer(3 * aByteArray.length);
        for (int i = 0; i < aByteArray.length; ++i) {
            hex.append("\\");
            hex.append(MVDUtil.byteToHexHelper(aByteArray[i]));
        }
        return new String(hex);
    }

    static char[] byteToHexHelper(byte aByte) {
        char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] hex = new char[2];
        hex[1] = hexDigit[aByte & 0xF];
        hex[0] = hexDigit[aByte >>> 4 & 0xF];
        return hex;
    }

    public static byte[] hexToByte(String aHexString) {
        String hex = aHexString.toLowerCase();
        char[] hexChar = hex.toCharArray();
        byte[] byt = new byte[hexChar.length % 2 == 0 ? hexChar.length / 2 : hexChar.length / 2 + 1];
        for (int i = 0; i < byt.length; ++i) {
            byt[i] = 0;
        }
        int bytIndex = -1;
        int shift = 4;
        for (int i = 0; i < hexChar.length; ++i) {
            bytIndex = i % 2 == 0 ? ++bytIndex : bytIndex;
            shift = i % 2 == 0 ? 4 : 0;
            if (hexChar[i] >= '0' & hexChar[i] <= '9') {
                int n = bytIndex;
                byt[n] = (byte)(byt[n] + (hexChar[i] - 48 << shift));
                continue;
            }
            if (hexChar[i] >= 'a' & hexChar[i] <= 'f') {
                int n = bytIndex;
                byt[n] = (byte)(byt[n] + (10 + (hexChar[i] - 97) << shift));
                continue;
            }
            throw new IllegalArgumentException("Non hex character found");
        }
        return byt;
    }

    public static String base64encode(byte[] aByteArr, boolean bDoPad) {
        return Base64.encode(aByteArr, bDoPad);
    }

    public static String base64encode(byte[] aByteArr) {
        return Base64.encode(aByteArr, false);
    }

    public static byte[] base64decode(String str) {
        try {
            return Base64.decode(str);
        }
        catch (IllegalBase64Exception e) {
            return str.getBytes();
        }
    }

    public static void WriteStringToFile(String FileName, String strToDump) {
        MVDUtil.WriteStringToFile(FileName, strToDump, false);
    }

    public static boolean WriteStringToFile(String FileName, String strToDump, boolean append) {
        FileOutputStream writeFile = null;
        try {
            writeFile = new FileOutputStream(FileName, append);
            if (append) {
                writeFile.write(strToDump.getBytes());
            } else {
                writeFile.write(strToDump.getBytes(), 0, strToDump.length());
            }
            writeFile.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static String computeMD5(String aStr) {
        if (aStr == null) {
            return null;
        }
        byte[] tmp = MVDUtil.getMD5Bytes(aStr.getBytes());
        if (tmp != null) {
            return MVDUtil.byteToHex(tmp);
        }
        return null;
    }

    public static byte[] getMD5Bytes(byte[] aBytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(aBytes);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            MVDLogger.Log("JVM does not provide MD5 algorithm", 7);
            return null;
        }
    }

    public static boolean replaceTemplateParameters(HashMap aParameters, MxRequest aMxRequest) {
        Iterator it = aParameters.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object v = entry.getValue();
            if (!(v instanceof String)) continue;
            String value = (String)v;
            String newval = MVDUtil.replaceTemplateParameter(value, aMxRequest);
            if (newval.indexOf(37) >= 0) {
                return false;
            }
            entry.setValue(newval);
        }
        return true;
    }

    public static String replaceTemplateParameter(String aParamValue, MxRequest aMxRequest) {
        StringBuffer buf = new StringBuffer(aParamValue);
        int start = buf.indexOf("%");
        while (start > 0) {
            int next = buf.indexOf("%", start + 1);
            String attrname = buf.substring(start + 1, next);
            String attrval = MVDUtil.getAttrValue(attrname, aMxRequest);
            if (attrval != null) {
                buf.replace(start, next + 1, attrval);
            }
            start = buf.indexOf("%", next + 1);
        }
        return buf.toString();
    }

    private static String getAttrValue(String aAttrName, MxRequest aRequest) {
        if (aRequest instanceof MxAdd) {
            MxAdd add = (MxAdd)aRequest;
            if (aAttrName.equalsIgnoreCase("dn")) {
                return add.getDn();
            }
            return add.getAttrSetAndValues().getFirstAttrValue(aAttrName.toLowerCase());
        }
        if (aRequest instanceof MxModify) {
            MxModify mod = (MxModify)aRequest;
            if (aAttrName.equalsIgnoreCase("dn")) {
                return mod.getDn();
            }
            Vector v = mod.getAttrAndModValues();
            for (int i = 0; i < v.size(); ++i) {
                MVDModAttrValues mval = (MVDModAttrValues)v.elementAt(i);
                String aname = mval.getAttrName();
                if (!aname.equalsIgnoreCase(aAttrName)) continue;
                try {
                    return (String)mval.firstElement();
                }
                catch (NoSuchElementException e) {
                    // empty catch block
                }
            }
            return null;
        }
        if (aRequest instanceof MxDelete) {
            if (aAttrName.equalsIgnoreCase("dn")) {
                MxDelete del = (MxDelete)aRequest;
                return del.getDn();
            }
            return null;
        }
        return null;
    }

    public static String SQLtoMultivalue(String aDbfilter, Vector aMultiAttrs, String aTemplate) {
        boolean wildtag = false;
        if (aTemplate == null) {
            aTemplate = "(<Attr>='<Val>' OR <Attr> LIKE '*|<Val>' OR <Attr> LIKE '<Val>|*' OR <Attr> LIKE '*|<Val>|*')";
        }
        for (int i = 0; i < aMultiAttrs.size(); ++i) {
            String target;
            int start = aDbfilter.indexOf((String)aMultiAttrs.get(i));
            if (start == -1) continue;
            int end = aDbfilter.indexOf(" ", start);
            int tval = aDbfilter.indexOf(")", start);
            int tval2 = aDbfilter.toLowerCase().indexOf("like", end > start ? end : start);
            if (tval2 != -1 && tval2 < tval) {
                wildtag = true;
                end = tval;
            } else if (tval != -1 && (end == -1 || tval < end)) {
                end = tval;
            } else {
                if (tval2 != -1) {
                    wildtag = true;
                }
                end = aDbfilter.length();
            }
            if (end == -1) {
                end = aDbfilter.length();
            }
            if ((target = aDbfilter.substring(start, end)) == null) continue;
            String value = "";
            value = wildtag ? target.substring(target.toLowerCase().indexOf("like ") + 5, target.length()) : target.substring(target.indexOf("=") + 1, target.length());
            if (value.startsWith("'")) {
                value = value.substring(1, value.length() - 1);
            }
            if (wildtag && value.compareTo("*") == 0) break;
            String template = aTemplate;
            template = template.replaceAll("<Val>", value);
            template = template.replaceAll("<Attr>", (String)aMultiAttrs.get(i));
            aDbfilter = MVDUtil.replace(aDbfilter, target, template);
        }
        return aDbfilter;
    }

    public static boolean isURLEqual(String aStartingPoint, String aScope, String aFilter, String aCompareURL) {
        return MVDUtil.isURLEqual(aStartingPoint, aScope, aFilter, aCompareURL, true);
    }

    public static boolean isURLEqual(String aStartingPoint, String aScope, String aFilter, String aCompareURL, boolean aStrict) {
        String urlFilter;
        String startingPoint;
        String urlSP;
        if (aCompareURL == null) {
            return false;
        }
        Vector urlParts = MVDUtil.splitString(aCompareURL = aCompareURL.trim(), "?");
        if (urlParts == null || urlParts.size() == 0) {
            return false;
        }
        if (((String)urlParts.get(0)).length() == 0) {
            return false;
        }
        if (urlParts.size() != 4) {
            if (aStrict) {
                return false;
            }
            int i = urlParts.size();
            for (int u = 0; u < 4 - i; ++u) {
                urlParts.add("");
            }
        }
        if ((urlSP = (String)urlParts.get(0)) == null) {
            return false;
        }
        if (!(urlSP = urlSP.trim().toLowerCase()).startsWith("ldap:///")) {
            urlSP = "ldap:///" + urlSP;
        }
        if (!urlSP.equalsIgnoreCase(startingPoint = "ldap:///" + aStartingPoint)) {
            return false;
        }
        boolean bScopeMatched = false;
        boolean bFilterMatched = false;
        String urlScope = (String)urlParts.get(2);
        if (urlScope == null || urlScope.length() == 0 || urlScope.equalsIgnoreCase(aScope)) {
            bScopeMatched = true;
        }
        if ((urlFilter = (String)urlParts.get(3)) == null || urlFilter.length() == 0 || urlFilter.equalsIgnoreCase(aFilter)) {
            bFilterMatched = true;
        }
        return bScopeMatched && bFilterMatched;
    }

    public static String getUID(Object instance) {
        String strRetVal = "";
        String strTemp = "";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            byte[] ipaddr = addr.getAddress();
            for (int i = 0; i < ipaddr.length; ++i) {
                Byte b = new Byte(ipaddr[i]);
                strTemp = Integer.toHexString(b.intValue() & 0xFF);
                while (strTemp.length() < 2) {
                    strTemp = '0' + strTemp;
                }
                strRetVal = strRetVal + strTemp;
            }
            strTemp = Long.toHexString(System.currentTimeMillis());
            while (strTemp.length() < 12) {
                strTemp = '0' + strTemp;
            }
            strRetVal = strRetVal + strTemp;
            SecureRandom prng = SecureRandom.getInstance("SHA1PRNG");
            strTemp = Integer.toHexString(prng.nextInt());
            while (strTemp.length() < 8) {
                strTemp = '0' + strTemp;
            }
            strRetVal = strRetVal + strTemp.substring(4);
            strTemp = Long.toHexString(System.identityHashCode(instance));
            while (strTemp.length() < 8) {
                strTemp = '0' + strTemp;
            }
            strRetVal = strRetVal + strTemp;
        }
        catch (UnknownHostException ex) {
            MVDLogger.Debug("Unknown Host Exception Caught: " + ex.getMessage());
        }
        catch (NoSuchAlgorithmException ex) {
            MVDLogger.Debug("No Such Algorithm Exception Caught: " + ex.getMessage());
        }
        return strRetVal.toLowerCase();
    }

    public static int getDatabaseType(String connection_string) {
        if (connection_string.indexOf("oracle") != -1) {
            return 1;
        }
        if (connection_string.indexOf("sqlserver") != -1) {
            return 2;
        }
        if (connection_string.indexOf("mysql") != -1) {
            return 3;
        }
        if (connection_string.indexOf("odbc") != -1) {
            return 4;
        }
        if (connection_string.indexOf("db2") != -1) {
            return 5;
        }
        if (connection_string.indexOf("domino") != -1) {
            return 6;
        }
        if (connection_string.indexOf("solid") != -1) {
            return 7;
        }
        MVDLogger.Debug("Unknown database type: " + connection_string, 6);
        return 0;
    }

    public static boolean isEmpty(String aTest) {
        return aTest == null || aTest.equals("");
    }
}

