/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds;

import com.sap.idm.vds.AbstractSystemManagement;
import com.sap.idm.vds.Engine;
import com.sap.idm.vds.EnginePool;
import com.sap.idm.vds.FetchAvailableFieldsJDBC;
import com.sap.idm.vds.FetchAvailableFieldsLDAP;
import com.sap.idm.vds.Globals;
import com.sap.idm.vds.MVDError;
import com.sap.idm.vds.MVDGlobals;
import com.sap.idm.vds.MVDHashMap;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDOperationResult;
import com.sap.idm.vds.MVDStatistics;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.MVDVersion;
import com.sap.idm.vds.cache.MVDCachePool;
import com.sap.idm.vds.config.Config;
import com.sap.idm.vds.config.MVDConfig;
import com.sap.idm.vds.config.MVDDataSource;
import com.sap.idm.vds.config.MVDDataSourceList;
import com.sap.idm.vds.config.MVDLDAPDeployment;
import com.sap.idm.vds.config.MVDLDAPDeploymentList;
import com.sap.idm.vds.config.MVDProxy;
import com.sap.idm.vds.config.MVDProxyLoggerDebitList;
import com.sap.idm.vds.config.MVDWSDeployment;
import com.sap.idm.vds.config.MVDWSDeploymentList;
import com.sap.idm.vds.config.ReloadConfig;
import com.sap.idm.vds.event.EventHandler;
import com.sap.idm.vds.ie.op.common.AbstractReader;
import com.sap.idm.vds.ie.op.db.vdsReadDB;
import com.sap.idm.vds.ie.op.http.vdsReadHTTP;
import com.sap.idm.vds.protocols.ldap.MxLdapListener;
import com.sap.idm.vds.sldreg.VDSSLDRegDeployed;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MVDServer {
    public static final String DEFAULT_APPLICATION_ID = "USE_PORT";
    private static AbstractReader mExternReader = null;
    public static final int CONFIGURATION_FROM_FILE = 0;
    public static final int CONFIGURATION_FROM_DB = 1;
    public static final int CONFIGURATION_FROM_MIC = 2;
    public static final int CONFIGURATION_FROM_HTTP = 3;
    private static MVDServer mMVDServerInstance;
    private static boolean mContinueStartup;
    private static String mUniqueInstanceID;
    private static int mMvdProtocol;
    private int mConfigSource = 0;
    public static final int MVD_PROTOCOL_LDAP = 0;
    public static final int MVD_PROTOCOL_API = 1;
    public static HashMap hashCommandArguments;
    private static MxLdapListener mLdapMainListener;
    private static Vector mLdapListeners;
    private static HashMap mActiveLdapListenerNames;
    private ReloadConfig mReloader;
    private EnginePool mEnginePool;

    public static AbstractReader getExternReader() {
        return mExternReader;
    }

    public static int getMVDProtocol() {
        return mMvdProtocol;
    }

    public static HashMap getActiveLdapListenerNames() {
        return mActiveLdapListenerNames;
    }

    public static String getUniqueInstanceID() {
        return mUniqueInstanceID;
    }

    public static void setUniqueInstanceID(String aID) {
        mUniqueInstanceID = aID;
    }

    public Engine getMessageHandler() {
        try {
            return EnginePool.checkOut();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int getConfigSourceType() {
        if (mMVDServerInstance != null) {
            return MVDServer.mMVDServerInstance.mConfigSource;
        }
        return 0;
    }

    public static void SLDRegDeployed() {
        MVDLogger.Log("SLD registration (deployed mode) ... ", 2);
        Vector<String> vAppURLs = new Vector<String>();
        Iterator iter = MVDWSDeploymentList.getWsDeployments().keySet().iterator();
        while (iter.hasNext()) {
            String lsName = (String)iter.next();
            MVDWSDeployment wsdp = (MVDWSDeployment)MVDWSDeploymentList.getWsDeployments().get(lsName);
            if (!wsdp.isEnabled()) continue;
            vAppURLs.add(wsdp.getApplicationName() + "/router");
        }
        MVDLogger.Log("SLD registration (deployed mode) - configuring", 2);
        VDSSLDRegDeployed.doConfigure(vAppURLs);
        VDSSLDRegDeployed.doPublish();
    }

    private void Serv(Config config, int aMvdProtocol) {
        try {
            MVDProxy.setActiveDeployment(mUniqueInstanceID);
            this.printVersions();
            mMvdProtocol = aMvdProtocol;
            Thread.currentThread().setName("0");
            MVDGlobals.setMainGroupName(Thread.currentThread().getThreadGroup().getName());
            MVDGlobals.setConfigurationFile(config.getConfigFile().getAbsolutePath());
            new Globals(config.getWorkArea());
            new MVDConfig(config, mUniqueInstanceID);
            config.setProtocol(aMvdProtocol);
            if (!mContinueStartup) {
                return;
            }
            this.mReloader = new ReloadConfig(config);
            this.mReloader.start();
            if (!mContinueStartup) {
                return;
            }
            try {
                String s = new String("gurba".getBytes("UTF-8"), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                MVDError.ConfigError("This Java Virtual Machine does not support UTF-8 conversion, which is needed for LDAP");
            }
            if (!mContinueStartup) {
                return;
            }
            this.RunStartUpMethod();
            if (!mContinueStartup) {
                return;
            }
            this.mEnginePool = new EnginePool();
            if (!mContinueStartup) {
                return;
            }
            if (Globals.getPriorityQueue() != null) {
                System.out.println("Starting priority queue (" + Globals.getPriorityQueue().getEngineLimit() + "," + Globals.getPriorityQueue().getQueueSizeLimit() + ")");
            }
            MxLdapListener aLdapListener = null;
            if (mMvdProtocol == 0) {
                Iterator iter = MVDLDAPDeploymentList.getLDAPDeployments().keySet().iterator();
                while (iter.hasNext()) {
                    String lsName = (String)iter.next();
                    MVDLDAPDeployment ldp = (MVDLDAPDeployment)MVDLDAPDeploymentList.getLDAPDeployments().get(lsName);
                    if (!ldp.isEnabled() || lsName.equalsIgnoreCase(MVDLDAPDeploymentList.getMainLDAPDeployment().getName())) continue;
                    aLdapListener = new MxLdapListener(ldp);
                    mLdapListeners.add(aLdapListener);
                    mActiveLdapListenerNames.put(ldp.getName(), aLdapListener);
                }
                for (int ix = 0; ix < mLdapListeners.size(); ++ix) {
                    aLdapListener = (MxLdapListener)mLdapListeners.elementAt(ix);
                    aLdapListener.start();
                    Thread.sleep(300L);
                    if (aLdapListener.isAlive()) continue;
                    throw new Exception("Could not start all listeners - exiting");
                }
                mLdapMainListener = new MxLdapListener(MVDLDAPDeploymentList.getMainLDAPDeployment());
                mActiveLdapListenerNames.put(MVDLDAPDeploymentList.getMainLDAPDeployment().getName(), mLdapMainListener);
                mLdapMainListener.execute();
            }
            if (!mContinueStartup) {
                return;
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            MVDLogger.Log(e.getMessage(), 7, e);
        }
        catch (Error e) {
            System.out.println("Error: " + e.toString());
            MVDLogger.Log("Error:" + e.toString(), 7, e);
        }
    }

    public static void logVersions() {
        MVDLogger.Log(MVDVersion.getVersionInfo(), 4);
        MVDLogger.Log("Java VM: " + System.getProperty("java.vendor") + "   Version: " + System.getProperty("java.version"), 4);
        MVDLogger.Log("Java home: " + System.getProperty("java.home"), 4);
        MVDLogger.Log("Java lib/ext: " + System.getProperty("java.ext.dirs"), 4);
        MVDLogger.Log("CLASSPATH: " + MVDUtil.replace(System.getProperty("java.class.path"), ";", "; "), 4);
    }

    private void printVersions() {
        System.out.println(MVDVersion.getVersionInfo());
        System.out.println("Java VM: " + System.getProperty("java.vendor") + "   Version: " + System.getProperty("java.version"));
        System.out.println("Java home: " + System.getProperty("java.home"));
        System.out.println("Java lib/ext: " + System.getProperty("java.ext.dirs"));
        System.out.println("CLASSPATH: " + System.getProperty("java.class.path"));
    }

    public static InputStream openFileOrURL(String aLocation) throws FileNotFoundException {
        InputStream result = null;
        try {
            URL url = new URL(aLocation);
            result = url.openStream();
        }
        catch (MalformedURLException mue) {
            result = null;
        }
        catch (IOException ioe) {
            result = null;
        }
        if (result == null) {
            result = new FileInputStream(aLocation);
        }
        return result;
    }

    public void prepare(String[] args) throws Exception {
        mMVDServerInstance = this;
        String xmlFileName = "";
        int startOpt = 0;
        if (args.length == 0) {
            MVDServer.usage();
        }
        if (args[0].equalsIgnoreCase("-version")) {
            MVDVersion.getVersionInfo();
            System.exit(0);
        }
        if (args[0].equalsIgnoreCase("-helper")) {
            if (args.length < 3) {
                MVDServer.usage();
            }
            xmlFileName = args[2];
            String addArgument = "";
            if (args.length == 4) {
                addArgument = args[3];
            }
            System.out.println(MVDServer.fetchAvailableFields(new Config(xmlFileName, null), args[1], addArgument));
            System.exit(0);
        }
        String commandParValue = "";
        String commandArgument = "";
        String commandKey = "";
        hashCommandArguments.put("PROTOCOL", "LDAP");
        for (int x = startOpt; x < args.length; ++x) {
            commandArgument = args[x];
            int iHelp = commandArgument.indexOf("=");
            if (iHelp < 0) {
                hashCommandArguments.put("FILE", commandArgument);
                continue;
            }
            commandKey = commandArgument.substring(0, iHelp).toLowerCase();
            commandParValue = commandArgument.substring(iHelp + 1);
            if (commandKey.equalsIgnoreCase("file")) {
                hashCommandArguments.put("FILE", commandParValue);
                continue;
            }
            if (commandKey.equalsIgnoreCase("type")) {
                hashCommandArguments.put("PROTOCOL", commandParValue);
                continue;
            }
            if (commandKey.equalsIgnoreCase("mic")) {
                hashCommandArguments.put("MIC", commandParValue);
                continue;
            }
            if (commandKey.equalsIgnoreCase("miccfg")) {
                hashCommandArguments.put("MICCFG", commandParValue);
                continue;
            }
            if (commandKey.equalsIgnoreCase("db")) {
                hashCommandArguments.put("DB", commandParValue);
                continue;
            }
            if (commandKey.equalsIgnoreCase("dbcfg")) {
                hashCommandArguments.put("DBCFG", commandParValue);
                continue;
            }
            if (commandKey.equalsIgnoreCase("driver")) {
                hashCommandArguments.put("DRIVER", commandParValue);
                continue;
            }
            if (commandKey.equalsIgnoreCase("config")) {
                hashCommandArguments.put("CONFIG", commandParValue);
                continue;
            }
            if (commandKey.equalsIgnoreCase("workArea")) {
                hashCommandArguments.put("WORKAREA", commandParValue);
                continue;
            }
            if (commandKey.equalsIgnoreCase("httpurl")) {
                hashCommandArguments.put("HTTPURL", commandParValue);
                continue;
            }
            if (!commandKey.equalsIgnoreCase("jdbcurl")) continue;
            hashCommandArguments.put("JDBCURL", commandParValue);
        }
        String jdbcurl = (String)hashCommandArguments.get("JDBCURL");
        String httpurl = (String)hashCommandArguments.get("HTTPURL");
        if (jdbcurl != null || httpurl != null) {
            String[] s = new String[12];
            int index = 0;
            s[index++] = "OPER=start";
            String exportConfigName = (String)hashCommandArguments.get("FILE");
            if (exportConfigName == null) {
                System.exit(1);
            } else {
                s[index++] = "OUTPUTCONFIG=" + exportConfigName;
            }
            if (jdbcurl != null) {
                String jdbcDriver;
                s[index++] = "JDBCURL=" + jdbcurl;
                String importtConfigName = (String)hashCommandArguments.get("DBCFG");
                if (importtConfigName != null) {
                    s[index++] = "DBCFG=" + importtConfigName;
                }
                if ((jdbcDriver = (String)hashCommandArguments.get("DRIVER")) != null) {
                    s[index++] = "DRIVER=" + jdbcDriver;
                }
                mExternReader = new vdsReadDB();
            } else if (httpurl != null) {
                s[index++] = "HTTPURL=" + httpurl;
                mExternReader = new vdsReadHTTP();
            }
            String[] co = new String[index];
            System.arraycopy(s, 0, co, 0, index);
            mExternReader.execute(co, false);
        }
    }

    public void start(int aProtocol, String aUniqueID) throws Exception {
        String xmlFileName = "";
        mUniqueInstanceID = aUniqueID;
        xmlFileName = (String)hashCommandArguments.get("FILE");
        if (xmlFileName != null) {
            this.Serv(new Config(xmlFileName, (String)hashCommandArguments.get("WORKAREA")), aProtocol);
        }
    }

    public static void main(String[] args) throws Exception {
        int aMvdProtocol;
        MVDServer mvdServer = new MVDServer();
        mvdServer.prepare(args);
        String strProto = (String)hashCommandArguments.get("PROTOCOL");
        String aMVDUniqueID = null;
        if (strProto.equalsIgnoreCase("LDAP")) {
            aMvdProtocol = 0;
            aMVDUniqueID = DEFAULT_APPLICATION_ID;
        } else if (strProto.equalsIgnoreCase("API")) {
            aMvdProtocol = 1;
            aMVDUniqueID = "myID";
        } else {
            aMvdProtocol = 0;
            aMVDUniqueID = DEFAULT_APPLICATION_ID;
        }
        mvdServer.start(aMvdProtocol, aMVDUniqueID);
        MVDServer.kill();
    }

    public static Engine getMessageHandlerInstance() {
        return mMVDServerInstance.getMessageHandler();
    }

    public static synchronized void kill() {
        if (mMVDServerInstance != null) {
            mMVDServerInstance.shutdown();
        }
        mContinueStartup = false;
    }

    public void shutdown() {
        System.out.println("Shutting down...");
        for (int ix = 0; ix < mLdapListeners.size(); ++ix) {
            MxLdapListener aListener = (MxLdapListener)mLdapListeners.elementAt(ix);
            aListener.shutdown();
        }
        if (mLdapMainListener != null) {
            mLdapMainListener.shutdown();
        }
        MVDCachePool.instance().shutdown();
        if (MVDServer.mMVDServerInstance.mReloader != null) {
            MVDServer.mMVDServerInstance.mReloader.shutdown();
        }
        if (MVDServer.mMVDServerInstance.mEnginePool != null) {
            MVDServer.mMVDServerInstance.mEnginePool.shutdown();
        }
        MVDStatistics.getInstance().stopStatisticsCollection();
        mMVDServerInstance = null;
        EventHandler.shutdown();
    }

    private static void usage() {
        System.out.println("USAGE:\nMVDServer -version \nMVDServer <xml configuration file> \nMVDServer <url for xml configuration file> \nMVDServer -helper <DS id> <xml file> \nMVDServer database=<database> config=<config name> workArea=<VDS home> [driver=<jdbc driver>] ");
        System.exit(0);
    }

    private void LoadJDBCdrivers() {
        Vector jdbcDrivers = MVDProxy.JDBCDrivers();
        String JDriver = "";
        if (jdbcDrivers != null && jdbcDrivers.size() > 0) {
            int ls = jdbcDrivers.size();
            for (int x = 0; x < ls; ++x) {
                try {
                    JDriver = (String)jdbcDrivers.elementAt(x);
                    Class.forName(JDriver);
                    MVDLogger.Log("Loaded JDBCDriver: " + JDriver, 1);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    MVDLogger.Log("Failed loading JDBCDriver: " + JDriver, 7, e);
                }
            }
        }
    }

    private void RunStartUpMethod() {
        MVDHashMap param = new MVDHashMap();
        param.putAll(MVDProxy.MVDGlobals());
        this.LoadJDBCdrivers();
        String startStr = MVDProxy.SystemManagementClass();
        if (startStr == null || startStr.length() == 0 || startStr.equalsIgnoreCase("none") || startStr.equalsIgnoreCase("com.sap.idm.vds.bc.MxBackwardsSystemManagement") && !MVDProxy.ExplAuth() && !MVDProxy.TransparentAuth()) {
            MVDOperationResult res = new MVDOperationResult();
            res.setOK();
            return;
        }
        Class t = (Class)Globals.GetExternalClass(startStr);
        AbstractSystemManagement o = null;
        try {
            o = (AbstractSystemManagement)t.newInstance();
            MVDOperationResult res = o.startUp(param);
            if (!res.isOK()) {
                MVDError.ConfigError("Start-up method failed: " + res.getMessage());
            }
        }
        catch (InstantiationException e) {
            MVDError.ConfigError("Can not create object for start-up method!");
        }
        catch (IllegalAccessException ee) {
            MVDError.ConfigError("Can not create object for start-up method!");
        }
        catch (Throwable ee) {
            MVDError.ConfigError("Exception in start-up method! " + ee.getMessage());
        }
    }

    private static String fetchAvailableFields(Config config, String dsIdStr, String additionalParams) {
        int dsIdInt;
        Thread.currentThread().setName("Help");
        new Globals(config.getWorkArea());
        String strVal = "";
        Document doc = config.getDoc();
        try {
            dsIdInt = Integer.parseInt(dsIdStr);
        }
        catch (Exception e) {
            return "ERROR: Datasource ID is not a number";
        }
        try {
            NodeList nl = doc.getElementsByTagName("Proxy");
            Node node = nl.item(0);
            MVDProxyLoggerDebitList.loadConfig(node, true);
            nl = doc.getElementsByTagName("DataSources");
            node = nl.item(0);
            MVDDataSourceList.loadHelperConfig(node, dsIdInt);
        }
        catch (VirtualMachineError vte) {
            Globals.blownAwayByThrowable(vte);
        }
        catch (Throwable tr) {
            System.out.println("Throwable, Failed reading config file: " + tr);
            MVDLogger.Log("Throwable:" + tr, 7);
        }
        MVDHashMap param = new MVDHashMap();
        MVDDataSource ds = MVDDataSourceList.getDSByID(dsIdInt);
        if (ds == null) {
            return "ERROR: No datasource found with id=" + dsIdInt;
        }
        param.putAll(ds.ParamFields());
        try {
            if (ds.DSType().equalsIgnoreCase("database")) {
                FetchAvailableFieldsJDBC mvdHelpJDBC = new FetchAvailableFieldsJDBC();
                return mvdHelpJDBC.fetchAvailableFields(param);
            }
            FetchAvailableFieldsLDAP mvdHelpLDAP = new FetchAvailableFieldsLDAP();
            return mvdHelpLDAP.fetchAvailableFields(param, additionalParams);
        }
        catch (Throwable e) {
            return "ERROR: Fetching attributes: " + e;
        }
    }

    static {
        mContinueStartup = true;
        mUniqueInstanceID = "";
        hashCommandArguments = new HashMap();
        mLdapMainListener = null;
        mLdapListeners = new Vector();
        mActiveLdapListenerNames = new HashMap();
    }
}

