/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds;

import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDSearchResultEntry;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.message.MxResponse;
import com.sap.idm.vds.util.HidedIDStoreOperations;
import com.sap.idm.vds.util.MVDOpUtilities;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;

public class MVDSearchResults
extends MxResponse {
    private int mCallbackEntries = 0;
    private boolean mPartial = false;

    public int PickTheNamingExceptionCode(NamingException ne) {
        return MVDOpUtilities.PickTheNamingExceptionCode(ne);
    }

    private HashMap ConvertJNDIAttributesToGeneralAttributes(Attributes attrs, boolean returnValues) {
        HashMap aAttrHash = new HashMap();
        if (attrs == null) {
            return aAttrHash;
        }
        try {
            String attrId = "";
            NamingEnumeration<? extends Attribute> ae = attrs.getAll();
            while (ae.hasMoreElements()) {
                Attribute attr = ae.next();
                try {
                    attrId = attr.getID();
                    Vector attrValuesVector = new Vector();
                    if (!returnValues) {
                        NamingEnumeration<?> vals = attr.getAll();
                        while (vals.hasMoreElements()) {
                            attrValuesVector.add(vals.nextElement());
                        }
                    }
                    aAttrHash.put(attrId.toLowerCase(), attrValuesVector);
                }
                catch (Exception e) {
                    MVDLogger.Log("Attribute : " + attrId + " failed " + e.getMessage(), 2);
                }
            }
        }
        catch (NamingException ne) {
            MVDLogger.Log("Naming exception: " + ne.getMessage(), 6, ne);
            return aAttrHash;
        }
        return aAttrHash;
    }

    public void putNamingEnumeration(NamingEnumeration ne, String startingpoint) throws Exception {
        this.putNamingEnumeration(ne, startingpoint, 0);
    }

    public void putNamingEnumeration(NamingEnumeration ne, String startingpoint, int szLimit) throws NamingException {
        if (szLimit > 0) {
            ++szLimit;
        }
        try {
            if (ne != null) {
                while (ne.hasMore()) {
                    SearchResult jndiResultEntry = (SearchResult)ne.next();
                    if (--szLimit == 0) {
                        MVDLogger.Log("Size limit reached, but remaining entries in NamingEnumeration. Skipping.", 2);
                        return;
                    }
                    HashMap aAttrHash = this.ConvertJNDIAttributesToGeneralAttributes(jndiResultEntry.getAttributes(), false);
                    String nm = jndiResultEntry.getName();
                    nm = MVDUtil.replace(nm, "\\\\", "\\");
                    startingpoint = MVDUtil.replace(startingpoint, "\\/", "/");
                    if ((nm = MVDUtil.replace(nm, "\\\"", "\"")).startsWith("\"")) {
                        nm = nm.substring(1);
                    }
                    if (nm.endsWith("\"")) {
                        nm = nm.substring(0, nm.length() - 1);
                    }
                    if (jndiResultEntry.isRelative()) {
                        if (nm.length() > 0) {
                            if (startingpoint.length() > 0) {
                                nm = nm + "," + startingpoint;
                            }
                        } else {
                            nm = startingpoint;
                        }
                    }
                    MVDLogger.Log("Name returned: " + nm, 1);
                    this.putEntry(new MVDSearchResultEntry(nm, aAttrHash));
                }
            }
            MVDLogger.Log("All entries in enumeration are put to the result", 1);
        }
        catch (NamingException e) {
            int aCode = this.PickTheNamingExceptionCode(e);
            if (aCode == 4 || aCode == 3 || aCode == 11 || aCode == 9) {
                MVDLogger.Log("Size, Time, Admin limit or Partial result code received", 2);
                this.setOK(aCode, e.getMessage());
            }
            MVDLogger.Log("NamingException in putNamingEnumeration", 2);
            throw e;
        }
    }

    public void putEntryWithJNDIAttributes(Attributes attributes, String startingpoint) {
        HashMap aAttrHash = this.ConvertJNDIAttributesToGeneralAttributes(attributes, false);
        this.putEntry(new MVDSearchResultEntry(startingpoint, aAttrHash));
    }

    public String addJDBCRecordSet(ResultSet rs) {
        int xxx = 123;
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            while (rs.next()) {
                ++xxx;
                MVDSearchResultEntry oneEntry = new MVDSearchResultEntry();
                int ls = rsmd.getColumnCount() + 1;
                for (int i = 1; i < ls; ++i) {
                    String colValue;
                    String colName = rsmd.getColumnName(i).toLowerCase();
                    String sso = rs.getString(i);
                    if (sso == null || (colValue = sso.toString()).length() <= 0) continue;
                    oneEntry.setAttrValue(colName, true, colValue, "|");
                }
                oneEntry.setDn("cn=" + xxx);
                this.putEntry(oneEntry);
            }
            return "OK";
        }
        catch (SQLException ex) {
            MVDLogger.Log("addJDBCRecordSet: fatal exception: " + ex.getMessage(), 7, ex);
            return "ERROR:" + ex.getMessage();
        }
    }

    public void fixJDBCDns(String dnTemplate) {
        int x;
        String replaceWith = "";
        String replaceEffWhat = "";
        String replaceWhatOrig = "";
        String replaceWhat = "";
        Vector<String> vecWhat = new Vector<String>();
        int ls = this.size();
        if (ls == 0) {
            return;
        }
        dnTemplate = dnTemplate.toLowerCase();
        Vector aha = MVDUtil.splitString(dnTemplate, "<");
        int t = aha.size();
        for (x = 0; x < t; ++x) {
            String templateElem = (String)aha.elementAt(x);
            int y = templateElem.indexOf(">");
            if (y <= -1) continue;
            vecWhat.add(templateElem.substring(0, y).toLowerCase());
        }
        for (x = 0; x < ls; ++x) {
            String newDn = dnTemplate.toLowerCase();
            MVDSearchResultEntry m = (MVDSearchResultEntry)this.elementAt(x);
            int tt = vecWhat.size();
            for (int y = 0; y < tt; ++y) {
                char aChar;
                replaceWhatOrig = (String)vecWhat.elementAt(y);
                boolean bReverse = false;
                if (replaceWhatOrig.startsWith("reverse_")) {
                    replaceEffWhat = replaceWhatOrig.substring(8);
                    bReverse = true;
                } else {
                    replaceEffWhat = replaceWhatOrig;
                }
                Vector vecReplaceWith = m.getAttrValues(replaceEffWhat);
                replaceWhat = "<" + replaceWhatOrig + ">";
                if (vecReplaceWith == null) {
                    replaceWith = "";
                    int idx = dnTemplate.indexOf(replaceWhat);
                    if (idx > 1) {
                        aChar = dnTemplate.charAt(idx - 1);
                        replaceWhat = aChar + replaceWhat;
                    }
                } else {
                    try {
                        replaceWith = (String)vecReplaceWith.elementAt(0);
                    }
                    catch (Exception e) {
                        replaceWith = MVDUtil.FromUTF8((byte[])vecReplaceWith.elementAt(0));
                    }
                    if (replaceWith.length() == 0) {
                        int idx = dnTemplate.indexOf(replaceWhat);
                        if (idx > 1) {
                            aChar = dnTemplate.charAt(idx - 1);
                            replaceWhat = aChar + replaceWhat;
                        }
                    } else if (bReverse) {
                        replaceWith = MVDOpUtilities.reverseDN(replaceWith);
                    }
                }
                newDn = MVDUtil.replace(newDn, replaceWhat, replaceWith);
            }
            m.setDn(newDn);
        }
    }

    public void fixIDStoreDns(String dnTemplate, String what, String objclassattr, HashMap objclasskeys) {
        int x;
        String replaceWith = "";
        String replaceEffWhat = "";
        String replaceWhatOrig = "";
        String replaceWhat = "";
        Vector<String> vecWhat = new Vector<String>();
        int ls = this.size();
        if (ls == 0) {
            return;
        }
        dnTemplate = dnTemplate.toLowerCase();
        Vector aha = MVDUtil.splitString(dnTemplate, "<");
        int t = aha.size();
        for (x = 0; x < t; ++x) {
            String templateElem = (String)aha.elementAt(x);
            int y = templateElem.indexOf(">");
            if (y <= -1) continue;
            vecWhat.add(templateElem.substring(0, y).toLowerCase());
        }
        for (x = 0; x < ls; ++x) {
            String newDn = dnTemplate.toLowerCase();
            MVDSearchResultEntry m = (MVDSearchResultEntry)this.elementAt(x);
            String thisobjclass = m.getFirstAttrValue(objclassattr);
            String ockey = "uid";
            if (thisobjclass != null) {
                if (objclasskeys != null) {
                    ockey = (String)objclasskeys.get(thisobjclass);
                    if (ockey == null) {
                        ockey = "uid";
                    }
                } else {
                    ockey = thisobjclass;
                }
            } else {
                ockey = "uid";
            }
            newDn = MVDUtil.replace(newDn, what, ockey);
            int tt = vecWhat.size();
            for (int y = 0; y < tt; ++y) {
                char aChar;
                replaceWhatOrig = (String)vecWhat.elementAt(y);
                boolean bReverse = false;
                if (replaceWhatOrig.startsWith("reverse_")) {
                    replaceEffWhat = replaceWhatOrig.substring(8);
                    bReverse = true;
                } else {
                    replaceEffWhat = replaceWhatOrig;
                }
                Vector vecReplaceWith = m.getAttrValues(replaceEffWhat);
                replaceWhat = "<" + replaceWhatOrig + ">";
                if (vecReplaceWith == null) {
                    replaceWith = "";
                    int idx = dnTemplate.indexOf(replaceWhat);
                    if (idx > 1) {
                        aChar = dnTemplate.charAt(idx - 1);
                        replaceWhat = aChar + replaceWhat;
                    }
                } else {
                    try {
                        replaceWith = (String)vecReplaceWith.elementAt(0);
                    }
                    catch (Exception e) {
                        replaceWith = MVDUtil.FromUTF8((byte[])vecReplaceWith.elementAt(0));
                    }
                    if (replaceWith.length() == 0) {
                        int idx = dnTemplate.indexOf(replaceWhat);
                        if (idx > 1) {
                            aChar = dnTemplate.charAt(idx - 1);
                            replaceWhat = aChar + replaceWhat;
                        }
                    } else if (bReverse) {
                        replaceWith = MVDOpUtilities.reverseDN(replaceWith);
                    }
                }
                newDn = MVDUtil.replace(newDn, replaceWhat, replaceWith);
            }
            m.setDn(newDn);
        }
    }

    public String addIDStoreRecordSetBase(ResultSet rs, HidedIDStoreOperations aOps, int ISID) {
        MVDSearchResultEntry oneEntry = null;
        String attrName = "";
        String attrValue = "";
        String mskey = "";
        int xxx = 123;
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            oneEntry = new MVDSearchResultEntry();
            while (rs.next()) {
                ++xxx;
                int limit = rsmd.getColumnCount() + 1;
                for (int i = 1; i < limit; ++i) {
                    String sso;
                    String colName = rsmd.getColumnName(i).toLowerCase();
                    if (colName.equalsIgnoreCase("AttrName")) {
                        sso = rs.getString(i);
                        if (sso == null) continue;
                        attrName = sso.toString();
                        continue;
                    }
                    if (colName.equalsIgnoreCase("aValue")) {
                        sso = rs.getString(i);
                        if (sso == null) continue;
                        attrValue = sso.toString();
                        continue;
                    }
                    if (!colName.equalsIgnoreCase("mskey") || (sso = rs.getString(i)) == null) continue;
                    mskey = sso.toString();
                }
                if (attrName != null && attrName.length() > 0) {
                    if (attrValue.startsWith(HidedIDStoreOperations.getLargeAttributePrefix())) {
                        try {
                            attrValue = aOps.get_large_attribute(ISID, Integer.parseInt(mskey), attrName, attrValue);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (attrValue != null && attrValue.length() > 0) {
                        oneEntry.setAttrValue(attrName.toLowerCase(), true, attrValue, "|");
                    }
                }
                if (mskey == null || mskey.length() <= 0) continue;
                oneEntry.setAttrValue("mskey", true, mskey, "|");
            }
            oneEntry.setDn("cn=" + xxx);
            this.putEntry(oneEntry);
            return "OK";
        }
        catch (SQLException ex) {
            MVDLogger.Log("addIDStoreRecordSet: fatal exception: " + ex.getMessage(), 7, ex);
            return "ERROR:" + ex.getMessage();
        }
    }

    public String addIDStoreRecordSetOneSub(ResultSet rs, HidedIDStoreOperations aOps, int ISID) {
        MVDSearchResultEntry oneEntry = null;
        String attrValue = "";
        String attrName = "";
        String mskey = "";
        int xxx = 123;
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            while (rs.next()) {
                ++xxx;
                oneEntry = new MVDSearchResultEntry();
                int limit = rsmd.getColumnCount() + 1;
                for (int i = 1; i < limit; ++i) {
                    String sso;
                    String colName = rsmd.getColumnName(i).toLowerCase();
                    if (colName.equalsIgnoreCase("AttrName")) {
                        sso = rs.getString(i);
                        if (sso == null) continue;
                        attrName = sso.toString();
                        continue;
                    }
                    if (colName.equalsIgnoreCase("aValue")) {
                        sso = rs.getString(i);
                        if (sso == null) continue;
                        attrValue = sso.toString();
                        continue;
                    }
                    if (!colName.equalsIgnoreCase("mskey") || (sso = rs.getString(i)) == null) continue;
                    mskey = sso.toString();
                }
                if (attrName != null && attrName.length() > 0) {
                    if (attrValue.startsWith(HidedIDStoreOperations.getLargeAttributePrefix())) {
                        try {
                            attrValue = aOps.get_large_attribute(ISID, Integer.parseInt(mskey), attrName, attrValue);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (attrValue != null && attrValue.length() > 0) {
                        oneEntry.setAttrValue(attrName.toLowerCase(), true, attrValue, "|");
                    }
                }
                if (mskey != null && mskey.length() > 0) {
                    oneEntry.setAttrValue("mskey", true, mskey, "|");
                }
                oneEntry.setDn("cn=" + xxx);
                this.putEntry(oneEntry);
            }
            return "OK";
        }
        catch (SQLException ex) {
            MVDLogger.Log("addIDStoreRecordSet: fatal exception: " + ex.getMessage(), 7, ex);
            return "ERROR:" + ex.getMessage();
        }
    }

    public boolean deleteEntry(String aDn) {
        boolean b = super.deleteEntry(aDn);
        if (b) {
            MVDLogger.Log("Deleting entry from result: " + aDn, 2);
        }
        return b;
    }

    public void join(MVDSearchResults msr) {
        for (int i = 0; i < this.size(); ++i) {
            MVDSearchResultEntry tempDN = (MVDSearchResultEntry)this.elementAt(i);
            tempDN.join((MVDSearchResultEntry)msr.elementAt(i));
        }
    }

    public void clear(int keepFirstEntries) {
        while (this.size() > keepFirstEntries) {
            this.removeElementAt(this.size() - 1);
        }
    }

    public Object clone() {
        MVDSearchResults s = (MVDSearchResults)super.clone();
        s.mCallbackEntries = this.mCallbackEntries;
        s.mPartial = this.mPartial;
        return s;
    }

    public String addIDSFromOneSearch(ResultSet rs, HidedIDStoreOperations aOps, int aExpandRefs, String nodeDN, int ISID) {
        HashMap refCache = new HashMap();
        HashMap<Integer, MVDSearchResultEntry> entries = new HashMap<Integer, MVDSearchResultEntry>();
        String attrValue = "";
        String attrName = "";
        String mskey = "";
        String datatypeid = "";
        int xxx = 123;
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            while (rs.next()) {
                ++xxx;
                int limit = rsmd.getColumnCount() + 1;
                for (int i = 1; i < limit; ++i) {
                    String sso;
                    String colName = rsmd.getColumnName(i).toLowerCase();
                    if (colName.equalsIgnoreCase("AttrName")) {
                        sso = rs.getString(i);
                        if (sso == null) continue;
                        attrName = sso.toString();
                        continue;
                    }
                    if (colName.equalsIgnoreCase("aValue")) {
                        sso = rs.getString(i);
                        if (sso == null) continue;
                        attrValue = sso.toString();
                        continue;
                    }
                    if (colName.equalsIgnoreCase("mskey")) {
                        sso = rs.getString(i);
                        if (sso == null) continue;
                        mskey = sso.toString();
                        continue;
                    }
                    if (!colName.equalsIgnoreCase("datatypeid") || aExpandRefs <= 0) continue;
                    datatypeid = rs.getString(i);
                }
                MVDSearchResultEntry oneEntry = (MVDSearchResultEntry)entries.get(new Integer(mskey));
                if (oneEntry == null) {
                    oneEntry = new MVDSearchResultEntry();
                    entries.put(new Integer(mskey), oneEntry);
                    oneEntry.setDn("cn=" + xxx);
                    oneEntry.setAttrValue("mskey", false, mskey);
                    this.putEntry(oneEntry);
                }
                if (aExpandRefs > 0 && ("5".equals(datatypeid) || "6".equals(datatypeid))) {
                    Vector attrValues = MVDUtil.splitString(attrValue, '|');
                    Vector<String> expanded = new Vector<String>();
                    for (int j = 0; j < attrValues.size(); ++j) {
                        String val = (String)attrValues.elementAt(j);
                        val = aOps.expandRef(datatypeid, attrValue, refCache, aExpandRefs);
                        if (aExpandRefs == 2) {
                            val = MVDUtil.replaceIgnoreCase(nodeDN, "<mskeyvalue>", val);
                        }
                        expanded.add(val);
                    }
                    attrValue = MVDUtil.joinStrings(expanded, "|");
                }
                if (attrName == null || attrName.length() <= 0) continue;
                if (attrValue.startsWith(HidedIDStoreOperations.getLargeAttributePrefix())) {
                    try {
                        attrValue = aOps.get_large_attribute(ISID, Integer.parseInt(mskey), attrName, attrValue);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (attrValue == null || attrValue.length() <= 0) continue;
                oneEntry.setAttrValue(attrName.toLowerCase(), true, attrValue, "|");
            }
            return "OK";
        }
        catch (SQLException ex) {
            MVDLogger.Log("addIDStoreRecordSet: fatal exception: " + ex.getMessage(), 7, ex);
            return "ERROR:" + ex.getMessage();
        }
    }

    public void setCallbackEntries(int aAmount) {
        this.mCallbackEntries += aAmount;
    }

    public int getCallbackEntries() {
        return this.mCallbackEntries;
    }

    public void setPartialResult() {
        this.mPartial = true;
    }

    public boolean isPartial() {
        return this.mPartial;
    }
}

