/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds;

import com.sap.idm.vds.AbstractAuthentication;
import com.sap.idm.vds.MVDHashMap;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDOperationResult;
import com.sap.idm.vds.MVDSearchResultEntry;
import com.sap.idm.vds.MVDSearchResults;
import com.sap.idm.vds.MVDUtil;
import java.util.HashMap;

public abstract class MVDRootInterface
extends AbstractAuthentication {
    protected String mUserName = null;
    protected String mPassword = null;
    protected String mClientIP = null;
    protected String mCertificate = null;
    protected String mUserGroup = null;
    protected final String REALDN = "REALDN";
    protected final String DSUNIQNAME = "DSUNIQNAME";
    protected HashMap SubResults = new HashMap();
    protected MVDHashMap SessionGlobals = null;
    protected MVDHashMap EngineGlobals = null;

    protected void getCommonParams(MVDHashMap aParams) {
        this.mUserName = (String)aParams.getLdapMandatoryParameter("USERNAME");
        MVDLogger.Debug("Received: " + this.mUserName + "/******");
        this.mPassword = (String)aParams.getLdapMandatoryParameter("USERPWD");
        this.mClientIP = (String)aParams.getLdapMandatoryParameter("CLIENTIP");
        this.mUserGroup = (String)aParams.getLdapMandatoryParameter("USERGROUP");
        this.mCertificate = (String)aParams.getLdapParameter("CERTIFICATE", null);
    }

    public String bind(MVDHashMap aParam) {
        MVDLogger.Log("Using MVDRootInterface is discouraged. Please use AbstractAuthentication instead.", 6);
        return this.Bind(aParam);
    }

    public void init(MVDHashMap sessionGlob, MVDHashMap engineGlob) {
        this.SessionGlobals = sessionGlob;
        this.EngineGlobals = engineGlob;
    }

    public MVDSearchResults RootDSE(MVDHashMap param) {
        MVDLogger.Debug("Running RootDSE method");
        MVDSearchResults result = new MVDSearchResults();
        MVDSearchResultEntry oneEntry = new MVDSearchResultEntry();
        oneEntry.setDn("");
        oneEntry.setAttrValue("objectclass", false, "org1|org2|org3", "|");
        oneEntry.setAttrValue("mail", false, "mail1");
        result.putEntry(oneEntry);
        result.setOK();
        return result;
    }

    public abstract String Bind(MVDHashMap var1);

    public MVDOperationResult StartUp(MVDHashMap param) {
        MVDOperationResult result = new MVDOperationResult();
        result.setOK();
        return result;
    }

    protected String getSubResultRealDN() {
        return (String)this.SubResults.get("REALDN");
    }

    protected void setSubResultDSUniqueName(String aDSUniqueName) {
        this.SubResults.put("REALDN", aDSUniqueName);
    }

    protected String getSubResultDSUniqueName() {
        return (String)this.SubResults.get("DSUNIQNAME");
    }

    protected void setSubResults(String aTree, String aUserName) {
        String dsUniqueName = MVDUtil.getUniqueDSNameByDN(aTree, aUserName);
        MVDLogger.Debug("The obtained unique datasource name is '" + dsUniqueName + "'");
        this.SubResults.put("DSUNIQNAME", dsUniqueName);
        String realDN = MVDUtil.getProperDN(aTree, aUserName);
        MVDLogger.Debug("The obtained real DN is '" + realDN + "'");
        this.SubResults.put("REALDN", realDN);
    }
}

