/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds;

import com.sap.idm.vds.AbstractPostProcessing;
import com.sap.idm.vds.MVDHashMap;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.message.MxAdd;
import com.sap.idm.vds.message.MxCompare;
import com.sap.idm.vds.message.MxDelete;
import com.sap.idm.vds.message.MxModify;
import com.sap.idm.vds.message.MxRequest;
import com.sap.idm.vds.message.MxResponse;
import com.sap.idm.vds.message.MxSearch;

public abstract class MVDPostProcessingInterface
extends AbstractPostProcessing {
    protected MVDHashMap SessionGlobals = null;
    protected MVDHashMap EngineGlobals = null;

    public MxResponse add(MxResponse aMxResp, MxAdd aMxReq) {
        return this.Add(aMxResp, aMxReq);
    }

    public MxResponse compare(MxResponse aMxResp, MxCompare aMxReq) {
        MVDLogger.Debug("Please extend AbstractPostProcessing to get Compare in post processing", 6);
        return aMxResp;
    }

    public MxResponse delete(MxResponse aMxResp, MxDelete aMxReq) {
        return this.Delete(aMxResp, aMxReq);
    }

    public MxResponse modify(MxResponse aMxResp, MxModify aMxReq) {
        return this.Modify(aMxResp, aMxReq);
    }

    public MxResponse search(MxResponse aMxResp, MxSearch aMxReq) {
        return this.Search(aMxResp, aMxReq);
    }

    public void init(MVDHashMap sessionGlob, MVDHashMap engineGlob) {
        this.SessionGlobals = sessionGlob;
        this.EngineGlobals = engineGlob;
    }

    public final MxResponse Process(MxResponse aResp, String opType, MxRequest aReq) {
        MVDLogger.Log("Executing PostProcess operation", 2);
        MxResponse mxResp = null;
        if (opType.equalsIgnoreCase("search")) {
            mxResp = this.Search(aResp, (MxSearch)aReq);
        } else if (opType.equalsIgnoreCase("add")) {
            mxResp = this.Add(aResp, (MxAdd)aReq);
        } else if (opType.equalsIgnoreCase("modify")) {
            mxResp = this.Modify(aResp, (MxModify)aReq);
        } else if (opType.equalsIgnoreCase("delete")) {
            mxResp = this.Delete(aResp, (MxDelete)aReq);
        } else {
            MVDLogger.Log("Invalid operation type '" + opType + "' - post transformation not carried out", 2);
            return aResp;
        }
        return mxResp;
    }

    public abstract MxResponse Search(MxResponse var1, MxSearch var2);

    public abstract MxResponse Add(MxResponse var1, MxAdd var2);

    public abstract MxResponse Modify(MxResponse var1, MxModify var2);

    public abstract MxResponse Delete(MxResponse var1, MxDelete var2);
}

