/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds;

import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDSearchResultEntry;
import com.sap.idm.vds.MVDSearchResults;
import com.sap.idm.vds.message.MxEntry;
import com.sap.idm.vds.util.LDAPUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class MVDInternalSearchResults
extends MVDSearchResults {
    public MVDInternalSearchResults() {
    }

    public MVDInternalSearchResults(Vector initVector, HashMap condHash, String descObjClass, String sp, String user, String pwd) {
        MVDSearchResultEntry aSingleResult = new MVDSearchResultEntry();
        aSingleResult.setDn(sp);
        aSingleResult.setAttrValue("objectclass", false, descObjClass, "|");
        if (initVector.size() == 0 || initVector.contains("*")) {
            Iterator iter = condHash.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry attr = iter.next();
                String sss = (String)attr.getKey();
                if (sss.equalsIgnoreCase("link")) {
                    try {
                        Vector values = (Vector)attr.getValue();
                        String dsname = (String)values.firstElement();
                        MxEntry linkentry = this.followLink(dsname, sp, user, pwd);
                        if (linkentry == null) continue;
                        aSingleResult.appendAttrAndValues(linkentry.getAttrAndValues());
                    }
                    catch (Exception e) {
                        MVDLogger.Log("Exception trying to get link on static node", 6, e);
                    }
                    continue;
                }
                aSingleResult.setAttrValue(sss, false, (Vector)((Vector)attr.getValue()).clone());
            }
        } else {
            int ls = initVector.size();
            for (int x = 0; x < ls; ++x) {
                String sss = ((String)initVector.elementAt(x)).toLowerCase();
                Vector values = (Vector)condHash.get(sss);
                if (values == null) continue;
                if (sss.equalsIgnoreCase("link")) {
                    try {
                        String dsname = (String)values.firstElement();
                        MxEntry linkentry = this.followLink(dsname, sp, user, pwd);
                        if (linkentry == null) continue;
                        aSingleResult.appendAttrAndValues(linkentry.getAttrAndValues());
                    }
                    catch (Exception e) {
                        MVDLogger.Log("Exception trying to get link on static node", 6, e);
                    }
                    continue;
                }
                aSingleResult.setAttrValue(sss, false, (Vector)values.clone());
            }
        }
        this.add(aSingleResult);
        this.setOK();
    }

    private MxEntry followLink(String aDSUniqueName, String aSp, String user, String pwd) {
        MVDSearchResults res = LDAPUtil.search(aDSUniqueName, user, pwd, aSp, 0, "", "(objectclass=*)", 0, 30);
        if (res.isOK()) {
            if (res.size() == 1) {
                MxEntry entry = res.getEntry(0);
                return entry;
            }
            if (res.size() == 0) {
                MVDLogger.Debug("No entry returned from link", 2);
                return null;
            }
            MVDLogger.Debug("More than one entry returned from link", 2);
            return null;
        }
        MVDLogger.Debug("Failed getting link for static node", 2);
        return null;
    }
}

