/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds;

import com.sap.idm.vds.MVDLogger;
import java.util.HashMap;

public class MVDHashMap
extends HashMap {
    private static final String AUTH_PREFIX = "AUTH_";
    private static final String GLOBAL_PREFIX = "GLOBAL_";
    private static final String LDAP_PREFIX = "LDAP_";
    private static final String DS_PREFIX = "DS_";
    private static final String NODE_PREFIX = "NODE_";
    private static final String DB_CONCAT = "DB";
    private static final String LDAP_CONCAT = "LDAP";

    public MVDHashMap() {
    }

    public MVDHashMap(HashMap h) {
        super(h);
    }

    public void putCaseSensitive(String key, String value) {
        if (value != null) {
            super.put(key, value);
        } else {
            super.put(key, value);
        }
    }

    public Object getMandatoryParameter(String key) throws RuntimeException {
        Object o = super.get(key);
        if (o == null) {
            throw new RuntimeException("Could not fetch parameter" + key);
        }
        return o;
    }

    public Object getParameter(String key, Object defaultValue) throws RuntimeException {
        Object o = super.get(key);
        if (o == null) {
            MVDLogger.Debug(key + " parameter was NOT given - using default value");
            return defaultValue;
        }
        return o;
    }

    public Object getPrefixedParameter(String prefix, String key, Object defaultValue) throws RuntimeException {
        String aKey = prefix + key;
        Object o = super.get(aKey);
        if (o == null) {
            MVDLogger.Debug(key + " parameter was NOT given - using default value");
            return defaultValue;
        }
        return o;
    }

    public Object getAuthParameter(String key, Object defaultValue) throws RuntimeException {
        return this.getPrefixedParameter(AUTH_PREFIX, key, defaultValue);
    }

    public Object getGlobalParameter(String key, Object defaultValue) throws RuntimeException {
        return this.getPrefixedParameter(GLOBAL_PREFIX, key, defaultValue);
    }

    public Object getLdapParameter(String key, Object defaultValue) throws RuntimeException {
        return this.getPrefixedParameter(LDAP_PREFIX, key, defaultValue);
    }

    public Object getDSParameter(String key, Object defaultValue) throws RuntimeException {
        return this.getPrefixedParameter(DS_PREFIX, key, defaultValue);
    }

    public Object getNodeParameter(String key, Object defaultValue) throws RuntimeException {
        return this.getPrefixedParameter(NODE_PREFIX, key, defaultValue);
    }

    public Object getPrefixedMandatoryParameter(String prefix, String key) throws RuntimeException {
        String aKey = prefix + key;
        Object o = super.get(aKey);
        if (o == null) {
            throw new RuntimeException("Could not fetch parameter" + key);
        }
        return o;
    }

    public Object getAuthMandatoryParameter(String key) throws RuntimeException {
        return this.getPrefixedMandatoryParameter(AUTH_PREFIX, key);
    }

    public Object getGlobalMandatoryParameter(String key) throws RuntimeException {
        return this.getPrefixedMandatoryParameter(GLOBAL_PREFIX, key);
    }

    public Object getLdapMandatoryParameter(String key) throws RuntimeException {
        return this.getPrefixedMandatoryParameter(LDAP_PREFIX, key);
    }

    public Object getDSMandatoryParameter(String key) throws RuntimeException {
        return this.getPrefixedMandatoryParameter(DS_PREFIX, key);
    }

    public Object getNodeMandatoryParameter(String key) throws RuntimeException {
        return this.getPrefixedMandatoryParameter(NODE_PREFIX, key);
    }

    public String backwardPrefixedFetch(String firstprefix, String key, String defaultValue) {
        String backward = (String)this.getPrefixedParameter(firstprefix, key, null);
        if ((backward == null || backward.length() == 0) && (backward = (String)this.getDSParameter(key, defaultValue)) == null) {
            backward = defaultValue;
        }
        MVDLogger.Debug("Value of " + key + "=" + backward);
        return backward;
    }

    public String concatPrefixedAttributeFetch(String firstprefix, String secondprefix, String aType, String key, String defaultValue) {
        String nodeval = (String)this.getPrefixedParameter(firstprefix, key, null);
        String dsval = (String)this.getPrefixedParameter(secondprefix, key, null);
        if (!(nodeval != null && nodeval.length() != 0 || dsval != null && dsval.length() != 0)) {
            return defaultValue;
        }
        if (nodeval == null || nodeval.length() == 0) {
            return dsval;
        }
        if (dsval == null || dsval.length() == 0) {
            return nodeval;
        }
        return nodeval + "," + dsval;
    }

    public String concatPrefixedFilterFetch(String firstprefix, String secondprefix, String aType, String key, String defaultValue) {
        String nodeval = (String)this.getPrefixedParameter(firstprefix, key, null);
        String dsval = (String)this.getPrefixedParameter(secondprefix, key, null);
        if (!(nodeval != null && nodeval.length() != 0 || dsval != null && dsval.length() != 0)) {
            return defaultValue;
        }
        if (nodeval == null || nodeval.length() == 0) {
            if (!(dsval = dsval.trim()).startsWith("(")) {
                dsval = "(" + dsval + ")";
            }
            MVDLogger.Log("Value of " + key + "=" + dsval, 1);
            return dsval;
        }
        if (dsval == null || dsval.length() == 0) {
            if (!(nodeval = nodeval.trim()).startsWith("(")) {
                nodeval = "(" + nodeval + ")";
            }
            MVDLogger.Log("Value of " + key + "=" + nodeval, 1);
            return nodeval;
        }
        if (!(nodeval = nodeval.trim()).startsWith("(")) {
            nodeval = "(" + nodeval + ")";
        }
        if (!(dsval = dsval.trim()).startsWith("(")) {
            dsval = "(" + dsval + ")";
        }
        String res = "";
        res = aType.equals(DB_CONCAT) ? "(" + nodeval + " AND " + dsval + ")" : "(&" + nodeval + dsval + ")";
        MVDLogger.Log("Value of " + key + "=" + res, 1);
        return res;
    }

    public String backwardFetch(String key, String defaultValue) {
        return this.backwardPrefixedFetch(NODE_PREFIX, key, defaultValue);
    }

    public String backwardGlobalFetch(String key, String defaultValue) {
        return this.backwardPrefixedFetch(GLOBAL_PREFIX, key, defaultValue);
    }

    public String backwardPrefixedMandatoryFetch(String firstprefix, String key) {
        String backward = (String)this.getPrefixedParameter(firstprefix, key, null);
        if (backward == null || backward.length() == 0) {
            return (String)this.getDSMandatoryParameter(key);
        }
        MVDLogger.Debug("Value of " + key + "=" + backward);
        return backward;
    }

    public String backwardMandatoryFetch(String key) {
        return this.backwardPrefixedMandatoryFetch(NODE_PREFIX, key);
    }

    public String backwardGlobalMandatoryFetch(String key) {
        return this.backwardPrefixedMandatoryFetch(GLOBAL_PREFIX, key);
    }

    public String concatDBFilterFetch(String key, String defaultValue) {
        return this.concatPrefixedFilterFetch(NODE_PREFIX, DS_PREFIX, DB_CONCAT, key, defaultValue);
    }

    public String concatLDAPFilterFetch(String key, String defaultValue) {
        return this.concatPrefixedFilterFetch(NODE_PREFIX, DS_PREFIX, LDAP_CONCAT, key, defaultValue);
    }

    public String concatAttributeFetch(String key, String defaultValue) {
        return this.concatPrefixedAttributeFetch(NODE_PREFIX, DS_PREFIX, LDAP_CONCAT, key, defaultValue);
    }
}

