/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds;

import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDMapping;
import com.sap.idm.vds.MVDServer;
import java.util.HashMap;

public class MVDError {
    public static HashMap mvdErrMap;
    public static final int ERR_BASE = -1000;
    public static final int errNoError = 0;
    public static final int errNoServerConfigured = -1011;
    public static final int errServerNotCorrect = -1012;
    public static final int errUserGroupNotFound = -1013;
    public static final int errOperationNotAllowed = -1022;
    public static final int errOperationError = -1023;
    public static final int errServerNotAvailable = -1031;
    public static final int errScriptError = -1034;
    public static final int errScriptNotDefined = -1044;
    public static final int errExplAuthFailed_Blank = -1051;
    public static final int errExplAuthFailed_NotConnected = -1052;
    public static final int errExplAuthFailed_StillMissingGroup = -1053;
    public static final int errExplAuthFailed_Error = -1054;
    public static final int errExplAuthFailed_IDidItMyWay = -1055;
    public static final int errExplAuthFailed_ScriptError = -1056;
    public static final int errExplAuthFailed_RootDSE = -1057;
    public static final int errRuleNotEnabled = -1062;
    public static final int errRuleNotDefined = -1063;
    public static final int errNoMappingNode = -1071;
    public static final int errOneLevelSearchNotAllowed = -1073;
    public static final int errSubSearchNotAllowed = -1074;
    public static final int errInvalidStartingPointRelation = -1080;
    public static final int errInsufficientAccess = -1086;
    public static final int errNoSuchObject = -1087;
    public static final int errSizeLimitExceeded = -1090;
    public static final int errTimeLimitExceeded = -1091;
    public static final int errSuppressErr = -1200;

    public MVDError() {
        mvdErrMap = new HashMap();
        mvdErrMap.put(new Integer(0), new MVDMapping(0, ""));
        mvdErrMap.put(new Integer(-1011), new MVDMapping(9999, "NOT YET USED"));
        mvdErrMap.put(new Integer(-1012), new MVDMapping(82, "Proper data source not found"));
        mvdErrMap.put(new Integer(-1013), new MVDMapping(49, "User group not found"));
        mvdErrMap.put(new Integer(-1022), new MVDMapping(50, "Insufficient access"));
        mvdErrMap.put(new Integer(-1023), new MVDMapping(9999, "NOT YET USED"));
        mvdErrMap.put(new Integer(-1031), new MVDMapping(82, "Defined data source not enabled"));
        mvdErrMap.put(new Integer(-1034), new MVDMapping(82, "Script execution failed"));
        mvdErrMap.put(new Integer(-1044), new MVDMapping(82, "Proper method is not defined"));
        mvdErrMap.put(new Integer(-1051), new MVDMapping(49, "Explicit authentication failed"));
        mvdErrMap.put(new Integer(-1052), new MVDMapping(49, "Explicit authentication failed"));
        mvdErrMap.put(new Integer(-1053), new MVDMapping(49, "Explicit authentication failed"));
        mvdErrMap.put(new Integer(-1054), new MVDMapping(49, "Explicit authentication failed"));
        mvdErrMap.put(new Integer(-1056), new MVDMapping(49, "Explicit authentication failed"));
        mvdErrMap.put(new Integer(-1057), new MVDMapping(48, "Explicit authentication failed"));
        mvdErrMap.put(new Integer(-1062), new MVDMapping(50, "Proper rule not enabled"));
        mvdErrMap.put(new Integer(-1063), new MVDMapping(50, "Proper rule not defined"));
        mvdErrMap.put(new Integer(-1071), new MVDMapping(32, "Couldn't perform DN to Data source mapping"));
        mvdErrMap.put(new Integer(-1073), new MVDMapping(0, "One level search is not allowed on this node"));
        mvdErrMap.put(new Integer(-1074), new MVDMapping(0, "Sub search is not allowed on this node"));
        mvdErrMap.put(new Integer(-1080), new MVDMapping(53, "Invalid starting point (or access profile)"));
        mvdErrMap.put(new Integer(-1086), new MVDMapping(50, "Insufficient access"));
        mvdErrMap.put(new Integer(-1087), new MVDMapping(32, "No such object"));
        mvdErrMap.put(new Integer(-1090), new MVDMapping(4, "Size limit exceeded"));
        mvdErrMap.put(new Integer(-1091), new MVDMapping(3, "Time limit exceeded"));
        mvdErrMap.put(new Integer(-1200), new MVDMapping(0, ""));
    }

    public static int GetMapping(int i) {
        Integer e = new Integer(i);
        MVDMapping m = (MVDMapping)mvdErrMap.get(e);
        if (m != null) {
            return m.getLdapError();
        }
        return 53;
    }

    public static String GetAdditionalInfo(int i) {
        Integer e = new Integer(i);
        MVDMapping m = (MVDMapping)mvdErrMap.get(e);
        if (m != null) {
            return m.getAdditionalInfo();
        }
        return "";
    }

    public static void ConfigError(String errorMessage) {
        System.err.println(errorMessage);
        MVDLogger.Log(errorMessage, 7);
        MVDServer.kill();
    }
}

