/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds;

import com.sap.idm.vds.AbstractAuthentication;
import com.sap.idm.vds.AbstractOperation;
import com.sap.idm.vds.AbstractPostProcessing;
import com.sap.idm.vds.AbstractPreProcessing;
import com.sap.idm.vds.AbstractRootDSE;
import com.sap.idm.vds.AbstractTransformation;
import com.sap.idm.vds.Engine;
import com.sap.idm.vds.Globals;
import com.sap.idm.vds.MVDAttributeFixInterface;
import com.sap.idm.vds.MVDAuthGlobals;
import com.sap.idm.vds.MVDDebitInfo;
import com.sap.idm.vds.MVDHashMap;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDOperationResult;
import com.sap.idm.vds.MVDServerSelectInterface;
import com.sap.idm.vds.config.MVDDataSource;
import com.sap.idm.vds.config.MVDProxy;
import com.sap.idm.vds.config.MVDUserGroup;
import com.sap.idm.vds.config.MVDUserGroupList;
import com.sap.idm.vds.config.MVDUserList;
import java.net.Socket;
import java.util.Iterator;

public class MVDEngineData {
    private MVDDebitInfo mMvdDebit = new MVDDebitInfo();
    private MVDUserGroup mMvdSessionsUserGroup = null;
    private boolean mIAmBinded = false;
    private Socket mTransparentAuthSocket = null;
    private MVDHashMap mInitatedInterfaces = new MVDHashMap();
    private MVDHashMap mInitializedOperations = new MVDHashMap();
    private MVDHashMap mExternalSessionGs = new MVDHashMap();
    private byte[] mLastASNString;
    private int mReloadNumber;
    private MVDUserGroup mOnBehalfOf;

    public MVDEngineData() {
        this.mExternalSessionGs.putAll(Globals.StartUpHash());
        this.mExternalSessionGs.put("AUTH_GLOBALS", new MVDAuthGlobals());
        this.mLastASNString = null;
        this.mReloadNumber = 0;
    }

    public MVDDebitInfo MvdDebit() {
        return this.mMvdDebit;
    }

    public MVDUserGroup MvdSessionsUserGroup() {
        return this.mMvdSessionsUserGroup;
    }

    public boolean IAmBinded() {
        return this.mIAmBinded;
    }

    public Socket getTransparentAuthSocket() {
        return this.mTransparentAuthSocket;
    }

    public MVDHashMap ExternalSessionGs() {
        return this.mExternalSessionGs;
    }

    public MVDHashMap InitatedInterfaces() {
        return this.mInitatedInterfaces;
    }

    public MVDHashMap getInitializedOperations() {
        return this.mInitializedOperations;
    }

    public byte[] LastASNString() {
        return this.mLastASNString;
    }

    public void SetMvdSessionsUserGroup(MVDUserGroup ug) {
        this.mMvdSessionsUserGroup = ug;
    }

    public void SetIAmBinded(boolean b) {
        this.mIAmBinded = b;
    }

    public void setTransparentAuthSocket(Socket s) {
        this.mTransparentAuthSocket = s;
    }

    public void SetExternalSessionGs(MVDHashMap s) {
        this.mExternalSessionGs = s;
    }

    public void SetLastASNString(byte[] b) {
        this.mLastASNString = b;
    }

    public void SetLastASNString(byte[] b, long x) {
        this.mLastASNString = new byte[(int)x];
        System.arraycopy(b, 0, this.mLastASNString, 0, (int)x);
    }

    public void RefreshUserGroup() {
        MVDUserGroup tempUG = this.mMvdSessionsUserGroup;
        this.mMvdSessionsUserGroup = MVDUserList.DetermineUserGroup(this.mMvdDebit.UserName(), this.mMvdDebit.UserPwd(), this.mMvdDebit.ClientIPAddress());
        if (this.mMvdSessionsUserGroup == null) {
            MVDLogger.Log("Could not find new UserGroup. Trying by id.", 2);
            this.mMvdSessionsUserGroup = MVDUserGroupList.getUGByID(tempUG.ID());
        }
        if (this.mMvdSessionsUserGroup == null) {
            MVDLogger.Log("Could not find new UserGroup. Trying by name.", 2);
            this.mMvdSessionsUserGroup = MVDUserGroupList.getUGByName(tempUG.Name());
        }
        MVDLogger.Log("Configuration reloaded, lost user group in open session. New ug: " + this.mMvdSessionsUserGroup, 2);
    }

    public void reset() {
        this.mMvdDebit.reset();
        this.mMvdSessionsUserGroup = null;
        this.mIAmBinded = false;
        this.mLastASNString = null;
        try {
            if (this.mTransparentAuthSocket != null) {
                this.mTransparentAuthSocket.close();
            }
            this.mTransparentAuthSocket = null;
        }
        catch (Exception e) {
            this.mTransparentAuthSocket = null;
            MVDLogger.Log("Error closing socket:" + e.getMessage(), 2);
        }
        Iterator ii = this.mInitializedOperations.keySet().iterator();
        while (ii.hasNext()) {
            String termScr;
            String qname = (String)ii.next();
            MVDDataSource dsTmp = (MVDDataSource)this.mInitializedOperations.get(qname);
            if (dsTmp == null || (termScr = dsTmp.PostOpScript()).equalsIgnoreCase("none")) continue;
            this.RunTerminateScripts(termScr);
        }
        this.mInitializedOperations.clear();
        this.mInitatedInterfaces.clear();
        this.mExternalSessionGs.clear();
        this.mExternalSessionGs.putAll(Globals.StartUpHash());
        this.mExternalSessionGs.put("AUTH_GLOBALS", new MVDAuthGlobals());
    }

    private void RunTerminateScripts(String termStr) {
        AbstractOperation o = (AbstractOperation)this.mInitatedInterfaces.get(termStr);
        if (o == null) {
            MVDLogger.Log("Could not execute trerminate script " + termStr, 7);
            return;
        }
        MVDHashMap param = new MVDHashMap();
        param.putAll(MVDProxy.MVDGlobals());
        try {
            MVDOperationResult res = o.terminate(param);
            if (!res.isOK()) {
                MVDLogger.Log("Terminate failed !!", 7);
            }
        }
        catch (VirtualMachineError vte) {
            Globals.blownAwayByThrowable(vte);
            return;
        }
        catch (Throwable ee) {
            MVDLogger.Log("Error on Terminate:" + ee.getMessage(), 7, ee);
            return;
        }
    }

    public AbstractOperation getInitiatedAbstractOperation(String extClassName, MVDHashMap useEngineGsHere) {
        Class t = null;
        this.verifyInitiatedinterfaces();
        AbstractOperation o = (AbstractOperation)this.mInitatedInterfaces.get(extClassName);
        if (o == null) {
            t = (Class)Globals.GetExternalClass(extClassName);
            try {
                o = (AbstractOperation)t.newInstance();
                o.init(this.mExternalSessionGs, useEngineGsHere);
                this.mInitatedInterfaces.put(extClassName, o);
            }
            catch (InstantiationException e) {
                MVDLogger.Log("Can not create object: " + e, 7, e);
                return null;
            }
            catch (IllegalAccessException ee) {
                MVDLogger.Log("Can not create object: " + ee, 7, ee);
                return null;
            }
            catch (VirtualMachineError vte) {
                Globals.blownAwayByThrowable(vte);
            }
            catch (Throwable tr) {
                System.out.println("Throwable, on search init:" + tr);
                MVDLogger.Log("Throwable:" + tr, 7);
                return null;
            }
        }
        return o;
    }

    public AbstractRootDSE getInitiatedRootDSEObject(String extClassName, MVDHashMap useEngineGsHere) {
        Class t = null;
        this.verifyInitiatedinterfaces();
        AbstractRootDSE o = (AbstractRootDSE)this.mInitatedInterfaces.get(extClassName);
        if (o == null) {
            t = (Class)Globals.GetExternalClass(extClassName);
            try {
                o = (AbstractRootDSE)t.newInstance();
                o.init(this.mExternalSessionGs, useEngineGsHere);
                this.mInitatedInterfaces.put(extClassName, o);
            }
            catch (InstantiationException e) {
                MVDLogger.Log("Can not create object:" + e.getMessage(), 7, e);
                return null;
            }
            catch (IllegalAccessException ee) {
                MVDLogger.Log("Can not create object:" + ee.getMessage(), 7, ee);
                return null;
            }
        }
        return o;
    }

    public AbstractAuthentication getInitiatedAuthenticationObject(String extClassName, MVDHashMap useEngineGsHere) {
        Class t = null;
        this.verifyInitiatedinterfaces();
        AbstractAuthentication o = (AbstractAuthentication)this.mInitatedInterfaces.get(extClassName);
        if (o == null) {
            t = (Class)Globals.GetExternalClass(extClassName);
            try {
                o = (AbstractAuthentication)t.newInstance();
                o.init(this.mExternalSessionGs, useEngineGsHere);
                this.mInitatedInterfaces.put(extClassName, o);
            }
            catch (InstantiationException e) {
                MVDLogger.Log("Can not create object:" + e.getMessage(), 7, e);
                return null;
            }
            catch (IllegalAccessException ee) {
                MVDLogger.Log("Can not create object:" + ee.getMessage(), 7, ee);
                return null;
            }
        }
        return o;
    }

    public MVDAttributeFixInterface getInitiatedAttrFixObject(String extClassName, MVDHashMap useEngineGsHere) {
        Class t = null;
        this.verifyInitiatedinterfaces();
        MVDAttributeFixInterface o = (MVDAttributeFixInterface)this.mInitatedInterfaces.get(extClassName);
        if (o == null) {
            t = (Class)Globals.GetExternalClass(extClassName);
            try {
                o = (MVDAttributeFixInterface)t.newInstance();
                o.init(this.mExternalSessionGs, useEngineGsHere);
                this.mInitatedInterfaces.put(extClassName, o);
            }
            catch (InstantiationException e) {
                MVDLogger.Log("Can not create object:" + e.getMessage(), 7, e);
                return null;
            }
            catch (IllegalAccessException ee) {
                MVDLogger.Log("Can not create object:" + ee.getMessage(), 7, ee);
                return null;
            }
        }
        return o;
    }

    public AbstractTransformation getInitiatedTransformationObject(String extClassName, MVDHashMap useEngineGsHere) {
        Class t = null;
        this.verifyInitiatedinterfaces();
        AbstractTransformation o = (AbstractTransformation)this.mInitatedInterfaces.get(extClassName);
        if (o == null) {
            t = (Class)Globals.GetExternalClass(extClassName);
            try {
                o = (AbstractTransformation)t.newInstance();
                o.init(this.mExternalSessionGs, useEngineGsHere);
                this.mInitatedInterfaces.put(extClassName, o);
            }
            catch (InstantiationException e) {
                MVDLogger.Log("Can not create object: " + e, 7, e);
                return null;
            }
            catch (IllegalAccessException ee) {
                MVDLogger.Log("Can not create object: " + ee, 7, ee);
                return null;
            }
            catch (VirtualMachineError vte) {
                Globals.blownAwayByThrowable(vte);
            }
            catch (Throwable tr) {
                System.out.println("Throwable, on search init:" + tr);
                MVDLogger.Log("Throwable:" + tr, 7);
                return null;
            }
        }
        return o;
    }

    public AbstractPreProcessing getInitiatedPreProcessingObject(String extClassName, MVDHashMap useEngineGsHere) {
        Class t = null;
        this.verifyInitiatedinterfaces();
        AbstractPreProcessing o = (AbstractPreProcessing)this.mInitatedInterfaces.get(extClassName);
        if (o == null) {
            t = (Class)Globals.GetExternalClass(extClassName);
            try {
                o = (AbstractPreProcessing)t.newInstance();
                o.init(this.mExternalSessionGs, useEngineGsHere);
                this.mInitatedInterfaces.put(extClassName, o);
            }
            catch (InstantiationException e) {
                MVDLogger.Log("Can not create object: " + e, 7, e);
                return null;
            }
            catch (IllegalAccessException ee) {
                MVDLogger.Log("Can not create object: " + ee, 7, ee);
                return null;
            }
            catch (VirtualMachineError vte) {
                Globals.blownAwayByThrowable(vte);
            }
            catch (Throwable tr) {
                System.out.println("Throwable, on search init:" + tr);
                MVDLogger.Log("Throwable:" + tr, 7);
                return null;
            }
        }
        return o;
    }

    public AbstractPostProcessing getInitiatedPostProcessingObject(String extClassName, MVDHashMap useEngineGsHere) {
        Class t = null;
        this.verifyInitiatedinterfaces();
        AbstractPostProcessing o = (AbstractPostProcessing)this.mInitatedInterfaces.get(extClassName);
        if (o == null) {
            t = (Class)Globals.GetExternalClass(extClassName);
            try {
                o = (AbstractPostProcessing)t.newInstance();
                o.init(this.mExternalSessionGs, useEngineGsHere);
                this.mInitatedInterfaces.put(extClassName, o);
            }
            catch (InstantiationException e) {
                MVDLogger.Log("Can not create object: " + e, 7, e);
                return null;
            }
            catch (IllegalAccessException ee) {
                MVDLogger.Log("Can not create object: " + ee, 7, ee);
                return null;
            }
            catch (VirtualMachineError vte) {
                Globals.blownAwayByThrowable(vte);
            }
            catch (Throwable tr) {
                System.out.println("Throwable, on search init:" + tr);
                MVDLogger.Log("Throwable:" + tr, 7);
                return null;
            }
        }
        return o;
    }

    public MVDServerSelectInterface getInitiatedMultiSearchObject(String extClassName, MVDHashMap useEngineGsHere) {
        Class t = null;
        this.verifyInitiatedinterfaces();
        MVDServerSelectInterface o = (MVDServerSelectInterface)this.mInitatedInterfaces.get(extClassName);
        if (o == null) {
            t = (Class)Globals.GetExternalClass(extClassName);
            try {
                o = (MVDServerSelectInterface)t.newInstance();
                this.mInitatedInterfaces.put(extClassName, o);
            }
            catch (InstantiationException e) {
                MVDLogger.Log("Can not create object: " + e, 7, e);
                return null;
            }
            catch (IllegalAccessException ee) {
                MVDLogger.Log("Can not create object: " + ee, 7, ee);
                return null;
            }
            catch (VirtualMachineError vte) {
                Globals.blownAwayByThrowable(vte);
            }
            catch (Throwable tr) {
                System.out.println("Throwable, on search init:" + tr);
                MVDLogger.Log("Throwable:" + tr, 7);
                return null;
            }
        }
        return o;
    }

    public void verifyInitiatedinterfaces() {
        int currentReload = Engine.getGlobalReloadCounter();
        if (this.mReloadNumber != currentReload) {
            this.mReloadNumber = currentReload;
            this.mInitatedInterfaces.clear();
        }
    }

    public MVDUserGroup getOnBehalfOf() {
        return this.mOnBehalfOf;
    }

    public void setOnBeHalfOf(MVDUserGroup onBeHalfOf) {
        this.mOnBehalfOf = onBeHalfOf;
    }

    public MVDAuthGlobals getAuthGlobals() {
        MVDAuthGlobals authglobals = (MVDAuthGlobals)this.mExternalSessionGs.get("AUTH_GLOBALS");
        return authglobals;
    }

    public void setAuthGlobals(MVDAuthGlobals aAuthGlobals) {
        this.mExternalSessionGs.put("AUTH_GLOBALS", aAuthGlobals);
    }
}

