/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds;

import com.sap.idm.vds.EnginePool;
import com.sap.idm.vds.Globals;

public class MVDDebitInfo {
    private static final String SEP = " ! ";
    private String mStartingPoint;
    private int mVersion;
    private int mStartOpTime;
    private int mEndOpTime;
    private int mNumberOfBytes;
    private String mUserName;
    private String mUserPwd;
    private String mUserGroup;
    private String mOperationType;
    private String mOperationSubType;
    private int mReturnedEntries;
    private int mReturnedReferrals;
    private String mClientIPAddress;
    private String mFilter;
    private String mRequestedAttributes;
    private String mComparingAttribute;
    private int mResultCode;
    private String mResultMessage;
    private boolean mCached;
    private long mOperationStart;
    private long mOperationEnd;

    public void reset() {
        this.mStartingPoint = "";
        this.mUserName = "";
        this.mUserPwd = "";
        this.mOperationType = "";
        this.mOperationSubType = "";
        this.mClientIPAddress = "";
        this.mFilter = "";
        this.mUserGroup = "";
        this.mVersion = 3;
        this.mStartOpTime = 0;
        this.mEndOpTime = 0;
        this.mNumberOfBytes = 0;
        this.mReturnedEntries = 0;
        this.mReturnedReferrals = 0;
        this.mResultCode = 0;
        this.mResultMessage = "";
        this.mRequestedAttributes = "";
        this.mCached = false;
        this.mOperationStart = 0L;
        this.mOperationEnd = -1L;
    }

    public MVDDebitInfo() {
        this.reset();
    }

    public void SetStartingPoint(String sp) {
        this.mStartingPoint = sp;
    }

    public void SetUserName(String sp) {
        this.mUserName = sp;
    }

    public void SetUserPwd(String sp) {
        this.mUserPwd = sp;
    }

    public void SetUserGroup(String sp) {
        this.mUserGroup = sp;
    }

    public void SetOperationType(String sp) {
        this.mOperationType = sp;
    }

    public void SetOperationSubType(String sp) {
        this.mOperationSubType = sp;
    }

    public void SetVersion(int i) {
        this.mVersion = i;
    }

    public void SetStartOpTime(int i) {
        this.mStartOpTime = i;
    }

    public void SetEndOpTime(int i) {
        this.mEndOpTime = i;
    }

    public void SetNumberOfBytes(int i) {
        this.mNumberOfBytes = i;
    }

    public void SetReturnedEntries(int i) {
        this.mReturnedEntries = i;
    }

    public void SetReturnedReferrals(int i) {
        this.mReturnedReferrals = i;
    }

    public void SetClientIPAddress(String sp) {
        this.mClientIPAddress = sp;
    }

    public void SetFilter(String sp) {
        this.mFilter = sp;
    }

    public void SetResultCode(int i) {
        this.mResultCode = i;
    }

    public void SetResultMessage(String sp) {
        this.mResultMessage = sp;
    }

    public void SetRequestedAttributes(String sp) {
        this.mRequestedAttributes = sp;
    }

    public void SetComparingAttribute(String sp) {
        this.mComparingAttribute = sp;
    }

    public void SetCached(boolean aCached) {
        this.mCached = aCached;
    }

    public String StartingPoint() {
        return this.mStartingPoint;
    }

    public String UserName() {
        return this.mUserName;
    }

    public String UserPwd() {
        return this.mUserPwd;
    }

    public String UserGroup() {
        return this.mUserGroup;
    }

    public String OperationType() {
        return this.mOperationType;
    }

    public String OperationSubType() {
        return this.mOperationSubType;
    }

    public int Version() {
        return this.mVersion;
    }

    public int StartOpTime() {
        return this.mStartOpTime;
    }

    public int EndOpTime() {
        return this.mEndOpTime;
    }

    public int NumberOfBytes() {
        return this.mNumberOfBytes;
    }

    public int ReturnedEntries() {
        return this.mReturnedEntries;
    }

    public int ReturnedReferrals() {
        return this.mReturnedReferrals;
    }

    public String ClientIPAddress() {
        return this.mClientIPAddress;
    }

    public String Filter() {
        return this.mFilter;
    }

    public String RequestedAttributes() {
        return this.mRequestedAttributes;
    }

    public String ComparingAttribute() {
        return this.mComparingAttribute;
    }

    public boolean Cached() {
        return this.mCached;
    }

    public int resultCode() {
        return this.mResultCode;
    }

    public void startOperation() {
        this.mOperationStart = System.currentTimeMillis();
    }

    public void endOperation() {
        this.mOperationEnd = System.currentTimeMillis();
    }

    private static String minString(String s, int m) {
        if (s.length() >= m) {
            return s;
        }
        StringBuffer sb = new StringBuffer(m);
        sb.insert(0, s);
        for (int x = s.length(); x < m; ++x) {
            sb.insert(x, " ");
        }
        return sb.substring(0);
    }

    public String toDebitString() {
        return MVDDebitInfo.minString(this.mStartingPoint, 32) + SEP + MVDDebitInfo.minString(this.mOperationType, 6) + SEP + MVDDebitInfo.minString(this.mOperationSubType, 9) + SEP + MVDDebitInfo.minString(this.mFilter, 32) + SEP + MVDDebitInfo.minString(new Integer(this.mReturnedEntries).toString(), 7) + SEP + MVDDebitInfo.minString(this.mUserName, 32) + SEP + MVDDebitInfo.minString(this.mUserPwd, 10) + SEP + MVDDebitInfo.minString(this.mClientIPAddress, 15) + SEP + MVDDebitInfo.minString(this.mUserGroup, 14);
    }

    public String toDebitStringSimple() {
        return this.mStartingPoint + SEP + this.mOperationType + SEP + this.mOperationSubType + SEP + this.mFilter + SEP + new Integer(this.mReturnedEntries).toString() + SEP + this.mUserName + SEP + this.mUserPwd + SEP + this.mClientIPAddress + SEP + this.mUserGroup;
    }

    public String toXmlDebitString() {
        if (this.mOperationType.equalsIgnoreCase("SEARCH")) {
            if (this.mRequestedAttributes.startsWith("[") && this.mRequestedAttributes.endsWith("]")) {
                this.mRequestedAttributes = this.mRequestedAttributes.substring(1, this.mRequestedAttributes.length() - 1);
            }
            return "<UserName>" + this.mUserName + "</UserName>" + "<ClientIP>" + this.mClientIPAddress + "</ClientIP>" + "<UserGroup>" + this.mUserGroup + "</UserGroup>" + "<StartingPoint>" + this.mStartingPoint + "</StartingPoint>" + "<OperationType>" + this.mOperationType + "</OperationType>" + "<OperationSubType>" + this.mOperationSubType + "</OperationSubType>" + "<Filter>" + this.mFilter + "</Filter>" + "<RequestedAttributes>" + this.mRequestedAttributes + "</RequestedAttributes>" + "<ReturnedEntries>" + this.mReturnedEntries + "</ReturnedEntries>" + "<ResultCode>" + this.mResultCode + "</ResultCode>" + "<ResultMessage>" + this.mResultMessage + "</ResultMessage>";
        }
        if (this.mOperationType.equalsIgnoreCase("COMPARE")) {
            return "<UserName>" + this.mUserName + "</UserName>" + "<ClientIP>" + this.mClientIPAddress + "</ClientIP>" + "<UserGroup>" + this.mUserGroup + "</UserGroup>" + "<DN>" + this.mStartingPoint + "</DN>" + "<OperationType>" + this.mOperationType + "</OperationType>" + "<ComparingAttribute>" + this.mComparingAttribute + "</ComparingAttribute>" + "<ResultCode>" + this.mResultCode + "</ResultCode>" + "<ResultMessage>" + this.mResultMessage + "</ResultMessage>";
        }
        return "<UserName>" + this.mUserName + "</UserName>" + "<ClientIP>" + this.mClientIPAddress + "</ClientIP>" + "<UserGroup>" + this.mUserGroup + "</UserGroup>" + "<DN>" + this.mStartingPoint + "</DN>" + "<OperationType>" + this.mOperationType + "</OperationType>" + "<ResultCode>" + this.mResultCode + "</ResultCode>" + "<ResultMessage>" + this.mResultMessage + "</ResultMessage>";
    }

    public String toString() {
        String DELIMITER = Globals.getDebitDelimiter();
        if (this.mOperationType.equalsIgnoreCase("SEARCH")) {
            if (this.mRequestedAttributes.startsWith("[") && this.mRequestedAttributes.endsWith("]")) {
                this.mRequestedAttributes = this.mRequestedAttributes.substring(1, this.mRequestedAttributes.length() - 1);
            }
            return "UserName:" + this.mUserName + DELIMITER + "ClientIP:" + this.mClientIPAddress + DELIMITER + "UserGroup:" + this.mUserGroup + DELIMITER + "StartingPoint:" + this.mStartingPoint + DELIMITER + "OperationType:" + this.mOperationType + DELIMITER + "OperationSubType:" + this.mOperationSubType + DELIMITER + "Filter:" + this.mFilter + DELIMITER + "RequestedAttributes:" + this.mRequestedAttributes + DELIMITER + "ReturnedEntries:" + this.mReturnedEntries + DELIMITER + "ResultCode:" + this.mResultCode + DELIMITER + "ResultMessage:" + this.mResultMessage + DELIMITER + "Fetched from cache: " + this.mCached + DELIMITER + "Operation duration (ms):" + (this.mOperationEnd - this.mOperationStart) + DELIMITER + "System load (engines):" + EnginePool.getBusyEnginesCount();
        }
        if (this.mOperationType.equalsIgnoreCase("COMPARE")) {
            return "UserName:" + this.mUserName + DELIMITER + "ClientIP:" + this.mClientIPAddress + DELIMITER + "UserGroup:" + this.mUserGroup + DELIMITER + "DN:" + this.mStartingPoint + DELIMITER + "OperationType:" + this.mOperationType + DELIMITER + "ComparingAttribute:" + this.mComparingAttribute + DELIMITER + "ResultCode:" + this.mResultCode + DELIMITER + "ResultMessage:" + this.mResultMessage;
        }
        return "UserName:" + this.mUserName + DELIMITER + "ClientIP:" + this.mClientIPAddress + DELIMITER + "UserGroup:" + this.mUserGroup + DELIMITER + "DN:" + this.mStartingPoint + DELIMITER + "OperationType:" + this.mOperationType + DELIMITER + "ResultCode:" + this.mResultCode + DELIMITER + "ResultMessage:" + this.mResultMessage;
    }
}

