/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds;

import com.sap.idm.vds.MVDHashMap;
import com.sap.idm.vds.MVDSearchResultEntry;
import com.sap.idm.vds.MVDSearchResults;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.util.LDAPUtil;
import java.util.Vector;

public class FetchAvailableFieldsLDAP {
    public String fetchAvailableFields(MVDHashMap param, String additionalParams) {
        String startingpoint = "";
        String filter = "objectclass=*";
        String aUser = "";
        String aPassword = "";
        Vector v = MVDUtil.splitString(additionalParams, "[$]");
        startingpoint = (String)v.elementAt(0);
        if (startingpoint.length() < 3) {
            return "ERROR: Missing 'SP:' part of the aditional parameters";
        }
        startingpoint = startingpoint.substring(3);
        if (v.size() < 2) {
            return "ERROR: Missing filter part of the aditional parameters";
        }
        filter = (String)v.elementAt(1);
        if (filter.length() < 7) {
            return "ERROR: Missing 'FILTER:' part of the aditional parameters";
        }
        filter = filter.substring(7);
        String aServer = (String)param.get("DS_SERVER");
        String aPort = (String)param.get("DS_PORT");
        aUser = (String)param.get("DS_USER");
        if (aUser == null) {
            aUser = "";
        }
        if ((aPassword = (String)param.get("DS_PASSWORD")) == null) {
            aPassword = "";
        }
        Vector attrs = new Vector();
        String secProt = null;
        String aVersion = (String)param.get("DS_VERSION");
        if (aVersion != null) {
            if (aVersion.equals("3") || aVersion.equals("2")) {
                secProt = "::" + aVersion;
            } else {
                return "ERROR: Invalid LDAP version: " + aVersion;
            }
        }
        MVDSearchResults result = LDAPUtil.search(aServer, aPort, aUser, aPassword, startingpoint, 2, attrs, filter, 100, 0, secProt, null, false, null);
        Vector superVector = new Vector();
        for (int x = 0; x < result.size(); ++x) {
            MVDSearchResultEntry rr = (MVDSearchResultEntry)result.elementAt(x);
            v = rr.getAttributes();
            v.removeAll(superVector);
            superVector.addAll(v);
        }
        String temps = superVector.toString();
        if ((temps = MVDUtil.replace(temps, ", ", ",")) != null && temps.length() > 2) {
            return temps.substring(1, temps.length() - 1);
        }
        return "";
    }

    public static void main(String[] argv) {
        MVDHashMap h = new MVDHashMap();
        h.put("DS_SERVER", "directory.maxware.com");
        h.put("DS_PORT", "389");
        System.out.println(new FetchAvailableFieldsLDAP().fetchAvailableFields(h, "SP:O=maxware international,C=no[$]FILTER:objectclass=*"));
    }
}

