/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds;

import com.sap.idm.vds.EnginePool;
import com.sap.idm.vds.Globals;
import com.sap.idm.vds.MVDCacheUtil;
import com.sap.idm.vds.MVDEngineData;
import com.sap.idm.vds.MVDException;
import com.sap.idm.vds.MVDGlobalStatistics;
import com.sap.idm.vds.MVDHashMap;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDSearchResults;
import com.sap.idm.vds.MVDServer;
import com.sap.idm.vds.MVDStatistics;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.MxLDAPBindException;
import com.sap.idm.vds.PartialResultCallbackHandler;
import com.sap.idm.vds.config.MVDLDAPDeployment;
import com.sap.idm.vds.config.MVDLDAPDeploymentList;
import com.sap.idm.vds.config.MVDProxy;
import com.sap.idm.vds.ldapv3.LDAPMessage;
import com.sap.idm.vds.message.MxAdd;
import com.sap.idm.vds.message.MxBind;
import com.sap.idm.vds.message.MxCompare;
import com.sap.idm.vds.message.MxDelete;
import com.sap.idm.vds.message.MxModify;
import com.sap.idm.vds.message.MxRequest;
import com.sap.idm.vds.message.MxResponse;
import com.sap.idm.vds.message.MxSearch;
import com.sap.idm.vds.operations.AddOperation;
import com.sap.idm.vds.operations.BindOperation;
import com.sap.idm.vds.operations.CompareOperation;
import com.sap.idm.vds.operations.DeleteOperation;
import com.sap.idm.vds.operations.ModifyOperation;
import com.sap.idm.vds.operations.RenameOperation;
import com.sap.idm.vds.operations.SearchOperation;
import com.sap.idm.vds.protocols.ldap.MxLdapListener;
import com.sap.idm.vds.protocols.ldap.MxLdapMessageHandler;
import com.sap.idm.vds.protocols.ldap.MxLdapResponse;
import com.sap.idm.vds.protocols.ldap.MxLdapTransform;
import com.sap.idm.vds.protocols.ldap.MxProtoTransform;
import com.sap.idm.vds.util.MVDDebitLogger;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class Engine {
    public static final String MX_CALLBACK_HANDLER = "#MX_CALLBACK_HANDLER#";
    private static int sGlobalReloadCounter = 0;
    private int mReloadCounter = 0;
    private MVDHashMap mEngineGs = new MVDHashMap();
    private MVDEngineData mEngineData;
    private int mSerialId = Globals.GetUniqueEngineId();
    private MxProtoTransform mProtocolTransform = null;
    private static int mStatBind = 0;
    private static int mStatSearch = 0;
    private static int mStatAdd = 0;
    private static int mStatModify = 0;
    private static int mStatDelete = 0;
    private static int mStatCompare = 0;
    private MxLdapMessageHandler mMessageHandler;

    public static void increaseGlobalReloadCounter() {
        ++sGlobalReloadCounter;
    }

    public static int getGlobalReloadCounter() {
        return sGlobalReloadCounter;
    }

    public int getReloadCounter() {
        return this.mReloadCounter;
    }

    public void setReloadCounter(int i) {
        this.mReloadCounter = i;
    }

    public Engine() throws Exception {
        if (Globals.bLimitMaxNrOfEngines && this.mSerialId == -9999) {
            MVDLogger.Log("Engine: No more allowed ", 6);
            throw new Exception("No more engines allowed");
        }
        this.mEngineData = new MVDEngineData();
        MVDLogger.Log("Engine: Creating new (" + this.mSerialId + ")", 0);
        this.mProtocolTransform = new MxProtoTransform(this.mEngineData, this.mEngineGs);
    }

    public static int getBindCounter() {
        return mStatBind;
    }

    public static int getSearchCounter() {
        return mStatSearch;
    }

    public static int getAddCounter() {
        return mStatAdd;
    }

    public static int getModifyCounter() {
        return mStatModify;
    }

    public static int getDeleteCounter() {
        return mStatDelete;
    }

    public static int getCompareCounter() {
        return mStatCompare;
    }

    public int SerialId() {
        return this.mSerialId;
    }

    public MVDEngineData getEngineData() {
        return this.mEngineData;
    }

    private void ExecDNStat(String opType, MxRequest mxrequest) {
        String sp = null;
        Vector v = MVDStatistics.getInstance().getStatDNs();
        if (v == null) {
            return;
        }
        if (opType.equals("search")) {
            sp = ((MxSearch)mxrequest).getStartingPoint().toLowerCase();
        } else if (opType.equals("modify")) {
            sp = ((MxModify)mxrequest).getDn().toLowerCase();
        } else if (opType.equals("add")) {
            sp = ((MxAdd)mxrequest).getDn().toLowerCase();
        } else if (opType.equals("delete")) {
            sp = ((MxDelete)mxrequest).getDn().toLowerCase();
        } else if (opType.equals("compare")) {
            sp = ((MxCompare)mxrequest).getStartingPoint().toLowerCase();
        }
        if (sp == null) {
            return;
        }
        for (int x = 0; x < v.size(); ++x) {
            if (!sp.endsWith((String)v.elementAt(x))) continue;
            MVDGlobalStatistics.increaseDN(opType.toUpperCase() + ":" + v.elementAt(x), 1);
            break;
        }
    }

    public Object objAnswerRequest(Object aObject) throws Exception {
        try {
            HashMap tmp;
            String c;
            MxRequest[] mxrequestArr = this.mProtocolTransform.transformRequestIfNeeded(aObject);
            if (mxrequestArr == null || mxrequestArr.length == 0) {
                MxResponse negativeResponse = new MxResponse();
                negativeResponse.setError(53, "Request transform failed");
                Object aRes = this.mProtocolTransform.transformResponseIfNeeded(new MxResponse[]{negativeResponse}, aObject, mxrequestArr);
                return aRes;
            }
            String clientip = "";
            if (aObject != null && aObject instanceof HashMap && (c = (String)(tmp = (HashMap)aObject).get("CLIENT_IP")) != null) {
                clientip = c;
            }
            MxResponse[] mxrespArr = this.answerRequest(mxrequestArr, clientip);
            return this.mProtocolTransform.transformResponseIfNeeded(mxrespArr, aObject, mxrequestArr);
        }
        catch (Exception e) {
            e.printStackTrace();
            MVDLogger.Log("Exception on objAnswerRequest" + e.getMessage(), 2);
            return null;
        }
    }

    public MxResponse[] answerRequest(MxRequest[] aMxreqArr, String aClientIP) throws Exception {
        MxResponse[] respArr = new MxResponse[aMxreqArr.length];
        for (int i = 0; i < aMxreqArr.length; ++i) {
            MxRequest request = aMxreqArr[i];
            respArr[i] = this.answerRequest(request, aClientIP);
        }
        return respArr;
    }

    public MxResponse answerRequest(MxRequest mxrequest, String aIPaddress) throws Exception {
        mxrequest.niceDN();
        switch (mxrequest.getChoiceID()) {
            case 0: {
                ++mStatBind;
                String username = ((MxBind)mxrequest).getUserName();
                String password = ((MxBind)mxrequest).getPassword();
                String magicnumber = MVDProxy.getMagicNumber() + "";
                if (username.equals(magicnumber) && password.equals(magicnumber)) {
                    this.mEngineData.SetIAmBinded(true);
                    MxResponse lm = new MxResponse();
                    lm.setOK(0, "");
                    return lm;
                }
                return this.doMxBind(mxrequest, this, aIPaddress);
            }
            case 16: {
                MVDLogger.Log("Abandon request received on engine id=" + this.mSerialId, 0);
                return null;
            }
            case 2: {
                MVDLogger.Log("Unbind request received on engine id=" + this.mSerialId, 0);
                return null;
            }
        }
        boolean bIAmBinded = this.mEngineData.IAmBinded();
        if (!bIAmBinded && !this.doMxImplicitBind(mxrequest, aIPaddress)) {
            MxResponse lm = new MxResponse();
            lm.setError(49, "Implicit bind failed");
            return lm;
        }
        MxResponse aResult = null;
        String opType = "";
        switch (mxrequest.getChoiceID()) {
            case 3: {
                opType = "search";
                MxSearch mxs = (MxSearch)mxrequest;
                this.mEngineData.MvdDebit().SetStartingPoint(mxs.getStartingPoint());
                this.mEngineData.MvdDebit().SetRequestedAttributes(mxs.getRequestedAttributes().toString());
                this.mEngineData.MvdDebit().SetOperationType("SEARCH");
                this.mEngineData.MvdDebit().SetOperationSubType(Globals.SearchTypeOperations[mxs.getOperationScope()]);
                this.mEngineData.MvdDebit().SetFilter(mxs.getRequestedURLFilter());
                mxrequest = this.mProtocolTransform.preRequestIfNeeded(mxrequest, opType);
                if (mxrequest == null) {
                    MxResponse negativeResponse = new MxResponse();
                    String preError = (String)this.mEngineData.ExternalSessionGs().get("PRE_ERROR");
                    if (preError == null) {
                        preError = "Pre processing failed";
                    } else {
                        this.mEngineData.ExternalSessionGs().put("PRE_ERROR", null);
                    }
                    negativeResponse.setError(53, preError);
                    this.mEngineData.MvdDebit().SetResultCode(53);
                    this.mEngineData.MvdDebit().SetResultMessage(preError);
                    MVDDebitLogger.LogDebitInfo(this.mEngineData.MvdDebit());
                    return negativeResponse;
                }
                if (MVDStatistics.getInstance().getPerDNStat()) {
                    this.ExecDNStat(opType, mxrequest);
                }
                ++mStatSearch;
                Vector unlegalURLs = MVDProxy.getProhibitedSearchURLs();
                if (!this.isSearchLegal(mxs, unlegalURLs)) {
                    MxResponse negativeResponse = new MxResponse();
                    negativeResponse.setError(53, "Prohibited operation");
                    this.mEngineData.MvdDebit().SetResultCode(53);
                    this.mEngineData.MvdDebit().SetResultMessage("Prohibited operation");
                    MVDDebitLogger.LogDebitInfo(this.mEngineData.MvdDebit());
                    return negativeResponse;
                }
                SearchOperation searchop = new SearchOperation(mxrequest, this);
                aResult = searchop.mxperform();
                break;
            }
            case 6: {
                opType = "modify";
                MxModify mxo = (MxModify)mxrequest;
                this.mEngineData.MvdDebit().SetStartingPoint(mxo.getDn());
                this.mEngineData.MvdDebit().SetOperationType("MODIFY");
                mxrequest = this.mProtocolTransform.preRequestIfNeeded(mxrequest, opType);
                if (mxrequest == null) {
                    MxResponse negativeResponse = new MxResponse();
                    String preError = (String)this.mEngineData.ExternalSessionGs().get("PRE_ERROR");
                    if (preError == null) {
                        preError = "Pre processing failed";
                    } else {
                        this.mEngineData.ExternalSessionGs().put("PRE_ERROR", null);
                    }
                    negativeResponse.setError(53, preError);
                    this.mEngineData.MvdDebit().SetResultCode(53);
                    this.mEngineData.MvdDebit().SetResultMessage(preError);
                    MVDDebitLogger.LogDebitInfo(this.mEngineData.MvdDebit());
                    return negativeResponse;
                }
                if (MVDStatistics.getInstance().getPerDNStat()) {
                    this.ExecDNStat(opType, mxrequest);
                }
                ++mStatModify;
                ModifyOperation modop = new ModifyOperation(mxrequest, this);
                aResult = modop.mxperform();
                break;
            }
            case 8: {
                opType = "add";
                MxAdd mxa = (MxAdd)mxrequest;
                this.mEngineData.MvdDebit().SetStartingPoint(mxa.getDn());
                this.mEngineData.MvdDebit().SetOperationType("ADD");
                mxrequest = this.mProtocolTransform.preRequestIfNeeded(mxrequest, opType);
                if (mxrequest == null) {
                    MxResponse negativeResponse = new MxResponse();
                    String preError = (String)this.mEngineData.ExternalSessionGs().get("PRE_ERROR");
                    if (preError == null) {
                        preError = "Pre processing failed";
                    } else {
                        this.mEngineData.ExternalSessionGs().put("PRE_ERROR", null);
                    }
                    negativeResponse.setError(53, preError);
                    this.mEngineData.MvdDebit().SetResultCode(53);
                    this.mEngineData.MvdDebit().SetResultMessage(preError);
                    MVDDebitLogger.LogDebitInfo(this.mEngineData.MvdDebit());
                    return negativeResponse;
                }
                if (MVDStatistics.getInstance().getPerDNStat()) {
                    this.ExecDNStat(opType, mxrequest);
                }
                ++mStatAdd;
                AddOperation addop = new AddOperation(mxrequest, this);
                aResult = addop.mxperform();
                break;
            }
            case 10: {
                opType = "delete";
                MxDelete mxd = (MxDelete)mxrequest;
                this.mEngineData.MvdDebit().SetStartingPoint(mxd.getDn());
                this.mEngineData.MvdDebit().SetOperationType("DELETE");
                mxrequest = this.mProtocolTransform.preRequestIfNeeded(mxrequest, opType);
                if (mxrequest == null) {
                    MxResponse negativeResponse = new MxResponse();
                    String preError = (String)this.mEngineData.ExternalSessionGs().get("PRE_ERROR");
                    if (preError == null) {
                        preError = "Pre processing failed";
                    } else {
                        this.mEngineData.ExternalSessionGs().put("PRE_ERROR", null);
                    }
                    negativeResponse.setError(53, preError);
                    this.mEngineData.MvdDebit().SetResultCode(53);
                    this.mEngineData.MvdDebit().SetResultMessage(preError);
                    MVDDebitLogger.LogDebitInfo(this.mEngineData.MvdDebit());
                    return negativeResponse;
                }
                if (MVDStatistics.getInstance().getPerDNStat()) {
                    this.ExecDNStat(opType, mxrequest);
                }
                ++mStatDelete;
                MxDelete del = (MxDelete)mxrequest;
                if (del.getDn().equalsIgnoreCase(MVDProxy.SecretDNToStopMVD())) {
                    MVDLogger.Log("Received shutdown command, shutting down...", 4);
                    try {
                        File f = new File(MVDProxy.RandomFile());
                        if (f.exists() && f.canWrite() && !f.delete()) {
                            MVDLogger.Log("Cannot delete the random file", 6);
                        }
                        MVDServer.kill();
                    }
                    catch (VirtualMachineError t) {
                        Globals.blownAwayByThrowable(t);
                    }
                    catch (Throwable tr) {
                        System.out.println("Throwable:" + tr);
                        MVDLogger.Log("Throwable:" + tr, 7);
                    }
                    return null;
                }
                String loweredDn = del.getDn().toLowerCase();
                if (loweredDn.endsWith("ou=cache," + MVDProxy.SecretDNToStopMVD().toLowerCase())) {
                    String strCleanId = "";
                    if (loweredDn.equalsIgnoreCase("ou=cache," + MVDProxy.SecretDNToStopMVD().toLowerCase())) {
                        strCleanId = "GLOBAL_CACHE";
                    } else if (loweredDn.startsWith("cn=all")) {
                        strCleanId = "GLOBAL_CACHE";
                    } else {
                        int ix = loweredDn.indexOf(",");
                        if (ix >= 3) {
                            loweredDn = loweredDn.substring(3, ix);
                        }
                        strCleanId = loweredDn;
                    }
                    MVDLogger.Log("Received clean cache command ...", 4);
                    MVDCacheUtil.cleanAllEntries(strCleanId);
                    System.out.println("Cache: " + strCleanId + " is cleaned.");
                    aResult = new MxResponse();
                    aResult.setOK();
                    return aResult;
                }
                if (loweredDn.endsWith("ou=listeners," + MVDProxy.SecretDNToStopMVD().toLowerCase())) {
                    MVDLogger.Log("Received check listeners command ...", 4);
                    String accumulated = "";
                    Iterator iter = MVDServer.getActiveLdapListenerNames().keySet().iterator();
                    while (iter.hasNext()) {
                        String lsName = (String)iter.next();
                        MVDLDAPDeployment ldp = (MVDLDAPDeployment)MVDLDAPDeploymentList.getLDAPDeployments().get(lsName);
                        if (MVDLDAPDeploymentList.isMainDeployment(ldp)) {
                            if (accumulated.length() > 0) {
                                accumulated = accumulated + "!";
                            }
                            accumulated = accumulated + ldp.getPortNumber() + "(main):" + "running";
                            System.out.println(ldp.getPortNumber() + "(main):" + "running");
                            continue;
                        }
                        MxLdapListener aLdapListener = (MxLdapListener)MVDServer.getActiveLdapListenerNames().get(ldp.getName());
                        if (aLdapListener.isAlive()) {
                            if (accumulated.length() > 0) {
                                accumulated = accumulated + "!";
                            }
                            accumulated = accumulated + ldp.getPortNumber() + ":" + "running";
                            System.out.println(ldp.getPortNumber() + ":" + "running");
                            continue;
                        }
                        if (accumulated.length() > 0) {
                            accumulated = accumulated + "!";
                        }
                        accumulated = accumulated + ldp.getPortNumber() + ":" + "not running";
                        System.out.println(ldp.getPortNumber() + ":" + "not running");
                    }
                    aResult = new MxResponse();
                    aResult.setError(32, "CHECKLISTENERS=" + accumulated);
                    return aResult;
                }
                DeleteOperation delop = new DeleteOperation(mxrequest, this);
                aResult = delop.mxperform();
                break;
            }
            case 12: {
                RenameOperation renop = new RenameOperation(mxrequest);
                aResult = renop.mxperform();
                opType = "rename";
                break;
            }
            case 14: {
                opType = "compare";
                MxCompare mxcomp = (MxCompare)mxrequest;
                this.mEngineData.MvdDebit().SetStartingPoint(mxcomp.getStartingPoint());
                this.mEngineData.MvdDebit().SetOperationType("COMPARE");
                this.mEngineData.MvdDebit().SetComparingAttribute(mxcomp.getCompAttr());
                if (MVDStatistics.getInstance().getPerDNStat()) {
                    this.ExecDNStat(opType, mxrequest);
                }
                ++mStatCompare;
                CompareOperation compop = new CompareOperation((MxCompare)mxrequest, this);
                aResult = compop.mxperform();
                break;
            }
            default: {
                MVDLogger.Log("Unrecognized request received on engine id=" + this.mSerialId, 0);
                return null;
            }
        }
        MVDDebitLogger.LogDebitInfo(this.mEngineData.MvdDebit());
        MVDLogger.Log("Finished " + opType + " operation", 2);
        aResult = this.mProtocolTransform.postRequestIfNeeded(aResult, opType, mxrequest);
        if (MVDProxy.isStripAdditionalInfo()) {
            aResult.getOperRes().setMessage("");
        }
        return aResult;
    }

    private boolean isSearchLegal(MxSearch aSearch, Vector aNonLegalURLs) {
        if (aNonLegalURLs == null || aNonLegalURLs.isEmpty()) {
            return true;
        }
        MVDLogger.Log("Checking search up against prohibited urls for search operations", 3);
        String startingPoint = aSearch.getStartingPoint().trim().toLowerCase();
        int tmp = aSearch.getOperationScope();
        String scopestr = tmp == 0 ? "base" : (tmp == 1 ? "one" : "sub");
        String filter = aSearch.getRequestedURLFilter();
        for (int i = 0; i < aNonLegalURLs.size(); ++i) {
            String url = (String)aNonLegalURLs.elementAt(i);
            if (url == null || !MVDUtil.isURLEqual(startingPoint, scopestr, filter, url, false)) continue;
            MVDLogger.Log("Search is not allowed due to prohibited url " + url, 6);
            return false;
        }
        MVDLogger.Log("Search is allowed - continue processing", 3);
        return true;
    }

    public MxResponse internalAnswerRequest(MxRequest mxrequest) throws Exception {
        if (!this.mEngineData.IAmBinded()) {
            throw new MVDException(-1023, "Internal operation failed");
        }
        MxResponse aResult = null;
        String opType = null;
        switch (mxrequest.getChoiceID()) {
            case 3: {
                opType = "search";
                SearchOperation searchop = new SearchOperation(mxrequest, this);
                aResult = searchop.mxperform();
                break;
            }
            case 6: {
                opType = "modify";
                ModifyOperation modop = new ModifyOperation(mxrequest, this);
                aResult = modop.mxperform();
                break;
            }
            case 8: {
                opType = "add";
                AddOperation addop = new AddOperation(mxrequest, this);
                aResult = addop.mxperform();
                break;
            }
            case 10: {
                opType = "delete";
                DeleteOperation delop = new DeleteOperation(mxrequest, this);
                aResult = delop.mxperform();
                break;
            }
            case 14: {
                opType = "compare";
                CompareOperation compop = new CompareOperation(mxrequest, this);
                aResult = compop.mxperform();
                break;
            }
            default: {
                MVDLogger.Log("Unrecognized statement on " + this.mSerialId, 0);
                return null;
            }
        }
        MVDLogger.Log("Finished " + opType + " operation", 2);
        return aResult;
    }

    public MxResponse doMxBind(MxRequest mxrequest, Engine aEng, String aIPAddress) throws Exception {
        BindOperation bindop = new BindOperation(mxrequest, aEng, aIPAddress);
        try {
            MxResponse bindR = bindop.mxperform();
            if (bindR.getCode() == 0) {
                aEng.getEngineData().ExternalSessionGs().put("SESSION_PWD", aEng.getEngineData().MvdDebit().UserPwd());
                aEng.getEngineData().ExternalSessionGs().put("SESSION_USER", aEng.getEngineData().MvdDebit().UserName());
                aEng.getEngineData().ExternalSessionGs().put("SESSION_CLIENTIP", aEng.getEngineData().MvdDebit().ClientIPAddress());
                aEng.getEngineData().ExternalSessionGs().put("SESSION_USERGROUP", aEng.getEngineData().MvdDebit().UserGroup());
            }
            return bindR;
        }
        catch (MxLDAPBindException dbe) {
            if (dbe.getLDAPErrorCode() == -1055) {
                MxResponse lm = new MxResponse();
                lm.setOK(99999, dbe.getMessage());
                return lm;
            }
            throw new Exception("Exception in doMxBind");
        }
    }

    public boolean doMxImplicitBind(MxRequest mxrequest, String aIPAddress) throws Exception {
        BindOperation bindop = new BindOperation(null, this, aIPAddress);
        try {
            MxResponse bindR = bindop.mximplicitperform();
            if (bindR.getCode() == 0) {
                this.mEngineData.ExternalSessionGs().put("SESSION_PWD", this.mEngineData.MvdDebit().UserPwd());
                this.mEngineData.ExternalSessionGs().put("SESSION_USER", this.mEngineData.MvdDebit().UserName());
                this.mEngineData.ExternalSessionGs().put("SESSION_CLIENTIP", this.mEngineData.MvdDebit().ClientIPAddress());
                this.mEngineData.ExternalSessionGs().put("SESSION_USERGROUP", this.mEngineData.MvdDebit().UserGroup());
                return true;
            }
            return false;
        }
        catch (MxLDAPBindException dbe) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public MVDHashMap getEngineGs() {
        return this.mEngineGs;
    }

    public void release() {
        EnginePool.checkIn(this);
    }

    public void setMessageHandler(MxLdapMessageHandler aMessageHandler) {
        this.mMessageHandler = aMessageHandler;
        PartialResultCallbackHandler intermediatesender = new PartialResultCallbackHandler();
        intermediatesender.setEngine(this);
        this.mEngineGs.put(MX_CALLBACK_HANDLER, intermediatesender);
    }

    public void clearMessageHandler() {
        this.mMessageHandler = null;
        this.mEngineGs.remove(MX_CALLBACK_HANDLER);
    }

    public boolean sendPartialResult(MVDSearchResults aRes, MxRequest aRequest) {
        try {
            this.mProtocolTransform.postRequestIfNeeded(aRes, "search", aRequest);
            LDAPMessage curreq = this.mMessageHandler.getCurrentRequest();
            MxLdapResponse finalResult = MxLdapTransform.transformback(curreq, aRes);
            if (finalResult != null) {
                try {
                    finalResult.setDoneResult(null);
                    finalResult.sendMessageStruct(this.mMessageHandler);
                    return true;
                }
                catch (Exception e) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

